﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.Transactions;
using Seguridad;
using System.Net.Mail;

namespace Nova.Controllers.PrestamoPeliculas
{
    public class PeliculasPrestamosController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: PeliculasPrestamos
        public ActionResult Index()
        {
            Session["IdConvenioLaboralTrabajadorCategoria"] = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            int IdConvenioLaboralTrabajadorCategoria = (int) Session["IdConvenioLaboralTrabajadorCategoria"];
            var cinedebates_stPrestamos = db.Cinedebates_stPrestamos.Where(c=> c.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).Include(c => c.Cinedebates_ctEstatusFormato).Include(c => c.Cinedebates_ctPeliculas).Include(c => c.Convenios_stConvenioLaboralTrabajadorCategoria);
            return View(cinedebates_stPrestamos.ToList());
        }

        public ActionResult AdminIndex()
        {
            int dias = 0;
            foreach (var item in db.Cinedebates_stPrestamos.Where(a => a.FechaEntrega == null && a.Notificacion == false).ToList())
            {

                DateTime firstDay2 = item.FechaPrestamo;
                DateTime lastDay2 = DateTime.Now;
                if (firstDay2 > lastDay2)
                    throw new ArgumentException("Incorrecta la fecha" + lastDay2);

                TimeSpan span2 = lastDay2 - firstDay2;
                int businessDays2 = span2.Days + 1;
                int fullWeekCount2 = businessDays2 / 7;
                // find out if there are weekends during the time exceedng the full weeks
                if (businessDays2 > fullWeekCount2 * 7)
                {
                    // we are here to find out if there is a 1-day or 2-days weekend
                    // in the time interval remaining after subtracting the complete weeks
                    int firstDayOfWeek2 = (int)firstDay2.DayOfWeek;
                    int lastDayOfWeek2 = (int)lastDay2.DayOfWeek;
                    if (lastDayOfWeek2 < firstDayOfWeek2)
                        lastDayOfWeek2 += 7;
                    if (firstDayOfWeek2 <= 6)
                    {
                        if (lastDayOfWeek2 >= 7)// Both Saturday and Sunday are in the remaining time interval
                            businessDays2 -= 2;
                        else if (lastDayOfWeek2 >= 6)// Only Saturday is in the remaining time interval
                            businessDays2 -= 1;
                    }
                    else if (firstDayOfWeek2 <= 7 && lastDayOfWeek2 >= 7)// Only Sunday is in the remaining time interval
                        businessDays2 -= 1;
                }

                // subtract the weekends during the full weeks in the interval
                businessDays2 -= fullWeekCount2 + fullWeekCount2;
                dias =  businessDays2;
                if (dias > 30)
                {
                    MailMessage msg = new MailMessage();
                    msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
                    string correoprestamo = item.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.CorreoElectronico;
                   string tituloprestamo = item.Cinedebates_ctPeliculas.TituloPelicula; 
                    msg.To.Add(correoprestamo);
                    //msg.To.Add("pzafra@cecyteo.edu.mx");
                  
                    msg.Subject = "Sistema CineDebates";
                    msg.IsBodyHtml = true;
                    string cuerpo = @"<!doctype html>
                                                    <html xmlns='http://www.w3.org/1999/xhtml'>
                                                    <head>

                                                    <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />

                                                    <title>Rporte de Credenciales</title>

                                                    <style type='text/css'>
	                                                    .ReadMsgBody {width: 100%; background-color: #ffffff;}
	                                                    .ExternalClass {width: 100%; background-color: #ffffff;}
	                                                    body	 {width: 100%; background-color: #ffffff; margin:0; padding:0; -webkit-font-smoothing: antialiased;font-family: Helvetica, Georgia, Times, serif}
	                                                    table {border-collapse: collapse;}

	                                                    @media only screen and (max-width: 640px)  {
					                                                    body[yahoo] .deviceWidth {width:440px!important; padding:0;}
					                                                    body[yahoo] .center {text-align: center!important;}
			                                                    }

	                                                    @media only screen and (max-width: 479px) {
					                                                    body[yahoo] .deviceWidth {width:280px!important; padding:0;}
					                                                    body[yahoo] .center {text-align: center!important;}
			                                                    }

                                                    </style>
                                                    </head>

                                                    <body leftmargin='0' topmargin='0' marginwidth='0' marginheight='0' yahoo='fix' style='font-family: Helvetica, Georgia, Times, serif'>

                                                    <!-- Wrapper -->
                                                    <table width='100%' border='0' cellpadding='0' cellspacing='0' align='center'>
	                                                    <tr>
		                                                    <td width='100%' valign='top' bgcolor='#ffffff' style='padding-top:20px'>

			                                                    <!-- Start Header-->
			                                                    <table width='580' border='0' cellpadding='0' cellspacing='0' align='center' class='deviceWidth' style='margin:0 auto;'>
				                                                    <tr>
					                                                    <td width='100%' bgcolor='#ffffff'>

                                                                                <!-- Logo -->
                                                                                <table border='0' cellpadding='0' cellspacing='0' align='left' class='deviceWidth'>
                                                                                    <tr>
                                                                                        <td style='padding:10px 20px' class='center'>
                                                                                            <a href='#'><img src='https://www.cecyteo.edu.mx/Nova/app_themes/Nova2015/img/logocecyte.png' alt='' border='0' /></a>
                                                                                        </td>
                                                                                    </tr>
                                                                                </table><!-- End Logo -->

                                                                                <!-- Nav -->
                                                                                <table border='0' cellpadding='0' cellspacing='0' align='right' class='deviceWidth'>
                                                                                    <tr>
                                                                                        <td class='center' style='font-size: 13px; color: #272727; font-weight: light; text-align: right; font-family: Helvetica, Georgia, Times, serif; line-height: 20px; vertical-align: middle; padding:10px 20px; font-style:italic'>
                                         
                                                                                        </td>
                                                                                    </tr>
                                                                                </table><!-- End Nav -->

					                                                    </td>
				                                                    </tr>
			                                                    </table><!-- End Header -->

		


                                                    <div style='height:15px;margin:0 auto;'>&nbsp;</div><!-- spacer -->


                                                                <!-- 2 Column Images & Text Side by SIde -->
                                                                <table width='580' border='0' cellpadding='0' cellspacing='0' align='center' class='deviceWidth' bgcolor='#202022' style='margin:0 auto;'>
                                                                    <tr>
                                                                        <td style='padding:10px 0'>
                                                                                <table align='left' width='49%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                                                                    <tr>
                                                                                        <td valign='top' align='center' class='center' style='padding-top:20px;color:#fff;' >
                                                                                             <h1 style='text-align:center;' >Sistema CineDebates</h1>
                                                                                        </td>
                                                                                    </tr>
                                                                                </table>
                                                                                <table align='right' width='49%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                                                                    <tr>
                                                                                        <td style='font-size: 12px; color: #959595; font-weight: normal; text-align: left; font-family: Helvetica, Georgia, Times, serif; line-height: 24px; vertical-align: top; padding:10px 8px 10px 8px'>

                                                                                            <table>
                                                                                                <tr>
                                                                                                    <td valign='top' style='padding:0 10px 10px 5px;color:#fff;'>
                                                    
                                                                                                    </td>
                                                                                                    <td valign='middle' style='padding:0 10px 10px 0'>
                                                                                                    <a href='#' style='text-decoration: none; font-size: 16px; color: #ccc; font-weight: normal; font-family:Arial, sans-serif '>Estimado usuario existe actualmente un retraso en su entrega del prestamo de la pelicula:</a>
                                                                                                    <a href='#' style='text-decoration: none; font-size: 16px; color: #ccc; font-weight: bold; font-family:Arial, sans-serif '>"+ "  " + tituloprestamo  + "  " +@"  </a>
                                                                                                    <a href='#' style='text-decoration: none; font-size: 16px; color: #ccc; font-weight: normal; font-family:Arial, sans-serif '>" + " favor de pasar  a entregar,  ya que el tiempo maximo es de  30 días  y usted tiene" + " " + dias + " " + @" días con el prestamo, por lo cual se notifica por este medio para su entrega</a>
                                                                                                    </td>
                                                                                                </tr>
                                                                                            </table>

                                                                                            <p style='mso-table-lspace:0;mso-table-rspace:0; margin:0'>
                                             
                                                                                                <br/><br/>

                                            

                                                                                            </p>
                                                                                        </td>
                                                                                    </tr>
                                                                                </table>

                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td bgcolor='#fe7f00'><div style='height:6px'>&nbsp;</div></td>
                                                                    </tr>
                                                                </table><!-- End 2 Column Images & Text Side by SIde -->


                                                    <div style='height:15px;margin:0 auto;'>&nbsp;</div><!-- spacer -->
			                                                    <!-- Two Column (Images Stacked over Text) -->
			 
 
       
 

                                                    <div style='height:35px;margin:0 auto;'>&nbsp;</div><!-- spacer -->


			                                                    <!-- 4 Columns -->
			                                                    <table width='100%' border='0' cellpadding='0' cellspacing='0' align='center'>
				                                                    <tr>
					                                                    <td bgcolor='#363636' style='padding:30px 0'>
                                                                            <table width='580' border='0' cellpadding='10' cellspacing='0' align='center' class='deviceWidth' style='margin:0 auto;'>
                                                                                <tr>
                                                                                    <td>
                                                                                            <table width='45%' cellpadding='0' cellspacing='0'  border='0' align='left' class='deviceWidth'>
                                                                                                <tr>
                                                                                                    <td valign='top' style='font-size: 11px; color: #f1f1f1; color:#999; font-family: Arial, sans-serif; padding-bottom:20px' class='center'>

                                                                                                       Departamento de Sistemas, Redes y Soporte Técnico | 
                                                                                                        <a href='www.cecyteo.edu.mx/nova' style='color:#999;text-decoration:none;'>NOVA - " + DateTime.Now.Year + @"</a><br/>

                                                                                                        <br/><br/>
                                                   

                                                                                                    </td>
                                                                                                </tr>
                                                                                            </table>

                                                                                            <table width='40%' cellpadding='0' cellspacing='0'  border='0' align='right' class='deviceWidth'>
                                                                                                <tr>
                                                                                                    <td valign='top' style='font-size: 11px; color: #f1f1f1; font-weight: normal; font-family: Helvetica, Georgia, Times, serif; line-height: 26px; vertical-align: top; text-align:right' class='center'>
                                                                                                         Todos los Derechos Reservados - Cecyteo  

                                                                                                        <a href='#'><img src='https://www.cecyteo.edu.mx/Nova/app_themes/Nova2015/img/logocecyte.png' alt='' border='0' /></a>

                                                   
                                                                                                    </td>
                                                                                                </tr>
                                                                                            </table>

                        		                                                    </td>
                        	                                                    </tr>
                                                                            </table>
                                                                        </td>
                                                                    </tr>
                                                                </table><!-- End 4 Columns -->

		                                                    </td>
	                                                    </tr>
                                                    </table> <!-- End Wrapper -->
                                                    <div style='display:none; white-space:nowrap; font:15px courier; color:#ffffff;'>
                                                    - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
                                                    </div>
                                                    </body>
                                                    </html>";

                    msg.Body = cuerpo;
                    //msg.Body = "Favor de pasar a entregar la pelicula:" +  " " + tituloprestamo + " "+ "ya que el tiempo del prestamo ha vencido";
                    SmtpClient client = new SmtpClient();

                    client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
                    client.Host = "smtp.gmail.com";
                    client.Port = 587;
                    client.DeliveryMethod = SmtpDeliveryMethod.Network;
                    client.EnableSsl = true;
                    // client.UseDefaultCredentials = false; 
                    client.Send(msg);
                    Cinedebates_stPrestamos prestamo = db.Cinedebates_stPrestamos.Where(b=> b.FechaEntrega == null && b.Notificacion==false && b.IdPrestamo == item.IdPrestamo).FirstOrDefault();
                    prestamo.Notificacion = true;
                    db.Entry(prestamo).State = System.Data.Entity.EntityState.Modified;
                    db.SaveChanges();
                   
                }

            }
            
            var cinedebates_stPrestamosAdmin = db.Cinedebates_stPrestamos.Include(c => c.Cinedebates_ctEstatusFormato).Include(c => c.Cinedebates_ctPeliculas).Include(c => c.Convenios_stConvenioLaboralTrabajadorCategoria);
            return View(cinedebates_stPrestamosAdmin.ToList());
        }


        public ActionResult AdminIndex2()
        {
            int dias = 0;
            foreach (var item in db.Cinedebates_stPrestamos.Where(a => a.FechaEntrega == null && a.Notificacion == true).ToList())
            {

                DateTime firstDay2 = item.FechaPrestamo;
                DateTime lastDay2 = DateTime.Now;
                if (firstDay2 > lastDay2)
                    throw new ArgumentException("Incorrecta la fecha" + lastDay2);

                TimeSpan span2 = lastDay2 - firstDay2;
                int businessDays2 = span2.Days + 1;
                int fullWeekCount2 = businessDays2 / 7;
                // find out if there are weekends during the time exceedng the full weeks
                if (businessDays2 > fullWeekCount2 * 7)
                {
                    // we are here to find out if there is a 1-day or 2-days weekend
                    // in the time interval remaining after subtracting the complete weeks
                    int firstDayOfWeek2 = (int)firstDay2.DayOfWeek;
                    int lastDayOfWeek2 = (int)lastDay2.DayOfWeek;
                    if (lastDayOfWeek2 < firstDayOfWeek2)
                        lastDayOfWeek2 += 7;
                    if (firstDayOfWeek2 <= 6)
                    {
                        if (lastDayOfWeek2 >= 7)// Both Saturday and Sunday are in the remaining time interval
                            businessDays2 -= 2;
                        else if (lastDayOfWeek2 >= 6)// Only Saturday is in the remaining time interval
                            businessDays2 -= 1;
                    }
                    else if (firstDayOfWeek2 <= 7 && lastDayOfWeek2 >= 7)// Only Sunday is in the remaining time interval
                        businessDays2 -= 1;
                }

                // subtract the weekends during the full weeks in the interval
                businessDays2 -= fullWeekCount2 + fullWeekCount2;
                dias = businessDays2;
                if (dias > 30)
                {
                    MailMessage msg = new MailMessage();
                    msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
                    string correoprestamo = item.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.CorreoElectronico;
                    string tituloprestamo = item.Cinedebates_ctPeliculas.TituloPelicula;
                    msg.To.Add(correoprestamo);
                    //msg.To.Add("pzafra@cecyteo.edu.mx");

                    msg.Subject = "Sistema CineDebates";
                    msg.IsBodyHtml = true;
                    string cuerpo = @"<!doctype html>
                                                    <html xmlns='http://www.w3.org/1999/xhtml'>
                                                    <head>

                                                    <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />

                                                    <title>Rporte de Credenciales</title>

                                                    <style type='text/css'>
	                                                    .ReadMsgBody {width: 100%; background-color: #ffffff;}
	                                                    .ExternalClass {width: 100%; background-color: #ffffff;}
	                                                    body	 {width: 100%; background-color: #ffffff; margin:0; padding:0; -webkit-font-smoothing: antialiased;font-family: Helvetica, Georgia, Times, serif}
	                                                    table {border-collapse: collapse;}

	                                                    @media only screen and (max-width: 640px)  {
					                                                    body[yahoo] .deviceWidth {width:440px!important; padding:0;}
					                                                    body[yahoo] .center {text-align: center!important;}
			                                                    }

	                                                    @media only screen and (max-width: 479px) {
					                                                    body[yahoo] .deviceWidth {width:280px!important; padding:0;}
					                                                    body[yahoo] .center {text-align: center!important;}
			                                                    }

                                                    </style>
                                                    </head>

                                                    <body leftmargin='0' topmargin='0' marginwidth='0' marginheight='0' yahoo='fix' style='font-family: Helvetica, Georgia, Times, serif'>

                                                    <!-- Wrapper -->
                                                    <table width='100%' border='0' cellpadding='0' cellspacing='0' align='center'>
	                                                    <tr>
		                                                    <td width='100%' valign='top' bgcolor='#ffffff' style='padding-top:20px'>

			                                                    <!-- Start Header-->
			                                                    <table width='580' border='0' cellpadding='0' cellspacing='0' align='center' class='deviceWidth' style='margin:0 auto;'>
				                                                    <tr>
					                                                    <td width='100%' bgcolor='#ffffff'>

                                                                                <!-- Logo -->
                                                                                <table border='0' cellpadding='0' cellspacing='0' align='left' class='deviceWidth'>
                                                                                    <tr>
                                                                                        <td style='padding:10px 20px' class='center'>
                                                                                            <a href='#'><img src='https://www.cecyteo.edu.mx/Nova/app_themes/Nova2015/img/logocecyte.png' alt='' border='0' /></a>
                                                                                        </td>
                                                                                    </tr>
                                                                                </table><!-- End Logo -->

                                                                                <!-- Nav -->
                                                                                <table border='0' cellpadding='0' cellspacing='0' align='right' class='deviceWidth'>
                                                                                    <tr>
                                                                                        <td class='center' style='font-size: 13px; color: #272727; font-weight: light; text-align: right; font-family: Helvetica, Georgia, Times, serif; line-height: 20px; vertical-align: middle; padding:10px 20px; font-style:italic'>
                                         
                                                                                        </td>
                                                                                    </tr>
                                                                                </table><!-- End Nav -->

					                                                    </td>
				                                                    </tr>
			                                                    </table><!-- End Header -->

		


                                                    <div style='height:15px;margin:0 auto;'>&nbsp;</div><!-- spacer -->


                                                                <!-- 2 Column Images & Text Side by SIde -->
                                                                <table width='580' border='0' cellpadding='0' cellspacing='0' align='center' class='deviceWidth' bgcolor='#202022' style='margin:0 auto;'>
                                                                    <tr>
                                                                        <td style='padding:10px 0'>
                                                                                <table align='left' width='49%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                                                                    <tr>
                                                                                        <td valign='top' align='center' class='center' style='padding-top:20px;color:#fff;' >
                                                                                             <h1 style='text-align:center;' >Sistema CineDebates</h1>
                                                                                        </td>
                                                                                    </tr>
                                                                                </table>
                                                                                <table align='right' width='49%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                                                                    <tr>
                                                                                        <td style='font-size: 12px; color: #959595; font-weight: normal; text-align: left; font-family: Helvetica, Georgia, Times, serif; line-height: 24px; vertical-align: top; padding:10px 8px 10px 8px'>

                                                                                            <table>
                                                                                                <tr>
                                                                                                    <td valign='top' style='padding:0 10px 10px 5px;color:#fff;'>
                                                    
                                                                                                    </td>
                                                                                                    <td valign='middle' style='padding:0 10px 10px 0'>
                                                                                                    <a href='#' style='text-decoration: none; font-size: 16px; color: #ccc; font-weight: normal; font-family:Arial, sans-serif '>Estimado usuario existe actualmente un retraso en su entrega del prestamo de la pelicula:</a>
                                                                                                    <a href='#' style='text-decoration: none; font-size: 16px; color: #ccc; font-weight: bold; font-family:Arial, sans-serif '>" + "  " + tituloprestamo + "  " + @"  </a>
                                                                                                    <a href='#' style='text-decoration: none; font-size: 16px; color: #ccc; font-weight: normal; font-family:Arial, sans-serif '>" + " favor de pasar  a entregar,  ya que el tiempo maximo es de  30 días  y usted tiene" + " " + dias + " " + @" días con el prestamo, por lo cual se notifica por este medio para su entrega</a>
                                                                                                    </td>
                                                                                                </tr>
                                                                                            </table>

                                                                                            <p style='mso-table-lspace:0;mso-table-rspace:0; margin:0'>
                                             
                                                                                                <br/><br/>

                                            

                                                                                            </p>
                                                                                        </td>
                                                                                    </tr>
                                                                                </table>

                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td bgcolor='#fe7f00'><div style='height:6px'>&nbsp;</div></td>
                                                                    </tr>
                                                                </table><!-- End 2 Column Images & Text Side by SIde -->


                                                    <div style='height:15px;margin:0 auto;'>&nbsp;</div><!-- spacer -->
			                                                    <!-- Two Column (Images Stacked over Text) -->
			 
 
       
 

                                                    <div style='height:35px;margin:0 auto;'>&nbsp;</div><!-- spacer -->


			                                                    <!-- 4 Columns -->
			                                                    <table width='100%' border='0' cellpadding='0' cellspacing='0' align='center'>
				                                                    <tr>
					                                                    <td bgcolor='#363636' style='padding:30px 0'>
                                                                            <table width='580' border='0' cellpadding='10' cellspacing='0' align='center' class='deviceWidth' style='margin:0 auto;'>
                                                                                <tr>
                                                                                    <td>
                                                                                            <table width='45%' cellpadding='0' cellspacing='0'  border='0' align='left' class='deviceWidth'>
                                                                                                <tr>
                                                                                                    <td valign='top' style='font-size: 11px; color: #f1f1f1; color:#999; font-family: Arial, sans-serif; padding-bottom:20px' class='center'>

                                                                                                       Departamento de Sistemas, Redes y Soporte Técnico | 
                                                                                                        <a href='www.cecyteo.edu.mx/nova' style='color:#999;text-decoration:none;'>NOVA - " + DateTime.Now.Year + @"</a><br/>

                                                                                                        <br/><br/>
                                                   

                                                                                                    </td>
                                                                                                </tr>
                                                                                            </table>

                                                                                            <table width='40%' cellpadding='0' cellspacing='0'  border='0' align='right' class='deviceWidth'>
                                                                                                <tr>
                                                                                                    <td valign='top' style='font-size: 11px; color: #f1f1f1; font-weight: normal; font-family: Helvetica, Georgia, Times, serif; line-height: 26px; vertical-align: top; text-align:right' class='center'>
                                                                                                         Todos los Derechos Reservados - Cecyteo  

                                                                                                        <a href='#'><img src='https://www.cecyteo.edu.mx/Nova/app_themes/Nova2015/img/logocecyte.png' alt='' border='0' /></a>

                                                   
                                                                                                    </td>
                                                                                                </tr>
                                                                                            </table>

                        		                                                    </td>
                        	                                                    </tr>
                                                                            </table>
                                                                        </td>
                                                                    </tr>
                                                                </table><!-- End 4 Columns -->

		                                                    </td>
	                                                    </tr>
                                                    </table> <!-- End Wrapper -->
                                                    <div style='display:none; white-space:nowrap; font:15px courier; color:#ffffff;'>
                                                    - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
                                                    </div>
                                                    </body>
                                                    </html>";

                    msg.Body = cuerpo;
                    //msg.Body = "Favor de pasar a entregar la pelicula:" +  " " + tituloprestamo + " "+ "ya que el tiempo del prestamo ha vencido";
                    SmtpClient client = new SmtpClient();

                    client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
                    client.Host = "smtp.gmail.com";
                    client.Port = 587;
                    client.DeliveryMethod = SmtpDeliveryMethod.Network;
                    client.EnableSsl = true;
                    // client.UseDefaultCredentials = false; 
                    client.Send(msg);



                }

            }

            var cinedebates_stPrestamosAdmin2 = db.Cinedebates_stPrestamos.Include(c => c.Cinedebates_ctEstatusFormato).Include(c => c.Cinedebates_ctPeliculas).Include(c => c.Convenios_stConvenioLaboralTrabajadorCategoria);
            return View(cinedebates_stPrestamosAdmin2.ToList());
        }
        public ActionResult PrestamoIndex(int IdConvenioLaboralTrabajadorCategoria)
        {
            Session["IdConvenioLaboralTrabajadorCategoria2"] = IdConvenioLaboralTrabajadorCategoria;
            var cinedebates_stPrestamosPre = db.Cinedebates_stPrestamos.Where(c => c.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).Include(c => c.Cinedebates_ctEstatusFormato).Include(c => c.Cinedebates_ctPeliculas).Include(c => c.Convenios_stConvenioLaboralTrabajadorCategoria); 
            return View(cinedebates_stPrestamosPre.ToList());
        }

      
        
        

        // GET: PeliculasPrestamos/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Cinedebates_stPrestamos cinedebates_stPrestamos = db.Cinedebates_stPrestamos.Find(id);
            if (cinedebates_stPrestamos == null)
            {
                return HttpNotFound();
            }
            return View(cinedebates_stPrestamos);
        }

        // GET: PeliculasPrestamos/Create
        public ActionResult Create(int idpelicula)
        {
            ViewBag.IdEstatusFormato = new SelectList(db.Cinedebates_ctEstatusFormato, "IdEstatusFormato", "EstatusFormato");
            ViewBag.IdPelicula = new SelectList(db.Cinedebates_ctPeliculas.Where(a => a.Existencias > 0 && a.IdPelicula == idpelicula), "IdPelicula", "TituloPelicula");
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            return View();
        }

        // POST: PeliculasPrestamos/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdPrestamo,IdConvenioLaboralTrabajadorCategoria,IdPelicula,FechaPrestamo,FechaEntrega,Comentarios,IdEstatusFormato")] Cinedebates_stPrestamos cinedebates_stPrestamos)
        {
            //int IdConvenioLaboralTrabajadorCategoria = (int)Session["IdConvenioLaboralTrabajadorCategoria"];
            int IdConvenioLaboralTrabajadorCategoria =  Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            if (ModelState.IsValid)
            {
                using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                        TransactionOptions Grabar = new TransactionOptions();
                        Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                        using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                    {
                          try
                            {
                              //modificar existencias

                                var pelicula = db.Cinedebates_ctPeliculas.Find(cinedebates_stPrestamos.IdPelicula);
                                pelicula.Existencias = pelicula.Existencias - 1;
                                db.Entry(pelicula).State = System.Data.Entity.EntityState.Modified;
                                db.SaveChanges();  
                              //grabar prestamo
                                cinedebates_stPrestamos.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                db.Cinedebates_stPrestamos.Add(cinedebates_stPrestamos);
                                db.SaveChanges();
                                trans.Complete();
                            }
                          catch (Exception e)
                          {
                              ViewData["EditError"] = e.Message;
                              // all changes will be rolled back
                          }
                          scope.Complete();
                    }
                        return RedirectToAction("Index");
                    }
            }

            ViewBag.IdEstatusFormato = new SelectList(db.Cinedebates_ctEstatusFormato, "IdEstatusFormato", "EstatusFormato", cinedebates_stPrestamos.IdEstatusFormato);
            ViewBag.IdPelicula = new SelectList(db.Cinedebates_ctPeliculas.Where(a => a.Existencias > 0), "IdPelicula", "TituloPelicula", cinedebates_stPrestamos.IdPelicula);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", cinedebates_stPrestamos.IdConvenioLaboralTrabajadorCategoria);
            return View(cinedebates_stPrestamos);
        }

        public ActionResult Create2()
        {
            ViewBag.IdEstatusFormato = new SelectList(db.Cinedebates_ctEstatusFormato, "IdEstatusFormato", "EstatusFormato");
            ViewBag.IdPelicula = new SelectList(db.Cinedebates_ctPeliculas.Where(a=> a.Existencias > 0), "IdPelicula", "TituloPelicula");
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            return View();
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create2([Bind(Include = "IdPrestamo,IdConvenioLaboralTrabajadorCategoria,IdPelicula,FechaPrestamo,FechaEntrega,Comentarios,IdEstatusFormato")] Cinedebates_stPrestamos cinedebates_stPrestamos)
        {
            int IdConvenioLaboralTrabajadorCategoria = (int)Session["IdConvenioLaboralTrabajadorCategoria2"];
            if (ModelState.IsValid)
            {
                using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                        TransactionOptions Grabar = new TransactionOptions();
                        Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                        using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                    {
                          try
                            {
                                //modificar existencias

                                var pelicula2 = db.Cinedebates_ctPeliculas.Find(cinedebates_stPrestamos.IdPelicula);
                                pelicula2.Existencias = pelicula2.Existencias - 1;
                                db.Entry(pelicula2).State = System.Data.Entity.EntityState.Modified;
                                db.SaveChanges();
                                //grabar prestamo
                                cinedebates_stPrestamos.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                db.Cinedebates_stPrestamos.Add(cinedebates_stPrestamos);
                                db.SaveChanges();                                
                                trans.Complete();
                            }
                          catch (Exception e)
                          {
                              ViewData["EditError"] = e.Message;
                              // all changes will be rolled back
                          }
                          scope.Complete();
                    }
                        return RedirectToAction("PrestamoIndex", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                    }
            }

            ViewBag.IdEstatusFormato = new SelectList(db.Cinedebates_ctEstatusFormato, "IdEstatusFormato", "EstatusFormato", cinedebates_stPrestamos.IdEstatusFormato);
            ViewBag.IdPelicula = new SelectList(db.Cinedebates_ctPeliculas.Where(a => a.Existencias > 0), "IdPelicula", "TituloPelicula", cinedebates_stPrestamos.IdPelicula);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", cinedebates_stPrestamos.IdConvenioLaboralTrabajadorCategoria);
            return View(cinedebates_stPrestamos);
        }

        // GET: PeliculasPrestamos/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Cinedebates_stPrestamos cinedebates_stPrestamos = db.Cinedebates_stPrestamos.Find(id);
            if (cinedebates_stPrestamos == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdEstatusFormato = new SelectList(db.Cinedebates_ctEstatusFormato, "IdEstatusFormato", "EstatusFormato", cinedebates_stPrestamos.IdEstatusFormato);
            ViewBag.IdPelicula = new SelectList(db.Cinedebates_ctPeliculas.Where(a => a.Existencias > 0), "IdPelicula", "TituloPelicula", cinedebates_stPrestamos.IdPelicula);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", cinedebates_stPrestamos.IdConvenioLaboralTrabajadorCategoria);
            return View(cinedebates_stPrestamos);
        }

        // POST: PeliculasPrestamos/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdPrestamo,IdConvenioLaboralTrabajadorCategoria,IdPelicula,FechaPrestamo,FechaEntrega,Comentarios,IdEstatusFormato")] Cinedebates_stPrestamos cinedebates_stPrestamos)
        {
            int IdConvenioLaboralTrabajadorCategoria = (int)Session["IdConvenioLaboralTrabajadorCategoria"];
            if (ModelState.IsValid)
            {
                using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                        TransactionOptions Grabar = new TransactionOptions();
                        Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                        using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                    {
                          try
                            {
                            cinedebates_stPrestamos.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                            db.Entry(cinedebates_stPrestamos).State = System.Data.Entity.EntityState.Modified;
                            db.SaveChanges();                            
                            trans.Complete();
                            }
                          catch (Exception e)
                          {
                              ViewData["EditError"] = e.Message;
                              // all changes will be rolled back
                          }
                          scope.Complete();
                    }
                        return RedirectToAction("Index");
                    }
            }
            ViewBag.IdEstatusFormato = new SelectList(db.Cinedebates_ctEstatusFormato, "IdEstatusFormato", "EstatusFormato", cinedebates_stPrestamos.IdEstatusFormato);
            ViewBag.IdPelicula = new SelectList(db.Cinedebates_ctPeliculas.Where(a => a.Existencias > 0), "IdPelicula", "TituloPelicula", cinedebates_stPrestamos.IdPelicula);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", cinedebates_stPrestamos.IdConvenioLaboralTrabajadorCategoria);
            return View(cinedebates_stPrestamos);
        }

        public ActionResult Edit2(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Cinedebates_stPrestamos cinedebates_stPrestamos = db.Cinedebates_stPrestamos.Find(id);
            if (cinedebates_stPrestamos == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdEstatusFormato = new SelectList(db.Cinedebates_ctEstatusFormato, "IdEstatusFormato", "EstatusFormato", cinedebates_stPrestamos.IdEstatusFormato);
            ViewBag.IdPelicula = new SelectList(db.Cinedebates_ctPeliculas.Where(a => a.Existencias > 0), "IdPelicula", "TituloPelicula", cinedebates_stPrestamos.IdPelicula);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", cinedebates_stPrestamos.IdConvenioLaboralTrabajadorCategoria);
            return View(cinedebates_stPrestamos);
        }

        // POST: PeliculasPrestamos/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit2([Bind(Include = "IdPrestamo,IdConvenioLaboralTrabajadorCategoria,IdPelicula,FechaPrestamo,FechaEntrega,Comentarios,IdEstatusFormato")] Cinedebates_stPrestamos cinedebates_stPrestamos)
        {
            int IdConvenioLaboralTrabajadorCategoria = (int)Session["IdConvenioLaboralTrabajadorCategoria2"];
            if (ModelState.IsValid)
            {
                using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                        TransactionOptions Grabar = new TransactionOptions();
                        Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                        using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                    {
                          try
                            {
                                cinedebates_stPrestamos.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                                db.Entry(cinedebates_stPrestamos).State = System.Data.Entity.EntityState.Modified;
                                db.SaveChanges();                                
                                trans.Complete();
                            }
                          catch (Exception e)
                          {
                              ViewData["EditError"] = e.Message;
                              // all changes will be rolled back
                          }
                          scope.Complete();
                    }
                        return RedirectToAction("PrestamoIndex", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
                    }
            }
            ViewBag.IdEstatusFormato = new SelectList(db.Cinedebates_ctEstatusFormato, "IdEstatusFormato", "EstatusFormato", cinedebates_stPrestamos.IdEstatusFormato);
            ViewBag.IdPelicula = new SelectList(db.Cinedebates_ctPeliculas.Where(a => a.Existencias > 0), "IdPelicula", "TituloPelicula", cinedebates_stPrestamos.IdPelicula);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", cinedebates_stPrestamos.IdConvenioLaboralTrabajadorCategoria);
            return View(cinedebates_stPrestamos);
        }

        public ActionResult Edit3(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Cinedebates_stPrestamos cinedebates_stPrestamos = db.Cinedebates_stPrestamos.Find(id);
            if (cinedebates_stPrestamos == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdEstatusFormato = new SelectList(db.Cinedebates_ctEstatusFormato, "IdEstatusFormato", "EstatusFormato", cinedebates_stPrestamos.IdEstatusFormato);
            ViewBag.IdPelicula = new SelectList(db.Cinedebates_ctPeliculas.Where(a => a.Existencias > 0), "IdPelicula", "TituloPelicula", cinedebates_stPrestamos.IdPelicula);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", cinedebates_stPrestamos.IdConvenioLaboralTrabajadorCategoria);
            return View(cinedebates_stPrestamos);
        }

        // POST: PeliculasPrestamos/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit3([Bind(Include = "IdPrestamo,IdConvenioLaboralTrabajadorCategoria,IdPelicula,FechaPrestamo,FechaEntrega,Comentarios,IdEstatusFormato")] Cinedebates_stPrestamos cinedebates_stPrestamos)
        {
            
            if (ModelState.IsValid)
            {
                using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                        TransactionOptions Grabar = new TransactionOptions();
                        Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                        using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                    {
                          try
                            {
                                var prestamos = (from a in db.Cinedebates_stPrestamos
                                              where a.IdPrestamo == cinedebates_stPrestamos.IdPrestamo
                                              select new
                                              {
                                                  idconveniolaboraltrabajadorcategoria = a.IdConvenioLaboralTrabajadorCategoria,
                                                  idpelicula = a.IdPelicula,
                                                  idestatus = a.IdEstatusFormato
                                              });
                                int idcltc = prestamos.FirstOrDefault().idconveniolaboraltrabajadorcategoria;
                                int idpelicula = prestamos.FirstOrDefault().idpelicula;
                                int idestatus = prestamos.FirstOrDefault().idestatus;
                                cinedebates_stPrestamos.IdConvenioLaboralTrabajadorCategoria = idcltc;                             
                                db.Entry(cinedebates_stPrestamos).State = System.Data.Entity.EntityState.Modified;
                                db.SaveChanges();                                
                                trans.Complete();
                            }
                          catch (Exception e)
                          {
                              ViewData["EditError"] = e.Message;
                              // all changes will be rolled back
                          }
                          scope.Complete();
                    }
                        return RedirectToAction("AdminIndex");
                    }
            }
            ViewBag.IdEstatusFormato = new SelectList(db.Cinedebates_ctEstatusFormato, "IdEstatusFormato", "EstatusFormato", cinedebates_stPrestamos.IdEstatusFormato);
            ViewBag.IdPelicula = new SelectList(db.Cinedebates_ctPeliculas.Where(a => a.Existencias > 0), "IdPelicula", "TituloPelicula", cinedebates_stPrestamos.IdPelicula);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", cinedebates_stPrestamos.IdConvenioLaboralTrabajadorCategoria);
            return View(cinedebates_stPrestamos);
        }

        // GET: PeliculasPrestamos/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Cinedebates_stPrestamos cinedebates_stPrestamos = db.Cinedebates_stPrestamos.Find(id);
            if (cinedebates_stPrestamos == null)
            {
                return HttpNotFound();
            }
            return View(cinedebates_stPrestamos);
        }

        // POST: PeliculasPrestamos/Delete/5
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        [HttpPost, ActionName("DeleteConfirmed")]
        public JsonResult DeleteConfirmed(int id)
        {
             using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                        TransactionOptions Grabar = new TransactionOptions();
                        Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                        using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                    {
                          try
                            {
                            Cinedebates_stPrestamos cinedebates_stPrestamos = db.Cinedebates_stPrestamos.Find(id);
                            db.Cinedebates_stPrestamos.Remove(cinedebates_stPrestamos);
                            db.SaveChanges();
                            var pelicula = db.Cinedebates_ctPeliculas.Find(cinedebates_stPrestamos.IdPelicula);
                            pelicula.Existencias = pelicula.Existencias + 1;
                            db.Entry(pelicula).State = System.Data.Entity.EntityState.Modified;
                            db.SaveChanges();  
                           
                            }
                          catch (Exception e)
                          {
                              ViewData["EditError"] = e.Message;
                              // all changes will be rolled back
                          }
                          scope.Complete();
                    }
                        return new JsonResult() { Data = "Registro eliminado exitosamente" };
                    }
            //return RedirectToAction("Index");
        }
        public ActionResult Delete2(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Cinedebates_stPrestamos cinedebates_stPrestamos = db.Cinedebates_stPrestamos.Find(id);
            if (cinedebates_stPrestamos == null)
            {
                return HttpNotFound();
            }
            return View(cinedebates_stPrestamos);
        }

        // POST: PeliculasPrestamos/Delete/5
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        [HttpPost, ActionName("DeleteConfirmed2")]
        public JsonResult DeleteConfirmed2(int id)
        {
            using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                        TransactionOptions Grabar = new TransactionOptions();
                        Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                        using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                    {
                          try
                            {
                                Cinedebates_stPrestamos cinedebates_stPrestamos = db.Cinedebates_stPrestamos.Find(id);
                                db.Cinedebates_stPrestamos.Remove(cinedebates_stPrestamos);
                                db.SaveChanges();
                                var pelicula = db.Cinedebates_ctPeliculas.Find(cinedebates_stPrestamos.IdPelicula);
                                pelicula.Existencias = pelicula.Existencias + 1;
                                db.Entry(pelicula).State = System.Data.Entity.EntityState.Modified;
                                db.SaveChanges();  
                                
                            }
                          catch (Exception e)
                          {
                              ViewData["EditError"] = e.Message;
                              // all changes will be rolled back
                          }
                          scope.Complete();
                    }
                        return new JsonResult() { Data = "Registro eliminado exitosamente" };
                    }
          
            //return RedirectToAction("Index");
        }
        public ActionResult Delete3(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Cinedebates_stPrestamos cinedebates_stPrestamos = db.Cinedebates_stPrestamos.Find(id);
            if (cinedebates_stPrestamos == null)
            {
                return HttpNotFound();
            }
            return View(cinedebates_stPrestamos);
        }

        // POST: PeliculasPrestamos/Delete/5
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        [HttpPost, ActionName("DeleteConfirmed3")]
        public JsonResult DeleteConfirmed3(int id)
        {
            using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                        TransactionOptions Grabar = new TransactionOptions();
                        Grabar.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                        using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, Grabar))
                    {
                          try
                            {
                                Cinedebates_stPrestamos cinedebates_stPrestamos = db.Cinedebates_stPrestamos.Find(id);
                                db.Cinedebates_stPrestamos.Remove(cinedebates_stPrestamos);
                                db.SaveChanges();
                                var pelicula = db.Cinedebates_ctPeliculas.Find(cinedebates_stPrestamos.IdPelicula);
                                pelicula.Existencias = pelicula.Existencias + 1;
                                db.Entry(pelicula).State = System.Data.Entity.EntityState.Modified;
                                db.SaveChanges();  
                                
                            }
                          catch (Exception e)
                          {
                              ViewData["EditError"] = e.Message;
                              // all changes will be rolled back
                          }
                          scope.Complete();
                    }
                        return new JsonResult() { Data = "Registro eliminado exitosamente" };
                    }
            //return RedirectToAction("Index");
        }


        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
