﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.Web.Helpers;
using System.IO;

namespace Nova.Controllers.Portal
{
    public class SiteRevistasController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /SiteRevistas/
        public ActionResult Index()
        {
            var portal_articulos = db.Portal_Articulos.Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Portal_TipoArticulo);
            return View(portal_articulos.Where(f => f.Portal_TipoArticulo.TipoArticulo == "REVISTA").OrderByDescending(o => o.IdArticulo).ToList());
        }



        //métodos para agregar revistas lluevia de ciencia. ******************************************************************************

        // GET: /other/Create
        public ActionResult Create()
        {

            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "IdConvenioLaboralTrabajadorCategoria");
            ViewBag.IdTipoArticulo = new SelectList(db.Portal_TipoArticulo, "IdTipoArticulo", "TipoArticulo");
            return View();
        }

        // POST: /other/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdArticulo,NombreArticulo,FechaCreacion,FechaInicioPublicacion,FechaTermino,IdConvenioLaboralTrabajadorCategoria,Descripcion,Contenido,ImagenUrl,Publicar,Visitas,Twiter,IdTipoArticulo,UrlExterno")] Portal_Articulos portal_articulos)
        {
            portal_articulos.FechaCreacion = DateTime.Now;
            portal_articulos.IdConvenioLaboralTrabajadorCategoria = 2;
            portal_articulos.Descripcion = "--------------------------------------------------";
            portal_articulos.Contenido = "------";
            portal_articulos.Visitas = 0;
            portal_articulos.Twiter = 0;
            portal_articulos.IdTipoArticulo = db.Portal_TipoArticulo.Where(t => t.TipoArticulo == "REVISTA").Select(f => f.IdTipoArticulo).FirstOrDefault();


            ModelState["Descripcion"].Errors.Clear();

            //ModelState["ImagenUrl"].Errors.Clear();
            ModelState["Contenido"].Errors.Clear();
            //ModelState["IdTipoArticulo"].Errors.Clear();


            if (ModelState.IsValid)
            {
                String fileName = Request.Files[0].FileName;
                if (fileName != "" && fileName != null)
                {
                    var image = new WebImage(Request.Files[0].InputStream);
                    var pathimg = Path.Combine(Server.MapPath("~/Content/Site/Images/AvisosConvocatorias"), Path.GetFileName(fileName));

                    var Height = image.Height;
                    var Width = image.Width;
                    decimal Top = System.Convert.ToDecimal(Request["hfimgcrop_top"]);
                    decimal Left = System.Convert.ToDecimal(Request["hfimgcrop_left"]);
                    decimal Bottom = System.Convert.ToDecimal(Request["hfimgcrop_bottom"]);
                    decimal Right = System.Convert.ToDecimal(Request["hfimgcrop_right"]);
                    image.Crop((int)Top, (int)Left, (int)(Height - Bottom), (int)(Width - Right));
                    image.Resize(960, 587, true, true);
                    image.Save(pathimg);

                    portal_articulos.ImagenUrl = fileName;

                }
                else
                {
                    ModelState.AddModelError("", "No se pudo cargar la imagen!!!");
                }

                if (portal_articulos.Publicar == true)
                {
                    portal_articulos.FechaInicioPublicacion = DateTime.Now;
                }

                db.Portal_Articulos.Add(portal_articulos);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "IdConvenioLaboralTrabajadorCategoria", portal_articulos.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdTipoArticulo = new SelectList(db.Portal_TipoArticulo, "IdTipoArticulo", "TipoArticulo", portal_articulos.IdTipoArticulo);
            return View(portal_articulos);
        }

        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_Articulos portal_articulos = db.Portal_Articulos.Find(id);
            if (portal_articulos == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "IdConvenioLaboralTrabajadorCategoria", portal_articulos.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdTipoArticulo = new SelectList(db.Portal_TipoArticulo, "IdTipoArticulo", "TipoArticulo", portal_articulos.IdTipoArticulo);
            return View(portal_articulos);
        }

        // POST: /other/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdArticulo,NombreArticulo,FechaCreacion,FechaInicioPublicacion,FechaTermino,IdConvenioLaboralTrabajadorCategoria,Descripcion,Contenido,ImagenUrl,Publicar,Visitas,Twiter,IdTipoArticulo,UrlExterno")] Portal_Articulos portal_articulos)
        {
            var id = portal_articulos.IdArticulo;

            string fileurl = db.Portal_Articulos.Where(t => t.IdArticulo == id).Select(t => t.ImagenUrl).FirstOrDefault();


            portal_articulos.IdConvenioLaboralTrabajadorCategoria = 2;
            portal_articulos.Descripcion = "--------------------------------------------------";
            portal_articulos.Contenido = "------";
            portal_articulos.ImagenUrl = fileurl;

            portal_articulos.IdTipoArticulo = db.Portal_TipoArticulo.Where(t => t.TipoArticulo == "REVISTA").Select(f => f.IdTipoArticulo).FirstOrDefault();

            ModelState["ImagenUrl"].Errors.Clear();
            ModelState["Contenido"].Errors.Clear();
            ModelState["Descripcion"].Errors.Clear();



            if (ModelState.IsValid)
            {
                String fileName = Request.Files[0].FileName;
                if (fileName != "" && fileName != null)
                {
                    var image = new WebImage(Request.Files[0].InputStream);
                    var pathimg = Path.Combine(Server.MapPath("~/Content/Site/Images/AvisosConvocatorias"), Path.GetFileName(fileName));

                    var Height = image.Height;
                    var Width = image.Width;
                    decimal Top = System.Convert.ToDecimal(Request["hfimgcrop_top"]);
                    decimal Left = System.Convert.ToDecimal(Request["hfimgcrop_left"]);
                    decimal Bottom = System.Convert.ToDecimal(Request["hfimgcrop_bottom"]);
                    decimal Right = System.Convert.ToDecimal(Request["hfimgcrop_right"]);
                    image.Crop((int)Top, (int)Left, (int)(Height - Bottom), (int)(Width - Right));
                    image.Resize(960, 587, true, true);
                    image.Save(pathimg);

                    if (portal_articulos.EliminarImage(Path.Combine(Server.MapPath("~/Content/Site/Images/AvisosConvocatorias"), Path.GetFileName(fileurl))).IsValid) { }

                    portal_articulos.ImagenUrl = fileName;
                }
                else
                {
                    ModelState.AddModelError("", "Se ha producido un error al subir la imagen.");
                }


                if (portal_articulos.Publicar == true)
                {
                    var fechaPublica = db.Portal_Articulos.Where(a => a.IdArticulo == id).Select(f => f.FechaInicioPublicacion).FirstOrDefault();
                    if (fechaPublica == null)
                    {
                        portal_articulos.FechaInicioPublicacion = DateTime.Now;
                    }
                    else
                    {
                        portal_articulos.FechaInicioPublicacion = fechaPublica;
                    }
                }

                portal_articulos.FechaCreacion = db.Portal_Articulos.Where(a => a.IdArticulo == id).Select(f => f.FechaCreacion).FirstOrDefault();


                db.Entry(portal_articulos).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "IdConvenioLaboralTrabajadorCategoria", portal_articulos.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdTipoArticulo = new SelectList(db.Portal_TipoArticulo, "IdTipoArticulo", "TipoArticulo", portal_articulos.IdTipoArticulo);
            return View(portal_articulos);
        }

        // GET: /other/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_Articulos portal_articulos = db.Portal_Articulos.Find(id);
            if (portal_articulos == null)
            {
                return HttpNotFound();
            }
            return View(portal_articulos);
        }

        // GET: /SiteRevistas/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_Articulos portal_articulos = db.Portal_Articulos.Find(id);
            if (portal_articulos == null)
            {
                return HttpNotFound();
            }
            return View(portal_articulos);
        }

        // POST: /SiteRevistas/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Portal_Articulos portal_articulos = db.Portal_Articulos.Find(id);
            db.Portal_Articulos.Remove(portal_articulos);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
