﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.IO;
//using System.Configuration;
using System.Linq;
using System.Net;
using System.Net.Mail;
using System.Web;
using System.Web.Mvc;


namespace Nova.Controllers
{
    

    public class SitePreviewController : Controller
    {
        bdAriesEntities bdAries = new bdAriesEntities();
        bdNovaEntities bdNova = new bdNovaEntities();

        public ActionResult Index()
        {
            ViewBag.SepRss = Nova.Models.SepRssReader.GetFeed();
            return View();
        }


        public ActionResult Team()
        {
            return View();
        }


        public ActionResult OfertaEducativa(string m = null, int e = 0, string c = null, decimal longitud = 0, decimal latitud = 0)
        {
            bdNovaEntities bd = new bdNovaEntities();
            var plazas = bd.Plazas_stDistribucionPlazaCategoria.Where(w =>
                  w.Plazas_ctCategoria.Categoria == "RESPONSABLE DE CENTRO \" A \"" ||
                                                               w.Plazas_ctCategoria.Categoria == "RESPONSABLE DE CENTRO \" B \"" ||
                                                               w.Plazas_ctCategoria.Categoria == "RESPONSABLE DE CENTRO \" C \"" ||
                                                               w.Plazas_ctCategoria.Categoria == "DIRECTOR DE PLANTEL \"A\"" ||
                                                               w.Plazas_ctCategoria.Categoria == "DIRECTOR DE PLANTEL \"B\"").Select(v => v.IdDistribucionPlazaCategoria).ToArray();


            List<Convenios_stConvenioLaboralTrabajadorCategoria> model = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(f => plazas.Contains(f.IdDistribucionPlazaCategoria)).ToList();

            //return View(model);

            if (m == null)
            {
                ViewBag.ModalEstudio = "plantel";
                if (c == "" || c == null)
                {
                    ViewBag.CentroEducativo = bdNova.Catalogos_ctEstructuraOrganica.Where(t => t.EstructuraOrganica.Contains("PLANTEL NUM")).OrderBy(t => t.IdEstructuraOrganica).Select(s => s.EstructuraOrganica).FirstOrDefault();
                }
            }
            else if (m != null || m != "")
            {
                if (m == "plantel")
                {
                    ViewBag.ModalEstudio = "plantel";
                    if (c == "" || c == null)
                    {
                        ViewBag.CentroEducativo = bdNova.Catalogos_ctEstructuraOrganica.Where(t => t.EstructuraOrganica.Contains("PLANTEL NUM")).OrderBy(t => t.IdEstructuraOrganica).Select(s => s.EstructuraOrganica).FirstOrDefault();
                    }
                }
                else if (m == "emsad")
                {
                    ViewBag.ModalEstudio = "emsad";
                    if (c == "" || c == null)
                    {
                        ViewBag.CentroEducativo = bdNova.Catalogos_ctEstructuraOrganica.Where(t => t.EstructuraOrganica.Contains("EMSAD NUM")).OrderBy(t => t.IdEstructuraOrganica).Select(s => s.EstructuraOrganica).FirstOrDefault();
                        var eq = bdNova.Catalogos_ctEstructuraOrganica.Where(t => t.EstructuraOrganica.Contains("EMSAD NUM")).OrderBy(t => t.IdEstructuraOrganica).Select(s => s.IdCampusEquivalencia).FirstOrDefault();
                        ViewBag.EquivalenciaActive = eq;
                    }
                }
            }



            if (e != 0)
            {
                ViewBag.CentroEducativo = c;
                ViewBag.EquivalenciaActive = e;
                ViewBag.Longitud = longitud;
                ViewBag.Latitud = latitud;
            }



            return View(model);

        }


        public ActionResult Servicios()
        {
            return View();
        }

        public ActionResult About()
        {
            return View();
        }


        public ActionResult Contact()
        {
            return View();
        }

        public JsonResult ContactoDirectorio(Mail mail)
        {
            JsonResult json = new JsonResult();
            if (ModelState.IsValid)
            {
                string Directorio = System.Convert.ToString(Request["mailto"]);
                try
                {
                    SendMail.Paramether(mail.fname, mail.lname, mail.email, mail.subject, mail.message, Directorio);
                }
                catch (Exception)
                {


                }

            }

            return json;
        }

        public ActionResult Search()
        {
            String palabra = System.Convert.ToString(Request["search"]);
            ViewBag.palabra = palabra;
            return View();
        }

        public ActionResult Contenido(int id)
        {
            ViewBag.Contenido = id;
            return View();
        }



        public ActionResult Noticias(int? id, int? page)
        {

            ViewBag.Contenido = id;
            if (page != null)
            {
                ViewBag.Page = page;
            }
            else
            {
                ViewBag.Page = 1;
            }

            return View();
        }


        public ActionResult NoticiasTipo(String categoria = null)
        {
            ViewBag.Categoria = categoria;
            //ViewBag.Fecha = fecha;
            return View();
        }
        public ActionResult NoticiasFecha(int? anio, int? mes)
        {
            ViewBag.Anio = anio;
            ViewBag.Mes = mes;
            return View();
        }
        public ActionResult CarrerasTecnicas(int id)
        {
            ViewBag.CTid = id;
            return View();
        }

        public ActionResult Avisos(int id)
        {

            ViewBag.Aviso = id;
            return View();
        }
        public ActionResult Convocatorias(int id)
        {

            ViewBag.Conv = id;
            return View();
        }
        //public ActionResult getFotografia(string id)
        //{
        //    string tipo = "";
        //    byte[] image = PortalNovaAries.getFotografia(id,ref tipo);
            
        //    return File(image, tipo);
        //}

        public ActionResult getFotografia(string id)
        {
            List<stAlumnosFotos> fotos = (List<stAlumnosFotos>)Session["AlumnosFotos"];
            string tipo = "jpg";
            byte[] image = PortalNovaAries.getFotografia(id, ref tipo, fotos);
            //string tipo = PortalNovaAries.getTipoFotografia(id);
            if (image != null)
                return File(image, tipo);
            else
                return null;
        }

        //public FileResult Download(string path)
        //{
        //    byte[] fileBytes = System.IO.File.ReadAllBytes("~/Content/Site/FilesUpload/" + path);

        //    return File(fileBytes, System.Net.Mime.MediaTypeNames.Application.Octet, path);
        //}

        public ActionResult Download(string fileName)
        {
            string fullpath = Request.MapPath("~/Content/Site/FilesUpload/" + fileName);
            return File(Nova.Models.Formatos.getByteFile(fullpath), System.Net.Mime.MediaTypeNames.Application.Octet, fileName);
        }

        byte[] GetFile(string s)
        {
            System.IO.FileStream fs = System.IO.File.OpenRead(s);
            byte[] data = new byte[fs.Length];
            int br = fs.Read(data, 0, data.Length);
            if (br != fs.Length)
                throw new System.IO.IOException(s);
            return data;
        }

        public JsonResult getPlanEstudios(int id)
        {
            try
            {
                List<PlanesEstudio> planes = new List<PlanesEstudio>();
                Int32 planVigente = bdAries.ctPlanEstudio.Where(t => t.IdStatusPlan == t.ctStatusPlan.IdStatusPlan && t.ctStatusPlan.Nombre == "VIGENTE" && t.IdCarrera == id).OrderByDescending(o => o.IdPlanEstudio).Select(s => s.IdPlanEstudio).FirstOrDefault();
                var details = bdAries.stPlanEstudioAsignatura.Where(t => t.IdAsignatura == t.ctAsignatura.IdAsignatura && t.IdPlanEstudio == planVigente).OrderBy(o => new { o.IdValorCiclo, o.Orden }).ToList();

                foreach (var item in details)
                {
                    PlanesEstudio lista = new PlanesEstudio();
                    lista.IdValorCiclo = item.IdValorCiclo;
                    lista.Orden = Convert.ToInt32(item.Orden);
                    lista.ClaveAsignatura = item.ClaveAsignatura;
                    lista.IdAsignatura = item.ctAsignatura.IdAsignatura;
                    lista.Nombre = item.ctAsignatura.Nombre;
                    lista.Creditos = item.ctAsignatura.Creditos;
                    lista.Componente = item.ctAsignatura.ctTipoComponente.Nombre;
                    planes.Add(lista);
                }

                return Json(new { Results = planes }, JsonRequestBehavior.AllowGet);
            }
            catch (Exception)
            {
                throw;
            }
        }


    }
}