﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.IO;
using Dapper;
using Seguridad;
using System.Transactions;

namespace Nova.Controllers
{
    public class SiteDatosDocumentosWebController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /Anexos/
        public ActionResult Index()
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            string query = string.Format(@"	select a.IdDatosDocumentoWeb, a.NombreDocumentoWeb, a.Año, a.IdTrimesteDocumentoWeb, a.IdPortalCatalogoApartado, a.Orden, a.FechaRegistro, a.IdKardexRegistro, a.Observaciones,
                                             b.IdDocumentosWeb, b.Archivo, b.TipoDocumento, b.NombreArchivo,
                                             c.Nombre,c.ApellidoPaterno,c.ApellidoMaterno,
                                             d.NombreTrimestre, f.PortalCatalogoApartado, g.NombrePortalCatalogoDocumento,
											 a.IdFraccionDocumento, h.NombreFraccionDocumento,j.NombreIncisoDocumento
                                             from Portal_DatosDocumentoWeb a
                                             left join bdNovaDocumentacion.dbo.Portal_DocumentosWeb b  on a.IdDatosDocumentoWeb = b.IdDatosDocumentoWeb
                                             inner join vwDatosAspirantesTrabajadores c on a.IdKardexRegistro = c.IdKardex
                                             inner join Portal_TrimestreDocumentoWeb d on a.IdTrimesteDocumentoWeb = d.IdTrimesteDocumentoWeb
                                             inner join Portal_CatalogoApartado f on a.IdPortalCatalogoApartado = f.IdPortalCatalogoApartado
                                             inner join Portal_CatalogoDocumento g on f.IdPortalCatalogoDocumento= g.IdPortalCatalogoDocumento
											  inner join Portal_FraccionDocumento h on a.IdFraccionDocumento= h.IdFraccionDocumento
											  left join Portal_IncisoFraccionDocumento j on h.IdIncisoFraccionDocumento= j.IdIncisoFraccionDocumento");
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var documentosweb = (List<DocumentosWeb>)dp.connection.Query<DocumentosWeb>(query);
            dp.Close();
            //return View(documentosweb.Where(z => z.IdKardex == IdKardex));
            return View(documentosweb);
        }

        public FileResult VerInfo(int iddatosdocumentoweb)
        {
            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string querydatosweb;

            querydatosweb = @"select* from bdNovaDocumentacion.dbo.Portal_DocumentosWeb
                                where bdNovaDocumentacion.dbo.Portal_DocumentosWeb.IdDatosDocumentoWeb = @iddatosdocumentoweb";
            var documentosweb = (List<Portal_DocumentosWeb>)dpcg.connection.Query<Portal_DocumentosWeb>(querydatosweb, new { iddatosdocumentoweb });
            dpcg.Close();

            if (documentosweb.FirstOrDefault().TipoDocumento == "application/pdf")
            {
                return File(documentosweb.FirstOrDefault().Archivo, "application/pdf");

            }
            else if (documentosweb.FirstOrDefault().TipoDocumento == "application/msword")
            {
                return File(documentosweb.FirstOrDefault().Archivo, "application/msword");
            }

            else if (documentosweb.FirstOrDefault().TipoDocumento == "image/jpeg")
            {
                return File(documentosweb.FirstOrDefault().Archivo, "image/jpeg");
            }
            else if (documentosweb.FirstOrDefault().TipoDocumento == "application/vnd.ms-excel")
            {
                return File(documentosweb.FirstOrDefault().Archivo, "application/vnd.ms-excel");
            }
            else if (documentosweb.FirstOrDefault().TipoDocumento == "application/vnd.openxmlformats-officedocument.wordprocessingml.document")
            {
                return File(documentosweb.FirstOrDefault().Archivo, "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            }

            return File(documentosweb.FirstOrDefault().Archivo, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        }


        public FileResult DescargarInfo(int iddatosdocumentoweb)
        {
            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string querydatosweb;

            querydatosweb = @"select* from bdNovaDocumentacion.dbo.Portal_DocumentosWeb
                                where bdNovaDocumentacion.dbo.Portal_DocumentosWeb.IdDatosDocumentoWeb = @iddatosdocumentoweb";
            var documentosweb = (List<Portal_DocumentosWeb>)dpcg.connection.Query<Portal_DocumentosWeb>(querydatosweb, new { iddatosdocumentoweb });
            dpcg.Close();

            if (documentosweb.FirstOrDefault().TipoDocumento == "application/pdf")
            {
                return File(documentosweb.FirstOrDefault().Archivo, "application/pdf", "Descarga_" + documentosweb.FirstOrDefault().NombreArchivo + ".pdf");

            }
            else if (documentosweb.FirstOrDefault().TipoDocumento == "application/msword")
            {
                return File(documentosweb.FirstOrDefault().Archivo, "application/msword", "Descarga_" + documentosweb.FirstOrDefault().NombreArchivo + ".doc");
            }

            else if (documentosweb.FirstOrDefault().TipoDocumento == "image/jpeg")
            {
                return File(documentosweb.FirstOrDefault().Archivo, "image/jpeg", "Descarga_" + documentosweb.FirstOrDefault().NombreArchivo + ".jpg");
            }
            else if (documentosweb.FirstOrDefault().TipoDocumento == "application/vnd.ms-excel")
            {
                return File(documentosweb.FirstOrDefault().Archivo, "application/vnd.ms-excel", "Descarga_" + documentosweb.FirstOrDefault().NombreArchivo + ".xls");
            }


            else if (documentosweb.FirstOrDefault().TipoDocumento == "application/octet-stream")
            {
                return File(documentosweb.FirstOrDefault().Archivo, "application/octet-stream", "Descarga_" + documentosweb.FirstOrDefault().NombreArchivo + ".zip");
            }
            else if (documentosweb.FirstOrDefault().TipoDocumento == "application/vnd.openxmlformats-officedocument.wordprocessingml.document")
            {
                return File(documentosweb.FirstOrDefault().Archivo, "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "Descarga_" + documentosweb.FirstOrDefault().NombreArchivo + ".docx");
            }

            return File(documentosweb.FirstOrDefault().Archivo, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "Descarga_" + documentosweb.FirstOrDefault().NombreArchivo + ".xlsx");

            //string modalidad = "Poa_Mir" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";


        }


        // GET: /Anexos/Create
        public ActionResult Create()
        {
            int IdKardexRegistro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
        
            ViewBag.IdTrimesteDocumentoWeb = new SelectList(db.Portal_TrimestreDocumentoWeb, "IdTrimesteDocumentoWeb", "NombreTrimestre");

            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string query;

            query = @"select a.IdPortalCatalogoApartado, a.PortalCatalogoApartado,a.IdPortalCatalogoDocumento,b.NombrePortalCatalogoDocumento
                             from Portal_CatalogoApartado a
                            inner join Portal_CatalogoDocumento b on a.IdPortalCatalogoDocumento = b.IdPortalCatalogoDocumento ";
            var clasificacion = (List<ClasificacionDocumentosWeb>)dpcg.connection.Query<ClasificacionDocumentosWeb>(query);

            string queryfraccion;

            queryfraccion = @"select a.IdFraccionDocumento, a.NombreFraccionDocumento,a.IdIncisoFraccionDocumento,b.NombreIncisoDocumento
                             from Portal_FraccionDocumento a
                            left join Portal_IncisoFraccionDocumento b on a.IdIncisoFraccionDocumento = b.IdIncisoFraccionDocumento ";
            var fraccioninciso = (List<FraccionIncisoDocumentosWeb>)dpcg.connection.Query<FraccionIncisoDocumentosWeb>(queryfraccion);

            dpcg.Close();
            IEnumerable<SelectListItem> selectList = from s in clasificacion
                                                     select new SelectListItem
                                                     {
                                                         Value = s.IdPortalCatalogoApartado.ToString(),
                                                         Text = s.NombrePortalCatalogoDocumento + ' ' + '|' + ' '+ s.PortalCatalogoApartado 
                                                     };
            IEnumerable<SelectListItem> selectListfraccion = from s in fraccioninciso
                                                             select new SelectListItem
                                                     {
                                                         Value = s.IdFraccionDocumento.ToString(),
                                                         Text = s.NombreFraccionDocumento + ' ' + '|' + ' ' + s.NombreIncisoDocumento
                                                             };
            ViewBag.IdPortalCatalogoApartado = new SelectList(selectList, "Value", "Text");
            ViewBag.IdTrimesteDocumentoWeb = new SelectList(db.Portal_TrimestreDocumentoWeb, "IdTrimesteDocumentoWeb", "NombreTrimestre");
            ViewBag.IdFraccionDocumento = new SelectList(selectListfraccion, "Value", "Text");
            ViewBag.IdKardexRegistro = IdKardexRegistro;



            return PartialView();
        }

        // POST: /Anexos/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdDatosDocumentoWeb, NombreDocumentoWeb, Año, IdTrimesteDocumentoWeb, IdPortalCatalogoApartado, IdFraccionDocumento, Orden, FechaRegistro, IdKardexRegistro, Observaciones")] Portal_DatosDocumentoWeb portal_datosdocumentoWeb, HttpPostedFileBase upload)
        {
                    

            if (ModelState.IsValid)
            {

             

                try
                {
                   



                        using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                        {

                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                            portal_datosdocumentoWeb.NombreDocumentoWeb = portal_datosdocumentoWeb.NombreDocumentoWeb.ToUpper();
                            //Escribir Datos de los archivos
                            string sqlQueryDoc = "Insert Into Portal_DatosDocumentoWeb (NombreDocumentoWeb, Año, IdTrimesteDocumentoWeb, IdPortalCatalogoApartado,IdFraccionDocumento, Orden, FechaRegistro, IdKardexRegistro, Observaciones) " +
                             "Values('" + portal_datosdocumentoWeb.NombreDocumentoWeb + "'," + portal_datosdocumentoWeb.Año + "," + portal_datosdocumentoWeb.IdTrimesteDocumentoWeb + "," + portal_datosdocumentoWeb.IdPortalCatalogoApartado + "," + portal_datosdocumentoWeb.IdFraccionDocumento + "," + portal_datosdocumentoWeb.Orden + ",'" + DateTime.Now.ToString("yyyy/MM/dd") + "'," + portal_datosdocumentoWeb.IdKardexRegistro + ",'" + portal_datosdocumentoWeb.Observaciones + "')";
                            var rowsAffectedDoc = dp.connection.Execute(sqlQueryDoc);


                                if (upload != null && upload.ContentLength > 0)

                                {

                                    byte[] imagenData = null;
                                    string tipoarchivo = "";
                                    using (var binaryArchivo = new BinaryReader(upload.InputStream))
                                    {
                                        imagenData = binaryArchivo.ReadBytes(upload.ContentLength);
                                        tipoarchivo = upload.ContentType;
                                    }


                                    string sql = @"SELECT Max(IdDatosDocumentoWeb)
                                                        FROM Portal_DatosDocumentoWeb";
                                    int iddatosdocumentoweb = dp.connection.ExecuteScalar<int>(sql);
                            DateTime Fecha = Convert.ToDateTime(DateTime.Now.ToString("yyyy/MM/dd"));

                            //Escribir archivo 

                            string sql01 = "Insert Into bdNovaDocumentacion.dbo.Portal_DocumentosWeb (Archivo,TipoDocumento,NombreArchivo,FechaRegistro,IdKardexRegistro,IdDatosDocumentoWeb) " +
                                         "Values(@Archivo,@TipoDocumento,@NombreArchivo,@FechaRegistro,@IdKardexRegistro,@IdDatosDocumentoWeb)  ";
                            //"Values('" + imagenData + "','" + tipoarchivo + "','" + upload.FileName + "','" + Fecha + "'," + portal_datosdocumentoWeb.IdKardexRegistro + "," + iddatosdocumentoweb + ")";
                            
                                    var parameters = new { Archivo = imagenData, TipoDocumento = tipoarchivo, NombreArchivo = upload.FileName, FechaRegistro = Fecha, IdKardexRegistro = portal_datosdocumentoWeb.IdKardexRegistro, IdDatosDocumentoWeb = iddatosdocumentoweb };
                                    var rowsAffectedImg01 = dp.connection.ExecuteScalar(sql01, parameters);
                            //var rowsAffectedImg01 = dp.connection.Execute(sql01);

                        }
                       

                            dp.Close();
                            trans.Complete();
                            return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                        }

                    


                }


                catch (Exception e)
                {

                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }


                return JsonView(ModelState.IsValid, "El archivo no fue agregado satisfactoriamente");
                //}



            }

            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }




        // GET: /Anexos/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_DatosDocumentoWeb portal_datosdocumentoweb = db.Portal_DatosDocumentoWeb.Find(id);
            if (portal_datosdocumentoweb == null)
            {
                return HttpNotFound();
            }


            int IdKardexRegistro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;

  
            string querydocumentos = string.Format(@"select a.IdDatosDocumentoWeb, a.NombreDocumentoWeb, a.Año, a.IdTrimesteDocumentoWeb, a.IdPortalCatalogoApartado, a.Orden, a.FechaRegistro, a.IdKardexRegistro, a.Observaciones,
                                             b.IdDocumentosWeb, b.Archivo, b.TipoDocumento, b.NombreArchivo,
                                             c.Nombre,c.ApellidoPaterno,c.ApellidoMaterno,
                                             d.NombreTrimestre, f.PortalCatalogoApartado, g.NombrePortalCatalogoDocumento,
											 a.IdFraccionDocumento, h.NombreFraccionDocumento
                                             from Portal_DatosDocumentoWeb a
                                             left join bdNovaDocumentacion.dbo.Portal_DocumentosWeb b  on a.IdDatosDocumentoWeb = b.IdDatosDocumentoWeb
                                             inner join vwDatosAspirantesTrabajadores c on a.IdKardexRegistro = c.IdKardex
                                             inner join Portal_TrimestreDocumentoWeb d on a.IdTrimesteDocumentoWeb = d.IdTrimesteDocumentoWeb
                                             inner join Portal_CatalogoApartado f on a.IdPortalCatalogoApartado = f.IdPortalCatalogoApartado
                                             inner join Portal_CatalogoDocumento g on f.IdPortalCatalogoDocumento= g.IdPortalCatalogoDocumento
											  inner join Portal_FraccionDocumento h on a.IdFraccionDocumento= h.IdFraccionDocumento
                                               where a.IdDatosDocumentoWeb = {0}", id);
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var documentosweb = (List<DocumentosWeb>)dp.connection.Query<DocumentosWeb>(querydocumentos);
            dp.Close();

            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string query;

            query = @"select a.IdPortalCatalogoApartado, a.PortalCatalogoApartado,a.IdPortalCatalogoDocumento,b.NombrePortalCatalogoDocumento
                             from Portal_CatalogoApartado a
                            inner join Portal_CatalogoDocumento b on a.IdPortalCatalogoDocumento = b.IdPortalCatalogoDocumento ";
            var clasificacion = (List<ClasificacionDocumentosWeb>)dpcg.connection.Query<ClasificacionDocumentosWeb>(query);
            string queryfraccion;

            queryfraccion = @"select a.IdFraccionDocumento, a.NombreFraccionDocumento,a.IdIncisoFraccionDocumento,b.NombreIncisoDocumento
                             from Portal_FraccionDocumento a
                            left join Portal_IncisoFraccionDocumento b on a.IdIncisoFraccionDocumento = b.IdIncisoFraccionDocumento ";
            var fraccioninciso = (List<FraccionIncisoDocumentosWeb>)dpcg.connection.Query<FraccionIncisoDocumentosWeb>(queryfraccion);

            dpcg.Close();
            IEnumerable<SelectListItem> selectList = from s in clasificacion
                                                     select new SelectListItem
                                                     {
                                                         Value = s.IdPortalCatalogoApartado.ToString(),
                                                         Text = s.NombrePortalCatalogoDocumento + ' ' + '|' + ' ' + s.PortalCatalogoApartado
                                                     };
            IEnumerable<SelectListItem> selectListfraccion = from s in fraccioninciso
                                                             select new SelectListItem
                                                             {
                                                                 Value = s.IdFraccionDocumento.ToString(),
                                                                 Text = s.NombreFraccionDocumento + ' ' + '|' + ' ' + s.NombreIncisoDocumento
                                                             };
            ViewBag.IdTrimesteDocumentoWeb = new SelectList(db.Portal_TrimestreDocumentoWeb, "IdTrimesteDocumentoWeb", "NombreTrimestre", documentosweb.FirstOrDefault().IdTrimesteDocumentoWeb);
            ViewBag.IdPortalCatalogoApartado = new SelectList(selectList, "Value", "Text", documentosweb.FirstOrDefault().IdPortalCatalogoApartado);
            ViewBag.IdFraccionDocumento = new SelectList(selectListfraccion, "Value", "Text", documentosweb.FirstOrDefault().IdFraccionDocumento);
            ViewBag.IdKardexRegistro = IdKardexRegistro;
           
            return View(documentosweb.FirstOrDefault());
        }

        // POST: /Anexos/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdDatosDocumentoWeb, NombreDocumentoWeb, Año, IdTrimesteDocumentoWeb, IdPortalCatalogoApartado,IdFraccionDocumento, Orden, FechaRegistro, IdKardexRegistro, Observaciones")] Portal_DatosDocumentoWeb portal_datosdocumentoWeb, HttpPostedFileBase upload)
        {
            string msj = "El archivo ha sido editado existosamente!";

            

            if (ModelState.IsValid)
            {

                try
                {

                    if (upload != null && upload.ContentLength > 0)
                    {
                        byte[] imagenData = null;
                        string tipoarchivo = "";
                        using (var binaryArchivo = new BinaryReader(upload.InputStream))
                        {
                            imagenData = binaryArchivo.ReadBytes(upload.ContentLength);
                            tipoarchivo = upload.ContentType;

                        }
          


                        using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                        {

                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

                            //Escribir Datos de los archivos


                            string sqlupdateQuery = @"UPDATE Portal_DatosDocumentoWeb SET NombreDocumentoWeb ='" + portal_datosdocumentoWeb.NombreDocumentoWeb + "',Año='" + portal_datosdocumentoWeb.Año + "',IdTrimesteDocumentoWeb = " + portal_datosdocumentoWeb.IdTrimesteDocumentoWeb + ",IdPortalCatalogoApartado = " + portal_datosdocumentoWeb.IdPortalCatalogoApartado + " ,IdFraccionDocumento = " + portal_datosdocumentoWeb.IdFraccionDocumento + ",Orden = " + portal_datosdocumentoWeb.Orden + ",FechaRegistro='" + DateTime.Now.ToString("yyyy/MM/dd") + "',IdKardexRegistro = " + portal_datosdocumentoWeb.IdKardexRegistro + ",Observaciones='" + portal_datosdocumentoWeb.Observaciones + "' WHERE IdDatosDocumentoWeb = " + portal_datosdocumentoWeb.IdDatosDocumentoWeb + "";

                            var rowsAffectedDoc = dp.connection.Execute(sqlupdateQuery);

                            string sql = @"SELECT IdDatosDocumentoWeb
                                          FROM bdNovaDocumentacion.dbo.Portal_DocumentosWeb
										   where IdDatosDocumentoWeb = " + portal_datosdocumentoWeb.IdDatosDocumentoWeb + "";
                            //string sql = @"SELECT IdDatosDocumentoWeb
                            //                    FROM Portal_DatosDocumentoWeb
                            //                where IdDatosDocumentoWeb = " + portal_datosdocumentoWeb.IdDatosDocumentoWeb + "";
                            int iddatosdocumentoweb = dp.connection.ExecuteScalar<int>(sql);

                            ////Escribir archivo 
                            DateTime Fecha = Convert.ToDateTime(DateTime.Now.ToString("yyyy/MM/dd"));
                            if (iddatosdocumentoweb != 0)
                            {
                                var rowsAffectedDocFile = dp.connection.Execute("UPDATE bdNovaDocumentacion.dbo.Portal_DocumentosWeb SET Archivo= @Archivo, TipoDocumento = @TipoDocumento, NombreArchivo=@NombreArchivo, FechaRegistro=@FechaRegistro, IdKardexRegistro=@IdKardexRegistro, IdDatosDocumentoWeb=@IdDatosDocumentoWeb WHERE IdDatosDocumentoWeb = @IdDatosDocumentoWebBuscar", new { Archivo = imagenData, TipoDocumento = tipoarchivo, NombreArchivo = upload.FileName, FechaRegistro = Fecha, IdKardexRegistro = portal_datosdocumentoWeb.IdKardexRegistro, IdDatosDocumentoWeb = portal_datosdocumentoWeb.IdDatosDocumentoWeb, IdDatosDocumentoWebBuscar = portal_datosdocumentoWeb.IdDatosDocumentoWeb });
                            }
                            else
                            {

                                string sql01 = "Insert Into bdNovaDocumentacion.dbo.Portal_DocumentosWeb (Archivo,TipoDocumento,NombreArchivo,FechaRegistro,IdKardexRegistro,IdDatosDocumentoWeb) " +
                                "Values(@Archivo,@TipoDocumento,@NombreArchivo,@FechaRegistro,@IdKardexRegistro,@IdDatosDocumentoWeb)  ";

                                
                                var parameters = new { Archivo = imagenData, TipoDocumento = tipoarchivo, NombreArchivo = upload.FileName, FechaRegistro = Fecha, IdKardexRegistro = portal_datosdocumentoWeb.IdKardexRegistro, IdDatosDocumentoWeb = portal_datosdocumentoWeb.IdDatosDocumentoWeb };
                                var rowsAffectedImg01 = dp.connection.ExecuteScalar(sql01, parameters);


                               
                            }




                            dp.Close();
                            trans.Complete();
                            return Json(new { Valid = true, Message = "El archivo ha sido editado existosamente!" });


                        }

                    }

                    else
                    {
                        using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                        {
                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

                            //Escribir Datos de los archivos

                            string sqlupdateQuery = @"UPDATE Portal_DatosDocumentoWeb SET NombreDocumentoWeb ='" + portal_datosdocumentoWeb.NombreDocumentoWeb + "',Año='" + portal_datosdocumentoWeb.Año + "',IdTrimesteDocumentoWeb = " + portal_datosdocumentoWeb.IdTrimesteDocumentoWeb + ",IdPortalCatalogoApartado = " + portal_datosdocumentoWeb.IdPortalCatalogoApartado + " ,IdFraccionDocumento = " + portal_datosdocumentoWeb.IdFraccionDocumento + ",Orden = " + portal_datosdocumentoWeb.Orden + ",FechaRegistro='" + DateTime.Now.ToString("yyyy/MM/dd") + "',IdKardexRegistro = " + portal_datosdocumentoWeb.IdKardexRegistro + ",Observaciones='" + portal_datosdocumentoWeb.Observaciones + "' WHERE IdDatosDocumentoWeb = " + portal_datosdocumentoWeb.IdDatosDocumentoWeb + "";

                            var rowsAffectedDoc = dp.connection.Execute(sqlupdateQuery);



                            dp.Close();
                            trans.Complete();
                            return Json(new { Valid = true, Message = "El archivo ha sido editado existosamente!" });
                        }




                    }




                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });
            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: /Anexos/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_ArticulosAnexos portal_articulosanexos = db.Portal_ArticulosAnexos.Find(id);
            if (portal_articulosanexos == null)
            {
                return HttpNotFound();
            }
            return View(portal_articulosanexos);
        }

        // POST: KardexGradoAcademico/Delete/5
        // POST: KardexGradoAcademico/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            //Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            //db.Kardex_GradoAcademico.Remove(kardex_GradoAcademico);
            string msj = "El registro ha sido eliminado existosamente!";
            if (ModelState.IsValid)
            {

                try
                {

                    using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                        Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                        var sqlDeleteExp = "DELETE Portal_DatosDocumentoWeb WHERE IdDatosDocumentoWeb =" + id + "";

                        var rowsAffectedExp = dp.connection.Execute(sqlDeleteExp);

                        var sqlDeleteArchivo = "DELETE bdNovaDocumentacion.dbo.Portal_DocumentosWeb WHERE IdDatosDocumentoWeb = " + id + "";


                        var rowsAffectedArch = dp.connection.Execute(sqlDeleteArchivo);

                        dp.Close();
                        trans.Complete();
                    }
                    //db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
