﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.IO;
using Dapper;

namespace Nova.Controllers
{
    public class SiteCatalogoDocumentosController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /Anexos/
        public ActionResult Index()
        {
            var catalogodocumentos = db.Portal_CatalogoDocumento;          
            return View(catalogodocumentos.ToList());
        }

 

        // GET: /Anexos/Create
        public ActionResult Create()
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
         //   Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");

         //   int IdConvenioLaboral = Seguridad.Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.IdConvenioLaboral;

         //   string querytipodocumento;

         //   querytipodocumento = @"SELECT *  FROM bdNova.dbo.Kardex_stTipoDocumentoConvenio Tp
								 //INNER JOIN  bdNova.dbo.Kardex_TipoDocumento a on a.IdKardexTipoDocumento = Tp.IdKardexTipoDocumento
								 //inner join  bdNova.dbo.Catalogos_ctConvenioLaboral b on b.IdConvenioLaboral = Tp.IdConvenioLaboral
								 //where Tp.IdConvenioLaboral=@IdConvenioLaboral and Tp.IdKardexTipoDocumento not in (select  bdNova.dbo.Kardex_DocumentosExpediente.IdKardexTipoDocumento 
         //                        from bdNova.dbo.Kardex_DocumentosExpediente where bdNova.dbo.Kardex_DocumentosExpediente.IdKardex=@IdKardex )";
         //   var todastipodocumento = (List<Kardex_TipoDocumento>)dpcg.connection.Query<Kardex_TipoDocumento>(querytipodocumento, new { IdConvenioLaboral, IdKardex });

         //   dpcg.Close();

            ViewBag.IdKardex = db.vwDatosAspirantesTrabajadores.Where(z => z.IdKardex == IdKardex).FirstOrDefault().IdKardex;
            //ViewBag.IdKardexTipoDocumento = new SelectList(todastipodocumento, "IdKardexTipoDocumento", "DocumentoExpediente");
            ViewBag.IdCicloEscolar = new SelectList(Nova.Models.Kardex.cicloescolar.GetCiclosEscolares(), "IdCicloEscolar", "CicloEscolar");
            ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio");
            return PartialView();
        }

        // POST: /Anexos/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdPortalCatalogoDocumento,NombrePortalCatalogoDocumento")] Portal_CatalogoDocumento portal_catalogoDocumento)
        {
        
                if (ModelState.IsValid)
                {
                try                 
                
                    {
                        portal_catalogoDocumento.NombrePortalCatalogoDocumento = portal_catalogoDocumento.NombrePortalCatalogoDocumento.ToUpper();
                        db.Portal_CatalogoDocumento.Add(portal_catalogoDocumento);
                        db.SaveChanges();
                    }

                      catch (Exception e)
                    {

                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }

            }

            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");

        }

        // GET: /Anexos/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_CatalogoDocumento portal_catalogoDocumento = db.Portal_CatalogoDocumento.Find(id);
            if (portal_catalogoDocumento == null)
            {
                return HttpNotFound();
            }
            //ViewBag.NameFile = portal_articulosanexos.ArchivoUrl;
            //ViewBag.IdArticulo = new SelectList(db.Portal_Articulos, "IdArticulo", "NombreArticulo", portal_articulosanexos.IdArticulo);
            return View(portal_catalogoDocumento);
        }

        // POST: /Anexos/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdPortalCatalogoDocumento,NombrePortalCatalogoDocumento")] Portal_CatalogoDocumento portal_catalogoDocumento)
        {
            
          if (ModelState.IsValid)
                {
                try                 
                
                    {
                    portal_catalogoDocumento.NombrePortalCatalogoDocumento = portal_catalogoDocumento.NombrePortalCatalogoDocumento.ToUpper();
                    db.Entry(portal_catalogoDocumento).State = EntityState.Modified;
                    db.SaveChanges();
                    }

                      catch (Exception e)
                    {

                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }

            }

            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");
        }

        // GET: /Anexos/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_ArticulosAnexos portal_articulosanexos = db.Portal_ArticulosAnexos.Find(id);
            if (portal_articulosanexos == null)
            {
                return HttpNotFound();
            }
            return View(portal_articulosanexos);
        }

        // POST: KardexGradoAcademico/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            //Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            //db.Kardex_GradoAcademico.Remove(kardex_GradoAcademico);
            string msj = "El registro ha sido eliminado existosamente!";
         
            if (ModelState.IsValid)
            {

                try
                {

                    Nova.Models.Portal_CatalogoDocumento portal_catalogoDocumento = db.Portal_CatalogoDocumento.Find(id);
                    db.Portal_CatalogoDocumento.Remove(portal_catalogoDocumento);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });




            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
