﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.IO;
using System.Drawing;
using System.Drawing.Imaging;
using System.Web.Helpers;

//caleb
namespace Nova.Controllers
{
    public class SiteArticulosController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /Articulos/
        public ActionResult Index()
        {
            var portal_articulos = db.Portal_Articulos.Include(p => p.Portal_TipoArticulo);

            return View(portal_articulos.Where(v => v.Portal_TipoArticulo.TipoArticulo == "NOTICIAS").OrderByDescending(x => x.IdArticulo).ToList());

        }

        // GET: /Articulos/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_Articulos portal_articulos = db.Portal_Articulos.Find(id);
            if (portal_articulos == null)
            {
                return HttpNotFound();
            }
            return View(portal_articulos);
        }

        // GET: /Articulos/Create



        // GET: /Articulos/Create
        public ActionResult Create()
        {
            ViewBag.IdTipoArticulo = new SelectList(db.Portal_TipoArticulo, "IdTipoArticulo", "TipoArticulo");
            return View();
        }

        // POST: /Articulos/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdArticulo,NombreArticulo,FechaCreacion,FechaInicioPublicacion,FechaTermino,IdConvenioLaboralTrabajadorCategoria,Descripcion,Contenido,ImagenUrl,Publicar,Visitas,Twiter,IdTipoArticulo,UrlExterno")] Portal_Articulos portal_articulos)
        {
            portal_articulos.IdConvenioLaboralTrabajadorCategoria = 2;
            portal_articulos.IdTipoArticulo = db.Portal_TipoArticulo.Where(t => t.TipoArticulo == "NOTICIAS").Select(f => f.IdTipoArticulo).FirstOrDefault();

            if (ModelState.IsValid)
            {
                String fileName = Request.Files[0].FileName;
                if (fileName != "")
                {
                    var image = new WebImage(Request.Files[0].InputStream);
                    var image2 = image;
                    var estandar = image;

                    var sliderpath = Path.Combine(Server.MapPath("~/Content/Site/Images/Slider"), Path.GetFileName(fileName));
                    var littlepath = Path.Combine(Server.MapPath("~/Content/Site/Images/littleimg"), Path.GetFileName(fileName));
                    var estandarpath = Path.Combine(Server.MapPath("~/Content/Site/Images/Estandar"), Path.GetFileName(fileName));



                    estandar.Save(estandarpath);

                    var Height = image.Height;
                    var Width = image.Width;
                    decimal Top = System.Convert.ToDecimal(Request["hfimgcrop_top"]);
                    decimal Left = System.Convert.ToDecimal(Request["hfimgcrop_left"]);
                    decimal Bottom = System.Convert.ToDecimal(Request["hfimgcrop_bottom"]);
                    decimal Right = System.Convert.ToDecimal(Request["hfimgcrop_right"]);
                    image.Crop((int)Top, (int)Left, (int)(Height - Bottom), (int)(Width - Right));
                    image.Resize(960, 385, true, true);
                    image.Save(sliderpath);

                    image2.Resize(60, 58, true, false);
                    image2.Save(littlepath);


                }
                else { ModelState.AddModelError("", "No se pudo cargar la imagen!!!"); }

                if (portal_articulos.Publicar == true) { portal_articulos.FechaInicioPublicacion = DateTime.Now; }

                portal_articulos.ImagenUrl = fileName;
                portal_articulos.Visitas = 0;
                portal_articulos.Twiter = 0;
                portal_articulos.IdConvenioLaboralTrabajadorCategoria = 2;
                portal_articulos.FechaCreacion = DateTime.Now;
                db.Portal_Articulos.Add(portal_articulos);
                db.SaveChanges();
                NoticiasSingleton noticias = NoticiasSingleton.Instance;
                noticias.Reset();
                return RedirectToAction("Index");

            }

            ViewBag.IdTipoArticulo = new SelectList(db.Portal_TipoArticulo, "IdTipoArticulo", "TipoArticulo", portal_articulos.IdTipoArticulo);
            return View(portal_articulos);
        }



        // GET: /Articulos/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_Articulos portal_articulos = db.Portal_Articulos.Find(id);
            if (portal_articulos == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdTipoArticulo = new SelectList(db.Portal_TipoArticulo, "IdTipoArticulo", "TipoArticulo", portal_articulos.IdTipoArticulo);
            return View(portal_articulos);
        }

        // POST: /Articulos/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdArticulo,NombreArticulo,FechaCreacion,FechaInicioPublicacion,FechaTermino,IdConvenioLaboralTrabajadorCategoria,Descripcion,Contenido,ImagenUrl,Publicar,Visitas,Twiter,IdTipoArticulo,UrlExterno")] Portal_Articulos portal_articulos)
        {
            var id = portal_articulos.IdArticulo;



            var fileurl = db.Portal_Articulos.Where(t => t.IdArticulo == id).Select(t => t.ImagenUrl).FirstOrDefault();


            portal_articulos.IdTipoArticulo = db.Portal_TipoArticulo.Where(t => t.TipoArticulo == "NOTICIAS").Select(f => f.IdTipoArticulo).FirstOrDefault();
            ModelState["ImagenUrl"].Errors.Clear();
            if (ModelState.IsValid)
            {

                string fileName = Request.Files[0].FileName;
                if (fileName != "")
                {
                    var image = new WebImage(Request.Files[0].InputStream);
                    var image2 = image;
                    var estandar = image;

                    var sliderpath = Path.Combine(Server.MapPath("~/Content/Site/Images/Slider"), Path.GetFileName(fileName));
                    var littlepath = Path.Combine(Server.MapPath("~/Content/Site/Images/littleimg"), Path.GetFileName(fileName));
                    var estandarpath = Path.Combine(Server.MapPath("~/Content/Site/Images/Estandar"), Path.GetFileName(fileName));

                    estandar.Save(estandarpath);


                    var Height = image.Height;
                    var Width = image.Width;
                    decimal Top = System.Convert.ToDecimal(Request["hfimgcrop_top"]);
                    decimal Left = System.Convert.ToDecimal(Request["hfimgcrop_left"]);
                    decimal Bottom = System.Convert.ToDecimal(Request["hfimgcrop_bottom"]);
                    decimal Right = System.Convert.ToDecimal(Request["hfimgcrop_right"]);
                    image.Crop((int)Top, (int)Left, (int)(Height - Bottom), (int)(Width - Right));
                    image.Resize(960, 385, true, true);
                    image.Save(sliderpath);

                    image2.Resize(60, 58, false, false);
                    image2.Save(littlepath);

                    if (portal_articulos.EliminarImage(Path.Combine(Server.MapPath("~/Content/Site/Images/Slider"), Path.GetFileName(fileurl))).IsValid) { }
                    if (portal_articulos.EliminarImage(Path.Combine(Server.MapPath("~/Content/Site/Images/littleimg"), Path.GetFileName(fileurl))).IsValid) { }
                    if (portal_articulos.EliminarImage(Path.Combine(Server.MapPath("~/Content/Site/Images/Estandar"), Path.GetFileName(fileurl))).IsValid) { }

                    if (portal_articulos.Publicar == true)
                    {
                        var fechaPublica = db.Portal_Articulos.Where(a => a.IdArticulo == id).Select(f => f.FechaInicioPublicacion).FirstOrDefault();
                        if (fechaPublica == null)
                        {
                            portal_articulos.FechaInicioPublicacion = DateTime.Now;
                        }
                    }

                    portal_articulos.ImagenUrl = fileName;

                    db.Entry(portal_articulos).State = System.Data.Entity.EntityState.Modified;
                    db.SaveChanges();
                    
                    NoticiasSingleton noticias = NoticiasSingleton.Instance;
                    noticias.Reset();

                    return RedirectToAction("Index");
                }
                else
                {

                    if (portal_articulos.Publicar == true)
                    {
                        var fechaPublica = db.Portal_Articulos.Where(a => a.IdArticulo == id).Select(f => f.FechaInicioPublicacion).FirstOrDefault();
                        if (fechaPublica == null)
                        {
                            portal_articulos.FechaInicioPublicacion = DateTime.Now;
                        }
                    }

                    portal_articulos.ImagenUrl = fileurl;

                    db.Entry(portal_articulos).State = System.Data.Entity.EntityState.Modified;
                    db.SaveChanges();

                    NoticiasSingleton noticias = NoticiasSingleton.Instance;
                    noticias.Reset();

                    return RedirectToAction("Index");
                }

            }

            ViewBag.IdTipoArticulo = new SelectList(db.Portal_TipoArticulo, "IdTipoArticulo", "TipoArticulo", portal_articulos.IdTipoArticulo);
            return View(portal_articulos);
        }


        public JsonResult getDetailsNoticia(int id)
        {
            try
            {
                List<Portal_Articulos> detalles = new List<Portal_Articulos>();
                var details = db.Portal_Articulos.Where(t => t.IdArticulo == id).ToList();

                foreach (var item in details)
                {
                    Portal_Articulos lista = new Portal_Articulos();
                    lista.NombreArticulo = item.NombreArticulo;
                    lista.FechaCreacion = item.FechaCreacion.Date;
                    lista.Descripcion = item.Descripcion;
                    detalles.Add(lista);
                }

                return Json(new { Results = detalles }, JsonRequestBehavior.AllowGet);
            }
            catch (Exception)
            {
                throw;
            }
        }

        public ActionResult DeleteConfirmed(int id)
        {
            Portal_Articulos portal_articulos = db.Portal_Articulos.Find(id);

            db.Portal_Articulos.Remove(portal_articulos);
            db.SaveChanges();
            NoticiasSingleton noticias = NoticiasSingleton.Instance;
            noticias.Reset();

            return RedirectToAction("Index");
        }


        public JsonResult getCategorias()
        {
            try
            {
                List<Categorias> ListCategorias = new List<Categorias>();
                var categorias = db.Portal_Categoria.ToList();

                foreach (var item in categorias)
                {
                    Categorias lista = new Categorias();
                    lista.IdCategoria = item.IdCategoria;
                    lista.NombreCategoria = item.Categoria;

                    ListCategorias.Add(lista);
                }

                return Json(new { Results = ListCategorias }, JsonRequestBehavior.AllowGet);
            }
            catch (Exception)
            {
                throw;
            }
        }


    }
}
