﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class SiteArticulosCategoriaController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /ArticulosCategoria/
        public ActionResult Index()
        {
            var portal_articuloscategoria = db.Portal_ArticulosCategoria.Include(p => p.Portal_Articulos).Include(p => p.Portal_Categoria);
            return View(portal_articuloscategoria.ToList());
        }

        // GET: /ArticulosCategoria/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_ArticulosCategoria portal_articuloscategoria = db.Portal_ArticulosCategoria.Find(id);
            if (portal_articuloscategoria == null)
            {
                return HttpNotFound();
            }
            return View(portal_articuloscategoria);
        }

        // GET: /ArticulosCategoria/Create
        public ActionResult Create()
        {
            ViewBag.IdArticulo = new SelectList(db.Portal_Articulos, "IdArticulo", "NombreArticulo");
            ViewBag.IdCategoria = new SelectList(db.Portal_Categoria, "IdCategoria", "Categoria");
            return View();
        }

        // POST: /ArticulosCategoria/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdArticuloCategoria,IdArticulo,IdCategoria")] Portal_ArticulosCategoria portal_articuloscategoria)
        {
            if (ModelState.IsValid)
            {
                db.Portal_ArticulosCategoria.Add(portal_articuloscategoria);
                db.SaveChanges();
                NoticiasSingleton noticias = NoticiasSingleton.Instance;
                noticias = null;
                return RedirectToAction("Index");
            }

            ViewBag.IdArticulo = new SelectList(db.Portal_Articulos, "IdArticulo", "NombreArticulo", portal_articuloscategoria.IdArticulo);
            ViewBag.IdCategoria = new SelectList(db.Portal_Categoria, "IdCategoria", "Categoria", portal_articuloscategoria.IdCategoria);
            return View(portal_articuloscategoria);
        }

        // GET: /ArticulosCategoria/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_ArticulosCategoria portal_articuloscategoria = db.Portal_ArticulosCategoria.Find(id);
            if (portal_articuloscategoria == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdArticulo = new SelectList(db.Portal_Articulos, "IdArticulo", "NombreArticulo", portal_articuloscategoria.IdArticulo);
            ViewBag.IdCategoria = new SelectList(db.Portal_Categoria, "IdCategoria", "Categoria", portal_articuloscategoria.IdCategoria);
            return View(portal_articuloscategoria);
        }

        // POST: /ArticulosCategoria/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdArticuloCategoria,IdArticulo,IdCategoria")] Portal_ArticulosCategoria portal_articuloscategoria)
        {
            if (ModelState.IsValid)
            {
                db.Entry(portal_articuloscategoria).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                NoticiasSingleton noticias = NoticiasSingleton.Instance;
                noticias = null;
                return RedirectToAction("Index");
            }
            ViewBag.IdArticulo = new SelectList(db.Portal_Articulos, "IdArticulo", "NombreArticulo", portal_articuloscategoria.IdArticulo);
            ViewBag.IdCategoria = new SelectList(db.Portal_Categoria, "IdCategoria", "Categoria", portal_articuloscategoria.IdCategoria);
            return View(portal_articuloscategoria);
        }

        // GET: /ArticulosCategoria/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_ArticulosCategoria portal_articuloscategoria = db.Portal_ArticulosCategoria.Find(id);
            if (portal_articuloscategoria == null)
            {
                return HttpNotFound();
            }
            return View(portal_articuloscategoria);
        }

        // POST: /ArticulosCategoria/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Portal_ArticulosCategoria portal_articuloscategoria = db.Portal_ArticulosCategoria.Find(id);
            db.Portal_ArticulosCategoria.Remove(portal_articuloscategoria);
            db.SaveChanges();
            NoticiasSingleton noticias = NoticiasSingleton.Instance;
            noticias = null;
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}