﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.IO;

namespace Nova.Controllers
{
    public class SiteAnexosController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /Anexos/
        public ActionResult Index()
        {
            var portal_articulosanexos = db.Portal_ArticulosAnexos.Include(p => p.Portal_Articulos);
            return View(portal_articulosanexos.ToList());
        }

        // GET: /Anexos/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_ArticulosAnexos portal_articulosanexos = db.Portal_ArticulosAnexos.Find(id);
            if (portal_articulosanexos == null)
            {
                return HttpNotFound();
            }
            return View(portal_articulosanexos);
        }

        // GET: /Anexos/Create
        public ActionResult Create(string tipo)
        {
            if (tipo == null || tipo == "")
            {
                ViewBag.IdArticulo = new SelectList(db.Portal_Articulos.Where(t =>
                                                                            t.Portal_TipoArticulo.TipoArticulo == "AVISOS"), "IdArticulo", "NombreArticulo");
                
            }else if(tipo == "AVISOS" ){
                ViewBag.IdArticulo = new SelectList(db.Portal_Articulos.Where(t =>
                                                                            t.Portal_TipoArticulo.TipoArticulo == "AVISOS"), "IdArticulo", "NombreArticulo");
                ViewBag.FiltroTipo = "a";
            }else if(tipo == "CONVOCATORIAS"){
                ViewBag.IdArticulo = new SelectList(db.Portal_Articulos.Where(t =>
                                                                            t.Portal_TipoArticulo.TipoArticulo == "CONVOCATORIAS"), "IdArticulo", "NombreArticulo");
                ViewBag.FiltroTipo = "c";
            }else if(tipo == "REVISTA"){
                ViewBag.IdArticulo = new SelectList(db.Portal_Articulos.Where(t =>
                                                                            t.Portal_TipoArticulo.TipoArticulo == "REVISTA"), "IdArticulo", "NombreArticulo");
                ViewBag.FiltroTipo = "r";
            }

            return View("Create");
        }

        // POST: /Anexos/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdArticuloAnexo,NombreAnexo,ArchivoUrl,IdArticulo")] Portal_ArticulosAnexos portal_articulosanexos, HttpPostedFileBase ArchivoUrl)
        {
            string ext = "";
            if (ArchivoUrl != null)
            {
                string fileName = Path.GetFileName(ArchivoUrl.FileName);
                ext = fileName.Substring(fileName.LastIndexOf(".") + 1).ToLower();

                if (ModelState.IsValid)
                {
                    if (portal_articulosanexos.ValidaModelo(ext).IsValid)
                    {

                        var path = Path.Combine(Server.MapPath("~/Content/Site/FilesUpload"), fileName);
                        if (portal_articulosanexos.ValidarArchivo(path).IsValid)
                        {
                            ArchivoUrl.SaveAs(path);

                            portal_articulosanexos.ArchivoUrl = fileName;

                            db.Portal_ArticulosAnexos.Add(portal_articulosanexos);
                            db.SaveChanges();
                            NoticiasSingleton noticias = NoticiasSingleton.Instance;
                            noticias = null;
                            return RedirectToAction("Index");
                        }
                        else { ModelState.AddModelError("ArchivoUrl", portal_articulosanexos.ValidarArchivo(path).Mensaje); }
                    }
                    else
                    {
                        ModelState.AddModelError("ArchivoUrl", "No se puede subir archivos de formato: " + ext);
                    }
                }

            }
            else
            {
                ModelState.AddModelError("ArchivoUrl", "Cargue un archivo");
            }


            ViewBag.IdArticulo = new SelectList(db.Portal_Articulos, "IdArticulo", "NombreArticulo", portal_articulosanexos.IdArticulo);
            return View(portal_articulosanexos);
        }

        // GET: /Anexos/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_ArticulosAnexos portal_articulosanexos = db.Portal_ArticulosAnexos.Find(id);
            if (portal_articulosanexos == null)
            {
                return HttpNotFound();
            }
            ViewBag.NameFile = portal_articulosanexos.ArchivoUrl;
            ViewBag.IdArticulo = new SelectList(db.Portal_Articulos, "IdArticulo", "NombreArticulo", portal_articulosanexos.IdArticulo);
            return View(portal_articulosanexos);
        }

        // POST: /Anexos/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdArticuloAnexo,NombreAnexo,ArchivoUrl,IdArticulo")] Portal_ArticulosAnexos portal_articulosanexos, HttpPostedFileBase ArchivoUrl)
        {
            var id = portal_articulosanexos.IdArticuloAnexo;
            
            var filequery = db.Portal_ArticulosAnexos.Where(k=> k.IdArticuloAnexo==id).Select(j=> j.ArchivoUrl).FirstOrDefault();
                       
            string fileurl = "";
            if (filequery!=null)
            {
                fileurl = filequery;
            }

            if (portal_articulosanexos.ArchivoUrl == null)
            {
                portal_articulosanexos.ArchivoUrl = fileurl;
                //if (ModelState.IsValidField("NombreAnexo"))
                //{
                //    if (!ModelState.IsValidField("ArchivoUrl"))
                //    {
                        
                //        if (ModelState.IsValidField("IdArticulo"))
                //        {
                //            db.Entry(portal_articulosanexos).State = System.Data.Entity.EntityState.Modified;
                //            db.SaveChanges();
                //            return RedirectToAction("Index");
                //        }
                //    }
                //}

                ModelState["ArchivoUrl"].Errors.Clear();

                if (ModelState.IsValid)
                {
                    db.Entry(portal_articulosanexos).State = System.Data.Entity.EntityState.Modified;
                    db.SaveChanges();
                    NoticiasSingleton noticias = NoticiasSingleton.Instance;
                    noticias = null;
                    return RedirectToAction("Index");
                }
            }
            else
            {
                if (ModelState.IsValid)
                {
                    var ruta = Path.Combine(Server.MapPath("~/Content/Site/FilesUpload"), fileurl);
                    if (portal_articulosanexos.ValidarBorrar(ruta).IsValid)
                    {
                        string fileName = Path.GetFileName(ArchivoUrl.FileName);
                        var path = Path.Combine(Server.MapPath("~/Content/Site/FilesUpload"), fileName);
                        ArchivoUrl.SaveAs(path);

                        portal_articulosanexos.ArchivoUrl = fileName;
                        db.Entry(portal_articulosanexos).State = System.Data.Entity.EntityState.Modified;
                        db.SaveChanges();
                        return RedirectToAction("Index");
                    }
                    else
                    {
                        ModelState.AddModelError("", "Error al intentar cambiar el archivo, Intentelo nuevamente");
                    }
                }
            }
            ViewBag.IdArticulo = new SelectList(db.Portal_Articulos, "IdArticulo", "NombreArticulo", portal_articulosanexos.IdArticulo);
            return View(portal_articulosanexos);
        }

        // GET: /Anexos/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Portal_ArticulosAnexos portal_articulosanexos = db.Portal_ArticulosAnexos.Find(id);
            if (portal_articulosanexos == null)
            {
                return HttpNotFound();
            }
            return View(portal_articulosanexos);
        }

        // POST: /Anexos/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Portal_ArticulosAnexos portal_articulosanexos = db.Portal_ArticulosAnexos.Find(id);
            string fileName = portal_articulosanexos.ArchivoUrl;
            var ruta = Path.Combine(Server.MapPath("~/Content/Site/FilesUpload"), fileName);
            if (portal_articulosanexos.ValidarBorrar(ruta).IsValid)
            {
                db.Portal_ArticulosAnexos.Remove(portal_articulosanexos);
                db.SaveChanges();
                NoticiasSingleton noticias = NoticiasSingleton.Instance;
                noticias = null;
                return RedirectToAction("Index");
            }
            else { ModelState.AddModelError("", "Ocurrio un problema al remover el archivo"); }
            return View(portal_articulosanexos);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
