﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.IO;
using System.Transactions;
using Nova.Models;
using Nova.Libraries;
using Dapper;

namespace Nova.Controllers.Poa
{
    public class PoaViaticosPasajesController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: Poa_ViaticosPasajes
        public ActionResult Index()
        {
            //var poa_ViaticosPasajes = db.Poa_ViaticosPasajes.Include(p => p.Poa_OrigenDestino).Include(p => p.Poa_TipoPasaje).Include(p => p.Poa_Calendario);
            //return View(poa_ViaticosPasajes.ToList());
            return View();
        }

        // GET: Poa_ViaticosPasajes/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_ViaticosPasajes poa_ViaticosPasajes = db.Poa_ViaticosPasajes.Find(id);
            if (poa_ViaticosPasajes == null)
            {
                return HttpNotFound();
            }
            return View(poa_ViaticosPasajes);
        }

        // GET: Poa_ViaticosPasajes/Create
        public ActionResult Create(int Id, short Mes)
        {
            ViewBag.Id = Id;
            ViewBag.Mes = Mes;
            ViewBag.Origen = db.Poa_OrigenDestino.Select(d => new { IdOrigenDestino = d.IdOrigenDestino, Tarifa = d.Tarifa }).ToList();

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            var añovigente = db.Poa_SistemaAñoVigente.FirstOrDefault().Año;

            ViewBag.IdOrigenDestino = new SelectList(db.Poa_OrigenDestino.Where(c=> c.Año==añovigente ), "IdOrigenDestino", "OrigenDestino");
            ViewBag.IdTipoPasaje = new SelectList(db.Poa_TipoPasaje, "IdTipoPasaje", "TipoPasaje");
            //  ViewBag.IdCalendario = new SelectList(db.Poa_Calendario, "IdCalendario", "Observacion");
            return View();
        }


        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "Dias,IdOrigenDestino,IdTipoPasaje,ImporteViaticos,NumeroPersonas,NumeroVisitas,TotalPasaje,ViajeRedondoPersona,ImporteBoleto,TotalViaticos")] Poa_ViaticosPasajes poa_ViaticosPasajes)
        {

            poa_ViaticosPasajes.IdViaticosPasajes = 0;
            poa_ViaticosPasajes.IdCalendario = -1;

            var idindicador = Libraries.ConvertToInt.ConvertToInt32(Request["hfIdPoaViaticosPasajes"]);
            ViewBag.Id = Libraries.ConvertToInt.ConvertToInt32(Request["hfIdPoaViaticosPasajes"]);
            ViewBag.Mes = Libraries.ConvertToInt.ConvertToInt16(Request["hfMesPoaViaticosPasajes"]);

            decimal Disponible=0M, TotalPresupuestadoArea = 0M;
            
            var Indicador = db.Poa_Indicadores.Where(s => s.IdIndicadores == idindicador).FirstOrDefault();
            
            decimal  TechoPresupuestalArea = db.Poa_ProyectosAñoAreaPresupuesto.Where(z => z.IdEstructuraOrganica == Indicador.Poa_Mir.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica && z.Poa_ProyectosAño.IdProyectos == Indicador.Poa_Mir.Poa_ProyectoArbol.IdProyectos && z.Poa_ProyectosAño.AñoProyectos== Indicador.Poa_Mir.Poa_ProyectoArbol.AñoArbol).Sum(s=>s.Presupuesto);

            
  //          TotalPresupuestadoArea = db.Poa_Calendario
  //              .Where(p => p.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.IdProyectos == Indicador.Poa_Mir.Poa_ProyectoArbol.IdProyectos && p.Poa_Indicadores.Poa_Mir.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica == Indicador.Poa_Mir.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica
  //&& (p.Poa_CalendarioElemento.CalendarioElemento == "Presupuesto" || p.Poa_CalendarioElemento.CalendarioElemento == "Viáticos y pasajes")).Sum(s => s.Valor);


            var listatotales =db.Poa_Calendario
                .Where(p => p.Poa_Indicadores.Poa_Mir.AñoMir==Indicador.Poa_Mir.AñoMir && p.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.IdProyectos == Indicador.Poa_Mir.Poa_ProyectoArbol.IdProyectos && p.Poa_Indicadores.Poa_Mir.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica == Indicador.Poa_Mir.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica
  && (p.Poa_CalendarioElemento.CalendarioElemento == "Presupuesto" || p.Poa_CalendarioElemento.CalendarioElemento == "Viáticos y pasajes")).ToList();

            foreach (var item in listatotales)
            {
                TotalPresupuestadoArea = TotalPresupuestadoArea + item.Valor;
            }

            int idIndicadorGet = Indicador.IdIndicadores;

            Disponible = TechoPresupuestalArea - TotalPresupuestadoArea;
            
            if (Disponible < (poa_ViaticosPasajes.TotalPasaje + poa_ViaticosPasajes.TotalViaticos))
            {
                ModelState.AddModelError("", "Estimado Usuario, no es posible cubrir su requerimiento con techo presupuestal disponible, verifíquelo con el administrador del sistema");

            }

            if (ModelState.IsValid)
            {
                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {
                    try
                    {

                        var calendarioPoa = PoaCalendario.Save(Libraries.ConvertToInt.ConvertToInt32(Request["hfIdPoaViaticosPasajes"]), Libraries.ConvertToInt.ConvertToInt16(Request["hfMesPoaViaticosPasajes"]), poa_ViaticosPasajes.TotalPasaje + poa_ViaticosPasajes.TotalViaticos, db);

                        poa_ViaticosPasajes.IdCalendario = calendarioPoa.IdCalendario;
                        db.Poa_ViaticosPasajes.Add(poa_ViaticosPasajes);

                        db.SaveChanges();
         

                        scope.Complete();
                    }
                    catch (Exception e)
                    {


                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }


                }

                return JsonView(ModelState.IsValid, "Se han grabado los viáticos exitosamente", null, null, Url.Action("Index", "PoaCalendario"));

            }
            ViewBag.Origen = db.Poa_OrigenDestino.Select(d => new { IdOrigenDestino = d.IdOrigenDestino, Tarifa = d.Tarifa }).ToList();

            
            var añovigente = db.Poa_SistemaAñoVigente.FirstOrDefault().Año;

            ViewBag.IdOrigenDestino = new SelectList(db.Poa_OrigenDestino.Where(c => c.Año == añovigente), "IdOrigenDestino", "OrigenDestino", poa_ViaticosPasajes.IdOrigenDestino);

            ViewBag.IdTipoPasaje = new SelectList(db.Poa_TipoPasaje, "IdTipoPasaje", "TipoPasaje", poa_ViaticosPasajes.IdTipoPasaje);
            
            string messages = string.Join("; ", ModelState.Values
                                        .SelectMany(x => x.Errors)
                                        .Select(x => x.ErrorMessage));
            return JsonView(ModelState.IsValid, messages, "Create", poa_ViaticosPasajes);
        }

        // GET: Poa_ViaticosPasajes/Edit/5
        public ActionResult Edit(int? id)
        {
            //if (id == null)
            //{
            //    return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            //}
            Poa_ViaticosPasajes poa_ViaticosPasajes = db.Poa_ViaticosPasajes.Find(id);
            ViewBag.Origen = db.Poa_OrigenDestino.Select(d => new { IdOrigenDestino = d.IdOrigenDestino, Tarifa = d.Tarifa }).ToList();

            //if (poa_ViaticosPasajes == null)
            //{
            //    return HttpNotFound();
            //}
            
            var añovigente = db.Poa_SistemaAñoVigente.FirstOrDefault().Año;

            ViewBag.IdOrigenDestino = new SelectList(db.Poa_OrigenDestino.Where(c => c.Año == añovigente), "IdOrigenDestino", "OrigenDestino", poa_ViaticosPasajes.IdOrigenDestino);

            ViewBag.IdTipoPasaje = new SelectList(db.Poa_TipoPasaje, "IdTipoPasaje", "TipoPasaje", poa_ViaticosPasajes.IdTipoPasaje);
            //ViewBag.IdCalendario = new SelectList(db.Poa_Calendario, "IdCalendario", "Observacion", poa_ViaticosPasajes.IdCalendario);
            return View(poa_ViaticosPasajes);
        }




        //private string RenderPartialView(string partialViewName, object model)
        //{
        //    if (ControllerContext == null)
        //        return string.Empty;

        //    if (model == null)
        //        throw new ArgumentNullException("model");

        //    if (string.IsNullOrEmpty(partialViewName))
        //        throw new ArgumentNullException("partialViewName");

        //    ViewData.Model = model;

        //    using (var sw = new StringWriter())
        //    {
        //        var viewResult = ViewEngines.Engines.FindPartialView(ControllerContext, partialViewName);
        //        var viewContext = new ViewContext(ControllerContext, viewResult.View, ViewData, TempData, sw);
        //        viewResult.View.Render(viewContext, sw);
        //        return sw.GetStringBuilder().ToString();
        //    }
        //}
        // POST: Poa_ViaticosPasajes/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdViaticosPasajes,Dias,IdCalendario,IdOrigenDestino,IdTipoPasaje,ImporteViaticos,NumeroPersonas,NumeroVisitas,TotalPasaje,ViajeRedondoPersona,ImporteBoleto,TotalViaticos")] Poa_ViaticosPasajes poa_ViaticosPasajes)
        {

            //DapperQuery dp = new DapperQuery("bdNovaEntities");

            // obtiene el presupuesto del área responsable asi como total presupuestado del área responsable



            var idindicadorC = Libraries.ConvertToInt.ConvertToInt32(Request["IdCalendario"]);
            var Calendario = db.Poa_Calendario.Find(idindicadorC);

            decimal disponible, techo, totalpresupuestado = 0M;
            //var Indicador = db.Poa_Indicadores.Where(s => s.IdIndicadores == idindicador).FirstOrDefault();

            int idIndicadorGet = Calendario.IdIndicadores;
            var Indicador = db.Poa_Indicadores.Where(s => s.IdIndicadores == idIndicadorGet).FirstOrDefault();

//            string queryPres = @"SELECT e.Presupuesto From Poa_Indicadores a 
//inner join Poa_Mir b on b.IdMir = a.IdMir
//inner join Poa_ProyectoArbol c on c.IdProyectoArbol = b.IdProyectoArbol
//inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria = c.IdConvenioLaboralTrabajadorCategoria
//inner join Poa_ProyectosAñoAreaPresupuesto e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
//where a.IdIndicadores = @idIndicadorGet";

//            var TechoPresaupuestal = (List<decimal>)dp.connection.Query<decimal>(queryPres, new { idIndicadorGet });

            // var TechoPresaupuestal = db.Poa_ProyectosAñoAreaPresupuesto.Where(z => z.IdEstructuraOrganica == Indicador.Poa_Mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica
            //&& z.Poa_ProyectosAño.IdProyectos == Indicador.Poa_Mir.Poa_ProyectoArbol.IdProyectos && z.Poa_ProyectosAño.Año == Indicador.Poa_Mir.Poa_ProyectoArbol.Año).FirstOrDefault();
            decimal TechoPresaupuestal = db.Poa_ProyectosAñoAreaPresupuesto.Where(z => z.IdEstructuraOrganica == Indicador.Poa_Mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica
                && z.Poa_ProyectosAño.IdProyectos == Indicador.Poa_Mir.Poa_ProyectoArbol.IdProyectos && z.Poa_ProyectosAño.AñoProyectos == Indicador.Poa_Mir.Poa_ProyectoArbol.AñoArbol).Sum(s => s.Presupuesto);

            techo = TechoPresaupuestal;


            //           var poa_Presupuestoarea = db.Poa_Presupuesto
            //.Where(p => p.Poa_Calendario.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica == Indicador.Poa_Mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica
            //&& (p.Poa_Calendario.Poa_CalendarioElemento.CalendarioElemento == "Presupuesto" || p.Poa_Calendario.Poa_CalendarioElemento.CalendarioElemento == "Viaticos y pasajes"));

//            string queryPresupuestadoArea = @"SELECT (case when  e.Valor=NULL then  0 else e.Valor end) as Valor From Poa_Indicadores a 
//inner join Poa_Mir b on b.IdMir = a.IdMir
//inner join Poa_ProyectoArbol c on c.IdProyectoArbol = b.IdProyectoArbol
//inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria = c.IdConvenioLaboralTrabajadorCategoria
//inner Join Poa_Calendario e on e.IdIndicadores = a.IdIndicadores
//inner join Poa_CalendarioElemento f on f.IdCalendarioElemento = e.IdCalendarioElemento
//where d.IdEstructuraOrganica = (SELECT d.IdEstructuraOrganica From Poa_Indicadores a 
//inner join Poa_Mir b on b.IdMir = a.IdMir
//inner join Poa_ProyectoArbol c on c.IdProyectoArbol = b.IdProyectoArbol
//inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria = c.IdConvenioLaboralTrabajadorCategoria
//where a.IdIndicadores = @idIndicadorGet) and (f.CalendarioElemento = 'Presupuesto' or f.CalendarioElemento = 'Viáticos y pasajes')";
//            var PresupuestadoArea = (List<decimal>)dp.connection.Query<decimal>(queryPresupuestadoArea, new { idIndicadorGet });
            var PresupuestadoArea = db.Poa_Calendario
.Where(p => p.Poa_Indicadores.Poa_Mir.AñoMir==Indicador.Poa_Mir.AñoMir && p.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.IdProyectos == Indicador.Poa_Mir.Poa_ProyectoArbol.IdProyectos && p.Poa_Indicadores.Poa_Mir.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica == Indicador.Poa_Mir.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica
&& (p.Poa_CalendarioElemento.CalendarioElemento == "Presupuesto" || p.Poa_CalendarioElemento.CalendarioElemento == "Viáticos y pasajes"));

            foreach (var item in PresupuestadoArea)
            {
                totalpresupuestado += item.Valor;
            }
            disponible = techo - totalpresupuestado;
            if (disponible < (poa_ViaticosPasajes.TotalPasaje + poa_ViaticosPasajes.TotalViaticos))
            {
                ModelState.AddModelError("", "Estimado Usuario, no es posible cubrir su requerimiento con techo presupuestal disponible, verifíquelo con el administrador del sistema");

            }


            //ViewBag.Id = Libraries.ConvertToInt.ConvertToInt32(Request["hfIdPoaViaticosPasajes"]);
            //ViewBag.Mes = Libraries.ConvertToInt.ConvertToInt16(Request["hfMesPoaViaticosPasajes"]);
            // obtiene el presupuesto del área responsable asi como total presupuestado del área responsable

            if (ModelState.IsValid)
            {

                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {

                    try
                    {
                        Poa_Calendario poaCalendario = db.Poa_Calendario.Find(poa_ViaticosPasajes.IdCalendario);
                        poaCalendario.Valor = poa_ViaticosPasajes.TotalPasaje + poa_ViaticosPasajes.TotalViaticos;
                        db.Entry(poaCalendario).State = System.Data.Entity.EntityState.Modified;
                        db.SaveChanges();

                        db.Entry(poa_ViaticosPasajes).State = System.Data.Entity.EntityState.Modified;
                        db.SaveChanges();

                    }
                    catch (Exception e)
                    {
                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }

                    scope.Complete();
                }



                //var result = new { value = "success", msg = "Se han actualizado los viáticos exitosamente" };
                //return Json(result, JsonRequestBehavior.AllowGet);
                return JsonView(ModelState.IsValid, "Se han actualizado los viáticos exitosamente", null, null, null);
            }



            //ViewBag.Origen = db.Poa_OrigenDestino.Select(d => new { IdOrigenDestino = d.IdOrigenDestino, Tarifa = d.Tarifa }).ToList();

            //ViewBag.IdOrigenDestino = new SelectList(db.Poa_OrigenDestino, "IdOrigenDestino", "OrigenDestino", poa_ViaticosPasajes.IdOrigenDestino);
            //ViewBag.IdTipoPasaje = new SelectList(db.Poa_TipoPasaje, "IdTipoPasaje", "TipoPasaje", poa_ViaticosPasajes.IdTipoPasaje);

            //  ViewBag.IdCalendario = new SelectList(db.Poa_Calendario, "IdCalendario", "Observacion", poa_ViaticosPasajes.IdCalendario);
            //return View(poa_ViaticosPasajes);
            string messages = string.Join("; ", ModelState.Values
                            .SelectMany(x => x.Errors)
                            .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, "Edit", poa_ViaticosPasajes);
        }

        // GET: Poa_ViaticosPasajes/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_ViaticosPasajes poa_ViaticosPasajes = db.Poa_ViaticosPasajes.Find(id);
            if (poa_ViaticosPasajes == null)
            {
                return HttpNotFound();
            }
            return View(poa_ViaticosPasajes);
        }

        // POST: Poa_ViaticosPasajes/Delete/5
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed()
        {

            int id = System.Convert.ToInt32(Request["id"]);
            string values = "";
            string msgs = "";


            TransactionOptions transactionoptions1 = new TransactionOptions();
            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
            {

                try
                {
                    Poa_ViaticosPasajes poa_ViaticosPasajes = db.Poa_ViaticosPasajes.Find(id);
                    db.Poa_ViaticosPasajes.Remove(poa_ViaticosPasajes);
                    db.SaveChanges();

                    Poa_Calendario poaCalendario = db.Poa_Calendario.Find(poa_ViaticosPasajes.IdCalendario);
                    poaCalendario.Valor = poaCalendario.Valor - (poa_ViaticosPasajes.TotalViaticos + poa_ViaticosPasajes.TotalPasaje);
                    db.Entry(poaCalendario).State = System.Data.Entity.EntityState.Modified;
                    db.SaveChanges();
                    

                    values = "success";
                }
                catch (Exception ex)
                {
                    values = "failed";
                    msgs = ex.ToString();
                }

                scope.Complete();
            }


            var result = new { value = values, msg = msgs };
            return Json(result, JsonRequestBehavior.AllowGet);

        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
