﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.Globalization;
using System.Transactions;

namespace Nova.Controllers.Poa.SeguimientoMetas
{
    public class PoaSeguimientoMetasController : BaseController
    {
        bdNovaEntities db = new bdNovaEntities();
        // GET: PoaSeguimientoMetas
        public ActionResult Index()
        {
            return View();
        }
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {

            try
            {

                Poa_Calendario poa_Calendario = db.Poa_Calendario.Find(id);
                db.Poa_Calendario.Remove(poa_Calendario);
                db.SaveChanges();
                Poa_Indicadores indicadores = new Poa_Indicadores();
                indicadores = db.Poa_Indicadores.Find(poa_Calendario.IdIndicadores);
                if (indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Actividad")
                {
                    if (indicadores.IdIndicadorComponente != null)
                    {
                        Poa_Indicadores poaindicadorcomponente = db.Poa_Indicadores.Find(indicadores.IdIndicadorComponente);
                        actualizacalendariocomponentedesdecomponente(poaindicadorcomponente.IdIndicadores, "Realizado");
                        //actualizacalendariocomponente(poaindicadorcomponente, poa_Calendario.PoaCalendario, "Programado");
                    }
                }

            }
            catch (Exception e)
            {


                return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
            }




            return JsonView(ModelState.IsValid, "Se ha eliminado la meta exitosamente", null, null, Url.Action("Index", "PoaCalendario"));

        }

        [AllowAnonymousAttribute]
        public ActionResult Create(int id = 0, int IdMes = 0, String Proyecto = "", String Anio = "", String ResumenNarrativo = "", String Elemento = "")
        {
            List<Poa_Calendario> Programados = new List<Poa_Calendario>();
            List<Poa_Calendario> Realizados = new List<Poa_Calendario>();
            List<Poa_CalendarioElemento> CalendarioElementos = new List<Poa_CalendarioElemento>();

            Poa_CalendarioAux setPoaCalendarioAux = new Poa_CalendarioAux();
            Poa_Calendario setPoaCalendario = new Poa_Calendario();
            Poa_Indicadores indicadores = new Poa_Indicadores();
          
            String msg = "";
            indicadores = db.Poa_Indicadores.Find(id);
            decimal ProgramadoMes = 0M;
            decimal totalmeta = indicadores.MetaAnual;

            CalendarioElementos = db.Poa_CalendarioElemento.ToList();

            int IdCalendarioElementoRealizado = CalendarioElementos.Where(x => x.CalendarioElemento == "Realizado").First().IdCalendarioElemento;
            int IdCalendarioElementoProgramado = CalendarioElementos.Where(x => x.CalendarioElemento == "Programado").First().IdCalendarioElemento;
            Programados = db.Poa_Calendario.Where(c => c.IdIndicadores == id && c.IdCalendarioElemento == IdCalendarioElementoProgramado).ToList();

            
            if (indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Actividad")
                setPoaCalendarioAux.Indicador = indicadores.Numerador;
            else
                setPoaCalendarioAux.Indicador = indicadores.Indicador;


            ProgramadoMes = (Programados.Where(m => m.IdMes == IdMes).FirstOrDefault()!=null? Programados.Where(m => m.IdMes == IdMes).FirstOrDefault().Valor : 0);
            
            Realizados = db.Poa_Calendario.Where(c => c.IdIndicadores == id && c.IdCalendarioElemento == IdCalendarioElementoRealizado).ToList();
            decimal Acumulado = Realizados.Sum(x => x.Valor);


            int registros = Realizados.Count();


            if (Acumulado > indicadores.MetaAnual)
            {
                setPoaCalendarioAux.MostrarObservacion = true;
                msg = "Meta anual superada con anterioridad. Es necesario reportar y justificar los motivos dentro del campo de Observaciones.";
                foreach (var item in Realizados)
                {
                    msg += "<p style='color:black'>" + "<strong> " + item.Catalogos_ctMes.Mes + " --- " + string.Format("{0:N}", item.Valor) + "</strong></p>";
                }

                setPoaCalendarioAux.MsgError = msg;
                setPoaCalendarioAux.Warning = true;
            
            }


            setPoaCalendarioAux.MsgError = "";
           
            switch (indicadores.Poa_FrecuenciaMedicionIndicador.FrecuenciaMedicion)
            {
                case "Anual":
                    if (registros >= 1)
                    {
                        String mes = Realizados.Select(x => x.Catalogos_ctMes.Mes).FirstOrDefault();
                        setPoaCalendarioAux.MsgError = "Meta anual registrada <strong>( " + string.Format("{0:N}", Acumulado) + " ) </strong>en el mes de <strong>" + mes + "</strong>";
                        setPoaCalendarioAux.Error = true;
                    }
                    else
                    {
                        setPoaCalendarioAux.MsgError = "Meta anual por guardar, <strong> recuerde que NO podrá eliminar </strong> el registro una vez guardado. Meta anual programada: <strong>" + string.Format("{0:N}", totalmeta) + "</strong>";
                        setPoaCalendario.Valor = totalmeta;
                        setPoaCalendarioAux.Warning = true;
                    }
                    break;

                case "Mensual":
                    if (registros >= 12)
                    {
                        msg = "Meta mensual calendarizada en su totalidad.";

                        foreach (var item in Realizados)
                        {
                            msg += "<p style='color:black'>" + "<strong> " + item.Catalogos_ctMes.Mes + " --- " + string.Format("{0:N}", item.Valor) + "</strong></p>";
                        }

                        setPoaCalendarioAux.MsgError = msg;
                        setPoaCalendarioAux.Error = true;
                    }
                    else
                    {
                        if (registros == 11)
                        {
                            setPoaCalendarioAux.MsgError = "Última meta mensual por realizar, <strong> recuerde que NO podrá eliminar </strong> los registros una vez guardados.</strong>";
                            setPoaCalendarioAux.MsgError += "<p>Usted lleva realizado al momento: <strong>" + string.Format("{0:N}", Acumulado) + "</strong> de un total anual: <strong>" + string.Format("{0:N}", totalmeta + "</strong></p>");
                            setPoaCalendarioAux.Warning = true;
                            setPoaCalendario.Valor = totalmeta + Acumulado;
                        }
                    }
                    break;

              
                case "Bimestral":
                    if (registros >= 6)
                    {
                        msg = "Meta bimestral calendarizada en su totalidad.";

                        foreach (var item in Realizados)
                        {
                            msg += "<p style='color:black'>" + "<strong> " + item.Catalogos_ctMes.Mes + " --- " + string.Format("{0:N}", item.Valor) + "</strong></p>";
                        }

                        setPoaCalendarioAux.MsgError = msg;
                        setPoaCalendarioAux.Error = true;
                    }
                    else
                    {
                        if (registros == 5)
                        {
                            setPoaCalendarioAux.MsgError = "Última meta bimestral por realizar, <strong> recuerde que NO podrá eliminar </strong> los registros una vez guardados.</strong>";
                            setPoaCalendarioAux.MsgError += "<p>Usted lleva realizado al momento: <strong>" + string.Format("{0:N}", Acumulado) + "</strong> de un total anual: <strong>" + string.Format("{0:N}", totalmeta + "</strong></p>");
                            setPoaCalendarioAux.Warning = true;
                            setPoaCalendario.Valor = totalmeta + Acumulado;
                        }
                    }
                    break;

                case "Trimestral":
                    if (registros >= 4)
                    {
                        msg = "Meta trimestral calendarizada en su totalidad.";

                        foreach (var item in Realizados)
                        {
                            msg += "<p style='color:black'>" + "<strong> " + item.Catalogos_ctMes.Mes + " --- " + string.Format("{0:N}", item.Valor) + "</strong></p>";
                        }

                        setPoaCalendarioAux.MsgError = msg;
                        setPoaCalendarioAux.Error = true;
                    }
                    else
                    {
                        if (registros == 3)
                        {
                            setPoaCalendarioAux.MsgError = "Última meta trimestral por realizar, <strong> recuerde que NO podrá eliminar </strong> los registros una vez guardados.</strong>";
                            setPoaCalendarioAux.MsgError += "<p>Usted lleva realizado al momento: <strong>" + string.Format("{0:N}", Acumulado) + "</strong> de un total anual: <strong>" + string.Format("{0:N}", totalmeta + "</strong></p>");
                            setPoaCalendarioAux.Warning = true;
                            setPoaCalendario.Valor = totalmeta - Acumulado;
                        }

                    }


                    break;
                case "Semestral":
                    if (registros >= 2)
                    {
                        msg = "Meta semestral calendarizada en su totalidad.";

                        foreach (var item in Realizados)
                        {
                            msg += "<p style='color:black'>" + "<strong> " + item.Catalogos_ctMes.Mes + " --- " + string.Format("{0:N}", item.Valor) + "</strong></p>";
                        }

                        setPoaCalendarioAux.MsgError = msg;
                        setPoaCalendarioAux.Error = true;
                    }
                    else
                    {
                        if (registros == 3)
                        {
                            setPoaCalendarioAux.MsgError = "Última meta semestral por realizar, <strong> recuerde que NO podrá eliminar </strong> los registros una vez guardados.</strong>";
                            setPoaCalendarioAux.MsgError += "<p>Usted lleva realizado al momento: <strong>" + string.Format("{0:N}", Acumulado) + "</strong> de un total anual: <strong>" + string.Format("{0:N}", totalmeta + "</strong></p>");
                            setPoaCalendarioAux.Warning = true;
                            setPoaCalendario.Valor = totalmeta - Acumulado;
                        }

                    }


                    break;
                default:
                    setPoaCalendarioAux.MsgError = "Frecuencia medición no implementada";
                    setPoaCalendarioAux.Error = true;

                    break;
            }






            setPoaCalendarioAux.FrecuenciaMedicionIndicador = indicadores.Poa_FrecuenciaMedicionIndicador.FrecuenciaMedicion;
            setPoaCalendarioAux.TipoIndicador = indicadores.Poa_TipoIndicador.TipoIndicador;
            
         

            setPoaCalendarioAux.MetaAnual = indicadores.MetaAnual;
            setPoaCalendarioAux.MetaAcumulada = Acumulado;
            setPoaCalendarioAux.MetaCorrespondienteMes = ProgramadoMes;
            setPoaCalendario.Valor = ProgramadoMes;

            
            setPoaCalendario.IdMes = System.Convert.ToInt16(IdMes);
            setPoaCalendario.IdCalendarioElemento = System.Convert.ToInt16(IdCalendarioElementoRealizado);
            setPoaCalendario.IdIndicadores = id;
            
            
            setPoaCalendarioAux.PoaCalendario = setPoaCalendario;
            setPoaCalendarioAux.Año = Anio;
            setPoaCalendarioAux.Mes = db.Catalogos_ctMes.Find(setPoaCalendario.IdMes).Mes;
            setPoaCalendarioAux.ResumenNarrativo = ResumenNarrativo;
            setPoaCalendarioAux.Proyecto = Proyecto;

            
          


            return PartialView(setPoaCalendarioAux);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        [AllowAnonymousAttribute]
        public ActionResult Create([Bind(Include = "Proyecto,Año,ResumenNarrativo,PoaCalendario,Poa_Indicadores,Poa_FrecuenciaMedicionIndicador")] Poa_CalendarioAux poa_Calendario)
        {
            List<Poa_Calendario> Programados = new List<Poa_Calendario>();
            List<Poa_Calendario> Realizados = new List<Poa_Calendario>();
            List<Poa_CalendarioElemento> CalendarioElementos = new List<Poa_CalendarioElemento>();
            Poa_Indicadores indicadores = new Poa_Indicadores();
            
            poa_Calendario.Mes= db.Catalogos_ctMes.Find(poa_Calendario.PoaCalendario.IdMes).Mes;

            CalendarioElementos = db.Poa_CalendarioElemento.ToList();

            int IdCalendarioElementoRealizado = CalendarioElementos.Where(x => x.CalendarioElemento == "Realizado").First().IdCalendarioElemento;
            int IdCalendarioElementoProgramado = CalendarioElementos.Where(x => x.CalendarioElemento == "Programado").First().IdCalendarioElemento;

            Programados = db.Poa_Calendario.Where(c => c.IdIndicadores == poa_Calendario.PoaCalendario.IdIndicadores && c.IdCalendarioElemento == IdCalendarioElementoProgramado).ToList();
            // Editado
            //Decimal ProgramadoMes = Programados.Where(m => m.IdMes == poa_Calendario.PoaCalendario.IdMes).First().Valor;
            Poa_Calendario ProgramadoMes = Programados.Where(m => m.IdMes == poa_Calendario.PoaCalendario.IdMes).FirstOrDefault();

            // fin editado
            Realizados = db.Poa_Calendario.Where(c => c.IdIndicadores == poa_Calendario.PoaCalendario.IdIndicadores && c.IdCalendarioElemento == IdCalendarioElementoRealizado).ToList();

            string messages = "";
            

            //if (poa_Calendario.PoaCalendario.Valor == 0)
            //    ModelState.AddModelError("Valor", "Campo requerido");

            indicadores = db.Poa_Indicadores.Find(poa_Calendario.PoaCalendario.IdIndicadores);

            decimal suma = Realizados.Sum(x => x.Valor);

            decimal totalmeta = db.Poa_Indicadores.Find(poa_Calendario.PoaCalendario.IdIndicadores).MetaAnual;


            //if ((suma + poa_Calendario.PoaCalendario.Valor > totalmeta && poa_Calendario.PoaCalendario.Observacion==null))
            //    {
            //    ModelState.AddModelError("PoaCalendario.Observacion", "Meta anual superada.Es necesario reportar y justificar los motivos dentro del campo de Observaciones.");
            //    poa_Calendario.MsgError = "<strog>Meta anual superada.</strong><p>Es necesario reportar y justificar los motivos dentro del campo de Observaciones.</p>";
            //    poa_Calendario.Error = true;
            //    poa_Calendario.Warning = true;
            //    poa_Calendario.MostrarObservacion = true;
            //    }

            switch (indicadores.Poa_TipoIndicador.TipoIndicador)
            {
                case "Acumulativo":

                    if ((suma + poa_Calendario.PoaCalendario.Valor > totalmeta && poa_Calendario.PoaCalendario.Observacion == null))
                    {
                        ModelState.AddModelError("PoaCalendario.Observacion", "Meta anual superada.Es necesario reportar y justificar los motivos dentro del campo de Observaciones.");
                        poa_Calendario.MsgError = "<strog>Meta anual superada.</strong><p>Es necesario reportar y justificar los motivos dentro del campo de Observaciones.</p>";
                        poa_Calendario.Error = true;
                        poa_Calendario.Warning = true;
                        poa_Calendario.MostrarObservacion = true;
                        poa_Calendario.PoaCalendario.EsAutorizado = false;
                        poa_Calendario.PoaCalendario.EsObservado = false;
                    }
                    break;
                case "Promedio":
                case "Incremental":
                    if (( poa_Calendario.PoaCalendario.Valor != totalmeta && poa_Calendario.PoaCalendario.Observacion == null))
                    {
                        ModelState.AddModelError("PoaCalendario.Observacion", "Valor inferior o superior al esperado.Es necesario reportar y justificar los motivos dentro del campo de Observaciones.");
                        poa_Calendario.MsgError = "<strog>Meta anual superada.</strong><p>Es necesario reportar y justificar los motivos dentro del campo de Observaciones.</p>";
                        poa_Calendario.Error = true;
                        poa_Calendario.Warning = true;
                        poa_Calendario.MostrarObservacion = true;
                        poa_Calendario.PoaCalendario.EsAutorizado = false;
                        poa_Calendario.PoaCalendario.EsObservado = false;
                    }
                    break;
                default:
                    Console.WriteLine("Default case");
                    break;
            }
     
            if (ProgramadoMes != null)
            {
                if (ProgramadoMes.Valor != poa_Calendario.PoaCalendario.Valor)
                {
                    if (poa_Calendario.PoaCalendario.Observacion == null)
                    {
                        ModelState.AddModelError("PoaCalendario.Observacion", "Observación requerida. Debe reportar y justificar los motivos del incumplimiento o superación de la meta programada. Meta programada");
                        poa_Calendario.MsgError = "<strog>Observación requerida.</strong><p>Debe reportar y justificar los motivos del incumplimiento o superación de la meta programada. Meta programada </p>";
                        poa_Calendario.Error = true;
                        poa_Calendario.Warning = true;
                        poa_Calendario.MostrarObservacion = true;
                        poa_Calendario.PoaCalendario.EsAutorizado = false;
                        poa_Calendario.PoaCalendario.EsObservado = false;
                    }
                    
                }
                else
                {
                    poa_Calendario.PoaCalendario.EsAutorizado = false;
                    poa_Calendario.PoaCalendario.EsObservado = false;
                }
            }
            else
            {
                if (poa_Calendario.PoaCalendario.Observacion == null)
                {
                    ModelState.AddModelError("PoaCalendario.Observacion", "Observación requerida.  Debe reportar y justificar los motivos de registrar un Avance no Programado. ");
                    poa_Calendario.MsgError = "<strog>Observación requerida.</strong><p>Debe reportar y justificar los motivos de registrar un Avance no Programado.</p>";
                    poa_Calendario.Error = true;
                    poa_Calendario.Warning = true;
                    poa_Calendario.MostrarObservacion = true;
                    poa_Calendario.PoaCalendario.EsAutorizado = false;
                    poa_Calendario.PoaCalendario.EsObservado = false;
                }
            }

            if (ModelState.IsValid)
            {

                try
                {

                    db.Poa_Calendario.Add(poa_Calendario.PoaCalendario);
                    db.SaveChanges();
                    if (indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Actividad")
                    {
                        if (indicadores.IdIndicadorComponente != null)
                        {
                            Poa_Indicadores poaindicadorcomponente = db.Poa_Indicadores.Find(indicadores.IdIndicadorComponente);
                            actualizacalendariocomponentedesdecomponente(poaindicadorcomponente.IdIndicadores, "Realizado");
                            //actualizacalendariocomponente(poaindicadorcomponente, poa_Calendario.PoaCalendario, "Programado");
                        }
                    }

                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }




                return JsonView(ModelState.IsValid, "Se ha grabado la programación exitosamente", null, null, Url.Action("Index", "PoaCalendario"));

            }


            messages = string.Join("  ", ModelState.Values
                                         .SelectMany(x => x.Errors)
                                         .Select(x => x.ErrorMessage));

          
            return JsonView(ModelState.IsValid, messages, "Create", poa_Calendario);


        }

        public PartialViewResult Edit(int? id)
        {
            if (id == null)
            {
                ModelState.AddModelError("Valor", "id Campo requerido");
            }

            Poa_Calendario poa_Calendario = db.Poa_Calendario.Find(id);

            if (poa_Calendario == null)
            {
                ModelState.AddModelError("Valor", "No existen valores");
            }

            return PartialView(poa_Calendario);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdCalendario,IdCalendarioElemento,IdIndicadores,IdMes,Observacion,Valor,Catalogos_ctMes,Poa_CalendarioElemento,Poa_Indicadores")] Poa_Calendario poa_Calendario)
        {

            Poa_Calendario modelo = new Poa_Calendario();
            modelo = db.Poa_Calendario.Find(poa_Calendario.IdCalendario);
            modelo.Valor = poa_Calendario.Valor;
            modelo.Observacion = poa_Calendario.Observacion;
            List<Poa_Calendario> Programados = new List<Poa_Calendario>();
            Poa_Indicadores indicadores = new Poa_Indicadores();
            Programados = db.Poa_Calendario.Where(c => c.IdIndicadores == poa_Calendario.IdIndicadores && c.IdCalendarioElemento == (db.Poa_CalendarioElemento.Where(t=>t.CalendarioElemento == "Programado").Select(s=>s.IdCalendarioElemento).FirstOrDefault())).ToList();
            //Decimal ProgramadoMes = Programados.Where(m => m.IdMes == poa_Calendario.IdMes).First().Valor;
            Poa_Calendario ProgramadoMes = Programados.Where(m => m.IdMes == poa_Calendario.IdMes).FirstOrDefault();

            Programados = db.Poa_Calendario.Where(c => c.IdIndicadores == poa_Calendario.IdIndicadores && c.Poa_CalendarioElemento.CalendarioElemento == "Realizado").ToList();

            string messages = "";
            int registros = Programados.Count();


            indicadores = db.Poa_Indicadores.Find(poa_Calendario.IdIndicadores);

            decimal suma = Programados.Where(i => i.IdCalendario != poa_Calendario.IdCalendario).Sum(x => x.Valor);

            decimal totalmeta = db.Poa_Indicadores.Find(poa_Calendario.IdIndicadores).MetaAnual;


            if ((suma + poa_Calendario.Valor > totalmeta && (poa_Calendario.Observacion == null)))
                ModelState.AddModelError("Observacion", "Observación requerida.El valor que intenta guardar [" + string.Format("{0:N}", poa_Calendario.Valor) + " ] rebasa la meta anual registrada " + string.Format("{0:N}", totalmeta) + ".");

            //if (ProgramadoMes != poa_Calendario.Valor && poa_Calendario.Observacion == null)
            //{
            //    ModelState.AddModelError("Observacion", "Observación requerida. Debe reportar y justificar los motivos del incumplimiento o superación de la meta programada. Meta programada: " + string.Format("{0:N}", ProgramadoMes));

            //}
            if (ProgramadoMes != null)
            {
                if (ProgramadoMes.Valor != poa_Calendario.Valor)
                {
                    if (poa_Calendario.Observacion == null || poa_Calendario.Observacion == "")
                    {
                        ModelState.AddModelError("PoaCalendario.Observacion", "Observación requerida. Debe reportar y justificar los motivos del incumplimiento o superación de la meta programada. Meta programada");
                        //poa_Calendario.MsgError = "<strog>Observación requerida.</strong><p>Debe reportar y justificar los motivos del incumplimiento o superación de la meta programada. Meta programada </p>";
                        //poa_Calendario.Error = true;
                        //poa_Calendario.Warning = true;
                        //poa_Calendario.MostrarObservacion = true;
                        modelo.EsAutorizado = false;
                        modelo.EsObservado = false;
                    }
                }
                else
                {
                    modelo.EsAutorizado = false;
                    modelo.EsObservado = false;
                }

            }
            else
            {
                if (poa_Calendario.Observacion == null || poa_Calendario.Observacion == "")
                {
                    ModelState.AddModelError("PoaCalendario.Observacion", "Observación requerida.  Debe reportar y justificar los motivos de registrar un Avance no Programado. ");
                    //poa_Calendario.MsgError = "<strog>Observación requerida.</strong><p>Debe reportar y justificar los motivos de registrar un Avance no Programado.</p>";
                    //poa_Calendario.Error = true;
                    //poa_Calendario.Warning = true;
                    //poa_Calendario.MostrarObservacion = true;
                    modelo.EsAutorizado = false;
                    modelo.EsObservado = false;
                }
            }

            //if (poa_Calendario.Valor == 0)
            //    ModelState.AddModelError("Valor", "Campo requerido");

            if (ModelState.IsValid)
            {

                try
                {
                    db.Entry(modelo).State = System.Data.Entity.EntityState.Modified;
                    db.SaveChanges();
                    if (indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Actividad")
                    {
                        if (indicadores.IdIndicadorComponente != null)
                        {
                            Poa_Indicadores poaindicadorcomponente = db.Poa_Indicadores.Find(indicadores.IdIndicadorComponente);
                            if (poaindicadorcomponente != null)
                                actualizacalendariocomponentedesdecomponente(poaindicadorcomponente.IdIndicadores, "Realizado");
                            else
                                throw new Exception("Error, No existe COMPONENTE para esta actividad [IdIndicadorComponente] " + indicadores.IdIndicadorComponente.ToString());
                            //actualizacalendariocomponente(poaindicadorcomponente, poa_Calendario.PoaCalendario, "Programado");
                        }
                    }

                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }




                return JsonView(ModelState.IsValid, "Se ha grabado la programación exitosamente", null, null, Url.Action("Index", "PoaCalendario"));

            }
            messages = string.Join("; ", ModelState.Values
                                       .SelectMany(x => x.Errors)
                                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, "Edit", poa_Calendario);




        }
        public ActionResult actualizacalendariocomponentedesdecomponente(int id, string elementocalendario)
        {
            TransactionOptions transactionoptions1 = new TransactionOptions();
            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
            {
                try
                {
                    Poa_Indicadores icomponente = db.Poa_Indicadores.Find(id);
                    var indicadorescalendariocomnponente = db.Poa_Calendario.Where(x => x.IdIndicadores == icomponente.IdIndicadores && x.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).ToList();
                    foreach (var ic in indicadorescalendariocomnponente)
                    {
                        Poa_Calendario modeloic = new Poa_Calendario();
                        modeloic = db.Poa_Calendario.Find(ic.IdCalendario);
                        modeloic.Valor = 0;
                        db.Entry(modeloic).State = System.Data.Entity.EntityState.Modified;
                        db.SaveChanges();
                    }

                    var ListaIndicadoresActividadAlimentanComponente = db.Poa_Indicadores.Where(x => x.IdIndicadorComponente == icomponente.IdIndicadores).Include("Poa_Calendario").ToList();
                    decimal sumavaloresprogramados = 0;
                    var IdMesesAProcesar = (from c in ListaIndicadoresActividadAlimentanComponente
                                            join a in db.Poa_Calendario
                                                 on c.IdIndicadores equals a.IdIndicadores
                                            where a.Poa_CalendarioElemento.CalendarioElemento == elementocalendario
                                            select new
                                            {
                                                a.IdMes
                                            }).Distinct();

                    foreach (var mes in IdMesesAProcesar)
                    {
                        sumavaloresprogramados = 0;
                        List<Poa_Calendario> IndicadoresCalendarizados = new List<Poa_Calendario>();

                        foreach (var actividad in ListaIndicadoresActividadAlimentanComponente)
                        {
                            switch (icomponente.Poa_TipoIndicador.TipoIndicador)
                            {
                                case "Incremental":
                                    IndicadoresCalendarizados = db.Poa_Calendario.Where(c => c.IdMes <= mes.IdMes && c.IdIndicadores == actividad.IdIndicadores && c.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).ToList();
                                    break;
                                case "Promedio":
                                case "Acumulativo":
                                case "Indice":
                                    IndicadoresCalendarizados = db.Poa_Calendario.Where(c => c.IdMes == mes.IdMes && c.IdIndicadores == actividad.IdIndicadores && c.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).ToList();
                                    break;

                            }
                            sumavaloresprogramados = sumavaloresprogramados + IndicadoresCalendarizados.Sum(x => x.Valor);

                        }

                        Decimal valorcomponente = 0M;
                        switch (icomponente.Poa_TipoIndicador.TipoIndicador)
                        {
                            case "Incremental":
                                valorcomponente = Math.Round((((icomponente.LineaBaseNumerador + sumavaloresprogramados) * 100M) / icomponente.MetaAnualDenominador), 4);
                                break;
                            case "Promedio":
                            case "Acumulativo":
                                valorcomponente = Math.Round((sumavaloresprogramados * 100M / icomponente.MetaAnualDenominador), 4);
                                break;
                            case "Indice":
                                valorcomponente = Math.Round(sumavaloresprogramados / icomponente.MetaAnualDenominador, 4);
                                break;

                        }
                        var poacalendariocomnponente = db.Poa_Calendario.Where(x => x.IdIndicadores == icomponente.IdIndicadores && x.IdMes == mes.IdMes && x.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).FirstOrDefault();
                        if (poacalendariocomnponente != null)
                        {
                            Poa_Calendario modelo2 = new Poa_Calendario();
                            modelo2 = db.Poa_Calendario.Find(poacalendariocomnponente.IdCalendario);
                            modelo2.Valor = valorcomponente;
                            db.Entry(modelo2).State = System.Data.Entity.EntityState.Modified;

                        }
                        else
                        {
                            Poa_Calendario poacalendariocomponente = new Poa_Calendario();
                            poacalendariocomponente.IdCalendarioElemento = db.Poa_CalendarioElemento.Where(f => f.CalendarioElemento == elementocalendario).FirstOrDefault().IdCalendarioElemento;
                            poacalendariocomponente.IdMes = mes.IdMes;
                            poacalendariocomponente.IdIndicadores = icomponente.IdIndicadores;
                            poacalendariocomponente.Valor = valorcomponente;
                            db.Poa_Calendario.Add(poacalendariocomponente);
                        }
                        db.SaveChanges();

                    }

                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                scope.Complete();
                return JsonView(ModelState.IsValid, "Se ha grabado la programación del Componente exitosamente", null, null, Url.Action("Index", "PoaCalendario"));

            }
        }

    }

}