﻿using Dapper;
using Nova.Libraries;
using Nova.Models;
using Rotativa;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.Poa.Avance
{
    public class PoaSeguimientoMensualController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();
        string query = @"  select *, ((Realizado * 100) / (case when Programado = 0 then 100 else Programado end)) Avance from(
  select max(g.Numero) NumeroProyecto ,(c.ResumenNarrativo) ResumenNarrativo
  ,max(case when e.CalendarioElemento ='Programado' then a.Valor else 0.0 end) Programado 
  ,MAX(case when e.CalendarioElemento ='Realizado' then a.Valor else 0.0 end) Realizado 
  ,MAX(a.Observacion) Observacion 
  ,MAX(k.EstructuraOrganica) EstructuraOrganica 
  ,max(ñ.IdKardex) IdKardex
  ,MAX(ñ.Nombre + ' ' + ñ.ApellidoPaterno + ' ' + ñ.ApellidoMaterno) NombreUsuario
,Max(case when a.EsAutorizado = 1 then 1 else 0 end) EsAutorizado
,max(dx.TipoElementoObjetivos) TipoElementoObjetivos
,max(dx.OrdenMir) OrdenMir
  from Poa_Calendario a 
  inner join Poa_Indicadores b on b.IdIndicadores = a.IdIndicadores 
  inner join Poa_Mir c on c.IdMir = b.IdMir and c.AñoMir = @Anio
  inner join Poa_ProyectoArbol d on d.IdProyectoArbol = c.IdProyectoArbol 
inner join Poa_TipoElementoObjetivos dx on dx.IdTipoElementoObjetivos = d.IdTipoElementoObjetivos
  inner join Poa_CalendarioElemento e on e.IdCalendarioElemento = a.IdCalendarioElemento and e.CalendarioElemento in ('Programado','Realizado')
  inner join Poa_MirEstatus f on f.IdMirEstatus = c.IdMirEstatus and f.EstatusMir = 'Indicadores Autorizados'
  inner join Poa_Proyectos g on g.IdProyectos = d.IdProyectos and g.IdProyectos in @proyectos
  inner join Convenios_stConvenioLaboralTrabajadorCategoria l on l.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria or l.IdConvenioLaboralTrabajadorCategoria = c.IdConvenioLaboralTrabajadorCategoria or l.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador m on m.IdConvenioLaboralTrabajador = l.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador n on n.IdTrabajador = m.IdTrabajador
  inner join Kardex_ctDatosPersonales ñ on ñ.IdKardex = n.IdKardex
  inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica = l.IdEstructuraOrganica
  where a.IdMes = @Mes
  group by b.IdIndicadores,g.IdProyectos, c.ResumenNarrativo 
  ) Seguimiento 
  order by NumeroProyecto,OrdenMir";

        string queryUser = @"  select *, ((Realizado * 100) / (case when Programado = 0 then 100 else Programado end)) Avance from(
  select max(g.Numero) NumeroProyecto ,(c.ResumenNarrativo) ResumenNarrativo
  ,max(case when e.CalendarioElemento ='Programado' then a.Valor else 0.0 end) Programado 
  ,MAX(case when e.CalendarioElemento ='Realizado' then a.Valor else 0.0 end) Realizado 
  ,MAX(a.Observacion) Observacion 
  ,MAX(k.EstructuraOrganica) EstructuraOrganica 
  ,max(ñ.IdKardex) IdKardex
  ,MAX(ñ.Nombre + ' ' + ñ.ApellidoPaterno + ' ' + ñ.ApellidoMaterno) NombreUsuario
,Max(case when a.EsAutorizado = 1 then 1 else 0 end) EsAutorizado
,max(dx.TipoElementoObjetivos) TipoElementoObjetivos
,max(dx.OrdenMir) OrdenMir
  from Poa_Calendario a 
  inner join Poa_Indicadores b on b.IdIndicadores = a.IdIndicadores 
  inner join Poa_Mir c on c.IdMir = b.IdMir and c.AñoMir = @Anio 
  inner join Poa_ProyectoArbol d on d.IdProyectoArbol = c.IdProyectoArbol 
  inner join Poa_TipoElementoObjetivos dx on dx.IdTipoElementoObjetivos = d.IdTipoElementoObjetivos
  inner join Poa_CalendarioElemento e on e.IdCalendarioElemento = a.IdCalendarioElemento and e.CalendarioElemento in ('Programado','Realizado')
  inner join Poa_MirEstatus f on f.IdMirEstatus = c.IdMirEstatus and f.EstatusMir = 'Indicadores Autorizados'
  inner join Poa_Proyectos g on g.IdProyectos = d.IdProyectos and g.IdProyectos in @proyectos
  inner join Convenios_stConvenioLaboralTrabajadorCategoria l on l.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria or l.IdConvenioLaboralTrabajadorCategoria = c.IdConvenioLaboralTrabajadorCategoria or l.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador m on m.IdConvenioLaboralTrabajador = l.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador n on n.IdTrabajador = m.IdTrabajador
  inner join Kardex_ctDatosPersonales ñ on ñ.IdKardex = n.IdKardex
  inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica = l.IdEstructuraOrganica
  where a.IdMes = @Mes and (b.IdConvenioLaboralTrabajadorCategoria = @idUsuario )
  group by b.IdIndicadores,g.IdProyectos, c.ResumenNarrativo 
  ) Seguimiento 
  order by NumeroProyecto,OrdenMir";


        string queryEstatal = @"  select *, ((Realizado * 100) / (case when Programado = 0 then 100 else Programado end)) Avance from(
select max(f.Numero) NumeroProyecto, max(cx.Actividad) ResumenNarrativo
  ,max(case when g.CalendarioElemento ='Programado' then a.Valor else 0.0 end) Programado 
  ,MAX(case when g.CalendarioElemento ='Realizado' then a.Valor else 0.0 end) Realizado 
  ,MAX(a.Observacion) Observacion 
  ,MAX(k.EstructuraOrganica) EstructuraOrganica 
  ,MAX(ñ.Nombre + ' ' + ñ.ApellidoPaterno + ' ' + ñ.ApellidoMaterno) NombreUsuario
,(1) EsAutorizado
,('Componente') TipoElementoObjetivos
from Poa_EstructuraProgramaticaEstatalActividadAñoMetas a
inner join Poa_EstructuraProgramaticaEstatalActividadAño b on b.IdEstructuraProgramaticaEstatalActividadAño = a.IdEstructuraProgramaticaEstatalActividadAño and b.Año = @Anio
inner join Poa_EstructuraProgramaticaEstatal c on c.IdEstructuraProgramaticaEstatal = b.IdEstructuraProgramaticaEstatal
inner join Poa_ProyectosEstatales cx on cx.IdProyectosEstatales = c.IdProyectosEstatales 
inner join Poa_Mir d on d.IdMir = c.IdMir
inner join Poa_ProyectoArbol e on e.IdProyectoArbol = d.IdProyectoArbol
inner join Poa_Proyectos f on f.IdProyectos = e.IdProyectos and f.IdProyectos in @proyectos
inner join Poa_CalendarioElemento g on g.IdCalendarioElemento = a.IdCalendarioElemento
inner join Convenios_stConvenioLaboralTrabajadorCategoria l on l.IdConvenioLaboralTrabajadorCategoria = cx.IdConvenioLaboralTrabajadorCategoriaResponsable
  inner join Convenios_stConvenioLaboralTrabajador m on m.IdConvenioLaboralTrabajador = l.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador n on n.IdTrabajador = m.IdTrabajador
  inner join Kardex_ctDatosPersonales ñ on ñ.IdKardex = n.IdKardex
  inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica = l.IdEstructuraOrganica
  where a.IdMes = @Mes
  group by b.IdEstructuraProgramaticaEstatalActividadAño
  ) seguimiento
  order by NumeroProyecto";

        string queryEstatalUser = @" select *, ((Realizado * 100) / (case when Programado = 0 then 100 else Programado end)) Avance from(
select max(f.Numero) NumeroProyecto, max(cx.Actividad) ResumenNarrativo
  ,max(case when g.CalendarioElemento ='Programado' then a.Valor else 0.0 end) Programado 
  ,MAX(case when g.CalendarioElemento ='Realizado' then a.Valor else 0.0 end) Realizado 
  ,MAX(a.Observacion) Observacion 
  ,MAX(k.EstructuraOrganica) EstructuraOrganica 
  ,MAX(ñ.Nombre + ' ' + ñ.ApellidoPaterno + ' ' + ñ.ApellidoMaterno) NombreUsuario
,(1) EsAutorizado
,('Componente') TipoElementoObjetivos
from Poa_EstructuraProgramaticaEstatalActividadAñoMetas a
inner join Poa_EstructuraProgramaticaEstatalActividadAño b on b.IdEstructuraProgramaticaEstatalActividadAño = a.IdEstructuraProgramaticaEstatalActividadAño  and b.Año = @Anio
inner join Poa_EstructuraProgramaticaEstatal c on c.IdEstructuraProgramaticaEstatal = b.IdEstructuraProgramaticaEstatal
inner join Poa_ProyectosEstatales cx on cx.IdProyectosEstatales = c.IdProyectosEstatales and cx.IdConvenioLaboralTrabajadorCategoriaResponsable = @idUsuario
inner join Poa_Mir d on d.IdMir = c.IdMir
inner join Poa_ProyectoArbol e on e.IdProyectoArbol = d.IdProyectoArbol
inner join Poa_Proyectos f on f.IdProyectos = e.IdProyectos and f.IdProyectos in @proyectos
inner join Poa_CalendarioElemento g on g.IdCalendarioElemento = a.IdCalendarioElemento
inner join Convenios_stConvenioLaboralTrabajadorCategoria l on l.IdConvenioLaboralTrabajadorCategoria = cx.IdConvenioLaboralTrabajadorCategoriaResponsable
  inner join Convenios_stConvenioLaboralTrabajador m on m.IdConvenioLaboralTrabajador = l.IdConvenioLaboralTrabajador
  inner join Kardex_ctTrabajador n on n.IdTrabajador = m.IdTrabajador
  inner join Kardex_ctDatosPersonales ñ on ñ.IdKardex = n.IdKardex
  inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica = l.IdEstructuraOrganica
  where a.IdMes = @Mes
  group by b.IdEstructuraProgramaticaEstatalActividadAño
  ) seguimiento
  order by NumeroProyecto";

        // GET: SequimientoMensual
        public ActionResult Index()
        {
            int AñoTrabajando = System.Convert.ToInt32(Request["SelectAnio"]);

            var listTipo = new List<SelectListItem>
            {
                new SelectListItem{ Value = "1",Text = "FEDERAL"},
                new SelectListItem{ Value = "2", Text = "ESTATAL"}
            };

            var tipoActividades = listTipo.Select(x => new {
                IdTipoActividad = x.Value,
                TipoActividad = x.Text
            }).ToList();

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            int AñoDefault = 0;
            if (AñoTrabajando == 0)
            {
                AñoDefault = db.Poa_SistemaAñoVigente.FirstOrDefault().Año;
            }
            else
            {
                AñoDefault = AñoTrabajando;
            }


            string queryProyectos = @"select b.IdProyectos, b.Numero, b.Proyecto,a.AñoProyectos from Poa_ProyectosAño a
  inner join Poa_Proyectos b on b.IdProyectos = a.IdProyectos
  where a.AñoProyectos = @AñoDefault
  order by b.Numero";

            var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { AñoDefault });
            var listProyectos = proy.Select(x => new
            {
                IdProyectos = x.IdProyectos,
                Proyectos = x.Numero + " " + x.Proyecto
            });
            dp.Close();


            var listMeses = db.Catalogos_ctMes.Select(x => new {
                IdMesAño = x.IdMes,
                MesAño = x.Mes
            }).OrderBy(t => t.IdMesAño).ToList();

            //Consultar lista años
            var ListAños = db.Poa_Mir.GroupBy(s => s.AñoMir).Select(t => new SelectListItem
            {
                Text = t.Key.ToString(),
                Value = t.Key.ToString()
            });


            ViewBag.AñoDefault = AñoDefault;
            ViewBag.SelectAnio = new SelectList(ListAños.OrderByDescending(x => x.Value), "Text", "Value", ViewBag.AñoDefault);
            ViewBag.IdTipoActividad = new SelectList(tipoActividades, "IdTipoActividad", "TipoActividad");
            ViewBag.IdProyectos = new SelectList(listProyectos, "IdProyectos", "Proyectos");
            ViewBag.IdMesAnio = new SelectList(listMeses, "IdMesAño", "MesAño");

            return View();
        }

        [HttpPost]
        public ActionResult SeguimientoMensualView(int Anio, int Tipo, int[] Proyectos, int Mes)
        {
            //var proyectos = Proyectos.Select(s => Int32.Parse(s)).ToArray();
            var proyectos = Proyectos;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idUsuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<ReporteAvanceMensual> result = new List<ReporteAvanceMensual>();



            if (rolAdmin.EsAdministrador())
            {
                if (Tipo == 1)
                {
                    result = (List<ReporteAvanceMensual>)dp.connection.Query<ReporteAvanceMensual>(query, new { Anio, proyectos, Mes });
                }
                else if (Tipo == 2)
                {
                    result = (List<ReporteAvanceMensual>)dp.connection.Query<ReporteAvanceMensual>(queryEstatal, new { Anio, proyectos, Mes });
                }


            }
            else
            {
                if (Tipo == 1)
                {
                    result = (List<ReporteAvanceMensual>)dp.connection.Query<ReporteAvanceMensual>(queryUser, new { Anio, proyectos, Mes, idUsuario });
                }
                else if (Tipo == 2)
                {
                    result = (List<ReporteAvanceMensual>)dp.connection.Query<ReporteAvanceMensual>(queryEstatalUser, new { Anio, proyectos, Mes, idUsuario });
                }

            }



            dp.Close();

            List<ReporteAvanceMensual> filaVacia = result.Where(t => t.Programado <= 0 && t.Realizado <= 0).ToList();
            foreach (var f in filaVacia)
            {
                result.Remove(f);
            }




            var mesC = db.Catalogos_ctMes.Find(Mes);
            ViewBag.IdMes = mesC.Mes;
            return PartialView("_SeguimientoMensual", result);
        }

        public ActionResult SeguimientoMensual(int SelectAnio, int IdTipoActividad, int[] IdProyectos, int IdMesAnio)
        {

            var proyectos = IdProyectos;
            var Tipo = IdTipoActividad;
            var Mes = IdMesAnio;
            var Anio = SelectAnio;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idUsuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<ReporteAvanceMensual> result = new List<ReporteAvanceMensual>();

            var TipoAño = "";

            if (rolAdmin.EsAdministrador())
            {
                if (Tipo == 1)
                {
                    result = (List<ReporteAvanceMensual>)dp.connection.Query<ReporteAvanceMensual>(query, new { Anio, proyectos, Mes });
                    TipoAño = "Federal " + Anio;
                }
                else if (Tipo == 2)
                {
                    result = (List<ReporteAvanceMensual>)dp.connection.Query<ReporteAvanceMensual>(queryEstatal, new { Anio, proyectos, Mes });
                    TipoAño = "Estatal " + Anio;
                }


            }
            else
            {
                if (Tipo == 1)
                {
                    result = (List<ReporteAvanceMensual>)dp.connection.Query<ReporteAvanceMensual>(queryUser, new { Anio, proyectos, Mes, idUsuario });
                    TipoAño = "Federal " + Anio;
                }
                else if (Tipo == 2)
                {
                    result = (List<ReporteAvanceMensual>)dp.connection.Query<ReporteAvanceMensual>(queryEstatalUser, new { Anio, proyectos, Mes, idUsuario });
                    TipoAño = "Estatal " + Anio;
                }

            }

            string modalidad = "Poa_SeguimientoMensual" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;

            List<ReporteAvanceMensual> filaVacia = result.Where(t => t.Programado <= 0 && t.Realizado <= 0).ToList();
            foreach (var f in filaVacia)
            {
                result.Remove(f);
            }

            var mesC = db.Catalogos_ctMes.Find(Mes);
            ViewBag.IdMes = mesC.Mes;
            ViewBag.IdTipoActividadAnio = TipoAño;
            //var pdff = new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            return new PartialViewAsPdf("_SeguimientoMensualPdf", result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

        }

        public ActionResult SeguimientoMensualXls(int SelectAnio, int IdTipoActividad, int[] IdProyectos, int IdMesAnio)
        {
            var proyectos = IdProyectos;
            var Tipo = IdTipoActividad;
            var Mes = IdMesAnio;
            var Anio = SelectAnio;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idUsuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<ReporteAvanceMensual> result = new List<ReporteAvanceMensual>();



            if (rolAdmin.EsAdministrador())
            {
                if (Tipo == 1)
                {
                    result = (List<ReporteAvanceMensual>)dp.connection.Query<ReporteAvanceMensual>(query, new { Anio, proyectos, Mes });
                }
                else if (Tipo == 2)
                {
                    result = (List<ReporteAvanceMensual>)dp.connection.Query<ReporteAvanceMensual>(queryEstatal, new { Anio, proyectos, Mes });
                }
            }
            else
            {
                if (Tipo == 1)
                {
                    result = (List<ReporteAvanceMensual>)dp.connection.Query<ReporteAvanceMensual>(queryUser, new { Anio, proyectos, Mes, idUsuario });
                }
                else if (Tipo == 2)
                {
                    result = (List<ReporteAvanceMensual>)dp.connection.Query<ReporteAvanceMensual>(queryEstatalUser, new { Anio, proyectos, Mes, idUsuario });
                }
            }
            string nombreXls = "Poa_SeguimientoMensual_" + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=" + nombreXls);

            List<ReporteAvanceMensual> filaVacia = result.Where(t => t.Programado <= 0 && t.Realizado <= 0).ToList();
            foreach (var f in filaVacia)
            {
                result.Remove(f);
            }

            var mesC = db.Catalogos_ctMes.Find(Mes);
            ViewBag.IdMes = mesC.Mes;
            return View(result);
        }




    }
}