﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Dapper;
using Rotativa;
using System.Transactions;

namespace Nova.Controllers.POA.ReporteValidacionAdmin
{
    public class PoaReporteValidarAdminController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();
        string query = @"select * from (
                                select * from (select aa.*,
						                     bb.EstructuraOrganica as EstructuraOrganicaFirma
						                     from (
                                                               select  d.TipoElementoObjetivos,e.Numero,e.Objetivo,e.Proyecto,b3.EstructuraOrganica, a.AñoMir as Año, a.ResumenNarrativo, 
					                        c.Indicador,					
                                            c.UnidadMedidaIndicador,
                                            c2.DimensionIndicador,
					                        c3.FrecuenciaMedicion, 
					                        c4.SentidoIndicador,
					                        c5.TipoIndicador, c.Numerador,c.Denominador, 
					                        c.LineaBaseNumerador,c.LineaBaseDenominador, c.LineaBase,
					                        c.MetaAnual, c.MetaAnualNumerador, c.MetaAnualDenominador,
				                            c.IdIndicadores,
					                        c.IdIndicadorComponente, c6.Indicador as AlimentaComponente,
					                        d.OrdenMir,
											b2.IdConvenioLaboralTrabajadorCategoria
											,a.IdConvenioLaboralTrabajadorCategoria as IdConvenioLaboralTrabajadorCategoriaMir
											,c.IdConvenioLaboralTrabajadorCategoria as IdConvenioLaboralTrabajadorCategoriaIndicadores
                                            ,b22.IdTrabajador,
					                        b23.Nombre + ' ' + b23.ApellidoPaterno + ' ' + b23.ApellidoMaterno as NombreCompleto,
					                                   
					                        c8.IdCalendarioElemento
					                        ,SUM( case when c7.IdMes in (1,2,3) then 1 else 0 end) PrimerTrimestre
											,SUM( case when c7.IdMes in (4,5,6) then 1 else 0 end) SegundoTrimestre
											,SUM( case when c7.IdMes in (7,8,9) then 1 else 0 end) TercerTrimestre
											,SUM( case when c7.IdMes in (10,11,12) then 1 else 0 end) CuartoTrimestre
											,case when B3.IdEstructuraOrganicaPadre = 1 then b3.IdEstructuraOrganica else b3.IdEstructuraOrganicaPadre end IdEstructuraOrganicaFirma
						                    from Poa_Mir a
                                            inner join  Poa_ProyectoArbol b on a.IdProyectoArbol = b.IdProyectoArbol
                                            inner join Convenios_stConvenioLaboralTrabajadorCategoria b2 on b.IdConvenioLaboralTrabajadorCategoria = b2.IdConvenioLaboralTrabajadorCategoria
						                    inner join Convenios_stConvenioLaboralTrabajador b21 on b2.IdConvenioLaboralTrabajador = b21.IdConvenioLaboralTrabajador
						                    inner join Kardex_ctTrabajador b22 on b21.IdTrabajador= b22.IdTrabajador
						                    inner join Kardex_ctDatosPersonales b23 on b22.IdKardex = b23.IdKardex
						                    inner join Catalogos_ctEstructuraOrganica b3 on b2.IdEstructuraOrganica= b3.IdEstructuraOrganica 
						                    inner join Poa_TipoElementoObjetivos d on b.IdTipoElementoObjetivos = d.IdTipoElementoObjetivos
                                            inner join Poa_Proyectos e on  b.IdProyectos = e.IdProyectos
                                            left join Poa_Indicadores c on a.IdMir= c.IdMir 
						                    left join Poa_DimensionIndicador c2 on c.IdDimensionIndicador = c2.IdDimensionIndicador
						                    left join Poa_FrecuenciaMedicionIndicador c3 on c.IdFrecuenciaMedicionIndicador = c3.IdFrecuenciaMedicionIndicador
						                    left join Poa_SentidoIndicador c4 on c.IdSentidoIndicador = c4.IdSentidoIndicador
						                    left join Poa_TipoIndicador c5 on c.IdTipoIndicador = c5.IdTipoIndicador
						                    left join Poa_Indicadores c6 on c.IdIndicadorComponente = c6.IdIndicadores
						                     left join Poa_Calendario c7 on c.IdIndicadores= c7.IdIndicadores
						                    left join Poa_CalendarioElemento c8 on c7.IdCalendarioElemento = c8.IdCalendarioElemento
						                    
											WHERE  a.IdMirEstatus=(select IdMirEstatus from [Poa_MirEstatus] where EstatusMir='Indicadores Autorizados') 
						                     
						                    group by d.TipoElementoObjetivos,e.Numero,e.Objetivo,e.Proyecto,b3.EstructuraOrganica, a.AñoMir, a.ResumenNarrativo, 
					                        c.Indicador,					
                                            c.UnidadMedidaIndicador,
                                            c2.DimensionIndicador,
					                        c3.FrecuenciaMedicion, 
					                        c4.SentidoIndicador,
					                        c5.TipoIndicador, c.Numerador,c.Denominador, 
					                        c.LineaBaseNumerador,c.LineaBaseDenominador, c.LineaBase,
					                        c.MetaAnual, c.MetaAnualNumerador, c.MetaAnualDenominador,
				                            c.IdIndicadores,
					                        c.IdIndicadorComponente, c6.Indicador ,
					                        d.OrdenMir,
                                            b22.IdTrabajador,
					                        b23.Nombre+ ' ' + b23.ApellidoPaterno + ' ' + b23.ApellidoMaterno ,
					                         					                                        
					                        c8.IdCalendarioElemento,
											b2.IdConvenioLaboralTrabajadorCategoria
											,a.IdConvenioLaboralTrabajadorCategoria 
											,c.IdConvenioLaboralTrabajadorCategoria
											,B3.IdEstructuraOrganicaPadre
											,b3.IdEstructuraOrganica
                                                                
											                    ) aa
											                    inner join Catalogos_ctEstructuraOrganica bb on aa.IdEstructuraOrganicaFirma = bb.IdEstructuraOrganica
                                                                ) as Universo
    					                    left join (
						                                select 
					                                    c.IdIndicadorComponente as NoIndicadorComponente
					                                    ,max(a.ResumenNarrativo) ResumenNarrativoActividad
						                                 from 
						                                  Poa_Mir a
                                                        inner join  Poa_ProyectoArbol b on a.IdProyectoArbol = b.IdProyectoArbol
                                                        inner join Convenios_stConvenioLaboralTrabajadorCategoria b2 on b.IdConvenioLaboralTrabajadorCategoria = b2.IdConvenioLaboralTrabajadorCategoria
						                                inner join Convenios_stConvenioLaboralTrabajador b21 on b2.IdConvenioLaboralTrabajador = b21.IdConvenioLaboralTrabajador
						                                inner join Kardex_ctTrabajador b22 on b21.IdTrabajador= b22.IdTrabajador
						                                inner join Kardex_ctDatosPersonales b23 on b22.IdKardex = b23.IdKardex
						                                inner join Catalogos_ctEstructuraOrganica b3 on b2.IdEstructuraOrganica= b3.IdEstructuraOrganica 
						                                inner join Poa_TipoElementoObjetivos d on b.IdTipoElementoObjetivos = d.IdTipoElementoObjetivos
                                                        inner join Poa_Proyectos e on  b.IdProyectos = e.IdProyectos
                                                        left join Poa_Indicadores c on a.IdMir= c.IdMir 
						                                left join Poa_DimensionIndicador c2 on c.IdDimensionIndicador = c2.IdDimensionIndicador
						                                left join Poa_FrecuenciaMedicionIndicador c3 on c.IdFrecuenciaMedicionIndicador = c3.IdFrecuenciaMedicionIndicador
						                                left join Poa_SentidoIndicador c4 on c.IdSentidoIndicador = c4.IdSentidoIndicador
						                                left join Poa_TipoIndicador c5 on c.IdTipoIndicador = c5.IdTipoIndicador
						                                left join Poa_Indicadores c6 on c.IdIndicadorComponente = c6.IdIndicadores
						                                where c.IdIndicadorComponente is not null
						                                group by c.IdIndicadorComponente	
						
						                                ) 
                                            as Activiades on Universo.IdIndicadores=Activiades.NoIndicadorComponente
						                    ) as Total
							            left join (
						                    SELECT Max(b.IdEstructuraOrganica) IdEstructuraOrganicaFirmaDirectores  ,MAX(n.Nombre +' '+n.ApellidoPaterno +' '+n.ApellidoMaterno) NombreCompletoFirmadirectores, MAX(EstructuraOrganica) EstructuraOrganicaFirmaDirectores FROM Catalogos_ctEstructuraOrganica a
									        inner join Convenios_stConvenioLaboralTrabajadorCategoria b on b.IdEstructuraOrganica = a.IdEstructuraOrganica
									        INNER JOIN Plazas_stDistribucionPlazaCategoria f ON f.IdDistribucionPlazaCategoria = b.IdDistribucionPlazaCategoria
									        inner join Plazas_ctCategoria g on g.IdCategoria = f.IdCategoria
									        inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral = g.IdRelacionConvenioLaboral and h.RelacionConvenioLaboral = 'MANDO MEDIO-CONFIANZA'
									        inner join Catalogos_ctRelacionLaboral j on j.IdRelacionLaboral = h.IdRelacionLaboral AND j.RelacionLaboral = 'MANDO MEDIO'
									        inner join Convenios_stConvenioLaboralTrabajador k on k.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
									        inner join Kardex_ctTrabajador m on m.IdTrabajador = k.IdTrabajador
									        inner join Kardex_ctDatosPersonales n on n.IdKardex = m.IdKardex
									        where b.FechaTermino is null
									        group by b.IdConvenioLaboralTrabajadorCategoria
					                
						
						                    ) 
                                            as Direcciones on Total.IdEstructuraOrganicaFirma =Direcciones.IdEstructuraOrganicaFirmaDirectores
			                             
										  where  Total.Año in @anio
                                             and Total.Proyecto in @proyecto
                                            
                                            
											Order by Total.Numero,Total.OrdenMir,Total.IdIndicadores";

        // GET: PoaReporteValidar
        Int16[] anio = { };
        String[] proyecto = { };
       // String[] area = { };

        public ActionResult Index()
        {
            var poa_Mir = db.Poa_Mir.Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Poa_MirEstatus).Include(p => p.Poa_ProyectoArbol);
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string queryAños = @"SELECT AñoArbol
                                  FROM Poa_ProyectoArbol
                                  group by AñoArbol
                                  order by 1 desc";
            var años = (List<short>)dp.connection.Query<short>(queryAños);
            ViewBag.Anios = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            string queryProyectos = @"SELECT 
                       b.Numero, b.Proyecto
                  FROM Poa_ProyectoArbol a
                  inner join Poa_Proyectos b on a.IdProyectos = b.IdProyectos
                  group by b.Numero, a.IdProyectos, b.Proyecto
                  order by b.Numero asc";

            var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos);
            ViewBag.Proyectos = proy.Select(x => new SelectListItem()
            {
                Value = x.Proyecto,
                Text = x.Numero + " " + x.Proyecto
            });


            //string queryAreas = @" select c.EstructuraOrganica 
            //                      from Poa_ProyectoArbol a
            //                      inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
            //                      inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
            //                      group by c.EstructuraOrganica";

            //var areas = (List<string>)dp.connection.Query<string>(queryAreas);
            //ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });

            dp.Close();


            return View();
        }

        [HttpPost]
        public ActionResult ReporteValidarViewAdmin(String[] anios, String[] proyectos)
        //String[] proyectos,
        {

            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            //area = areas;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            var result = (List<PoaReporteValidarAdmin>)dp.connection.Query<PoaReporteValidarAdmin>(query, new { anio, proyecto });

            dp.Close();
            return PartialView("_ReporteValidarAdmin", result.ToList());

        }

        public ActionResult ReporteValidarAdmin(String[] anios, String[] proyectos)
        //String[] proyectos,
        {

            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            //area = areas;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");


            var result = (List<PoaReporteValidarAdmin>)dp.connection.Query<PoaReporteValidarAdmin>(query, new { anio, proyecto });

            var actividades = (from t in result

                               group t by new { t.NombreCompleto, t.Proyecto, t.Numero }
                                   into grp
                                   select new
                                   {
                                       grp.Key.NombreCompleto,
                                       grp.Key.Proyecto,
                                       grp.Key.Numero,
                                       Cantidad = grp.Count()


                                   }).ToList();

            //var maxactividades = (from s in actividades
            //        group s by new { s.Numero } into g
            //        select new {
            //                       g.Key.Numero,

            //                     Maximo = g.Max(s => s.Cantidad) }).ToList();


            dp.Close();
            string modalidad = "Poa_ValidarAdmin" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;


            //return View("ReporteValidar", result.ToList());
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
        }


        public ActionResult ReporteValidarXlsAdmin(String[] anios, String[] proyectos)
        //String[] proyectos,
        {

            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            //area = areas;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");


            var result = (List<PoaReporteValidarAdmin>)dp.connection.Query<PoaReporteValidarAdmin>(query, new { anio, proyecto });
            dp.Close();
            string modalidad = "Poa_ValidarAdmin_" + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidad);

            return View(result);
        }

        // GET: PoaReporteValidar/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Mir poa_Mir = db.Poa_Mir.Find(id);
            if (poa_Mir == null)
            {
                return HttpNotFound();
            }
            return View(poa_Mir);
        }

        // GET: PoaReporteValidar/Create
        public ActionResult Create()
        {
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdMirEstatus = new SelectList(db.Poa_MirEstatus, "IdMirEstatus", "EstatusMir");
            ViewBag.IdProyectoArbol = new SelectList(db.Poa_ProyectoArbol, "IdProyectoArbol", "DescripcionElementoObjetivos");
            return View();
        }

        // POST: PoaReporteValidar/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdMir,IdConvenioLaboralTrabajadorCategoria,IdMirEstatus,IdProyectoArbol,ResumenNarrativo")] Poa_Mir poa_Mir)
        {
            if (ModelState.IsValid)
            {
                db.Poa_Mir.Add(poa_Mir);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", poa_Mir.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdMirEstatus = new SelectList(db.Poa_MirEstatus, "IdMirEstatus", "EstatusMir", poa_Mir.IdMirEstatus);
            ViewBag.IdProyectoArbol = new SelectList(db.Poa_ProyectoArbol, "IdProyectoArbol", "DescripcionElementoObjetivos", poa_Mir.IdProyectoArbol);
            return View(poa_Mir);
        }

        // GET: PoaReporteValidar/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Mir poa_Mir = db.Poa_Mir.Find(id);
            if (poa_Mir == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", poa_Mir.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdMirEstatus = new SelectList(db.Poa_MirEstatus, "IdMirEstatus", "EstatusMir", poa_Mir.IdMirEstatus);
            ViewBag.IdProyectoArbol = new SelectList(db.Poa_ProyectoArbol, "IdProyectoArbol", "DescripcionElementoObjetivos", poa_Mir.IdProyectoArbol);
            return View(poa_Mir);
        }

        // POST: PoaReporteValidar/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdMir,IdConvenioLaboralTrabajadorCategoria,IdMirEstatus,IdProyectoArbol,ResumenNarrativo")] Poa_Mir poa_Mir)
        {
            if (ModelState.IsValid)
            {
                db.Entry(poa_Mir).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", poa_Mir.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdMirEstatus = new SelectList(db.Poa_MirEstatus, "IdMirEstatus", "EstatusMir", poa_Mir.IdMirEstatus);
            ViewBag.IdProyectoArbol = new SelectList(db.Poa_ProyectoArbol, "IdProyectoArbol", "DescripcionElementoObjetivos", poa_Mir.IdProyectoArbol);
            return View(poa_Mir);
        }

        // GET: PoaReporteValidar/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Mir poa_Mir = db.Poa_Mir.Find(id);
            if (poa_Mir == null)
            {
                return HttpNotFound();
            }
            return View(poa_Mir);
        }

        // POST: PoaReporteValidar/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Poa_Mir poa_Mir = db.Poa_Mir.Find(id);
            db.Poa_Mir.Remove(poa_Mir);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
