﻿using Dapper;
using Nova.Libraries;
using Nova.Models;
using Rotativa;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.Poa.Productos
{
    public class PoaProductosReporteController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        string query = @"SELECT max(k.EstructuraOrganica) EstructuraOrganica, MAX(a2.Mes) as Mes, MAX(d.Productos) as Productos
,max(d.PartidaEspecifica) PartidaEspecifica
,max(d.PartidaGenerica) PartidaGenerica
,max(d.Partida) Partida
, sum(c.CantidadProducto) CantidadProducto  ,d.Precio ,sum(c.Total) Total
,max(H.Proyecto) Proyecto  
from Poa_Calendario a
inner join Poa_CalendarioElemento b on b.IdCalendarioElemento = a.IdCalendarioElemento
inner join Poa_Presupuesto c on c.IdCalendario = a.IdCalendario
inner join Catalogos_ctMes a2 on a2.IdMes = c.IdMes
inner join Poa_Productos d on d.IdProductos = c.IdProductos
inner join Poa_Indicadores e on e.IdIndicadores = a.IdIndicadores
INNER JOIN Poa_Mir f on f.IdMir = e.IdMir and f.AñoMir IN @anio
INNER JOIN Poa_ProyectoArbol g on g.IdProyectoArbol = f.IdProyectoArbol
INNER JOIN Poa_Proyectos H ON H.IdProyectos = g.IdProyectos
inner join Poa_ProyectosAño H2 ON H2.IdProyectos = H.IdProyectos and H2.AñoProyectos in @anio
INNER JOIN Convenios_stConvenioLaboralTrabajadorCategoria j on j.IdConvenioLaboralTrabajadorCategoria = f.IdConvenioLaboralTrabajadorCategoria
inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica = j.IdEstructuraOrganica
where H.Proyecto IN @proyecto
AND k.EstructuraOrganica in @area
GROUP BY H.IdProyectos,k.IdEstructuraOrganica, c.IdMes,d.IdProductos,d.Precio
order by 1,mAX(a2.Orden),4";

        string queryUser = @"SELECT max(k.EstructuraOrganica) EstructuraOrganica, MAX(a2.Mes) as Mes, MAX(d.Productos) as Productos
,max(d.PartidaEspecifica) PartidaEspecifica
,max(d.PartidaGenerica) PartidaGenerica
,max(d.Partida) Partida
, sum(c.CantidadProducto) CantidadProducto  ,d.Precio ,sum(c.Total) Total
,max(H.Proyecto) Proyecto  
from Poa_Calendario a
inner join Poa_CalendarioElemento b on b.IdCalendarioElemento = a.IdCalendarioElemento
inner join Poa_Presupuesto c on c.IdCalendario = a.IdCalendario
inner join Catalogos_ctMes a2 on a2.IdMes = c.IdMes
inner join Poa_Productos d on d.IdProductos = c.IdProductos
inner join Poa_Indicadores e on e.IdIndicadores = a.IdIndicadores
INNER JOIN Poa_Mir f on f.IdMir = e.IdMir and f.AñoMir IN @anio
INNER JOIN Poa_ProyectoArbol g on g.IdProyectoArbol = f.IdProyectoArbol
INNER JOIN Poa_Proyectos H ON H.IdProyectos = g.IdProyectos
inner join Poa_ProyectosAño H2 ON H2.IdProyectos = H.IdProyectos and H2.AñoProyectos in @anio
INNER JOIN Convenios_stConvenioLaboralTrabajadorCategoria j on j.IdConvenioLaboralTrabajadorCategoria = f.IdConvenioLaboralTrabajadorCategoria
inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica = j.IdEstructuraOrganica
where H.Proyecto IN @proyecto
AND k.EstructuraOrganica in @area
GROUP BY H.IdProyectos,k.IdEstructuraOrganica, c.IdMes,d.IdProductos,d.Precio
order by 1,mAX(a2.Orden),4";

        string queryResponsable = @"SELECT MAX(n.Nombre +' '+n.ApellidoPaterno +' '+n.ApellidoMaterno) NombreCompleto, MAX(EstructuraOrganica) EstructuraOrganica FROM Catalogos_ctEstructuraOrganica a
inner join Convenios_stConvenioLaboralTrabajadorCategoria b on b.IdEstructuraOrganica = a.IdEstructuraOrganica
INNER JOIN Plazas_stDistribucionPlazaCategoria f ON f.IdDistribucionPlazaCategoria = b.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria g on g.IdCategoria = f.IdCategoria
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral = g.IdRelacionConvenioLaboral and h.RelacionConvenioLaboral = 'MANDO MEDIO-CONFIANZA'
inner join Catalogos_ctRelacionLaboral j on j.IdRelacionLaboral = h.IdRelacionLaboral AND j.RelacionLaboral = 'MANDO MEDIO'
inner join Convenios_stConvenioLaboralTrabajador k on k.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador m on m.IdTrabajador = k.IdTrabajador
inner join Kardex_ctDatosPersonales n on n.IdKardex = m.IdKardex
where EstructuraOrganica  = (
select a.EstructuraOrganica from Catalogos_ctEstructuraOrganica a 
inner join (SELECT 
case when a.IdEstructuraOrganicaPadre <> 1 THEN a.IdEstructuraOrganicaPadre ELSE a.IdEstructuraOrganica end idEstructuraOrganica
FROM Catalogos_ctEstructuraOrganica a
where a.EstructuraOrganica = @areaSingle
) b on a.IdEstructuraOrganica = b.idEstructuraOrganica
) and b.FechaTermino is null";

        Int16[] anio = { };
        String[] proyecto = { };
        String[] area = { };

        // GET: PoaProductosReporte
        public ActionResult Index()
        {
            PoaMir rolAdmin = new PoaMir();

            if (rolAdmin.EsAdministrador())
            {
                return RedirectToAction("Admin", "PoaProductosReporte");
            }
            return View();
        }

        public ActionResult Admin()
        {

            PoaMir rolAdmin = new PoaMir();

            if (!rolAdmin.EsAdministrador())
            {
                return RedirectToAction("Index", "PoaProductosReporte");
            }

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"SELECT 
      AñoArbol
  FROM Poa_ProyectoArbol
  group by AñoArbol
  order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);
            ViewBag.Anios = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            string queryProyectos = @"SELECT 
       b.Numero, b.Proyecto
  FROM Poa_ProyectoArbol a
  inner join Poa_Proyectos b on a.IdProyectos = b.IdProyectos
  group by a.IdProyectos, b.Proyecto, b.Numero
  order by b.Numero";

            var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos);
            ViewBag.Proyectos = proy.Select(x => new SelectListItem()
            {
                Value = x.Proyecto,
                Text = x.Numero + " " + x.Proyecto
            });


  //          string queryAreas = @" select c.EstructuraOrganica 
  //from Poa_ProyectoArbol a
  //inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
  //inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
  //group by c.EstructuraOrganica";
            string queryAreas = @" select c.EstructuraOrganica 
  from Poa_Mir a
  inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
  group by c.EstructuraOrganica";

            var areas = (List<string>)dp.connection.Query<string>(queryAreas);
            ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });


            dp.Close();



            return View();
        }

        [HttpPost]
        public ActionResult ProductosTotalesView(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<ProductosTotalReporte> result = new List<ProductosTotalReporte>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<ProductosTotalReporte>)dp.connection.Query<ProductosTotalReporte>(query, new { anio, proyecto, area });

            }
            else
            {
                result = (List<ProductosTotalReporte>)dp.connection.Query<ProductosTotalReporte>(queryUser, new { anio, proyecto, area, idusuario });
            }



            dp.Close();

            return PartialView("_ProductosTotales", result);
        }

        public ActionResult ProductosTotales(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<ProductosTotalReporte> result = new List<ProductosTotalReporte>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<ProductosTotalReporte>)dp.connection.Query<ProductosTotalReporte>(query, new { anio, proyecto, area });
            }
            else
            {
                result = (List<ProductosTotalReporte>)dp.connection.Query<ProductosTotalReporte>(queryUser, new { anio, proyecto, area, idusuario });
            }

            if (proyecto.Count() == 1 && area.Count() == 1)
            {
                //if (rolAdmin.EsAdministrador())
                //{
                    string areaSingle = area.FirstOrDefault();
                    var responsable = (List<DirectorArea>)dp.connection.Query<DirectorArea>(queryResponsable, new { areaSingle });
                    ViewBag.UsuarioU = responsable.Select(t => t.NombreCompleto).FirstOrDefault();
                    ViewBag.EstructuraP = responsable.Select(t => t.EstructuraOrganica).FirstOrDefault();
                //}
                //else
                //{
                //    var usuario = Seguridad.Identidad.Usuario();
                //    ViewBag.UsuarioU = usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + ' ' + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + ' ' + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre;
                //}
            }
            else
            {
                ViewBag.UsuarioU = "NoUser";
            }

            dp.Close();

            string modalidad = "Poa_ProductosTotales" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;


            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

        }

        public ActionResult ProductosTotalesXls(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<ProductosTotalReporte> result = new List<ProductosTotalReporte>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<ProductosTotalReporte>)dp.connection.Query<ProductosTotalReporte>(query, new { anio, proyecto, area });

            }
            else
            {
                result = (List<ProductosTotalReporte>)dp.connection.Query<ProductosTotalReporte>(queryUser, new { anio, proyecto, area, idusuario });
            }



            dp.Close();


            string modalidad = "Poa_ProductosTotales_" + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=" + modalidad);

            return View(result);
        }

        [HttpPost]
        public ActionResult ConsultarProyectosAnio()
        {
            int año = System.Convert.ToInt32(Request["Anio"]);
            if (año != 0 && año > 2000)
            {

            }
            else
            {
                año = db.Poa_SistemaAñoVigente.Select(s => s.Año).FirstOrDefault();
            }

            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            PoaMir rol = new PoaMir();

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"SELECT 
      AñoArbol
  FROM Poa_ProyectoArbol
  group by AñoArbol
  order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            ViewBag.Anios = new SelectList(listAños, "Value", "Text", año);




            if (rol.EsMandoMedio())//para saber si es PoaResponsable
            {
                string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE f.AñoMir = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by a.Numero, a.Proyecto";

                var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
                ViewBag.Proyectos = proy.Select(x => new SelectListItem()
                {
                    Value = x.Proyecto,
                    Text = x.Numero + " " + x.Proyecto
                });


                string queryAreas = @" select d.EstructuraOrganica from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE f.AñoMir = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by d.EstructuraOrganica";

                var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
                ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });

            }
            else if (rol.TieneIndicadoresAsignados(año))
            {

                string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.Año = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by a.Numero, a.Proyecto";


                var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
                ViewBag.Proyectos = proy.Select(x => new SelectListItem()
                {
                    Value = x.Proyecto,
                    Text = x.Numero + " " + x.Proyecto
                });


                string queryAreas = @"select d.EstructuraOrganica from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.AñoProyectos = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by d.EstructuraOrganica";

                var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
                ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });
            }
            else
            {
                var result = "No se encuentra un elmento asociado";
                return Json(result, JsonRequestBehavior.AllowGet);
            }



            dp.Close();
            return PartialView("_FormListView");
        }



    }
}