﻿using Dapper;
using Nova.Libraries;
using Nova.Models;
using Rotativa;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.Poa.Productos
{
    public class PoaProductosPresupuestadosMesesController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        string query = @"select 
max(cast(p.Numero as nvarchar(2)) + ' ' + p.Proyecto) Proyecto
,max(k.EstructuraOrganica) EstructuraOrganica
,max(dp.Nombre +' '+ dp.ApellidoPaterno+' '+dp.ApellidoMaterno) AS Usuario
,max(c.Numerador) as Actividad
,MAX(case when x.IdPartidas IS null then 'No' else 'Si' end) EsConsolidada
,max(f.Clase) Clase
,max(f.PartidaGenerica) PartidaGenerica,max(f.PartidaEspecifica) PartidaEspecifica, max(f.Partida) Partida
,max(e.UnidadMedida) UnidadMedida
,max(e.Productos) Productos
,max(a.PrecioProducto) PrecioProducto
,SUM(case when  a.idmes=1 then  (a.CantidadProducto) ELSE 0 end )  cENERO
,SUM(case when  a.idmes=2 then  (a.CantidadProducto) else 0 end)   cFEBRERO
,SUM(case when  a.idmes=3 then  (a.CantidadProducto) else 0 end)   cMARZO
,SUM(case when  a.idmes=4 then  (a.CantidadProducto) else 0 end)   cABRIL
,SUM(case when  a.idmes=5 then  (a.CantidadProducto) else 0 end)   cMAYO
,SUM(case when  a.idmes=6 then  (a.CantidadProducto) else 0 end)   cJUNIO
,SUM(case when  a.idmes=7 then  (a.CantidadProducto) else 0 end)   cJULIO
,SUM(case when  a.idmes=8 then  (a.CantidadProducto) else 0 end)   cAGOSTO
,SUM(case when  a.idmes=9 then  (a.CantidadProducto) else 0 end)   cSEPTIEMBRE
,SUM(case when  a.idmes=10 then (a.CantidadProducto) else 0 end)   cOCTUBRE
,SUM(case when  a.idmes=11 then (a.CantidadProducto) else 0 end)   cNOVIEMBRE
,SUM(case when  a.idmes=12 then (a.CantidadProducto) else 0 end)   cDICIEMBRE
,SUM(case when (a.idmes)=1 then (a.Total)  ELSE 0 end ) ENERO
,SUM(case when  a.idmes=2 then  (a.Total) else 0 end)   FEBRERO
,SUM(case when  a.idmes=3 then  (a.Total) else 0 end)   MARZO
,SUM(case when  a.idmes=4 then  (a.Total) else 0 end)   ABRIL
,SUM(case when  a.idmes=5 then  (a.Total) else 0 end)   MAYO
,SUM(case when  a.idmes=6 then  (a.Total) else 0 end)   JUNIO
,SUM(case when  a.idmes=7 then  (a.Total) else 0 end)   JULIO
,SUM(case when  a.idmes=8 then  (a.Total) else 0 end)   AGOSTO
,SUM(case when  a.idmes=9 then  (a.Total) else 0 end)   SEPTIEMBRE
,SUM(case when  a.idmes=10 then (a.Total) else 0 end)   OCTUBRE
,SUM(case when  a.idmes=11 then (a.Total) else 0 end)   NOVIEMBRE
,SUM(case when  a.idmes=12 then (a.Total) else 0 end)   DICIEMBRE
,SUM(case when a.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) then a.CantidadProducto else 0 end) CantidadProducto
,SUM(case when a.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) then a.Total else 0 end) Total

from Poa_Presupuesto a
inner join Poa_Calendario b on b.IdCalendario=a.IdCalendario
inner join Poa_Indicadores c on c.IdIndicadores=b.IdIndicadores
inner join Poa_Mir d on d.IdMir=c.IdMir and  d.AñoMir in @anio
inner join Poa_ProyectoArbol dd on dd.IdProyectoArbol=d.IdProyectoArbol
inner join Poa_Proyectos p on p.IdProyectos=dd.IdProyectos
inner join Poa_ProyectosAño p2 on p2.IdProyectos = p.IdProyectos and p2.AñoProyectos in @anio
inner join Poa_Productos e on e.IdProductos=a.IdProductos and e.Año in @anio
inner join Poa_Partidas f on f.PartidaEspecifica=e.PartidaEspecifica and f.Capitulo=e.CapituloInterno and f.Año in @anio
inner join Convenios_stConvenioLaboralTrabajadorCategoria l on l.IdConvenioLaboralTrabajadorCategoria=d.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador m on m.IdConvenioLaboralTrabajador = l.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador n on n.IdTrabajador = m.IdTrabajador
inner join Kardex_ctDatosPersonales dp on dp.IdKardex = n.IdKardex
inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica = l.IdEstructuraOrganica
inner join Catalogos_ctMes mm on mm.IdMes=a.IdMes
left join ( select IdPartidas from Poa_ComprasConsolidadas where Año in @anio group by IdPartidas) x on x.IdPartidas = f.IdPartidas
where k.EstructuraOrganica in @area
and p.Proyecto in @proyecto
group by e.IdProductos, e.Precio, k.IdEstructuraOrganica, p.IdProyectos";

        string queryUser = @"select 
max(cast(p.Numero as nvarchar(2)) + ' ' + p.Proyecto) Proyecto
,max(k.EstructuraOrganica) EstructuraOrganica
,max(dp.Nombre +' '+ dp.ApellidoPaterno+' '+dp.ApellidoMaterno) AS Usuario
,max(c.Numerador) as Actividad
,MAX(case when x.IdPartidas IS null then 'No' else 'Si' end) EsConsolidada
,max(f.Clase) Clase
,max(f.PartidaGenerica) PartidaGenerica,max(f.PartidaEspecifica) PartidaEspecifica, max(f.Partida) Partida
,max(e.UnidadMedida) UnidadMedida
,max(e.Productos) Productos
,max(a.PrecioProducto) PrecioProducto
,SUM(case when  a.idmes=1 then  (a.CantidadProducto) ELSE 0 end )  cENERO
,SUM(case when  a.idmes=2 then  (a.CantidadProducto) else 0 end)   cFEBRERO
,SUM(case when  a.idmes=3 then  (a.CantidadProducto) else 0 end)   cMARZO
,SUM(case when  a.idmes=4 then  (a.CantidadProducto) else 0 end)   cABRIL
,SUM(case when  a.idmes=5 then  (a.CantidadProducto) else 0 end)   cMAYO
,SUM(case when  a.idmes=6 then  (a.CantidadProducto) else 0 end)   cJUNIO
,SUM(case when  a.idmes=7 then  (a.CantidadProducto) else 0 end)   cJULIO
,SUM(case when  a.idmes=8 then  (a.CantidadProducto) else 0 end)   cAGOSTO
,SUM(case when  a.idmes=9 then  (a.CantidadProducto) else 0 end)   cSEPTIEMBRE
,SUM(case when  a.idmes=10 then (a.CantidadProducto) else 0 end)   cOCTUBRE
,SUM(case when  a.idmes=11 then (a.CantidadProducto) else 0 end)   cNOVIEMBRE
,SUM(case when  a.idmes=12 then (a.CantidadProducto) else 0 end)   cDICIEMBRE
,SUM(case when (a.idmes)=1 then (a.Total)  ELSE 0 end ) ENERO
,SUM(case when  a.idmes=2 then  (a.Total) else 0 end)   FEBRERO
,SUM(case when  a.idmes=3 then  (a.Total) else 0 end)   MARZO
,SUM(case when  a.idmes=4 then  (a.Total) else 0 end)   ABRIL
,SUM(case when  a.idmes=5 then  (a.Total) else 0 end)   MAYO
,SUM(case when  a.idmes=6 then  (a.Total) else 0 end)   JUNIO
,SUM(case when  a.idmes=7 then  (a.Total) else 0 end)   JULIO
,SUM(case when  a.idmes=8 then  (a.Total) else 0 end)   AGOSTO
,SUM(case when  a.idmes=9 then  (a.Total) else 0 end)   SEPTIEMBRE
,SUM(case when  a.idmes=10 then (a.Total) else 0 end)   OCTUBRE
,SUM(case when  a.idmes=11 then (a.Total) else 0 end)   NOVIEMBRE
,SUM(case when  a.idmes=12 then (a.Total) else 0 end)   DICIEMBRE
,SUM(case when a.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) then a.CantidadProducto else 0 end) CantidadProducto
,SUM(case when a.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) then a.Total else 0 end) Total

from Poa_Presupuesto a
inner join Poa_Calendario b on b.IdCalendario=a.IdCalendario
inner join Poa_Indicadores c on c.IdIndicadores=b.IdIndicadores
inner join Poa_Mir d on d.IdMir=c.IdMir and  d.AñoMir in @anio
inner join Poa_ProyectoArbol dd on dd.IdProyectoArbol=d.IdProyectoArbol
inner join Poa_Proyectos p on p.IdProyectos=dd.IdProyectos
inner join Poa_ProyectosAño p2 on p2.IdProyectos = p.IdProyectos and p2.AñoProyectos in @anio
inner join Poa_Productos e on e.IdProductos=a.IdProductos and e.Año in @anio
inner join Poa_Partidas f on f.PartidaEspecifica=e.PartidaEspecifica and f.Capitulo=e.CapituloInterno and f.Año in @anio
inner join Convenios_stConvenioLaboralTrabajadorCategoria l on l.IdConvenioLaboralTrabajadorCategoria=d.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador m on m.IdConvenioLaboralTrabajador = l.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador n on n.IdTrabajador = m.IdTrabajador
inner join Kardex_ctDatosPersonales dp on dp.IdKardex = n.IdKardex
inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica = l.IdEstructuraOrganica
inner join Catalogos_ctMes mm on mm.IdMes=a.IdMes
left join ( select IdPartidas from Poa_ComprasConsolidadas where Año in @anio  group by IdPartidas) x on x.IdPartidas = f.IdPartidas
where k.EstructuraOrganica in @area
and p.Proyecto in @proyecto
and (d.IdConvenioLaboralTrabajadorCategoria = @idusuario or c.IdConvenioLaboralTrabajadorCategoria = @idusuario or dd.IdConvenioLaboralTrabajadorCategoria = @idusuario)
group by e.IdProductos, e.Precio, k.IdEstructuraOrganica, p.IdProyectos";

        string queryResponsable = @"SELECT MAX(n.Nombre +' '+n.ApellidoPaterno +' '+n.ApellidoMaterno) NombreCompleto, MAX(EstructuraOrganica) EstructuraOrganica FROM Catalogos_ctEstructuraOrganica a
inner join Convenios_stConvenioLaboralTrabajadorCategoria b on b.IdEstructuraOrganica = a.IdEstructuraOrganica
INNER JOIN Plazas_stDistribucionPlazaCategoria f ON f.IdDistribucionPlazaCategoria = b.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria g on g.IdCategoria = f.IdCategoria
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral = g.IdRelacionConvenioLaboral and h.RelacionConvenioLaboral = 'MANDO MEDIO-CONFIANZA'
inner join Catalogos_ctRelacionLaboral j on j.IdRelacionLaboral = h.IdRelacionLaboral AND j.RelacionLaboral = 'MANDO MEDIO'
inner join Convenios_stConvenioLaboralTrabajador k on k.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador m on m.IdTrabajador = k.IdTrabajador
inner join Kardex_ctDatosPersonales n on n.IdKardex = m.IdKardex
where EstructuraOrganica  = (
select a.EstructuraOrganica from Catalogos_ctEstructuraOrganica a 
inner join (SELECT 
case when a.IdEstructuraOrganicaPadre <> 1 THEN a.IdEstructuraOrganicaPadre ELSE a.IdEstructuraOrganica end idEstructuraOrganica
FROM Catalogos_ctEstructuraOrganica a
where a.EstructuraOrganica = @areaSingle
) b on a.IdEstructuraOrganica = b.idEstructuraOrganica
) and b.FechaTermino is null";

        Int16[] anio = { };
        String[] proyecto = { };
        String[] area = { };

        // GET: PoaProductosPresupuestadosMes
        public ActionResult Index()
        {
            PoaMir rolAdmin = new PoaMir();

            if (rolAdmin.EsAdministrador())
            {
                return RedirectToAction("Admin", "PoaProductosPresupuestadosMeses");
            }
            return View();
        }

        public ActionResult Admin()
        {
            PoaMir rolAdmin = new PoaMir();
            if (!rolAdmin.EsAdministrador())
            {
                return RedirectToAction("Index", "PoaProductosPresupuestadosMeses");
            }
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"SELECT 
      AñoArbol
  FROM Poa_ProyectoArbol
  group by AñoArbol
  order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);
            ViewBag.Anios = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            string queryProyectos = @"SELECT 
       b.Numero, b.Proyecto
  FROM Poa_ProyectoArbol a
  inner join Poa_Proyectos b on a.IdProyectos = b.IdProyectos
  group by a.IdProyectos, b.Proyecto, b.Numero
  order by b.Numero";

            var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos);
            ViewBag.Proyectos = proy.Select(x => new SelectListItem()
            {
                Value = x.Proyecto,
                Text = x.Numero + " " + x.Proyecto
            });


            string queryAreas = @" select c.EstructuraOrganica 
  from Poa_ProyectoArbol a
  inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
  group by c.EstructuraOrganica";

            var areas = (List<string>)dp.connection.Query<string>(queryAreas);
            ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });


            dp.Close();



            return View();
        }

        [HttpPost]
        public ActionResult ProductosPresupuestadosMesesView(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<ProductosPresupuestadosMes> result = new List<ProductosPresupuestadosMes>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<ProductosPresupuestadosMes>)dp.connection.Query<ProductosPresupuestadosMes>(query, new { anio, proyecto, area });

            }
            else
            {
                result = (List<ProductosPresupuestadosMes>)dp.connection.Query<ProductosPresupuestadosMes>(queryUser, new { anio, proyecto, area, idusuario });
            }



            dp.Close();

            return PartialView("_ProductosPresupuestadosMeses", result);
        }

        public ActionResult ProductosPresupuestadosMeses(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<ProductosPresupuestadosMes> result = new List<ProductosPresupuestadosMes>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<ProductosPresupuestadosMes>)dp.connection.Query<ProductosPresupuestadosMes>(query, new { anio, proyecto, area });
            }
            else
            {
                result = (List<ProductosPresupuestadosMes>)dp.connection.Query<ProductosPresupuestadosMes>(queryUser, new { anio, proyecto, area, idusuario });
            }
            if (proyecto.Count() == 1 && area.Count() == 1)
            {
                //if (rolAdmin.EsAdministrador())
                //{
                    string areaSingle = area.FirstOrDefault();
                    var responsable = (List<DirectorArea>)dp.connection.Query<DirectorArea>(queryResponsable, new { areaSingle });
                    ViewBag.UsuarioU = responsable.Select(t => t.NombreCompleto).FirstOrDefault();
                    ViewBag.EstructuraP = responsable.Select(t => t.EstructuraOrganica).FirstOrDefault();
                //}
                //else
                //{
                //    var usuario = Seguridad.Identidad.Usuario();
                //    ViewBag.UsuarioU = usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + ' ' + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + ' ' + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre;
                //}
            }
            else
            {
                ViewBag.UsuarioU = "NoUser";
            }


            dp.Close();

            string modalidad = "Poa_ProductosPresupuestadosMeses" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;


            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

        }

        public ActionResult ProductosPresupuestadosMesesXls(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<ProductosPresupuestadosMes> result = new List<ProductosPresupuestadosMes>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<ProductosPresupuestadosMes>)dp.connection.Query<ProductosPresupuestadosMes>(query, new { anio, proyecto, area });

            }
            else
            {
                result = (List<ProductosPresupuestadosMes>)dp.connection.Query<ProductosPresupuestadosMes>(queryUser, new { anio, proyecto, area, idusuario });
            }



            dp.Close();


            string modalidad = "Poa_ProductosPresupuestadosMeses_" + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=" + modalidad);

            return View(result);
        }

        [HttpPost]
        public ActionResult ConsultarProyectosAnio()
        {
            int año = System.Convert.ToInt32(Request["Anio"]);
            if (año != 0 && año > 2000)
            {

            }
            else
            {
                año = db.Poa_SistemaAñoVigente.Select(s => s.Año).FirstOrDefault();
            }

            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            PoaMir rol = new PoaMir();

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"SELECT 
      AñoArbol
  FROM Poa_ProyectoArbol
  group by AñoArbol
  order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            ViewBag.Anios = new SelectList(listAños, "Value", "Text", año);




            if (rol.EsMandoMedio())//para saber si es PoaResponsable
            {
                string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE f.AñoMir = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by a.Numero, a.Proyecto
  order by a.Numero";

                var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
                ViewBag.Proyectos = proy.Select(x => new SelectListItem()
                {
                    Value = x.Proyecto,
                    Text = x.Numero + " " + x.Proyecto
                });


                string queryAreas = @" select d.EstructuraOrganica from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE f.AñoMir = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by d.EstructuraOrganica";

                var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
                ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });

            }
            else if (rol.TieneIndicadoresAsignados(año))
            {

                string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.Año = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by a.Numero, a.Proyecto";


                var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
                ViewBag.Proyectos = proy.Select(x => new SelectListItem()
                {
                    Value = x.Proyecto,
                    Text = x.Numero + " " + x.Proyecto
                });


                string queryAreas = @"select d.EstructuraOrganica from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.AñoProyectos = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by d.EstructuraOrganica";

                var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
                ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });
            }
            else
            {
                var result = "No se encuentra un elmento asociado";
                return Json(result, JsonRequestBehavior.AllowGet);
            }



            dp.Close();
            return PartialView("_FormListView");
        }

    }
}