﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Seguridad;
using Dapper;
using ExcelDataReader;
using System.Transactions;

namespace Nova.Controllers
{
    public class PoaPresupuestoFederalEstatalController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: PoaPrespuestoFederalEstatal
        public ActionResult Index()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query = @"SELECT *
  FROM Poa_PrespuestoFederalEstatal
  where Año in (Select Año from Poa_SistemaAñoVigente)";

            var result = (List<Poa_PrespuestoFederalEstatal>)dp.connection.Query<Poa_PrespuestoFederalEstatal>(query);


            return View(result);
        }

        public ActionResult PresupuestoEstatalEXls()
        {

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            //var result = db.Poa_PrespuestoFederalEstatal.Where(x => x.Año == 2019).ToList();
            string query = @"SELECT *
  FROM Poa_PrespuestoFederalEstatal
  where Año in (Select Año from Poa_SistemaAñoVigente)";

            var result = (List<Poa_PrespuestoFederalEstatal>)dp.connection.Query<Poa_PrespuestoFederalEstatal>(query);
            dp.Close();

            string nombrefile = "Poa_PresupuestoFederalEstatal" + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=" + nombrefile);

            return View(result);
        }

        public ActionResult CargarDatos(HttpPostedFileBase upload)
        {
            if (ModelState.IsValid)
            {
                if (upload != null && upload.ContentLength > 0)
                {
                    // ExcelDataReader works with the binary Excel file, so it needs a FileStream
                    // to get started. This is how we avoid dependencies on ACE or Interop:
                    System.IO.Stream stream = upload.InputStream;
                    // We return the interface, so that
                    IExcelDataReader reader = null;

                    if (upload.FileName.EndsWith(".xls"))
                    {
                        reader = ExcelReaderFactory.CreateBinaryReader(stream);
                    }
                    else if (upload.FileName.EndsWith(".xlsx"))
                    {
                        reader = ExcelReaderFactory.CreateOpenXmlReader(stream);
                    }
                    else
                    {
                        ModelState.AddModelError("File", "Formato de archivo no soportado. ");
                        return View();
                    }
                    //reader.IsFirstRowAsColumnNames = true;

                    //DataSet result = new DataSet();

                    List<Poa_PrespuestoFederalEstatal> list = new List<Poa_PrespuestoFederalEstatal>();
                    int contador = 0;
                    while (reader.Read())
                    {
                        if (contador == 0)
                            reader.Read();
                        Poa_PrespuestoFederalEstatal newlist = new Poa_PrespuestoFederalEstatal();

                        newlist.IdProyectos = System.Convert.ToInt16(reader.GetValue(0));
                        newlist.Año = System.Convert.ToInt16(reader.GetValue(1));
                        newlist.Numero = System.Convert.ToInt32(reader.GetValue(2));
                        newlist.IdConvenioLaboralTrabajadorCategoria = System.Convert.ToInt32(reader.GetValue(3));
                        newlist.Nombre = System.Convert.ToString(reader.GetValue(4));
                        newlist.ApellidoPaterno = System.Convert.ToString(reader.GetValue(5));
                        newlist.ApellidoMaterno = System.Convert.ToString(reader.GetValue(6));
                        newlist.Partida = System.Convert.ToString(reader.GetValue(7));
                        newlist.CapituloInterno = System.Convert.ToString(reader.GetValue(8));
                        newlist.TechoPresupuestal = System.Convert.ToDecimal(reader.GetValue(9));
                        newlist.PresupuestoProgramado = System.Convert.ToDecimal(reader.GetValue(10));
                        newlist.Estatal = System.Convert.ToDecimal(reader.GetValue(11));
                        newlist.Federal = System.Convert.ToDecimal(reader.GetValue(12));

                        decimal suma = newlist.Estatal + newlist.Federal;
                        if (suma > newlist.TechoPresupuestal)
                        {
                            ModelState.AddModelError("File", "La fila número " + contador + " exece el techo presupuestal");
                        }

                        list.Add(newlist);

                        contador++;
                    }
                    reader.Close();


                    try
                    {
                        TransactionOptions transactionoptions1 = new TransactionOptions();
                        transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                        using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                        {

                            //eliminar el conjunto de datos
                            Int16 anio = db.Poa_SistemaAñoVigente.Select(x => x.Año).FirstOrDefault();

                            db.Poa_PrespuestoFederalEstatal.RemoveRange(db.Poa_PrespuestoFederalEstatal.Where(x => x.Año == anio).ToList());
                            db.SaveChanges();

                            //gurdar datos en base de datos
                            db.Poa_PrespuestoFederalEstatal.AddRange(list);
                            db.SaveChanges();

                            scope.Complete();

                        }
                    }
                    catch (Exception e)
                    {
                        
                    }




                }
                else
                {
                    ModelState.AddModelError("File", "Carga un archivo xlsx o xls");
                }
            }


            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query = @"SELECT *
  FROM Poa_PrespuestoFederalEstatal
  where Año in (Select Año from Poa_SistemaAñoVigente)";

            var result = (List<Poa_PrespuestoFederalEstatal>)dp.connection.Query<Poa_PrespuestoFederalEstatal>(query);
            dp.Close();

            return View("Index", result);
            //return Json(new { success = true, oldval = true },JsonRequestBehavior.AllowGet);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
