﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Nova.Libraries;

using Dapper;
using System.Transactions;

namespace Nova.Controllers
{
    public class PoaPresupuestoController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();
        public ActionResult PivotProductos()
        {
            return View();
        }
        public JsonResult ReporteProductosMesValorCantidad()
        {
            string query = @"
                    
                        select 
                        Max(cast(h.Numero as nvarchar(3))+' '+ h.Proyecto) Proyecto
                        ,max(k.EstructuraOrganica) EstructuraOrganica
                        ,mAX(p.Nombre +' '+ p.ApellidoPaterno+' '+p.ApellidoMaterno) AS Usuario
                        ,max(case when a.EsConsolidada=0 then 'NO' else 'SÍ' end) EsConsolidada
                        ,Max(case when f.Clase = 1 then '1 Servicios Personales' else (case when f.Clase = 2 then '2 Servicios Básicos' else (case when f.Clase=3 then '3 Materiales y Servicios Específicos' else (case when f.Clase= 4 then '4 Materiales y Servicios' else (case when f.Clase = 5 then '5 Bienes Muebles, Inmuebles e Intangibles' else '' end) end) end ) end) end)  Clase
                        ,Max(e.CapituloInterno) Capitulo, Max(e.PartidaGenerica) PartidaGenerica, Max(e.PartidaEspecifica) PartidaEspecifica, MAX( e.Partida) Partida
                        ,max(e.UnidadMedida) UnidadMedida
                        ,e.Productos Producto
                        ,max(b2.Mes) Mes
                        ,a.PrecioProducto Precio
                        ,SUM(a.CantidadProducto) Cantidad
                        ,Sum(a.Total) Total
                        ,max(b2.Orden) Orden
                          ,MAX(l.ResumenNarrativo) as Componente
						,MAX(ami.año) as Año
                        from Poa_Presupuesto a
                        inner join Poa_Calendario b on b.IdCalendario = a.IdCalendario
                        inner join Catalogos_ctMes b2 on b2.IdMes = b.IdMes
                        inner join Poa_Indicadores c on c.IdIndicadores = b.IdIndicadores
                        inner join Poa_Mir d on d.IdMir = c.IdMir
                        inner join Poa_ProyectoArbol g on g.IdProyectoArbol = d.IdProyectoArbol
                        inner join Poa_Proyectos h on h.IdProyectos = g.IdProyectos
                        inner join Poa_ProyectosAño i on i.IdProyectos = h.IdProyectos 
                        inner join (select max(AñoMir) Año from Poa_Mir group by AñoMir) ami on ami.Año = d.AñoMir
                        and d.AñoMir =(select año from Poa_SistemaAñoVigente)
                        inner join Poa_Productos e on e.IdProductos = A.IdProductos
                        INNER JOIN Poa_Partidas F ON F.Partida = e.Partida and F.PartidaEspecifica = e.PartidaEspecifica and F.PartidaGenerica = e.PartidaGenerica and F.Capitulo = e.CapituloInterno
                        inner join Convenios_stConvenioLaboralTrabajadorCategoria j on j.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
                        inner join Convenios_stConvenioLaboralTrabajador m on m.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
                        inner join Kardex_ctTrabajador n on n.IdTrabajador = m.IdTrabajador
                        inner join Kardex_ctDatosPersonales p on p.IdKardex = n.IdKardex
                        inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica = j.IdEstructuraOrganica
                        left join Poa_Mir l on l.IdProyectoArbol = g.IdPadreElementoObjetivos
                        group by ami.Año,b.IdMes,H.IdProyectos, K.IdEstructuraOrganica,f.IdPartidas,e.Productos,a.PrecioProducto

                        union all
                        select 
                        Max(cast(h.Numero as nvarchar(3))+' '+ h.Proyecto) Proyecto
                        ,MAX(k.EstructuraOrganica) EstructuraOrganica
                        ,mAX(p.Nombre +' '+ p.ApellidoPaterno+' '+p.ApellidoMaterno) AS Usuario
                        ,'NO' EsConsolidada
                        ,'4 Materiales y Servicios'  Clase
                        ,'3000' Capitulo, '411' PartidaGenerica, '374' PartidaEspecifica, 'VIÁTICOS EN EL PAÍS' Partida
                        ,'NO APLICA' UnidadMedida
                        ,Producto = 'VIÁTICOS'
                        ,MAX(a2.Mes) Mes
                        ,sum(z.ImporteViaticos) Precio
                        ,SUM(z.NumeroVisitas) Cantidad
                        ,SUM(z.TotalViaticos) Total
                        ,MAX(a2.Orden)Orden
                        ,MAX(l.ResumenNarrativo) as Componente
   						,MAX(ami.año) as Año

                        from Poa_ViaticosPasajes z
                        inner join Poa_TipoPasaje z2 on z2.IdTipoPasaje = z.IdTipoPasaje
                        inner join  Poa_Calendario a on a.IdCalendario = z.IdCalendario
                        inner join Catalogos_ctMes a2 on a2.IdMes = a.IdMes
                        inner join Poa_CalendarioElemento b on a.IdCalendarioElemento=b.IdCalendarioElemento
                        inner join Poa_Indicadores c on c.IdIndicadores = a.IdIndicadores
                        inner join Poa_Mir d on d.IdMir = c.IdMir
                        inner join Poa_ProyectoArbol e on e.IdProyectoArbol = d.IdProyectoArbol
                        inner join Poa_Proyectos h on h.IdProyectos = e.IdProyectos
                        inner join Poa_ProyectosAño i on i.IdProyectos = h.IdProyectos
                        inner join (select max(AñoMir) Año from Poa_Mir group by AñoMir) ami on ami.Año = d.AñoMir
                        inner join Convenios_stConvenioLaboralTrabajadorCategoria j on j.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
                        inner join Convenios_stConvenioLaboralTrabajador m on m.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
                        inner join Kardex_ctTrabajador n on n.IdTrabajador = m.IdTrabajador
                        inner join Kardex_ctDatosPersonales p on p.IdKardex = n.IdKardex
                        inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica = j.IdEstructuraOrganica
                        left join Poa_Mir l on l.IdProyectoArbol = e.IdPadreElementoObjetivos

                        group by ami.Año,a.IdMes,H.IdProyectos, K.IdEstructuraOrganica

                        union all
                        select 
                        Max(cast(h.Numero as nvarchar(3))+' '+ h.Proyecto) Proyecto
                        ,MAX(k.EstructuraOrganica) EstructuraOrganica
                        ,mAX(p.Nombre +' '+ p.ApellidoPaterno+' '+p.ApellidoMaterno) AS Usuario
                        ,'NO' EsConsolidada
                        ,'4 Materiales y Servicios'  Clase
                        ,case when z2.TipoPasaje = 'Avión' then '3000' else '300' end Capitulo
                        ,case when z2.TipoPasaje = 'Avión' then '411' else '411' end PartidaGenerica
                        ,case when z2.TipoPasaje = 'Avión' then '369' else '370' end PartidaEspecifica
                        ,case when z2.TipoPasaje = 'Avión' then 'PASAJES AÉREOS' else 'PASAJES TERRESTRES' end Partida
                        ,'NO APLICA' UnidadMedida
                        ,case when z2.TipoPasaje = 'Avión' then 'PASAJE AÉREO' else 'PASAJE TERRESTRE' end Producto
                        ,MAX(a2.Mes) Mes

                        ,sum(z.ViajeRedondoPersona) Precio
                        ,SUM(z.NumeroVisitas) Cantidad
                        ,SUM(z.TotalPasaje) Total
                        ,MAX(a2.Orden) Orden
                        ,MAX(l.ResumenNarrativo) as Componente
  						,MAX(ami.año) as Año
                        from Poa_ViaticosPasajes z
                        inner join Poa_TipoPasaje z2 on z2.IdTipoPasaje = z.IdTipoPasaje
                        inner join  Poa_Calendario a on a.IdCalendario = z.IdCalendario
                        inner join Catalogos_ctMes a2 on a2.IdMes = a.IdMes
                        inner join Poa_CalendarioElemento b on a.IdCalendarioElemento=b.IdCalendarioElemento
                        inner join Poa_Indicadores c on c.IdIndicadores = a.IdIndicadores
                        inner join Poa_Mir d on d.IdMir = c.IdMir
                        inner join (select max(AñoMir) Año from Poa_Mir group by AñoMir) ami on ami.Año = d.AñoMir
                        inner join Poa_ProyectoArbol e on e.IdProyectoArbol = d.IdProyectoArbol
                        inner join Poa_Proyectos h on h.IdProyectos = e.IdProyectos
                        inner join Poa_ProyectosAño i on i.IdProyectos = h.IdProyectos
                        inner join Convenios_stConvenioLaboralTrabajadorCategoria j on j.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
                        inner join Convenios_stConvenioLaboralTrabajador m on m.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
                        inner join Kardex_ctTrabajador n on n.IdTrabajador = m.IdTrabajador
                        inner join Kardex_ctDatosPersonales p on p.IdKardex = n.IdKardex
                        inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica = j.IdEstructuraOrganica
                        left join Poa_Mir l on l.IdProyectoArbol = e.IdPadreElementoObjetivos
                        where z2.TipoPasaje <> 'Vehículo oficial'
                        group by ami.Año,a.IdMes,h.IdProyectos, k.IdEstructuraOrganica, z2.TipoPasaje
                             ";
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var result = (List<ProductoMesValorCantidad>)dp.connection.Query<ProductoMesValorCantidad>(query);
            return Json(result, JsonRequestBehavior.AllowGet);
        }

        // GET: PoaPresupuesto
        public ActionResult Iniciar(int id, short idmes)
        {


            return View();
        }
        public ActionResult Index(int id, short idmes)
        {
            Session["IdIndicador"] = id;
            Session["IdMes"] = idmes;

            ViewBag.confirmarCerrarProceso = false;

            var Indicador = db.Poa_Indicadores.Where(s => s.IdIndicadores == id).FirstOrDefault();

            //var totalregistrosporIndicador = db.Poa_Calendario.Where(s => s.IdIndicadores == id && s.Poa_CalendarioElemento.CalendarioElemento=="Presupuesto").ToList();
            //switch (Indicador.Poa_FrecuenciaMedicionIndicador.FrecuenciaMedicion)
            //{
            //    case "Mensual":
            //        if (totalregistrosporIndicador.Count == 11)
            //            ViewBag.confirmarCerrarProceso = true;
            //        break;
            //    case "Bimestral":
            //        if (totalregistrosporIndicador.Count == 11)
            //            ViewBag.confirmarCerrarProceso = true;
            //        break;
            //    case "Trimestral":
            //        if (totalregistrosporIndicador.Count == 11)
            //            ViewBag.confirmarCerrarProceso = true;
            //        break;
            //    case "Semestral":
            //        if (totalregistrosporIndicador.Count ==11)
            //            ViewBag.confirmarCerrarProceso = true;
            //        break;
            //    case "Anual":
            //        if (totalregistrosporIndicador.Count == 11)
            //            ViewBag.confirmarCerrarProceso = true;
            //        break;
            //}

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query, query1, query2;
            query1 = @"select a.IdComprasConsolidadas,a.IdMes,b.Mes,c.PartidaEspecifica from Poa_ComprasConsolidadas a
inner join Poa_Partidas c on c.IdPartidas=a.IdPartidas
                    inner join Catalogos_ctMes b on a.idmes = b.idmes
                    where a.año=(select año from dbo.Poa_SistemaAñoVigente)";
            ViewBag.PartidasConsolidadas = (List<PartidasConsolidadas>)dp.connection.Query<PartidasConsolidadas>(query1);
            dp.Close();

            //query = @"select a.IdProductos,a.Precio,a.Productos as Producto, EsConsolidada = case when b.idcomprasconsolidadas is null then 0 else 1 end, a.partida from Poa_Productos a
            //        left join  Poa_ComprasConsolidadas b on a.partida = b.partida 
            //        where a.año = (select año from dbo.Poa_SistemaAñoVigente)";

            query = @" select a.IdProductos,a.Precio,a.Productos as Producto, EsConsolidada = case when q.IdPartidas is null then 0 else 1 end, Partida,a.PartidaEspecifica 
                        from Poa_Productos a


                     left join (

                     select distinct a.IdPartidas,b.PartidaEspecifica from Poa_ComprasConsolidadas a
					inner join Poa_Partidas b on a.IdPartidas = b.IdPartidas where b.Año =(select año from dbo.Poa_SistemaAñoVigente)
	) q
                   on   q.PartidaEspecifica = a.PartidaEspecifica


                    where a.año = (select año from dbo.Poa_SistemaAñoVigente)";
            ViewBag.Productos = (List<Nova.Models.Productos>)dp.connection.Query<Nova.Models.Productos>(query);

            dp.Close();
            // obtiene el presupuesto del área responsable asi como el proyecto y el año del indicador y el área responsable
            query2 = @"select  b.IdConvenioLaboralTrabajadorCategoria,h.IdProyectos,h.Proyecto, f.AñoMir as Año,h.Numero, b.Indicador,i.IdEstructuraOrganica
                    ,n.Presupuesto
                    ,l.Nombre+' '+l.ApellidoPaterno+' '+l.ApellidoMaterno as NombreUsuario,m.IdProyectosAño
                    from Poa_Indicadores b
                    inner join Poa_Mir f on b.IdMir = f.IdMir
                    inner join Poa_ProyectoArbol g on f.IdProyectoArbol = g.IdProyectoArbol
                    inner join Poa_Proyectos h on g.IdProyectos=h.IdProyectos
                    inner join Convenios_stConvenioLaboralTrabajadorCategoria i on g.IdConvenioLaboralTrabajadorCategoria=i.IdConvenioLaboralTrabajadorCategoria
                    inner join Convenios_stConvenioLaboralTrabajador j on i.IdConvenioLaboralTrabajador=j.IdConvenioLaboralTrabajador
                    inner join Kardex_ctTrabajador k on j.IdTrabajador=k.IdTrabajador
                    inner join vwKardex_ctDatosPersonales l on k.IdKardex= l.IdKardex
                    inner join Poa_ProyectosAño m on g.IdProyectos=m.IdProyectos and m.AñoProyectos = f.AñoMir
                    inner join Poa_ProyectosAñoAreaPresupuesto n on m.IdProyectosAño=n.IdProyectosAño and i.IdEstructuraOrganica=n.IdEstructuraOrganica
                    where b.idindicadores =" + id + " and f.añoMir=(select año from dbo.Poa_SistemaAñoVigente) ";
            var PresupuestoArea = (List<PresupuestoIndicador>)dp.connection.Query<PresupuestoIndicador>(query2);
            dp.Close();
            if (PresupuestoArea != null)
            {
                foreach (var item in PresupuestoArea)
                {
                    ViewBag.Numero = item.Numero;
                    ViewBag.Año = item.Año;
                    if (item.Indicador == null)
                        ViewBag.Indicador = "";
                    else
                        ViewBag.Indicador = item.Indicador;
                }

            }
            else
            {
                throw new Exception("No existe techo presupuestal para el área responsable");
            }

            return View();
        }
        public ActionResult PresupuestoIndicador(int idindicador, short idmes)
        {
            // short idmes = System.Convert.ToByte(Session["IdMes"]);
//            DapperQuery dp = new DapperQuery("bdNovaEntities");
            var añovigente = db.Poa_SistemaAñoVigente.FirstOrDefault().Año;
           // var idproyecto = db.Poa_ProyectosAño.Where(x=>x.Poa_Proyectos.Poa_ProyectoArbol.).FirstOrDefault().Año;

            var Indicador= db.Poa_Indicadores.Where(s => s.IdIndicadores == idindicador).FirstOrDefault();
            

            Session["idestructuraorganica"] = Indicador.Poa_Mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica;
            var poa_Presupuesto = db.Poa_Presupuesto
                .Where(p => p.Poa_Calendario.Poa_Indicadores.IdIndicadores == idindicador && p.Poa_Calendario.Poa_CalendarioElemento.CalendarioElemento == "Presupuesto" && (p.IdMes == idmes || p.EsConsolidada == true));

            var poa_Presupuestoarea = db.Poa_Calendario
    .Where(p => p.Poa_Indicadores.Poa_Mir.AñoMir==Indicador.Poa_Mir.AñoMir &&  p.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.IdProyectos == Indicador.Poa_Mir.Poa_ProyectoArbol.IdProyectos && p.Poa_Indicadores.Poa_Mir.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica == Indicador.Poa_Mir.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica
&& (p.Poa_CalendarioElemento.CalendarioElemento == "Presupuesto" || p.Poa_CalendarioElemento.CalendarioElemento == "Viáticos y pasajes"));

             
            decimal poa_PresupuestoareaIndicador = 0;
 //           var poa_PresupuestoareaIndicadorlista = db.Poa_Presupuesto
 //.Where(p => p.Poa_Calendario.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica == Indicador.Poa_Mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica
 //&& p.Poa_Calendario.Poa_CalendarioElemento.CalendarioElemento == "Presupuesto"   && p.Poa_Calendario.IdIndicadores==Indicador.IdIndicadores && p.IdMes==idmes).ToList();

            var poa_PresupuestoareaIndicadorlista = db.Poa_Presupuesto
.Where(p => p.Poa_Calendario.IdIndicadores == Indicador.IdIndicadores && p.IdMes == idmes).ToList();


            if (poa_PresupuestoareaIndicadorlista!=null)
                poa_PresupuestoareaIndicador= poa_PresupuestoareaIndicadorlista.Sum(g => g.Total);
            decimal TechoPresupuestal = 0M;
            var TechoPreup = db.Poa_ProyectosAñoAreaPresupuesto.Where(z => z.IdEstructuraOrganica == Indicador.Poa_Mir.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica 
                && z.Poa_ProyectosAño.IdProyectos==Indicador.Poa_Mir.Poa_ProyectoArbol.IdProyectos && z.Poa_ProyectosAño.AñoProyectos== Indicador.Poa_Mir.Poa_ProyectoArbol.AñoArbol);
            foreach (var item in TechoPreup)
            {
                TechoPresupuestal = TechoPresupuestal+item.Presupuesto;
            }
            if (TechoPresupuestal == 0)
            {
                throw new ApplicationException("Estimado usuario , aún el administrador del sistema no ha asignado el presupuesto para su área, favor de intentarlo más tarde.");
            }
            ViewBag.TotalPresupuestadoIndicador = poa_PresupuestoareaIndicador;
            decimal totalpresupuestado = 0M;
            foreach (var item in poa_Presupuestoarea)
            {
                totalpresupuestado += item.Valor;
            }
            ViewBag.TotalPresupuestado = totalpresupuestado;
            ViewBag.TechoPresaupuestal = TechoPresupuestal;
            //try
            //{
            //    ViewBag.TechoPresaupuestal = TechoPresaupuestal;
            //     //ViewBag.TechoPresaupuestal = db.Poa_ProyectosAñoAreaPresupuesto.Where(z => z.IdEstructuraOrganica == idestructuraorganica && z.Poa_ProyectosAño.Año == añovigente).FirstOrDefault().Presupuesto;
            //}
            //catch (Exception e)
            //{
            //    throw new ApplicationException("Estimado usuario , aún el administrador del sistema no ha asignado el presupuesto para su área, favor de intentarlo más tarde.");

            //}
            ViewBag.Disponible = TechoPresupuestal - totalpresupuestado;

            var idcalendario = db.Poa_Calendario.Where(z => z.IdIndicadores == idindicador && z.IdMes == idmes && z.Poa_CalendarioElemento.CalendarioElemento == "Presupuesto").FirstOrDefault();
            if (idcalendario == null)
            {
                ViewBag.IdCalendario = 0;
            }
            else
            {
                ViewBag.IdCalendario = idcalendario.IdCalendario;
            }
            return PartialView("vpPresupuestoIndicador", poa_Presupuesto.ToList());

        }


        // GET: PoaPresupuesto/Create
        public ActionResult Create()
        {
            ViewBag.IdMes = new SelectList(db.Catalogos_ctMes, "IdMes", "Mes");
            ViewBag.IdProductos = new SelectList(db.Poa_Productos, "IdProductos", "CapituloInterno");
            ViewBag.IdCalendario = new SelectList(db.Poa_Calendario, "IdCalendario", "Observacion");
            return View();
        }

        // POST: PoaPresupuesto/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdPresupuesto,CantidadProducto,IdMes,IdCalendario,IdProductos,PrecioProducto,Total,EsConsolidada")] Poa_Presupuesto poa_Presupuesto)
        {
            if (poa_Presupuesto.CantidadProducto == 0)
            {
                return Json(new { Valid = false, Message = "El campo de cantidad de producto es requerido" });

            }
            int idacalendario = poa_Presupuesto.IdCalendario;
            short idmes = poa_Presupuesto.IdMes;
            if (idmes == 0)
            {
                return Json(new { Valid = false, Message = "El campo de mes es requerido" });

            }
            int idindicador = System.Convert.ToInt32(Session["IdIndicador"]);

            var Indicador = db.Poa_Indicadores.Find(idindicador);
            short idestructuraorganica = System.Convert.ToInt16(Session["idestructuraorganica"]);
            var añovigente = db.Poa_SistemaAñoVigente.FirstOrDefault().Año;

            decimal disponible = 0M;
            decimal TechoPresaupuestal = 0M;
            poa_Presupuesto.Total = poa_Presupuesto.CantidadProducto * poa_Presupuesto.PrecioProducto;

            //TechoPresaupuestal = db.Poa_ProyectosAñoAreaPresupuesto.Where(z => z.IdEstructuraOrganica == idestructuraorganica && z.Poa_ProyectosAño.Año == añovigente).FirstOrDefault().Presupuesto;
            try
            {
                //TechoPresaupuestal = db.Poa_ProyectosAñoAreaPresupuesto.Where(z => z.Poa_ProyectosAño.IdProyectos == poaindicador.Poa_Mir.Poa_ProyectoArbol.IdProyectos && z.IdEstructuraOrganica == poaindicador.Poa_Mir.Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica && z.Poa_ProyectosAño.Año == añovigente).FirstOrDefault().Presupuesto;
                // TechoPresaupuestal = db.Poa_ProyectosAñoAreaPresupuesto.Where(z => z.Poa_ProyectosAño.AñoProyectos==Indicador.Poa_Mir.AñoMir && z.IdEstructuraOrganica == Indicador.Poa_Mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica
                //&& z.Poa_ProyectosAño.IdProyectos == Indicador.Poa_Mir.Poa_ProyectoArbol.IdProyectos && z.Poa_ProyectosAño.AñoProyectos== Indicador.Poa_Mir.Poa_ProyectoArbol.AñoArbol).Sum(s => s.Presupuesto);
                TechoPresaupuestal = db.Poa_ProyectosAñoAreaPresupuesto.Where(z => z.Poa_ProyectosAño.AñoProyectos == Indicador.Poa_Mir.AñoMir && z.IdEstructuraOrganica == Indicador.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica
                    && z.Poa_ProyectosAño.IdProyectos == Indicador.Poa_Mir.Poa_ProyectoArbol.IdProyectos && z.Poa_ProyectosAño.AñoProyectos == Indicador.Poa_Mir.Poa_ProyectoArbol.AñoArbol).Sum(s => s.Presupuesto);

                ViewBag.TechoPresaupuestal =TechoPresaupuestal ;
            }
            catch (Exception e)
            {
                throw new ApplicationException("Estimado usuario , aún el administrador del sistema no ha asignado el presupuesto para su área, favor de intentarlo más tarde.");

            }
            //var presupuestado = db.Poa_Presupuesto
            //    .Where(p => p.Poa_Calendario.Poa_Indicadores.IdIndicadores == idindicador && p.Poa_Productos.Año == añovigente && p.Poa_Calendario.Poa_CalendarioElemento.CalendarioElemento == "Presupuesto");

            var presupuestado = db.Poa_Calendario
    .Where(p => p.Poa_Indicadores.Poa_Mir.AñoMir==Indicador.Poa_Mir.AñoMir &&  p.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.IdProyectos == Indicador.Poa_Mir.Poa_ProyectoArbol.IdProyectos && p.Poa_Indicadores.Poa_Mir.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica == Indicador.Poa_Mir.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica
&& (p.Poa_CalendarioElemento.CalendarioElemento == "Presupuesto" || p.Poa_CalendarioElemento.CalendarioElemento == "Viáticos y pasajes"));

            decimal totalpresupuestado = 0M;
            foreach (var item in presupuestado)
            {
                totalpresupuestado += item.Valor;
            }

            disponible = TechoPresaupuestal - totalpresupuestado;
            if ((disponible - poa_Presupuesto.Total) < 0)
            {
                return Json(new { Valid = false, Message = "No hay suficiente techo presupuestal" });
            }
            if (idmes == 77)
            {
                idmes = System.Convert.ToInt16(Session["IdMes"]);
            }

            var presupuestoindicadormes = db.Poa_Presupuesto
                      .Where(p => p.Poa_Calendario.Poa_Indicadores.IdIndicadores == idindicador && p.IdMes == idmes);
            decimal presupuestadomes = 0M;
            foreach (var item in presupuestoindicadormes)
            {
                presupuestadomes += item.Total;
            }

            TransactionOptions transactionoptions1 = new TransactionOptions();
            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
            {

                if (idacalendario == 0)
                {
                    Poa_Calendario poac = new Poa_Calendario();
                    poac.IdCalendarioElemento = db.Poa_CalendarioElemento.Where(d => d.CalendarioElemento == "Presupuesto").FirstOrDefault().IdCalendarioElemento;
                    poac.IdIndicadores = idindicador;
                    poac.IdMes = idmes;
                    poac.Valor = 0;
                   


                    try
                    {
                        //if (calendarioexistente != null)
                        //{
                        //    Poa_Calendario editar = db.Poa_Calendario.Find(calendarioexistente.IdCalendario);
                        //    editar.Valor = editar.Valor + poa_Presupuesto.Total;

                        //    db.Entry(editar).State = System.Data.Entity.EntityState.Modified;
                        //    idacalendario = editar.IdCalendario;
                        //    db.SaveChanges();

                        //}
                        //else
                        //{
                        poac.Valor = poa_Presupuesto.Total;
                        db.Poa_Calendario.Add(poac);
                        db.SaveChanges();
                        idacalendario = poac.IdCalendario;
                        //}



                    }
                    catch (Exception e)
                    {
                        string msj = ExceptionExtensions.GetOriginalException(e).Message;
                        if (msj.IndexOf("UK_") > -1)
                        {

                        }
                        return Json(new
                        {
                            Valid = false,
                            Message = msj
                        });

                    }

                    //db.SaveChanges();
                }
                else {
                    //msj = "Ya ha agregado ese producto a la lista";
                    //Poa_Calendario calendarioexistente = db.Poa_Calendario.Where(r => r.Poa_CalendarioElemento.CalendarioElemento== "Presupuesto" && r.IdMes == idmes && r.IdIndicadores == idindicador).FirstOrDefault();

                    Poa_Calendario editar = db.Poa_Calendario.Find(idacalendario);
                    editar.Valor = editar.Valor+ poa_Presupuesto.Total;

                    db.Entry(editar).State = System.Data.Entity.EntityState.Modified;
                    //idacalendario = editar.IdCalendario;
                    db.SaveChanges();
                }

                poa_Presupuesto.IdCalendario = idacalendario;
                poa_Presupuesto.IdMes = idmes;

                if (ModelState.IsValid)
                {
                    db.Poa_Presupuesto.Add(poa_Presupuesto);
                    try
                    {

                        db.SaveChanges();
 

                    }
                    catch (Exception e)
                    {



                        string msj = ExceptionExtensions.GetOriginalException(e).Message;
                        if (msj.IndexOf("UK_") > -1)
                        {
                            msj = "Ya ha agregado ese producto a la lista";
                        }
                        return Json(new
                        {
                            Valid = false,
                            Message = msj
                        });
                    }

                }
                else
                {
                    return Json(new
                    {
                        Valid = false,
                        Message = ModelState.Values.SelectMany(m => m.Errors)
.Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j)
                    });

                }
                scope.Complete();
                return JsonView(true, "Se ha agregado el producto exitosamente",null,null,null, poa_Presupuesto.IdCalendario.ToString());

            }

        }

        // GET: PoaPresupuesto/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Presupuesto poa_Presupuesto = db.Poa_Presupuesto.Find(id);
            if (poa_Presupuesto == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdMes = new SelectList(db.Catalogos_ctMes, "IdMes", "Mes", poa_Presupuesto.IdMes);
            ViewBag.IdProductos = new SelectList(db.Poa_Productos, "IdProductos", "CapituloInterno", poa_Presupuesto.IdProductos);
            ViewBag.IdCalendario = new SelectList(db.Poa_Calendario, "IdCalendario", "Observacion", poa_Presupuesto.IdCalendario);
            return View(poa_Presupuesto);
        }

        // POST: PoaPresupuesto/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdPresupuesto,CantidadProducto,IdMes,IdCalendario,IdProductos,PrecioProducto,Total")] Poa_Presupuesto poa_Presupuesto)
        {
            if (ModelState.IsValid)
            {
                db.Entry(poa_Presupuesto).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdMes = new SelectList(db.Catalogos_ctMes, "IdMes", "Mes", poa_Presupuesto.IdMes);
            ViewBag.IdProductos = new SelectList(db.Poa_Productos, "IdProductos", "CapituloInterno", poa_Presupuesto.IdProductos);
            ViewBag.IdCalendario = new SelectList(db.Poa_Calendario, "IdCalendario", "Observacion", poa_Presupuesto.IdCalendario);
            return View(poa_Presupuesto);
        }

        // GET: PoaPresupuesto/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Presupuesto poa_Presupuesto = db.Poa_Presupuesto.Find(id);
            if (poa_Presupuesto == null)
            {
                return HttpNotFound();
            }
            return View(poa_Presupuesto);
        }

        // POST: PoaPresupuesto/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Poa_Presupuesto Presupuesto = db.Poa_Presupuesto.Find(id);
            string idpresupuesto = Presupuesto.Poa_Calendario.IdIndicadores.ToString() + "|" + Presupuesto.IdMes;

            //Poa_Presupuesto poa_Presupuesto = db.Poa_Presupuesto.Where(i => i.IdPresupuesto == id).Include("Poa_Calendario").FirstOrDefault();
            Poa_Presupuesto poa_Presupuesto = db.Poa_Presupuesto.Find(id);


            TransactionOptions transactionoptions1 = new TransactionOptions();
            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
            {
                ////se actualiza el prespuesto para el area
                //var TechoPresaupuestal = db.Poa_ProyectosAñoAreaPresupuesto.Where(z => z.IdEstructuraOrganica == poa_Presupuesto.Poa_Calendario.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Convenios_stConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica
                //   && z.Poa_ProyectosAño.IdProyectos == poa_Presupuesto.Poa_Calendario.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.IdProyectos && z.Poa_ProyectosAño.Año == poa_Presupuesto.Poa_Calendario.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Año).FirstOrDefault();
                //TechoPresaupuestal.Presupuesto = TechoPresaupuestal.Presupuesto + poa_Presupuesto.Total;
                //db.Entry(TechoPresaupuestal).State = System.Data.Entity.EntityState.Modified;
                //db.SaveChanges();


                try
                {

                    //db.Poa_Presupuesto.Remove(poa_Presupuesto);
                    //db.SaveChanges();

                    //int registrosprepsupuestocalendario = db.Poa_Presupuesto.Where(r => r.Poa_Calendario.Poa_CalendarioElemento.CalendarioElemento== "Presupuesto" && r.IdCalendario == poa_Presupuesto.IdCalendario && r.IdMes == poa_Presupuesto.IdMes).Count();

                    //if (registrosprepsupuestocalendario == 0)
                    //{
                    //    var poa_calendario = db.Poa_Calendario.Find(poa_Presupuesto.IdCalendario);

                    //    db.Poa_Calendario.Remove(poa_calendario);
                    //    db.SaveChanges();
                    //}
                    //else
                    //{
                    //    var poa_calendario = db.Poa_Calendario.Find(poa_Presupuesto.IdCalendario);
                    //    poa_calendario.Valor = poa_calendario.Valor - poa_Presupuesto.Total;
                    //    db.Entry(poa_calendario).State = System.Data.Entity.EntityState.Modified;
                    //    db.SaveChanges();
                    //}
                    db.Poa_Presupuesto.Remove(poa_Presupuesto);
                    db.SaveChanges();

                    Poa_Calendario poaCalendario = db.Poa_Calendario.Find(poa_Presupuesto.IdCalendario);
                    poaCalendario.Valor = poaCalendario.Valor - poa_Presupuesto.Total;
                    db.Entry(poaCalendario).State = System.Data.Entity.EntityState.Modified;
                    db.SaveChanges();




                    scope.Complete();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
            }

            return JsonView(ModelState.IsValid, "Se ha eliminado el registro exitosamente", null, null, null, idpresupuesto);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
