﻿using Dapper;
using Nova.Libraries;
using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Rotativa;


namespace Nova.Controllers.Poa.Presupuesto
{
    public class PoaPresupuestoClaseReporteController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        string query = @"
select mAX(p.Nombre +' '+ p.ApellidoPaterno+' '+p.ApellidoMaterno) AS Usuario
,Max(h.Numero) Numero, Max(h.Proyecto) Proyecto
,Max(e.CapituloInterno) Capitulo, Max(e.PartidaGenerica) PartidaGenerica, Max(e.PartidaEspecifica) PartidaEspecifica, MAX( e.Partida) Partida
,Max(case when f.Clase = 1 then '1 Servicios Personales' else (case when f.Clase = 2 then '2 Servicios Básicos' else (case when f.Clase=3 then '3 Materiales y Servicios Específicos' else (case when f.Clase= 4 then '4 Materiales y Servicios' else (case when f.Clase = 5 then '5 Bienes Muebles, Inmuebles e Intangibles' else '' end) end) end ) end) end)  Clase
,sum(case when a.idmes=1  then a.Total else 0 end) ENERO
,sum(case when a.idmes=2  then a.Total else 0 end) FEBRERO
,sum(case when a.idmes=3  then a.Total else 0 end) MARZO
,sum(case when a.idmes=4  then a.Total else 0 end) ABRIL
,sum(case when a.idmes=5  then a.Total else 0 end) MAYO
,sum(case when a.idmes=6  then a.Total else 0 end) JUNIO
,sum(case when a.idmes=7  then a.Total else 0 end) JULIO
,sum(case when a.idmes=8  then a.Total else 0 end) AGOSTO
,sum(case when a.idmes=9  then a.Total else 0 end) SEPTIEMBRE
,sum(case when a.idmes=10 then a.Total else 0 end) OCTUBRE
,sum(case when a.idmes=11 then a.Total else 0 end) NOVIEMBRE
,sum(case when a.idmes=12 then a.Total else 0 end) DICIEMBRE
,Sum(a.Total) Total, Clasificacion = 'productos'
 from Poa_Presupuesto a
inner join Poa_Calendario b on b.IdCalendario = a.IdCalendario
inner join Poa_Indicadores c on c.IdIndicadores = b.IdIndicadores
inner join Poa_Mir d on d.IdMir = c.IdMir and d.AñoMir IN @anio
inner join Poa_ProyectoArbol g on g.IdProyectoArbol = d.IdProyectoArbol
inner join Poa_Proyectos h on h.IdProyectos = g.IdProyectos
inner join Poa_ProyectosAño i on i.IdProyectos = h.IdProyectos and i.AñoProyectos IN @anio
inner join Poa_Productos e on e.IdProductos = A.IdProductos and e.Año IN @anio
INNER JOIN Poa_Partidas f ON f.PartidaEspecifica = e.PartidaEspecifica  and f.Capitulo=e.CapituloInterno and f.Año IN @anio
inner join Convenios_stConvenioLaboralTrabajadorCategoria j on j.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador m on m.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador n on n.IdTrabajador = m.IdTrabajador
inner join Kardex_ctDatosPersonales p on p.IdKardex = n.IdKardex
inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica = j.IdEstructuraOrganica
where h.Proyecto in @proyecto
and k.EstructuraOrganica in @area
group by H.IdProyectos, K.IdEstructuraOrganica ,F.IdPartidas, F.Clase
union all
select mAX(p.Nombre +' '+ p.ApellidoPaterno+' '+p.ApellidoMaterno) AS Usuario
,Max(h.Numero) Numero, Max(h.Proyecto) Proyecto
,'3000' Capitulo, '411' PartidaGenerica, '374' PartidaEspecifica, 'VIÁTICOS EN EL PAÍS' Partida
,'4 Materiales y Servicios'  Clase
,SUM(case when  a.idmes=1 then  (z.TotalViaticos) ELSE 0 end)   ENERO
,SUM(case when  a.idmes=2 then  (z.TotalViaticos) else 0 end)   FEBRERO
,SUM(case when  a.idmes=3 then  (z.TotalViaticos) else 0 end)   MARZO
,SUM(case when  a.idmes=4 then  (z.TotalViaticos) else 0 end)   ABRIL
,SUM(case when  a.idmes=5 then  (z.TotalViaticos) else 0 end)   MAYO
,SUM(case when  a.idmes=6 then  (z.TotalViaticos) else 0 end)   JUNIO
,SUM(case when  a.idmes=7 then  (z.TotalViaticos) else 0 end)   JULIO
,SUM(case when  a.idmes=8 then  (z.TotalViaticos) else 0 end)   AGOSTO
,SUM(case when  a.idmes=9 then  (z.TotalViaticos) else 0 end)   SEPTIEMBRE
,SUM(case when  a.idmes=10 then (z.TotalViaticos) else 0 end)   OCTUBRE
,SUM(case when  a.idmes=11 then (z.TotalViaticos) else 0 end)   NOVIEMBRE
,SUM(case when  a.idmes=12 then (z.TotalViaticos) else 0 end)   DICIEMBRE
,SUM(case when a.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) then z.TotalViaticos else 0 end) Total
,Clasificacion = 'viáticos'
from Poa_ViaticosPasajes z
inner join Poa_TipoPasaje z2 on z2.IdTipoPasaje = z.IdTipoPasaje
inner join  Poa_Calendario a on a.IdCalendario = z.IdCalendario
inner join Poa_CalendarioElemento b on a.IdCalendarioElemento=b.IdCalendarioElemento
inner join Poa_Indicadores c on c.IdIndicadores = a.IdIndicadores
inner join Poa_Mir d on d.IdMir = c.IdMir and d.AñoMir IN @anio
inner join Poa_ProyectoArbol e on e.IdProyectoArbol = d.IdProyectoArbol
inner join Poa_Proyectos h on h.IdProyectos = e.IdProyectos
inner join Poa_ProyectosAño i on i.IdProyectos = h.IdProyectos and i.AñoProyectos IN @anio
inner join Convenios_stConvenioLaboralTrabajadorCategoria j on j.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador m on m.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador n on n.IdTrabajador = m.IdTrabajador
inner join Kardex_ctDatosPersonales p on p.IdKardex = n.IdKardex
inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica = j.IdEstructuraOrganica
where h.Proyecto in @proyecto
and k.EstructuraOrganica in @area
group by h.IdProyectos, k.IdEstructuraOrganica
union all
select mAX(p.Nombre +' '+ p.ApellidoPaterno+' '+p.ApellidoMaterno) AS Usuario
,Max(h.Numero) Numero, Max(h.Proyecto) Proyecto
,case when z2.TipoPasaje = 'Avión' then '3000' else '300' end Capitulo
,case when z2.TipoPasaje = 'Avión' then '411' else '411' end PartidaGenerica
,case when z2.TipoPasaje = 'Avión' then '369' else '370' end PartidaEspecifica
,case when z2.TipoPasaje = 'Avión' then 'PASAJES AÉREOS' else 'PASAJES TERRESTRES' end Partida
,'4 Materiales y Servicios'  Clase
,SUM(case when  a.idmes=1 then  (z.TotalPasaje) ELSE 0 end)  ENERO
,SUM(case when  a.idmes=2 then  (z.TotalPasaje) else 0 end)  FEBRERO
,SUM(case when  a.idmes=3 then  (z.TotalPasaje) else 0 end)   MARZO
,SUM(case when  a.idmes=4 then  (z.TotalPasaje) else 0 end)   ABRIL
,SUM(case when  a.idmes=5 then  (z.TotalPasaje) else 0 end)   MAYO
,SUM(case when  a.idmes=6 then  (z.TotalPasaje) else 0 end)   JUNIO
,SUM(case when  a.idmes=7 then  (z.TotalPasaje) else 0 end)   JULIO
,SUM(case when  a.idmes=8 then  (z.TotalPasaje) else 0 end)   AGOSTO
,SUM(case when  a.idmes=9 then  (z.TotalPasaje) else 0 end)   SEPTIEMBRE
,SUM(case when  a.idmes=10 then (z.TotalPasaje) else 0 end)   OCTUBRE
,SUM(case when  a.idmes=11 then (z.TotalPasaje) else 0 end)   NOVIEMBRE
,SUM(case when  a.idmes=12 then (z.TotalPasaje) else 0 end)  DICIEMBRE
,SUM(case when a.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) then z.TotalPasaje else 0 end) Total
,case when z2.TipoPasaje in ('Avión') then 'aereo' else 'terrestre' end Clasificacion
from Poa_ViaticosPasajes z
inner join Poa_TipoPasaje z2 on z2.IdTipoPasaje = z.IdTipoPasaje
inner join  Poa_Calendario a on a.IdCalendario = z.IdCalendario
inner join Poa_CalendarioElemento b on a.IdCalendarioElemento=b.IdCalendarioElemento
inner join Poa_Indicadores c on c.IdIndicadores = a.IdIndicadores
inner join Poa_Mir d on d.IdMir = c.IdMir and d.AñoMir IN @anio
inner join Poa_ProyectoArbol e on e.IdProyectoArbol = d.IdProyectoArbol
inner join Poa_Proyectos h on h.IdProyectos = e.IdProyectos
inner join Poa_ProyectosAño i on i.IdProyectos = h.IdProyectos and i.AñoProyectos in @anio
inner join Convenios_stConvenioLaboralTrabajadorCategoria j on j.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador m on m.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador n on n.IdTrabajador = m.IdTrabajador
inner join Kardex_ctDatosPersonales p on p.IdKardex = n.IdKardex
inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica = j.IdEstructuraOrganica
where z2.TipoPasaje <> 'Vehículo oficial'
and h.Proyecto in @proyecto
and k.EstructuraOrganica in @area
group by h.IdProyectos, k.IdEstructuraOrganica, z2.TipoPasaje";

        string queryUser = @"
select mAX(p.Nombre +' '+ p.ApellidoPaterno+' '+p.ApellidoMaterno) AS Usuario
,Max(h.Numero) Numero, Max(h.Proyecto) Proyecto
,Max(e.CapituloInterno) Capitulo, Max(e.PartidaGenerica) PartidaGenerica, Max(e.PartidaEspecifica) PartidaEspecifica, MAX( e.Partida) Partida
,Max(case when f.Clase = 1 then '1 Servicios Personales' else (case when f.Clase = 2 then '2 Servicios Básicos' else (case when f.Clase=3 then '3 Materiales y Servicios Específicos' else (case when f.Clase= 4 then '4 Materiales y Servicios' else (case when f.Clase = 5 then '5 Bienes Muebles, Inmuebles e Intangibles' else '' end) end) end ) end) end)  Clase
,sum(case when b.idmes=1  then a.Total else 0 end) ENERO
,sum(case when b.idmes=2  then a.Total else 0 end) FEBRERO
,sum(case when b.idmes=3  then a.Total else 0 end) MARZO
,sum(case when b.idmes=4  then a.Total else 0 end) ABRIL
,sum(case when b.idmes=5  then a.Total else 0 end) MAYO
,sum(case when b.idmes=6  then a.Total else 0 end) JUNIO
,sum(case when b.idmes=7  then a.Total else 0 end) JULIO
,sum(case when b.idmes=8  then a.Total else 0 end) AGOSTO
,sum(case when b.idmes=9  then a.Total else 0 end) SEPTIEMBRE
,sum(case when b.idmes=10 then a.Total else 0 end) OCTUBRE
,sum(case when b.idmes=11 then a.Total else 0 end) NOVIEMBRE
,sum(case when b.idmes=12 then a.Total else 0 end) DICIEMBRE
,Sum(a.Total) Total, Clasificacion = 'productos'
 from Poa_Presupuesto a
inner join Poa_Calendario b on b.IdCalendario = a.IdCalendario
inner join Poa_Indicadores c on c.IdIndicadores = b.IdIndicadores
inner join Poa_Mir d on d.IdMir = c.IdMir and d.AñoMir IN @anio
inner join Poa_ProyectoArbol g on g.IdProyectoArbol = d.IdProyectoArbol
inner join Poa_Proyectos h on h.IdProyectos = g.IdProyectos
inner join Poa_ProyectosAño i on i.IdProyectos = h.IdProyectos and i.AñoProyectos in @anio
inner join Poa_Productos e on e.IdProductos = A.IdProductos and e.Año in @anio
INNER JOIN Poa_Partidas F ON F.PartidaEspecifica = e.PartidaEspecifica and f.Capitulo=e.CapituloInterno and f.Año in @anio
inner join Convenios_stConvenioLaboralTrabajadorCategoria j on j.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador m on m.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador n on n.IdTrabajador = m.IdTrabajador
inner join Kardex_ctDatosPersonales p on p.IdKardex = n.IdKardex
inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica = j.IdEstructuraOrganica
where h.Proyecto in @proyecto
and k.EstructuraOrganica in @area
and (d.IdConvenioLaboralTrabajadorCategoria = @idusuario or c.IdConvenioLaboralTrabajadorCategoria = @idusuario or g.IdConvenioLaboralTrabajadorCategoria = @idusuario)
group by H.IdProyectos, K.IdEstructuraOrganica ,F.IdPartidas, F.Clase
union all
select mAX(p.Nombre +' '+ p.ApellidoPaterno+' '+p.ApellidoMaterno) AS Usuario
,Max(h.Numero) Numero, Max(h.Proyecto) Proyecto
,'3000' Capitulo, '411' PartidaGenerica, '374' PartidaEspecifica, 'VIÁTICOS EN EL PAÍS' Partida
,'4 Materiales y Servicios'  Clase
,SUM(case when  a.idmes=1 then  (z.TotalViaticos) ELSE 0 end)   ENERO
,SUM(case when  a.idmes=2 then  (z.TotalViaticos) else 0 end)   FEBRERO
,SUM(case when  a.idmes=3 then  (z.TotalViaticos) else 0 end)   MARZO
,SUM(case when  a.idmes=4 then  (z.TotalViaticos) else 0 end)   ABRIL
,SUM(case when  a.idmes=5 then  (z.TotalViaticos) else 0 end)   MAYO
,SUM(case when  a.idmes=6 then  (z.TotalViaticos) else 0 end)   JUNIO
,SUM(case when  a.idmes=7 then  (z.TotalViaticos) else 0 end)   JULIO
,SUM(case when  a.idmes=8 then  (z.TotalViaticos) else 0 end)   AGOSTO
,SUM(case when  a.idmes=9 then  (z.TotalViaticos) else 0 end)   SEPTIEMBRE
,SUM(case when  a.idmes=10 then (z.TotalViaticos) else 0 end)   OCTUBRE
,SUM(case when  a.idmes=11 then (z.TotalViaticos) else 0 end)   NOVIEMBRE
,SUM(case when  a.idmes=12 then (z.TotalViaticos) else 0 end)   DICIEMBRE
,SUM(case when a.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) then z.TotalViaticos else 0 end) Total
,Clasificacion = 'viáticos'
from Poa_ViaticosPasajes z
inner join Poa_TipoPasaje z2 on z2.IdTipoPasaje = z.IdTipoPasaje
inner join  Poa_Calendario a on a.IdCalendario = z.IdCalendario
inner join Poa_CalendarioElemento b on a.IdCalendarioElemento=b.IdCalendarioElemento
inner join Poa_Indicadores c on c.IdIndicadores = a.IdIndicadores
inner join Poa_Mir d on d.IdMir = c.IdMir and d.AñoMir IN @anio
inner join Poa_ProyectoArbol e on e.IdProyectoArbol = d.IdProyectoArbol
inner join Poa_Proyectos h on h.IdProyectos = e.IdProyectos
inner join Poa_ProyectosAño i on i.IdProyectos = h.IdProyectos and i.AñoProyectos in @anio
inner join Convenios_stConvenioLaboralTrabajadorCategoria j on j.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador m on m.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador n on n.IdTrabajador = m.IdTrabajador
inner join Kardex_ctDatosPersonales p on p.IdKardex = n.IdKardex
inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica = j.IdEstructuraOrganica
where h.Proyecto in @proyecto
and k.EstructuraOrganica in @area
and (d.IdConvenioLaboralTrabajadorCategoria = @idusuario or c.IdConvenioLaboralTrabajadorCategoria = @idusuario or e.IdConvenioLaboralTrabajadorCategoria = @idusuario)
group by h.IdProyectos, k.IdEstructuraOrganica
union all
select mAX(p.Nombre +' '+ p.ApellidoPaterno+' '+p.ApellidoMaterno) AS Usuario
,Max(h.Numero) Numero, Max(h.Proyecto) Proyecto
,case when z2.TipoPasaje = 'Avión' then '3000' else '300' end Capitulo
,case when z2.TipoPasaje = 'Avión' then '411' else '411' end PartidaGenerica
,case when z2.TipoPasaje = 'Avión' then '369' else '370' end PartidaEspecifica
,case when z2.TipoPasaje = 'Avión' then 'PASAJES AÉREOS' else 'PASAJES TERRESTRES' end Partida
,'4 Materiales y Servicios'  Clase
,SUM(case when  a.idmes=1 then  (z.TotalPasaje) ELSE 0 end)  ENERO
,SUM(case when  a.idmes=2 then  (z.TotalPasaje) else 0 end)  FEBRERO
,SUM(case when  a.idmes=3 then  (z.TotalPasaje) else 0 end)   MARZO
,SUM(case when  a.idmes=4 then  (z.TotalPasaje) else 0 end)   ABRIL
,SUM(case when  a.idmes=5 then  (z.TotalPasaje) else 0 end)   MAYO
,SUM(case when  a.idmes=6 then  (z.TotalPasaje) else 0 end)   JUNIO
,SUM(case when  a.idmes=7 then  (z.TotalPasaje) else 0 end)   JULIO
,SUM(case when  a.idmes=8 then  (z.TotalPasaje) else 0 end)   AGOSTO
,SUM(case when  a.idmes=9 then  (z.TotalPasaje) else 0 end)   SEPTIEMBRE
,SUM(case when  a.idmes=10 then (z.TotalPasaje) else 0 end)   OCTUBRE
,SUM(case when  a.idmes=11 then (z.TotalPasaje) else 0 end)   NOVIEMBRE
,SUM(case when  a.idmes=12 then (z.TotalPasaje) else 0 end)  DICIEMBRE
,SUM(case when a.IdMes in (1,2,3,4,5,6,7,8,9,10,11,12) then z.TotalPasaje else 0 end) Total
,case when z2.TipoPasaje in ('Avión') then 'aereo' else 'terrestre' end Clasificacion
from Poa_ViaticosPasajes z
inner join Poa_TipoPasaje z2 on z2.IdTipoPasaje = z.IdTipoPasaje
inner join  Poa_Calendario a on a.IdCalendario = z.IdCalendario
inner join Poa_CalendarioElemento b on a.IdCalendarioElemento=b.IdCalendarioElemento
inner join Poa_Indicadores c on c.IdIndicadores = a.IdIndicadores
inner join Poa_Mir d on d.IdMir = c.IdMir and d.AñoMir IN @anio
inner join Poa_ProyectoArbol e on e.IdProyectoArbol = d.IdProyectoArbol
inner join Poa_Proyectos h on h.IdProyectos = e.IdProyectos
inner join Poa_ProyectosAño i on i.IdProyectos = h.IdProyectos and i.AñoProyectos in @anio 
inner join Convenios_stConvenioLaboralTrabajadorCategoria j on j.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador m on m.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador n on n.IdTrabajador = m.IdTrabajador
inner join Kardex_ctDatosPersonales p on p.IdKardex = n.IdKardex
inner join Catalogos_ctEstructuraOrganica k on k.IdEstructuraOrganica = j.IdEstructuraOrganica
where z2.TipoPasaje <> 'Vehículo oficial'
and h.Proyecto in @proyecto
and k.EstructuraOrganica in @area
and (d.IdConvenioLaboralTrabajadorCategoria = @idusuario or c.IdConvenioLaboralTrabajadorCategoria = @idusuario or e.IdConvenioLaboralTrabajadorCategoria = @idusuario)
group by h.IdProyectos, k.IdEstructuraOrganica, z2.TipoPasaje
";


        string queryResponsable = @"SELECT MAX(n.Nombre +' '+n.ApellidoPaterno +' '+n.ApellidoMaterno) NombreCompleto, MAX(EstructuraOrganica) EstructuraOrganica FROM Catalogos_ctEstructuraOrganica a
inner join Convenios_stConvenioLaboralTrabajadorCategoria b on b.IdEstructuraOrganica = a.IdEstructuraOrganica
INNER JOIN Plazas_stDistribucionPlazaCategoria f ON f.IdDistribucionPlazaCategoria = b.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria g on g.IdCategoria = f.IdCategoria
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral = g.IdRelacionConvenioLaboral and h.RelacionConvenioLaboral = 'MANDO MEDIO-CONFIANZA'
inner join Catalogos_ctRelacionLaboral j on j.IdRelacionLaboral = h.IdRelacionLaboral AND j.RelacionLaboral = 'MANDO MEDIO'
inner join Convenios_stConvenioLaboralTrabajador k on k.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador m on m.IdTrabajador = k.IdTrabajador
inner join Kardex_ctDatosPersonales n on n.IdKardex = m.IdKardex
where EstructuraOrganica  = (
select a.EstructuraOrganica from Catalogos_ctEstructuraOrganica a 
inner join (SELECT 
case when a.IdEstructuraOrganicaPadre <> 1 THEN a.IdEstructuraOrganicaPadre ELSE a.IdEstructuraOrganica end idEstructuraOrganica
FROM Catalogos_ctEstructuraOrganica a
where a.EstructuraOrganica = @areaSingle
) b on a.IdEstructuraOrganica = b.idEstructuraOrganica
) and b.FechaTermino is null";

        Int16[] anio = { };
        String[] proyecto = { };
        String[] area = { };


        public ActionResult Index()
        {

            PoaMir rolAdmin = new PoaMir();

            if (rolAdmin.EsAdministrador())
            {
                return RedirectToAction("Admin", "PoaPresupuestoClaseReporte");
            }

            return View();
        }


        // GET: PoaViaticosPasajesReport
        public ActionResult Admin()
        {
            PoaMir rolAdmin = new PoaMir();

            if (!rolAdmin.EsAdministrador())
            {
                return RedirectToAction("Index", "PoaProductosReporte");
            }

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"SELECT 
      AñoArbol
  FROM Poa_ProyectoArbol
  group by AñoArbol
  order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);
            ViewBag.Anios = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            string queryProyectos = @"SELECT 
       b.Numero, b.Proyecto
  FROM Poa_ProyectoArbol a
  inner join Poa_Proyectos b on a.IdProyectos = b.IdProyectos
  group by a.IdProyectos, b.Proyecto, b.Numero
  order by b.Numero";

            var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos);
            ViewBag.Proyectos = proy.Select(x => new SelectListItem()
            {
                Value = x.Proyecto,
                Text = x.Numero + " " + x.Proyecto
            });


  //          string queryAreas = @" select c.EstructuraOrganica 
  //from Poa_ProyectoArbol a
  //inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
  //inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
  //group by c.EstructuraOrganica";

            string queryAreas = @" select c.EstructuraOrganica 
  from Poa_Mir a
  inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
  inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
  group by c.EstructuraOrganica";


            var areas = (List<string>)dp.connection.Query<string>(queryAreas);
            ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });


            dp.Close();



            return View();
        }

        [HttpPost]
        public ActionResult PresupuestoClaseView(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<PresupuestoClaseReporte> result = new List<PresupuestoClaseReporte>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<PresupuestoClaseReporte>)dp.connection.Query<PresupuestoClaseReporte>(query, new { anio, proyecto, area });

            }
            else
            {
                result = (List<PresupuestoClaseReporte>)dp.connection.Query<PresupuestoClaseReporte>(queryUser, new { anio, proyecto, area, idusuario });
            }



            dp.Close();

            return PartialView("_PresupuestoClase", result);
        }

        public ActionResult PresupuestoClase(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<PresupuestoClaseReporte> result = new List<PresupuestoClaseReporte>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<PresupuestoClaseReporte>)dp.connection.Query<PresupuestoClaseReporte>(query, new { anio, proyecto, area });

            }
            else
            {
                result = (List<PresupuestoClaseReporte>)dp.connection.Query<PresupuestoClaseReporte>(queryUser, new { anio, proyecto, area, idusuario });
            }

            if (proyecto.Count() == 1 && area.Count() == 1)
            {
                //if (rolAdmin.EsAdministrador())
                //{
                    string areaSingle = area.FirstOrDefault();
                    var responsable = (List<DirectorArea>)dp.connection.Query<DirectorArea>(queryResponsable, new { areaSingle });
                    ViewBag.UsuarioU = responsable.Select(t => t.NombreCompleto).FirstOrDefault();
                    ViewBag.EstructuraP = responsable.Select(t => t.EstructuraOrganica).FirstOrDefault();
                //}
                //else
                //{
                //    var usuario = Seguridad.Identidad.Usuario();
                //    ViewBag.UsuarioU = usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + ' ' + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + ' ' + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre;
                //}
            }
            else
            {
                ViewBag.UsuarioU = "NoUser";
            }

            dp.Close();

            string modalidad = "Poa_PresupuestoClase" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;


            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

        }

        public ActionResult PresupuestoClaseXls(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<PresupuestoClaseReporte> result = new List<PresupuestoClaseReporte>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<PresupuestoClaseReporte>)dp.connection.Query<PresupuestoClaseReporte>(query, new { anio, proyecto, area });

            }
            else
            {
                result = (List<PresupuestoClaseReporte>)dp.connection.Query<PresupuestoClaseReporte>(queryUser, new { anio, proyecto, area, idusuario });
            }



            dp.Close();


            string modalidad = "Poa_PresupuestoClase_" + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=" + modalidad);

            return View(result);
        }

        [HttpPost]
        public ActionResult ConsultarProyectosAnio()
        {
            int año = System.Convert.ToInt32(Request["Anio"]);
            if (año != 0 && año > 2000)
            {

            }
            else
            {
                año = db.Poa_SistemaAñoVigente.Select(s => s.Año).FirstOrDefault();
            }

            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            PoaMir rol = new PoaMir();

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"SELECT 
      AñoArbol
  FROM Poa_ProyectoArbol
  group by AñoArbol
  order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            ViewBag.Anios = new SelectList(listAños, "Value", "Text", año);




            if (rol.EsMandoMedio())//para saber si es PoaResponsable
            {
                string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE f.AñoMir = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by a.Numero, a.Proyecto";

                var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
                ViewBag.Proyectos = proy.Select(x => new SelectListItem()
                {
                    Value = x.Proyecto,
                    Text = x.Numero + " " + x.Proyecto
                });


                string queryAreas = @" select d.EstructuraOrganica from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE f.AñoMir = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by d.EstructuraOrganica";

                var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
                ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });

            }
            else if (rol.TieneIndicadoresAsignados(año))
            {

                string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.AñoProyectos = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by a.Numero, a.Proyecto";


                var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
                ViewBag.Proyectos = proy.Select(x => new SelectListItem()
                {
                    Value = x.Proyecto,
                    Text = x.Numero + " " + x.Proyecto
                });


                string queryAreas = @"select d.EstructuraOrganica from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.AñoProyectos = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by d.EstructuraOrganica";

                var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
                ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });
            }
            else
            {
                var result = "No se encuentra un elmento asociado";
                return Json(result, JsonRequestBehavior.AllowGet);
            }



            dp.Close();
            return PartialView("_FormListView");
        }

    }
}