﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Rotativa;
using Seguridad;
using Dapper;
//using Nova.Libraries;

namespace Nova.Controllers.POA
{
    public class PoaPresupuestoAreasReporteController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        string query = @"
select EstructuraOrganica,Proyecto,TechoPresupuestal,case when Presupuestado is null then 0 else Presupuestado end as Presupuestado

,PorEjercer= TechoPresupuestal-(case when Presupuestado is null then 0 else Presupuestado end) from 
(
select d.IdEstructuraOrganica,f.IdProyectos,max('P'+cast(f.Numero as nvarchar(2))+' '+ f.Proyecto) as Proyectos,MAX(g.EstructuraOrganica) as Area ,SUM(a.Valor) as Presupuestado
from Poa_Calendario a
inner join Poa_Indicadores b on a.IdIndicadores=b.IdIndicadores
inner join Poa_Mir c on c.IdMir=b.IdMir and c.AñoMir in @anio
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=c.IdConvenioLaboralTrabajadorCategoria
inner join Poa_ProyectoArbol e on e.IdProyectoArbol=c.IdProyectoArbol
inner join Poa_Proyectos f on f.IdProyectos=e.IdProyectos and f.Proyecto in @proyecto
inner join Poa_ProyectosAño f2 on f2.IdProyectos = f.IdProyectos and f2.AñoProyectos in @anio
inner join Catalogos_ctEstructuraOrganica g on g.IdEstructuraOrganica=d.IdEstructuraOrganica
inner join Poa_CalendarioElemento h on h.IdCalendarioElemento=a.IdCalendarioElemento
WHERE h.CalendarioElemento in ('Presupuesto','Viáticos y pasajes')
group by d.IdEstructuraOrganica,f.IdProyectos
) as X

right join (

select a.IdEstructuraOrganica,max(g.EstructuraOrganica) as EstructuraOrganica,c.IdProyectos,max('P'+cast(c.Numero as nvarchar(2))+' '+ c.Proyecto) as Proyecto,max(Presupuesto) as TechoPresupuestal from 
Poa_ProyectosAñoAreaPresupuesto a
inner join Poa_ProyectosAño b on a.IdProyectosAño=b.IdProyectosAño and b.AñoProyectos in @anio
inner join Poa_Proyectos c on c.IdProyectos=b.IdProyectos and c.Proyecto in @proyecto
inner join Catalogos_ctEstructuraOrganica g on g.IdEstructuraOrganica=a.IdEstructuraOrganica

group by a.IdEstructuraOrganica,c.IdProyectos
           ) as Universo 

on X.IdProyectos=Universo.IdProyectos and X.IdEstructuraOrganica=Universo.IdEstructuraOrganica
where EstructuraOrganica in @area
";

        string queryUser = @"
select EstructuraOrganica,Proyecto,TechoPresupuestal,case when Presupuestado is null then 0 else Presupuestado end as Presupuestado

,PorEjercer= TechoPresupuestal-(case when Presupuestado is null then 0 else Presupuestado end) from 
(
select d.IdEstructuraOrganica,f.IdProyectos,max('P'+cast(f.Numero as nvarchar(2))+' '+ f.Proyecto) as Proyectos,MAX(g.EstructuraOrganica) as Area ,SUM(a.Valor) as Presupuestado
from Poa_Calendario a
inner join Poa_Indicadores b on a.IdIndicadores=b.IdIndicadores
inner join Poa_Mir c on c.IdMir=b.IdMir and c.AñoMir in @anio
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=c.IdConvenioLaboralTrabajadorCategoria
inner join Poa_ProyectoArbol e on e.IdProyectoArbol=c.IdProyectoArbol
inner join Poa_Proyectos f on f.IdProyectos=e.IdProyectos and f.Proyecto in @proyecto
inner join Poa_ProyectosAño f2 on f2.IdProyectos = f.IdProyectos and f2.AñoProyectos in @anio
inner join Catalogos_ctEstructuraOrganica g on g.IdEstructuraOrganica=d.IdEstructuraOrganica
inner join Poa_CalendarioElemento h on h.IdCalendarioElemento=a.IdCalendarioElemento
WHERE h.CalendarioElemento in ('Presupuesto','Viáticos y pasajes')
group by d.IdEstructuraOrganica,f.IdProyectos
) as X

right join (

select a.IdEstructuraOrganica,max(g.EstructuraOrganica) as EstructuraOrganica,c.IdProyectos,max('P'+cast(c.Numero as nvarchar(2))+' '+ c.Proyecto) as Proyecto,max(Presupuesto) as TechoPresupuestal from 
Poa_ProyectosAñoAreaPresupuesto a
inner join Poa_ProyectosAño b on a.IdProyectosAño=b.IdProyectosAño and b.AñoProyectos in @anio
inner join Poa_Proyectos c on c.IdProyectos=b.IdProyectos and c.Proyecto in @proyecto
inner join Catalogos_ctEstructuraOrganica g on g.IdEstructuraOrganica=a.IdEstructuraOrganica

group by a.IdEstructuraOrganica,c.IdProyectos
           ) as Universo 

on X.IdProyectos=Universo.IdProyectos and X.IdEstructuraOrganica=Universo.IdEstructuraOrganica
where EstructuraOrganica in @area
";

        string queryResponsable = @"SELECT MAX(n.Nombre +' '+n.ApellidoPaterno +' '+n.ApellidoMaterno) NombreCompleto, MAX(EstructuraOrganica) EstructuraOrganica FROM Catalogos_ctEstructuraOrganica a
inner join Convenios_stConvenioLaboralTrabajadorCategoria b on b.IdEstructuraOrganica = a.IdEstructuraOrganica
INNER JOIN Plazas_stDistribucionPlazaCategoria f ON f.IdDistribucionPlazaCategoria = b.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria g on g.IdCategoria = f.IdCategoria
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral = g.IdRelacionConvenioLaboral and h.RelacionConvenioLaboral = 'MANDO MEDIO-CONFIANZA'
inner join Catalogos_ctRelacionLaboral j on j.IdRelacionLaboral = h.IdRelacionLaboral AND j.RelacionLaboral = 'MANDO MEDIO'
inner join Convenios_stConvenioLaboralTrabajador k on k.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador m on m.IdTrabajador = k.IdTrabajador
inner join Kardex_ctDatosPersonales n on n.IdKardex = m.IdKardex
where EstructuraOrganica  = (
select a.EstructuraOrganica from Catalogos_ctEstructuraOrganica a 
inner join (SELECT 
case when a.IdEstructuraOrganicaPadre <> 1 THEN a.IdEstructuraOrganicaPadre ELSE a.IdEstructuraOrganica end idEstructuraOrganica
FROM Catalogos_ctEstructuraOrganica a
where a.EstructuraOrganica = @areaSingle
) b on a.IdEstructuraOrganica = b.idEstructuraOrganica
) and b.FechaTermino is null";


        Int16[] anio = { };
        String[] proyecto = { };
        String[] area = { };


        public ActionResult Index()
        {

            PoaMir rolAdmin = new PoaMir();

            if (rolAdmin.EsAdministrador())
            {
                return RedirectToAction("Admin", "PoaPresupuestoAreasReporte");
            }

            return View();
        }


        // GET: PoaViaticosPasajesReport
        public ActionResult Admin()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"SELECT 
      AñoArbol
  FROM Poa_ProyectoArbol
  group by AñoArbol
  order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);
            ViewBag.Anios = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            string queryProyectos = @"SELECT 
       b.Numero, b.Proyecto
  FROM Poa_ProyectoArbol a
  inner join Poa_Proyectos b on a.IdProyectos = b.IdProyectos
  group by a.IdProyectos, b.Proyecto, b.Numero
  order by a.IdProyectos desc";

            var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos);
            ViewBag.Proyectos = proy.Select(x => new SelectListItem()
            {
                Value = x.Proyecto,
                Text = x.Numero + " " + x.Proyecto
            });


            //          string queryAreas = @" select c.EstructuraOrganica 
            //from Poa_ProyectoArbol a
            //inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
            //inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
            //group by c.EstructuraOrganica";

            string queryAreas = @" select c.EstructuraOrganica 
            from Poa_Mir a
            inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
            inner join Catalogos_ctEstructuraOrganica c on b.IdEstructuraOrganica = c.IdEstructuraOrganica
            group by c.EstructuraOrganica";

            var areas = (List<string>)dp.connection.Query<string>(queryAreas);
            ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });


            dp.Close();



            return View();
        }

        [HttpPost]
        public ActionResult PresupuestoAreasView(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<PresupuestoAreasReporte> result = new List<PresupuestoAreasReporte>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<PresupuestoAreasReporte>)dp.connection.Query<PresupuestoAreasReporte>(query, new { anio, proyecto, area });

            }
            else
            {
                result = (List<PresupuestoAreasReporte>)dp.connection.Query<PresupuestoAreasReporte>(queryUser, new { anio, proyecto, area, idusuario });
            }



            dp.Close();

            return PartialView("_PresupuestoAreas", result);
        }

        public ActionResult PresupuestoAreas(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<PresupuestoAreasReporte> result = new List<PresupuestoAreasReporte>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<PresupuestoAreasReporte>)dp.connection.Query<PresupuestoAreasReporte>(query, new { anio, proyecto, area });

            }
            else
            {
                result = (List<PresupuestoAreasReporte>)dp.connection.Query<PresupuestoAreasReporte>(queryUser, new { anio, proyecto, area, idusuario });
            }

            if (proyecto.Count() == 1 && area.Count() == 1)
            {

                string areaSingle = area.FirstOrDefault();
                var responsable = (List<DirectorArea>)dp.connection.Query<DirectorArea>(queryResponsable, new { areaSingle });
                ViewBag.UsuarioU = responsable.Select(t => t.NombreCompleto).FirstOrDefault();
                ViewBag.EstructuraP = responsable.Select(t => t.EstructuraOrganica).FirstOrDefault();

            }
            else
            {
                ViewBag.UsuarioU = "NoUser";
            }


            dp.Close();

            string modalidad = "Poa_PresupuestoAreas" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 2;
            m.Left = 5;
            m.Right = 5;
            m.Top = 2;


            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

        }

        public ActionResult PresupuestoAreasXls(String[] anios, String[] proyectos, String[] areas)
        {
            anio = anios.Select(s => Int16.Parse(s)).ToArray();
            proyecto = proyectos;
            area = areas;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            PoaMir rolAdmin = new PoaMir();
            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            List<PresupuestoAreasReporte> result = new List<PresupuestoAreasReporte>();

            if (rolAdmin.EsAdministrador())
            {
                result = (List<PresupuestoAreasReporte>)dp.connection.Query<PresupuestoAreasReporte>(query, new { anio, proyecto, area });

            }
            else
            {
                result = (List<PresupuestoAreasReporte>)dp.connection.Query<PresupuestoAreasReporte>(queryUser, new { anio, proyecto, area, idusuario });
            }



            dp.Close();


            string modalidad = "Poa_PresupuestoAreas_" + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=" + modalidad);

            return View(result);
        }

        [HttpPost]
        public ActionResult ConsultarProyectosAnio()
        {
            int año = System.Convert.ToInt32(Request["Anio"]);
            if (año != 0 && año > 2000)
            {

            }
            else
            {
                año = db.Poa_SistemaAñoVigente.Select(s => s.Año).FirstOrDefault();
            }

            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            PoaMir rol = new PoaMir();

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"SELECT 
      AñoArbol
  FROM Poa_ProyectoArbol
  group by AñoArbol
  order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            ViewBag.Anios = new SelectList(listAños, "Value", "Text", año);




            if (rol.EsMandoMedio())//para saber si es PoaResponsable
            {
                string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE f.AñoMir = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by a.Numero, a.Proyecto";

                var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
                ViewBag.Proyectos = proy.Select(x => new SelectListItem()
                {
                    Value = x.Proyecto,
                    Text = x.Numero + " " + x.Proyecto
                });


                string queryAreas = @" select d.EstructuraOrganica from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE f.AñoMir = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by d.EstructuraOrganica";

                var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
                ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });

            }
            else if (rol.TieneIndicadoresAsignados(año))
            {

                string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.Año = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by a.Numero, a.Proyecto";


                var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
                ViewBag.Proyectos = proy.Select(x => new SelectListItem()
                {
                    Value = x.Proyecto,
                    Text = x.Numero + " " + x.Proyecto
                });


                string queryAreas = @"select d.EstructuraOrganica from Poa_Proyectos a 
  inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  WHERE b.AñoProyectos = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  group by d.EstructuraOrganica";

                var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
                ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });
            }
            else
            {
                var result = "No se encuentra un elmento asociado";
                return Json(result, JsonRequestBehavior.AllowGet);
            }



            dp.Close();
            return PartialView("_FormListView");
        }



    }
}