﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.Transactions;

namespace Nova.Controllers.Poa.PoaProgramacion
{
    public class PoaProgramacionController : BaseController
    {
        // GET: PoaProgramacion
        bdNovaEntities db = new bdNovaEntities();
        public ActionResult Index()
        {

            return View();
        }
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {

            try
            {

                Poa_Calendario poa_Calendario = db.Poa_Calendario.Find(id);
                db.Poa_Calendario.Remove(poa_Calendario);
                db.SaveChanges();
            }
            catch (Exception e)
            {


                return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
            }




            return JsonView(ModelState.IsValid, "Se ha eliminado la programación exitosamente", null, null, Url.Action("Index", "PoaCalendario"));
         
        }
        public ActionResult Create(int id = 0, int IdMes = 0, String Proyecto = "", String Anio = "", String ResumenNarrativo = "", String Elemento = "")
        {
            Poa_Indicadores indicadores = new Poa_Indicadores();
            Poa_Calendario setPoaCalendario = new Poa_Calendario();
            Poa_CalendarioAux setPoaCalendarioAux = new Poa_CalendarioAux();
            
            indicadores = db.Poa_Indicadores.Find(id);

            int IdCalendarioElemento = db.Poa_CalendarioElemento.Where(x => x.CalendarioElemento == "Programado").FirstOrDefault().IdCalendarioElemento;

            setPoaCalendarioAux.PoaCalendario = indicadores.Poa_Calendario.Where(f=> f.IdIndicadores==id).FirstOrDefault();
            setPoaCalendarioAux.Indicador = indicadores.Indicador;

            List<Poa_Calendario> Calendarizados = new List<Poa_Calendario>();

            Calendarizados = db.Poa_Calendario.Where(c => c.IdIndicadores == id && c.Poa_CalendarioElemento.CalendarioElemento == "Programado").ToList();

            int registros = Calendarizados.Count();

            decimal suma = Calendarizados.Sum(x => x.Valor);

            decimal totalmeta = indicadores.MetaAnual;

            String FrecuenciaMedicionIndicador = indicadores.Poa_FrecuenciaMedicionIndicador.FrecuenciaMedicion;

            String TipoIndicador = indicadores.Poa_TipoIndicador.TipoIndicador;
            setPoaCalendarioAux.MetaAnual = totalmeta;
            setPoaCalendarioAux.FrecuenciaMedicionIndicador = FrecuenciaMedicionIndicador;
            setPoaCalendarioAux.TipoIndicador=TipoIndicador;
           

            setPoaCalendarioAux.MsgError = "";
            String msg = "";
            switch (indicadores.Poa_FrecuenciaMedicionIndicador.FrecuenciaMedicion)
            {
                case "Anual":
                    if (registros >= 1)
                    {
                        String mes = Calendarizados.Select(x => x.Catalogos_ctMes.Mes).FirstOrDefault();
                        setPoaCalendarioAux.MsgError = "Meta anual registrada <strong>( " + string.Format("{0:N}", suma) + " ) </strong>en el mes de <strong>" + mes + "</strong>";
                        setPoaCalendarioAux.Error = true;
                    }
                    else
                    {
                        setPoaCalendarioAux.MsgError = "Meta anual por guardar, <strong> recuerde que NO podrá eliminar </strong> el registro una vez guardado. Meta anual programada: <strong>" + string.Format("{0:N}", totalmeta) + "</strong>";
                        setPoaCalendario.Valor = totalmeta;
                        setPoaCalendarioAux.Warning = true;
                    }
                    break;

                case "Mensual":
                    if (registros >= 12)
                    {
                        msg = "Meta mensual calendarizada en su totalidad.";

                        foreach (var item in Calendarizados)
                        {
                            msg += "<p style='color:black'>" + "<strong> " + item.Catalogos_ctMes.Mes + " --- " + string.Format("{0:N}", item.Valor) + "</strong></p>";
                        }

                        setPoaCalendarioAux.MsgError = msg;
                        setPoaCalendarioAux.Error = true;
                    }
                    else
                    {
                        if (registros == 11)
                        {
                            setPoaCalendarioAux.MsgError = "Meta mensual por calendarizar en su totalidad, <strong> recuerde que NO podrá eliminar </strong> los registros una vez guardados.</strong>";
                            setPoaCalendarioAux.MsgError += "<p>Usted lleva acumulado: <strong>" + string.Format("{0:N}", suma) + "</strong> de un total bimestral: <strong>" + string.Format("{0:N}", totalmeta + "</strong></p>");
                            setPoaCalendarioAux.Warning = true;
                            setPoaCalendarioAux.PoaCalendario.Valor = totalmeta+suma;
                        }
                    }
                    break;


                case "Bimestral":
                    if (registros >= 6)
                    {
                        msg = "Meta bimestral calendarizada en su totalidad.";

                        foreach (var item in Calendarizados)
                        {
                            msg += "<p style='color:black'>" + "<strong> " + item.Catalogos_ctMes.Mes + " --- " + string.Format("{0:N}", item.Valor) + "</strong></p>";
                        }

                        setPoaCalendarioAux.MsgError = msg;
                        setPoaCalendarioAux.Error = true;
                    }
                    else
                    {
                        if (registros == 5)
                        {
                            setPoaCalendarioAux.MsgError = "Meta bimestral por calendarizar en su totalidad, <strong> recuerde que NO podrá eliminar </strong> los registros una vez guardados.</strong>";
                            setPoaCalendarioAux.MsgError += "<p>Usted lleva acumulado: <strong>" + string.Format("{0:N}", suma) + "</strong> de un total bimestral: <strong>" + string.Format("{0:N}", totalmeta + "</strong></p>");
                            setPoaCalendarioAux.Warning = true;
                            setPoaCalendarioAux.PoaCalendario.Valor = totalmeta + suma;
                        }
                    }
                    break;

                case "Trimestral":
                    if (registros >= 4)
                    {
                        msg = "Meta trimestral calendarizada en su totalidad.";

                        foreach (var item in Calendarizados)
                        {
                            msg += "<p style='color:black'>" + "<strong> " + item.Catalogos_ctMes.Mes + " --- " + string.Format("{0:N}", item.Valor) + "</strong></p>";
                        }

                        setPoaCalendarioAux.MsgError = msg;
                        setPoaCalendarioAux.Error = true;
                    }
                    else
                    {
                        if (registros == 3)
                        {
                            setPoaCalendarioAux.MsgError = "Meta trimestral por calendarizar en su totalidad, <strong> recuerde que NO podrá eliminar </strong> los registros una vez guardados.</strong>";
                            setPoaCalendarioAux.MsgError += "<p>Usted lleva acumulado: <strong>" + string.Format("{0:N}", suma) + "</strong> de un total trimestral: <strong>" + string.Format("{0:N}", totalmeta + "</strong></p>");
                            setPoaCalendarioAux.Warning = true;
                            setPoaCalendario.Valor = totalmeta - suma;
                        }

                    }


                    break;
                case "Semestral":
                    if (registros >= 2)
                    {
                        msg = "Meta semestral calendarizada en su totalidad.";

                        foreach (var item in Calendarizados)
                        {
                            msg += "<p style='color:black'>" + "<strong> " + item.Catalogos_ctMes.Mes + " --- " + string.Format("{0:N}", item.Valor) + "</strong></p>";
                        }

                        setPoaCalendarioAux.MsgError = msg;
                        setPoaCalendarioAux.Error = true;
                    }
                    else
                    {
                        if (registros == 3)
                        {
                            setPoaCalendarioAux.MsgError = "Meta semestral por calendarizar en su totalidad, <strong> recuerde que NO podrá eliminar </strong> los registros una vez guardados.</strong>";
                            setPoaCalendarioAux.MsgError += "<p>Usted lleva acumulado: <strong>" + string.Format("{0:N}", suma) + "</strong> de un total semestral: <strong>" + string.Format("{0:N}", totalmeta + "</strong></p>");
                            setPoaCalendarioAux.Warning = true;
                            setPoaCalendario.Valor = totalmeta - suma;
                        }

                    }


                    break;
                default:
                    setPoaCalendarioAux.MsgError = "Frecuencia medición no implementada";
                    setPoaCalendarioAux.Error = true;

                    break;
            }







            setPoaCalendario.IdMes = System.Convert.ToInt16(IdMes);
            setPoaCalendario.IdCalendarioElemento = System.Convert.ToInt16(IdCalendarioElemento);
            setPoaCalendario.IdIndicadores = id;

            setPoaCalendarioAux.PoaCalendario = setPoaCalendario;
            setPoaCalendarioAux.Año = Anio;
            setPoaCalendarioAux.Mes = db.Catalogos_ctMes.Find(setPoaCalendario.IdMes).Mes;
            setPoaCalendarioAux.ResumenNarrativo = ResumenNarrativo;
            setPoaCalendarioAux.Proyecto = Proyecto;



            return PartialView(setPoaCalendarioAux);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "Proyecto,Año,ResumenNarrativo,PoaCalendario,Poa_Indicadores,Poa_FrecuenciaMedicionIndicador")] Poa_CalendarioAux poa_Calendario)
        {
            List<Poa_Calendario> Calendarizados = new List<Poa_Calendario>();
            Poa_Indicadores indicadores = new Poa_Indicadores();
            
            Calendarizados=db.Poa_Calendario.Where(c => c.IdIndicadores == poa_Calendario.PoaCalendario.IdIndicadores && c.Poa_CalendarioElemento.CalendarioElemento == "Programado").ToList();
            
            string messages = "";
            int registros = Calendarizados.Count();

            //if (poa_Calendario.PoaCalendario.Valor == 0)
            //    ModelState.AddModelError("Valor", "Campo requerido");

            indicadores = db.Poa_Indicadores.Find(poa_Calendario.PoaCalendario.IdIndicadores);

            decimal suma = Calendarizados.Sum(x => x.Valor);

            decimal totalmeta = db.Poa_Indicadores.Find(poa_Calendario.PoaCalendario.IdIndicadores).MetaAnual;


            //if (indicadores.Poa_TipoIndicador.TipoIndicador != "Promedio" || indicadores.Poa_TipoIndicador.TipoIndicador != "Indice")
            //if ((suma + poa_Calendario.PoaCalendario.Valor > totalmeta))
            //    ModelState.AddModelError("MsgError", "El valor que intenta guardar [" + string.Format("{0:N}", poa_Calendario.PoaCalendario.Valor) + " ] rebasa la meta anual registrada " + string.Format("{0:N}", totalmeta) + ".");

            //if (indicadores.Poa_TipoIndicador.TipoIndicador != "Promedio" || indicadores.Poa_TipoIndicador.TipoIndicador != "Indice")
            //{
            //}
            bool sevaaCerrar = false;
            int NumeroMesesFrecuencia = 0;
            switch (indicadores.Poa_FrecuenciaMedicionIndicador.FrecuenciaMedicion)
            {
                case "Anual":
                    NumeroMesesFrecuencia = 1;
                    if (registros == 0)
                        sevaaCerrar = true;

                    break;
                case "Mensual":
                    NumeroMesesFrecuencia = 12;
                    if (registros == 11)
                        sevaaCerrar = true;
                    break;
                case "Bimestral":
                    NumeroMesesFrecuencia = 6;
                    if (registros == 5)
                        sevaaCerrar = true;
                    break;
                case "Trimestral":
                    NumeroMesesFrecuencia = 4;
                    if (registros == 3)
                        sevaaCerrar = true;
                    break;
                 
                case "Semestral":
                    NumeroMesesFrecuencia = 2;
                    if (registros == 1)
                        sevaaCerrar = true;
                    break;
                
            }


            switch (indicadores.Poa_TipoIndicador.TipoIndicador)
            {
                case "Acumulativo":
                    if ((suma + poa_Calendario.PoaCalendario.Valor > totalmeta))
                  ModelState.AddModelError("MsgError", "El valor que intenta guardar [" + string.Format("{0:N}", poa_Calendario.PoaCalendario.Valor) + " ] rebasa la meta anual registrada " + string.Format("{0:N}", totalmeta) + ".");
                    break;

                case "Promedio":


                    decimal promedio = poa_Calendario.PoaCalendario.Valor;
                    
                    if (indicadores.Poa_SentidoIndicador.SentidoIndicador == "Ascendente")
                    {
                        

                        if (promedio < totalmeta)
                            ModelState.AddModelError("MsgError", "El valor que intenta guardar [" + string.Format("{0:N}", poa_Calendario.PoaCalendario.Valor) + " ] no es válido según el sentido del indicador " + string.Format("{0:N}", totalmeta) + ".");
                    }
                    else 
                                if (indicadores.Poa_SentidoIndicador.SentidoIndicador == "Descendente")
                                    if (promedio > totalmeta)
                                        ModelState.AddModelError("MsgError", "El valor que intenta guardar [" + string.Format("{0:N}", poa_Calendario.PoaCalendario.Valor) + " ] no es válido según el sentido del indicador " + string.Format("{0:N}", totalmeta) + ".");
                                    else
                                        ModelState.AddModelError("MsgError", "El indicador que intenta guardar no tiene definido un SENTIDO, revise su información" );
                    break;

                case "Incremental":
                   
                    if ((suma+indicadores.LineaBase) + poa_Calendario.PoaCalendario.Valor != totalmeta && sevaaCerrar)

                        ModelState.AddModelError("MsgError", "El valor que intenta guardar [" + string.Format("{0:N}", poa_Calendario.PoaCalendario.Valor) + " ] no cumple con la meta anual registrada según el tipo de indicador " + string.Format("{0:N}", totalmeta) + ".");
                    break;
            }

            switch (indicadores.Poa_FrecuenciaMedicionIndicador.FrecuenciaMedicion)
            {
                case "Anual":
                    if (registros >= 1)
                        ModelState.AddModelError("MsgError", "Meta anual registrada");
                    break;
                case "Mensual":
                    if (registros >= 12)
                        ModelState.AddModelError("MsgError", "Valores mensuales ya regsitrados.");
                    break;
                case "Bimestral":
                    if (registros >= 6)
                        ModelState.AddModelError("MsgError", "Valores bimestrales ya regsitrados.");
                    break;
                case "Trimestral":
                    if (registros >= 4)
                        ModelState.AddModelError("MsgError", "Valores trimestrales ya regsitrados.");
                    break;
                case "Semestral":
                    if (registros >= 2)
                        ModelState.AddModelError("MsgError", "Valores semestrales ya regsitrados.");
                    break;
                default:
                    ModelState.AddModelError("MsgError", "Frecuencia medición no implementada");
                    break;
            }


            if (ModelState.IsValid)
            {

                try
                {

                    db.Poa_Calendario.Add(poa_Calendario.PoaCalendario);
                    db.SaveChanges();
                    if (indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Actividad")
                    {
                        if (indicadores.IdIndicadorComponente != null)
                        {
                            Poa_Indicadores poaindicadorcomponente = db.Poa_Indicadores.Find(indicadores.IdIndicadorComponente);
                            actualizacalendariocomponente(poaindicadorcomponente, poa_Calendario.PoaCalendario, "Programado");
                        }
                    }

                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }




                
                return JsonView(ModelState.IsValid, "Se ha grabado la programación exitosamente", null, null, Url.Action("Index", "PoaCalendario"), poa_Calendario.PoaCalendario.IdCalendario.ToString());

            }

            else
            {
                messages = string.Join("; ", ModelState.Values
                                             .SelectMany(x => x.Errors)
                                             .Select(x => x.ErrorMessage));
                // return JsonView(ModelState.IsValid, messages, "Create", poa_Calendario);
                return Json(new { Valid = false, Message = messages });
            }

        }

        public PartialViewResult Edit(int? id)
        {
            if (id == null)
            {
                ModelState.AddModelError("Valor", "id Campo requerido");
            }

            Poa_Calendario poa_Calendario = db.Poa_Calendario.Find(id);

            if (poa_Calendario == null)
            {
                ModelState.AddModelError("Valor", "No existen valores");
            }

            return PartialView(poa_Calendario);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdCalendario,IdCalendarioElemento,IdIndicadores,IdMes,Observacion,Valor,Catalogos_ctMes,Poa_CalendarioElemento,Poa_Indicadores")] Poa_Calendario poa_Calendario)
        {

            Poa_Calendario modelo = new Poa_Calendario();
            modelo = db.Poa_Calendario.Find(poa_Calendario.IdCalendario);
            modelo.Valor = poa_Calendario.Valor;
            List<Poa_Calendario> Calendarizados = new List<Poa_Calendario>();
            Poa_Indicadores indicadores = new Poa_Indicadores();

            Calendarizados = db.Poa_Calendario.Where(c => c.IdIndicadores == poa_Calendario.IdIndicadores && c.Poa_CalendarioElemento.CalendarioElemento == "Programado").ToList();

            string messages = "";
            int registros = Calendarizados.Count();


            indicadores = db.Poa_Indicadores.Find(poa_Calendario.IdIndicadores);

            decimal suma = Calendarizados.Where(x=>x.IdMes!=poa_Calendario.IdMes).Sum(x => x.Valor);

            decimal totalmeta = db.Poa_Indicadores.Find(poa_Calendario.IdIndicadores).MetaAnual;


            if ((suma + poa_Calendario.Valor >= totalmeta))
                ModelState.AddModelError("Valor", "El valor que intenta guardar [" + string.Format("{0:N}", poa_Calendario.Valor) + " ] rebasa la meta anual registrada " + string.Format("{0:N}", totalmeta) + ".");


            if (poa_Calendario.Valor == 0)
                ModelState.AddModelError("Valor", "Campo requerido");

            if (ModelState.IsValid)
            {

                //try
                //{
                   
                //    db.Entry(modelo).State = System.Data.Entity.EntityState.Modified;
                //    db.SaveChanges();
                //}
                //catch (Exception e)
                //{


                //    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                //}




                //return JsonView(ModelState.IsValid, "Se ha grabado la programación exitosamente", null, null, Url.Action("Index", "PoaCalendario"));
                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {

                    try
                    {

                        db.Entry(modelo).State = System.Data.Entity.EntityState.Modified;
                        db.SaveChanges();
                        if (indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_TipoElementoObjetivos.TipoElementoObjetivos == "Actividad")
                        {
                            if (indicadores.IdIndicadorComponente != null)
                            {
                                Poa_Indicadores poaindicadorcomponente = db.Poa_Indicadores.Find(indicadores.IdIndicadorComponente);
                                actualizacalendariocomponente(poaindicadorcomponente, poa_Calendario, "Programado");
                            }
                        }

                    }
                    catch (Exception e)
                    {


                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }
                    scope.Complete();
                
                    return JsonView(ModelState.IsValid, "Se ha grabado la programación exitosamente", null, null, Url.Action("Index", "PoaCalendario"), modelo.IdCalendario.ToString());
                }

            }
            messages = string.Join("; ", ModelState.Values
                                       .SelectMany(x => x.Errors)
                                       .Select(x => x.ErrorMessage));
            
            return JsonView(ModelState.IsValid, messages, "Edit", poa_Calendario);



            
        }
        public void actualizacalendariocomponente(Poa_Indicadores icomponente, Poa_Calendario poacalendario, string elementocalendario)
        {
            List<Poa_Indicadores> ListaIndicadoresActividadAlimentanComponente = db.Poa_Indicadores.Where(x => x.IdIndicadorComponente == icomponente.IdIndicadores).ToList();
            decimal sumavaloresprogramados = 0;
            foreach (var item in ListaIndicadoresActividadAlimentanComponente)
            {
                List<Poa_Calendario> IndicadoresCalendarizados = new List<Poa_Calendario>();
                switch (icomponente.Poa_TipoIndicador.TipoIndicador)
                {
                    case "Incremental":
                        IndicadoresCalendarizados = db.Poa_Calendario.Where(c => c.IdMes <= poacalendario.IdMes && c.IdIndicadores == item.IdIndicadores && c.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).ToList();
                        break;
                    case "Promedio":
                    case "Acumulativo":
                    case "Indice":
                        IndicadoresCalendarizados = db.Poa_Calendario.Where(c => c.IdMes == poacalendario.IdMes && c.IdIndicadores == item.IdIndicadores && c.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).ToList();
                        break;

                }

                sumavaloresprogramados = sumavaloresprogramados + IndicadoresCalendarizados.Sum(x => x.Valor);
            }
            Decimal valorcomponente = 0M;
            switch (icomponente.Poa_TipoIndicador.TipoIndicador)
            {
                case "Incremental":

                    valorcomponente = ((icomponente.LineaBaseNumerador + sumavaloresprogramados) * 100M) / icomponente.MetaAnualDenominador;
                    break;
                case "Promedio":
                case "Acumulativo":
                    valorcomponente = (sumavaloresprogramados / icomponente.MetaAnualDenominador) * 100M;
                    break;
                case "Indice":
                    valorcomponente = (sumavaloresprogramados / icomponente.MetaAnualDenominador);
                    break;

            }
            var poacalendariocomnponente = db.Poa_Calendario.Where(x => x.IdIndicadores == icomponente.IdIndicadores && x.IdMes == poacalendario.IdMes && x.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).FirstOrDefault();
            if (poacalendariocomnponente != null)
            {
                Poa_Calendario modelo2 = new Poa_Calendario();
                modelo2 = db.Poa_Calendario.Find(poacalendariocomnponente.IdCalendario);
                modelo2.Valor = valorcomponente;
                db.Entry(modelo2).State = System.Data.Entity.EntityState.Modified;

            }
            else
            {
                Poa_Calendario poacalendariocomponente = new Poa_Calendario();
                poacalendariocomponente.IdCalendarioElemento = db.Poa_CalendarioElemento.Where(f => f.CalendarioElemento == elementocalendario).FirstOrDefault().IdCalendarioElemento;
                poacalendariocomponente.IdMes = poacalendario.IdMes;
                poacalendariocomponente.IdIndicadores = icomponente.IdIndicadores;
                poacalendariocomponente.Valor = valorcomponente;
                db.Poa_Calendario.Add(poacalendariocomponente);
            }
            db.SaveChanges();

        }


        public ActionResult actualizacalendariocomponentedesdecomponente(int id, string elementocalendario)
        {
            TransactionOptions transactionoptions1 = new TransactionOptions();
            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
            {
                try
                {
                    Poa_Indicadores icomponente = db.Poa_Indicadores.Find(id);
                    var indicadorescalendariocomnponente = db.Poa_Calendario.Where(x => x.IdIndicadores == icomponente.IdIndicadores && x.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).ToList();
                    foreach (var ic in indicadorescalendariocomnponente)
                    {
                        Poa_Calendario modeloic = new Poa_Calendario();
                        modeloic = db.Poa_Calendario.Find(ic.IdCalendario);
                        modeloic.Valor = 0;
                        db.Entry(modeloic).State = System.Data.Entity.EntityState.Modified;
                        db.SaveChanges();
                    }

                    var ListaIndicadoresActividadAlimentanComponente = db.Poa_Indicadores.Where(x => x.IdIndicadorComponente == icomponente.IdIndicadores).Include("Poa_Calendario").ToList();
                    decimal sumavaloresprogramados = 0;
                    var IdMesesAProcesar = (from c in ListaIndicadoresActividadAlimentanComponente
                                            join a in db.Poa_Calendario
                                                 on c.IdIndicadores equals a.IdIndicadores
                                             where a.Poa_CalendarioElemento.CalendarioElemento == "Programado"   
                                            select new
                                            {
                                                a.IdMes
                                            }).Distinct();

                    //List<short> IdMesesAProcesar = ListaIndicadoresActividadAlimentanComponente.Select(x => new short {x.Poa_Calendario.id }).Distinct().ToList();
                    foreach (var mes in IdMesesAProcesar)
                    {
                        sumavaloresprogramados = 0;
                        List<Poa_Calendario> IndicadoresCalendarizados = new List<Poa_Calendario>();

                        foreach (var actividad in ListaIndicadoresActividadAlimentanComponente)
                        {
                            switch (icomponente.Poa_TipoIndicador.TipoIndicador)
                            {
                                case "Incremental":
                                    IndicadoresCalendarizados = db.Poa_Calendario.Where(c => c.IdMes <= mes.IdMes && c.IdIndicadores == actividad.IdIndicadores && c.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).ToList();
                                    break;
                                case "Promedio":
                                case "Acumulativo":
                                case "Indice":
                                    IndicadoresCalendarizados = db.Poa_Calendario.Where(c => c.IdMes == mes.IdMes && c.IdIndicadores == actividad.IdIndicadores && c.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).ToList();
                                    break;

                            }
                            sumavaloresprogramados = sumavaloresprogramados + IndicadoresCalendarizados.Sum(x => x.Valor);

                        }

                        Decimal valorcomponente = 0M;
                        switch (icomponente.Poa_TipoIndicador.TipoIndicador)
                        {
                            case "Incremental":
                                valorcomponente = Math.Round((((icomponente.LineaBaseNumerador + sumavaloresprogramados) * 100M) / icomponente.MetaAnualDenominador),4);
                                break;
                            case "Promedio":
                            case "Acumulativo":
                                valorcomponente = Math.Round((sumavaloresprogramados * 100M / icomponente.MetaAnualDenominador),4);
                                break;
                            case "Indice":
                                valorcomponente = Math.Round(sumavaloresprogramados / icomponente.MetaAnualDenominador, 4);
                                break;

                        }
                        var poacalendariocomnponente = db.Poa_Calendario.Where(x => x.IdIndicadores == icomponente.IdIndicadores && x.IdMes == mes.IdMes && x.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).FirstOrDefault();
                        if (poacalendariocomnponente != null)
                        {
                            Poa_Calendario modelo2 = new Poa_Calendario();
                            modelo2 = db.Poa_Calendario.Find(poacalendariocomnponente.IdCalendario);
                            modelo2.Valor = valorcomponente;
                            db.Entry(modelo2).State = System.Data.Entity.EntityState.Modified;

                        }
                        else
                        {
                            Poa_Calendario poacalendariocomponente = new Poa_Calendario();
                            poacalendariocomponente.IdCalendarioElemento = db.Poa_CalendarioElemento.Where(f => f.CalendarioElemento == elementocalendario).FirstOrDefault().IdCalendarioElemento;
                            poacalendariocomponente.IdMes = mes.IdMes;
                            poacalendariocomponente.IdIndicadores = icomponente.IdIndicadores;
                            poacalendariocomponente.Valor = valorcomponente;
                            db.Poa_Calendario.Add(poacalendariocomponente);
                        }
                        db.SaveChanges();

                    }
                    //decimal sumaelementosprogramadoscomponente = db.Poa_Calendario.Where(x => x.IdIndicadores == icomponente.IdIndicadores && x.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).Select(z=>z.Valor).Sum();
                    //decimal diferenciametaanual = icomponente.MetaAnual - sumaelementosprogramadoscomponente;
                    //if (diferenciametaanual > 0)
                    //{
                    //    Poa_Calendario instanciacalendario = new Poa_Calendario();
                    //    var primermesprogramadocomponente = db.Poa_Calendario.Where(x => x.IdIndicadores == icomponente.IdIndicadores && x.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).FirstOrDefault();
                    //    instanciacalendario = db.Poa_Calendario.Find(primermesprogramadocomponente.IdCalendario);
                    //    instanciacalendario.Valor = instanciacalendario.Valor + diferenciametaanual;
                    //    db.Entry(instanciacalendario).State = System.Data.Entity.EntityState.Modified;
                    //    db.SaveChanges();
                    //}
                    //else
                    //{
                    //    Poa_Calendario instanciacalendario = new Poa_Calendario();
                    //    var primermesprogramadocomponente = db.Poa_Calendario.Where(x => x.IdIndicadores == icomponente.IdIndicadores && x.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).FirstOrDefault();
                    //    instanciacalendario = db.Poa_Calendario.Find(primermesprogramadocomponente.IdCalendario);
                    //    instanciacalendario.Valor = instanciacalendario.Valor + diferenciametaanual;
                    //    db.Entry(instanciacalendario).State = System.Data.Entity.EntityState.Modified;
                    //    db.SaveChanges();
                    //}

                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                scope.Complete();
                return JsonView(ModelState.IsValid, "Se ha grabado la programación del Componente exitosamente", null, null, Url.Action("Index", "PoaCalendario"));

            }
        }
        //public ActionResult actualizacalendariocomponentedesdecomponente(int id, string elementocalendario)
        //{
        //    TransactionOptions transactionoptions1 = new TransactionOptions();
        //    transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
        //    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
        //    {
        //        try
        //        {
        //            Poa_Indicadores icomponente = db.Poa_Indicadores.Find(id);
        //            var indicadorescalendariocomnponente = db.Poa_Calendario.Where(x => x.IdIndicadores == icomponente.IdIndicadores && x.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).ToList();
        //            foreach (var ic in indicadorescalendariocomnponente)
        //            {
        //                Poa_Calendario modeloic = new Poa_Calendario();
        //                modeloic = db.Poa_Calendario.Find(ic.IdCalendario);
        //                db.Entry(modeloic).State = System.Data.Entity.EntityState.Deleted;
        //                db.SaveChanges();
        //            }

        //            //var idprogramado = db.Poa_CalendarioElemento.Where(g => g.CalendarioElemento == "Programado").FirstOrDefault().CalendarioElemento;
        //            //List<Poa_Indicadores> ListaIndicadoresActividadAlimentanComponente = new List<Poa_Indicadores>();
        //            //var ListaIndicadoresActividadAlimentanComponentetempo = db.Poa_Indicadores.Where(x => x.IdIndicadorComponente == icomponente.IdIndicadores  ).Include("Poa_Calendario").ToList();

        //            //foreach (var item in ListaIndicadoresActividadAlimentanComponentetempo)
        //            //{
                        

        //            //    foreach (var progamado in item.Poa_Calendario)
        //            //    {
        //            //        if (progamado.Poa_CalendarioElemento.CalendarioElemento == idprogramado)
        //            //            ListaIndicadoresActividadAlimentanComponente.Add(item);
        //            //    }
                      
        //            //}


        //            var ListaIndicadoresActividadAlimentanComponenteValores = db.Poa_Calendario.Where(x => x.Poa_Indicadores.IdIndicadorComponente == icomponente.IdIndicadores && x.Poa_CalendarioElemento.CalendarioElemento=="Programado").ToList();

        //            var ListaIndicadoresActividadAlimentanComponente = db.Poa_Calendario.Where(x => x.Poa_Indicadores.IdIndicadorComponente == icomponente.IdIndicadores && x.Poa_CalendarioElemento.CalendarioElemento == "Programado").GroupBy(h => new { h.IdCalendarioElemento, h.IdIndicadores, h.IdMes,h.Valor }).Select(t=> new Poa_Calendario {IdCalendario=t.Max(f=> f.IdCalendario),IdCalendarioElemento=t.Key.IdCalendarioElemento,IdMes=t.Key.IdMes,Valor=t.Key.Valor,Observacion="",IdIndicadores=t.Key.IdIndicadores }).ToList();
        //            decimal sumavaloresprogramados = 0;
        //            //var IdMesesAProcesar = (from c in ListaIndicadoresActividadAlimentanComponente
        //            //                        join a in db.Poa_Calendario
        //            //                             on c.IdIndicadores equals a.IdIndicadores
        //            //                        select new
        //            //                        {
        //            //                            a.IdMes
        //            //                        }).Distinct();

        //            List<Int16> IdMesesAProcesar = ListaIndicadoresActividadAlimentanComponente.Select(x => x.IdMes).Distinct().ToList();
        //            foreach (var mes in IdMesesAProcesar)
        //            {
        //                sumavaloresprogramados = 0;
        //                List<Poa_Calendario> IndicadoresCalendarizados = new List<Poa_Calendario>();

        //                foreach (var actividad in ListaIndicadoresActividadAlimentanComponente)
        //                {
        //                    switch (icomponente.Poa_TipoIndicador.TipoIndicador)
        //                    {
        //                        case "Incremental":
        //                            IndicadoresCalendarizados = db.Poa_Calendario.Where(c => c.IdMes <= mes && c.IdIndicadores == actividad.IdIndicadores && c.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).ToList();
        //                            break;
        //                        case "Promedio":
        //                        case "Acumulativo":
        //                        case "Indice":
        //                            IndicadoresCalendarizados = db.Poa_Calendario.Where(c => c.IdMes == mes && c.IdIndicadores == actividad.IdIndicadores && c.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).ToList();
        //                            break;

        //                    }
        //                    sumavaloresprogramados = sumavaloresprogramados + IndicadoresCalendarizados.Sum(x => x.Valor);

        //                }

        //                Decimal valorcomponente = 0M;
        //                switch (icomponente.Poa_TipoIndicador.TipoIndicador)
        //                {
        //                    case "Incremental":
        //                        valorcomponente = ((icomponente.LineaBaseNumerador + sumavaloresprogramados) * 100M) / icomponente.MetaAnualDenominador;
        //                        break;
        //                    case "Promedio":
        //                        valorcomponente = (sumavaloresprogramados * 100M / icomponente.MetaAnualDenominador);
        //                        break;
        //                    case "Acumulativo":
        //                        //valorcomponente = (sumavaloresprogramados / icomponente.MetaAnualDenominador) * 100M;
        //                        valorcomponente = (sumavaloresprogramados * 100M / icomponente.MetaAnualDenominador);
        //                        break;
        //                    case "Indice":
        //                        valorcomponente = Math.Round(sumavaloresprogramados / icomponente.MetaAnualDenominador, 1);
        //                        break;

        //                }
        //                var poacalendariocomnponente = db.Poa_Calendario.Where(x => x.IdIndicadores == icomponente.IdIndicadores && x.IdMes == mes && x.Poa_CalendarioElemento.CalendarioElemento == elementocalendario).FirstOrDefault();
        //                if (poacalendariocomnponente != null)
        //                {
        //                    Poa_Calendario modelo2 = new Poa_Calendario();
        //                    modelo2 = db.Poa_Calendario.Find(poacalendariocomnponente.IdCalendario);
        //                    modelo2.Valor = valorcomponente;
        //                    db.Entry(modelo2).State = System.Data.Entity.EntityState.Modified;

        //                }
        //                else
        //                {
        //                    Poa_Calendario poacalendariocomponente = new Poa_Calendario();
        //                    poacalendariocomponente.IdCalendarioElemento = db.Poa_CalendarioElemento.Where(f => f.CalendarioElemento == elementocalendario).FirstOrDefault().IdCalendarioElemento;
        //                    poacalendariocomponente.IdMes = mes;
        //                    poacalendariocomponente.IdIndicadores = icomponente.IdIndicadores;
        //                    poacalendariocomponente.Valor = valorcomponente;
        //                    db.Poa_Calendario.Add(poacalendariocomponente);
        //                }
        //                db.SaveChanges();

        //            }

        //        }
        //        catch (Exception e)
        //        {


        //            return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
        //        }
        //        scope.Complete();


        //        return Json(new { Valid = true, Message = "Se ha Actualizado la programación del Componente exitosamente. " });
        //        //return JsonView(ModelState.IsValid, "Se ha grabado la programación del Componente exitosamente", null, null, Url.Action("Index", "PoaCalendario"));

        //    }
        //}

    }

}