﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Seguridad;
using System.Net.Mail;

namespace Nova.Controllers.Poa.PoaCalendarioObsTrimestralEstatal
{
    public class PoaCalendarioObservacionTrimestralEstatalController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: PoaCalendarioObservacionTrimestralEstatal
        public ActionResult Index()
        {
            var poa_CalendarioObservacionTrimestralEstatal = db.Poa_CalendarioObservacionTrimestralEstatal.Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Poa_Indicadores).Include(p => p.Poa_Trimestre);


         
            return View(poa_CalendarioObservacionTrimestralEstatal.ToList());
        }

        // GET: PoaCalendarioObservacionTrimestralEstatal/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }            Poa_CalendarioObservacionTrimestralEstatal poa_CalendarioObservacionTrimestralEstatal = db.Poa_CalendarioObservacionTrimestralEstatal.Find(id);
            if (poa_CalendarioObservacionTrimestralEstatal == null)
            {
                return HttpNotFound();
            }
            return View(poa_CalendarioObservacionTrimestralEstatal);
        }

        // GET: PoaCalendarioObservacionTrimestralEstatal/Create
        public ActionResult Create(int id, int idpoatrimestre, int idestructuraprogramaticaestatalactividadaño)
        {
            Poa_CalendarioObservacionTrimestralEstatal model = new Poa_CalendarioObservacionTrimestralEstatal();
            int Ide = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            model.IdIndicadores = id;
            model.IdPoaTrimestre = idpoatrimestre;
            model.IdConvenioLaboralTrabajadorCategoria = Ide;
            model.FechaActualizacion = DateTime.Now;


            decimal SumaTrimestreProgramado = 0;
            decimal SumaTrimestreRealizado = 0;

            var tipoindicador = from a in db.Poa_Indicadores
                                where a.IdIndicadores == id
                                select new { indicador = a.Poa_TipoIndicador.TipoIndicador };

            string indicador = tipoindicador.FirstOrDefault().indicador;

            if (indicador == "Incremental")
            {
                switch (idpoatrimestre)
                {

                    case 1:
                        int[] meses = { 1, 2, 3 };
                        var datosSumaProgramado1 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        var datosSumaRealizado1 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        if (datosSumaProgramado1 != null)
                        {
                            SumaTrimestreProgramado = datosSumaProgramado1.Valor;
                        }

                        if (datosSumaRealizado1 != null)
                        {
                            SumaTrimestreRealizado = datosSumaRealizado1.Valor;
                        }
                        break;
                    case 2:
                        int[] meses2 = { 4, 5, 6 };
                        var datosSumaProgramado2 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        var datosSumaRealizado2 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        if (datosSumaProgramado2 != null)
                        {
                            SumaTrimestreProgramado = datosSumaProgramado2.Valor;
                        }
                        if (datosSumaRealizado2 != null)
                        {
                            SumaTrimestreRealizado = datosSumaRealizado2.Valor;
                        }

                        break;
                    case 3:

                        int[] meses3 = { 7, 8, 9 };
                        var datosSumaProgramado3 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        var datosSumaRealizado3 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        if (datosSumaProgramado3 != null)
                        {
                            SumaTrimestreProgramado = datosSumaProgramado3.Valor;
                        }
                        if (datosSumaRealizado3 != null)
                        {
                            SumaTrimestreRealizado = datosSumaRealizado3.Valor;
                        }

                        break;
                    case 4:
                        int[] meses4 = { 10, 11, 12 };
                        var datosSumaProgramado4 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        var datosSumaRealizado4 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        if (datosSumaProgramado4 != null)
                        {
                            SumaTrimestreProgramado = datosSumaProgramado4.Valor;
                        }
                        if (datosSumaRealizado4 != null)
                        {
                            SumaTrimestreRealizado = datosSumaRealizado4.Valor;
                        }


                        break;

                }
            }
            else
            {
                switch (idpoatrimestre)
                {

                    case 1:
                        int[] meses = { 1, 2, 3 };
                        var datosSumaProgramado1 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño).ToList();
                        var datosSumaRealizado1 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño).ToList();
                        if (datosSumaProgramado1 != null)
                        {
                            SumaTrimestreProgramado = datosSumaProgramado1.Sum(t => t.Valor);
                        }

                        if (datosSumaRealizado1 != null)
                        {
                            SumaTrimestreRealizado = datosSumaRealizado1.Sum(t => t.Valor);
                        }
                        break;
                    case 2:
                        int[] meses2 = { 4, 5, 6 };
                        var datosSumaProgramado2 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño).ToList();
                        var datosSumaRealizado2 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño).ToList();
                        if (datosSumaProgramado2 != null)
                        {
                            SumaTrimestreProgramado = datosSumaProgramado2.Sum(t => t.Valor);
                        }
                        if (datosSumaRealizado2 != null)
                        {
                            SumaTrimestreRealizado = datosSumaRealizado2.Sum(t => t.Valor);
                        }

                        break;
                    case 3:

                        int[] meses3 = { 7, 8, 9 };
                        var datosSumaProgramado3 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño).ToList();
                        var datosSumaRealizado3 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño).ToList();
                        if (datosSumaProgramado3 != null)
                        {
                            SumaTrimestreProgramado = datosSumaProgramado3.Sum(t => t.Valor);
                        }
                        if (datosSumaRealizado3 != null)
                        {
                            SumaTrimestreRealizado = datosSumaRealizado3.Sum(t => t.Valor);
                        }

                        break;
                    case 4:
                        int[] meses4 = { 10, 11, 12 };
                        var datosSumaProgramado4 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño).ToList();
                        var datosSumaRealizado4 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño).ToList();
                        if (datosSumaProgramado4 != null)
                        {
                            SumaTrimestreProgramado = datosSumaProgramado4.Sum(t => t.Valor);
                        }
                        if (datosSumaRealizado4 != null)
                        {
                            SumaTrimestreRealizado = datosSumaRealizado4.Sum(t => t.Valor);
                        }


                        break;

                }

            }
               


            ViewBag.SumaTrimestreProgramado = SumaTrimestreProgramado;
            ViewBag.SumaTrimestreRealizado = SumaTrimestreRealizado;




            var año = from a in db.Poa_Mir
                      join b in db.Poa_Indicadores on a.IdMir equals b.IdMir
                      where b.IdIndicadores == id
                      select new { Año = a.AñoMir };


            //var año = db.Poa_Mir.Join(db.Poa_Indicadores.Where(c=> c.IdIndicadores== id), a=> a.IdMir, b=> b.IdMir, (a,b) => new { año= a.AñoMir});


            short anio = año.FirstOrDefault().Año;
            ViewBag.Año = anio;


            ViewBag.IdIndicadores = id;
            ViewBag.idpoatrimestre = idpoatrimestre;
            ViewBag.idestructuraprogramaticaestatalactividadaño = idestructuraprogramaticaestatalactividadaño; 
            
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdIndicadores = new SelectList(db.Poa_Indicadores, "IdIndicadores", "Denominador");
            ViewBag.IdPoaTrimestre = new SelectList(db.Poa_Trimestre, "IdPoaTrimestre", "Trimestre");
            return PartialView("_Create", model);
        }

        // POST: PoaCalendarioObservacionTrimestralEstatal/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdPoaCalendarioTrimestralEstatal,IdIndicadores,IdPoaTrimestre,IdConvenioLaboralTrabajadorCategoria,Observacion,FechaActualizacion")] Poa_CalendarioObservacionTrimestralEstatal poa_CalendarioObservacionTrimestralEstatal)
        {
            if (ModelState.IsValid)
            {
                db.Poa_CalendarioObservacionTrimestralEstatal.Add(poa_CalendarioObservacionTrimestralEstatal);
                try
                {

                    db.SaveChanges();
                    //return Json(new { Valid = true, Message = "El Area ha sido asignada exitosamente" });
                }
                catch (Exception e)
                {

                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }



                return Json(new { Valid = true, Message = "La Observación han sido agregados exitosamente" });
            }

            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", poa_CalendarioObservacionTrimestralEstatal.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdIndicadores = new SelectList(db.Poa_Indicadores, "IdIndicadores", "Denominador", poa_CalendarioObservacionTrimestralEstatal.IdIndicadores);
            ViewBag.IdPoaTrimestre = new SelectList(db.Poa_Trimestre, "IdPoaTrimestre", "Trimestre", poa_CalendarioObservacionTrimestralEstatal.IdPoaTrimestre);
            return new JsonResult() { Data = "La Observación han sido agregados exitosamente" };
        }

        // GET: PoaCalendarioObservacionTrimestralEstatal/Edit/5
        public ActionResult Edit(int? id ,int idindicador, int idpoatrimestre, int idestructuraprogramaticaestatalactividadaño)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_CalendarioObservacionTrimestralEstatal poa_CalendarioObservacionTrimestralEstatal = db.Poa_CalendarioObservacionTrimestralEstatal.Find(id);
            if (poa_CalendarioObservacionTrimestralEstatal == null)
            {
                return HttpNotFound();
            }
           
            decimal SumaTrimestreProgramado = 0;
            decimal SumaTrimestreRealizado = 0;

            var tipoindicador = from a in db.Poa_Indicadores
                                where a.IdIndicadores == idindicador
                                select new { indicador = a.Poa_TipoIndicador.TipoIndicador };

            string indicador = tipoindicador.FirstOrDefault().indicador;

            if (indicador == "Incremental")
            {
                switch (idpoatrimestre)
                {

                    case 1:
                        int[] meses = { 1, 2, 3 };
                        var datosSumaProgramado1 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        var datosSumaRealizado1 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        if (datosSumaProgramado1 != null)
                        {
                            SumaTrimestreProgramado = datosSumaProgramado1.Valor;
                        }

                        if (datosSumaRealizado1 != null)
                        {
                            SumaTrimestreRealizado = datosSumaRealizado1.Valor;
                        }
                        break;
                    case 2:
                        int[] meses2 = { 4, 5, 6 };
                        var datosSumaProgramado2 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        var datosSumaRealizado2 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        if (datosSumaProgramado2 != null)
                        {
                            SumaTrimestreProgramado = datosSumaProgramado2.Valor;
                        }
                        if (datosSumaRealizado2 != null)
                        {
                            SumaTrimestreRealizado = datosSumaRealizado2.Valor;
                        }

                        break;
                    case 3:

                        int[] meses3 = { 7, 8, 9 };
                        var datosSumaProgramado3 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        var datosSumaRealizado3 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        if (datosSumaProgramado3 != null)
                        {
                            SumaTrimestreProgramado = datosSumaProgramado3.Valor;
                        }
                        if (datosSumaRealizado3 != null)
                        {
                            SumaTrimestreRealizado = datosSumaRealizado3.Valor;
                        }

                        break;
                    case 4:
                        int[] meses4 = { 10, 11, 12 };
                        var datosSumaProgramado4 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        var datosSumaRealizado4 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño && t.Valor > 0).OrderByDescending(b => b.IdMes).FirstOrDefault();
                        if (datosSumaProgramado4 != null)
                        {
                            SumaTrimestreProgramado = datosSumaProgramado4.Valor;
                        }
                        if (datosSumaRealizado4 != null)
                        {
                            SumaTrimestreRealizado = datosSumaRealizado4.Valor;
                        }


                        break;

                }
            }
            else { 
                    switch (idpoatrimestre)
                {

                    case 1:
                        int[] meses = { 1, 2, 3 };
                        var datosSumaProgramado1 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño).ToList();
                        var datosSumaRealizado1 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño).ToList();
                        if (datosSumaProgramado1 != null)
                        {
                            SumaTrimestreProgramado = datosSumaProgramado1.Sum(t => t.Valor);
                        }

                        if (datosSumaRealizado1 != null)
                        {
                            SumaTrimestreRealizado = datosSumaRealizado1.Sum(t => t.Valor);
                        }
                        break;
                    case 2:
                        int[] meses2 = { 4, 5, 6 };
                        var datosSumaProgramado2 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño).ToList();
                        var datosSumaRealizado2 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses2.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño).ToList();
                        if (datosSumaProgramado2 != null)
                        {
                            SumaTrimestreProgramado = datosSumaProgramado2.Sum(t => t.Valor);
                        }
                        if (datosSumaRealizado2 != null)
                        {
                            SumaTrimestreRealizado = datosSumaRealizado2.Sum(t => t.Valor);
                        }

                        break;
                    case 3:

                        int[] meses3 = { 7, 8, 9 };
                        var datosSumaProgramado3 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño).ToList();
                        var datosSumaRealizado3 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses3.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño).ToList();
                        if (datosSumaProgramado3 != null)
                        {
                            SumaTrimestreProgramado = datosSumaProgramado3.Sum(t => t.Valor);
                        }
                        if (datosSumaRealizado3 != null)
                        {
                            SumaTrimestreRealizado = datosSumaRealizado3.Sum(t => t.Valor);
                        }

                        break;
                    case 4:
                        int[] meses4 = { 10, 11, 12 };
                        var datosSumaProgramado4 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Programado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño).ToList();
                        var datosSumaRealizado4 = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(t => meses4.Contains(t.IdMes) && t.Poa_CalendarioElemento.CalendarioElemento == "Realizado" && t.IdEstructuraProgramaticaEstatalActividadAño == idestructuraprogramaticaestatalactividadaño).ToList();
                        if (datosSumaProgramado4 != null)
                        {
                            SumaTrimestreProgramado = datosSumaProgramado4.Sum(t => t.Valor);
                        }
                        if (datosSumaRealizado4 != null)
                        {
                            SumaTrimestreRealizado = datosSumaRealizado4.Sum(t => t.Valor);
                        }


                        break;

                }
            }

            ViewBag.SumaTrimestreProgramado = SumaTrimestreProgramado;
            ViewBag.SumaTrimestreRealizado = SumaTrimestreRealizado;




            var año = from a in db.Poa_Mir
                      join b in db.Poa_Indicadores on a.IdMir equals b.IdMir
                      where b.IdIndicadores == idindicador
                      select new { Año = a.AñoMir };


            //var año = db.Poa_Mir.Join(db.Poa_Indicadores.Where(c=> c.IdIndicadores== id), a=> a.IdMir, b=> b.IdMir, (a,b) => new { año= a.AñoMir});


            short anio = año.FirstOrDefault().Año;
            ViewBag.Año = anio;





            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", poa_CalendarioObservacionTrimestralEstatal.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdIndicadores = new SelectList(db.Poa_Indicadores, "IdIndicadores", "Denominador", poa_CalendarioObservacionTrimestralEstatal.IdIndicadores);
            ViewBag.IdPoaTrimestre = new SelectList(db.Poa_Trimestre, "IdPoaTrimestre", "Trimestre", poa_CalendarioObservacionTrimestralEstatal.IdPoaTrimestre);
            return View(poa_CalendarioObservacionTrimestralEstatal);
        }

        // POST: PoaCalendarioObservacionTrimestralEstatal/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdPoaCalendarioTrimestralEstatal,IdIndicadores,IdPoaTrimestre,IdConvenioLaboralTrabajadorCategoria,Observacion,FechaActualizacion")] Poa_CalendarioObservacionTrimestralEstatal poa_CalendarioObservacionTrimestralEstatal)
        {
            if (ModelState.IsValid)
            {

                try 
                {
                    poa_CalendarioObservacionTrimestralEstatal.FechaActualizacion = DateTime.Now;
                    db.Entry(poa_CalendarioObservacionTrimestralEstatal).State = EntityState.Modified;
                    db.SaveChanges();
                    return Json(new { Valid = true, Message = "La observación ha sido modificado exitosamente" });
                
                }

                catch (Exception e)
                {
                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    // all changes will be rolled back
                }

                return Json(new { Valid = true, Message = "La observación ha sido modificado exitosamente" });
            }
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", poa_CalendarioObservacionTrimestralEstatal.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdIndicadores = new SelectList(db.Poa_Indicadores, "IdIndicadores", "Denominador", poa_CalendarioObservacionTrimestralEstatal.IdIndicadores);
            ViewBag.IdPoaTrimestre = new SelectList(db.Poa_Trimestre, "IdPoaTrimestre", "Trimestre", poa_CalendarioObservacionTrimestralEstatal.IdPoaTrimestre);
            string messages = string.Join("  ", ModelState.Values
                                       .SelectMany(x => x.Errors)
                                       .Select(x => x.ErrorMessage));

            return Json(new { Valid = false, Message = messages });
        }

        // GET: PoaCalendarioObservacionTrimestralEstatal/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_CalendarioObservacionTrimestralEstatal poa_CalendarioObservacionTrimestralEstatal = db.Poa_CalendarioObservacionTrimestralEstatal.Find(id);
            if (poa_CalendarioObservacionTrimestralEstatal == null)
            {
                return HttpNotFound();
            }
            return View(poa_CalendarioObservacionTrimestralEstatal);
        }

        // POST: PoaCalendarioObservacionTrimestralEstatal/Delete/5
         [HttpPost, ActionName("DeleteConfirmed")]
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Poa_CalendarioObservacionTrimestralEstatal poa_CalendarioObservacionTrimestralEstatal = db.Poa_CalendarioObservacionTrimestralEstatal.Find(id);
            db.Poa_CalendarioObservacionTrimestralEstatal.Remove(poa_CalendarioObservacionTrimestralEstatal);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
