﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.Net;
using System.Data.Entity;

namespace Nova.Controllers 
{
    public class PoaPartidasPresupuestalesController : BaseController
    {
        // GET: PoaPartidasPresupuestales
        bdNovaEntities db = new bdNovaEntities();
        public ActionResult Index()
        {
            //return View(db.Poa_Partidas.ToList());
            return View();
        }

        public ActionResult Datos()
        {
            return PartialView(db.Poa_Partidas.ToList());
        }


        public ActionResult Create()
        {
            return PartialView();
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdPartidas,Capitulo,Partida,PartidaEspecifica,PartidaGenerica,Año")] Poa_Partidas poa_Partidas)
        {

            if (ModelState.IsValid)
            {

                try
                {

                    db.Poa_Partidas.Add(poa_Partidas);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }

                return JsonView(ModelState.IsValid, "Se han agregado los datos exitosamente");
            }
            return JsonView(ModelState.IsValid, null, "Create", poa_Partidas);
        }

        // GET: Poa_Partidas/Edit/5
        public PartialViewResult Edit(int id)
        {
            if (id == null)
            {
                throw new System.ArgumentException("Parameter cannot be null", "original");
            }
            Poa_Partidas poa_Partidas = db.Poa_Partidas.Find(id);
            if (poa_Partidas == null)
            {
                ModelState.AddModelError("Valor", "modelo vacío");
            }
            return PartialView(poa_Partidas);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdPartidas,Capitulo,Partida,PartidaEspecifica,PartidaGenerica,Año")] Poa_Partidas poa_Partidas)
        {

            if (ModelState.IsValid)
            {

                try
                {

                    db.Entry(poa_Partidas).State = EntityState.Modified;
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }



                return JsonView(ModelState.IsValid, "Se han actualizado los datos exitosamente");
            }
            return JsonView(ModelState.IsValid, null, "Edit", poa_Partidas);
        }
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return Json(new { success = true, msj = "Error al intentar borrar el Id: vacío", JsonRequestBehavior.AllowGet });
            }
            Poa_Partidas poa_Partidas = db.Poa_Partidas.Find(id);
            if (poa_Partidas == null)
            {
                return HttpNotFound();
            }
            return View(poa_Partidas);
        }
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Poa_Partidas poa_Partidas = db.Poa_Partidas.Find(id);
            if (ModelState.IsValid)
            {


                try
                {


                    db.Poa_Partidas.Remove(poa_Partidas);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return JsonView(ModelState.IsValid, "Registro eliminado exitosamente");
            }

            return JsonView(ModelState.IsValid, null, "Delete", poa_Partidas);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }

    }
}