﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.IO;
using System.Transactions;
//using Excel = Microsoft.Office.Interop.Excel;
using ExcelDataReader;



namespace Nova.Controllers.POA.PartidasClase
{
    public class PoaPartidasController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: Partidas
        public ActionResult Index()
        {

            return View(db.Poa_Partidas.Where(a => a.Año == db.Poa_SistemaAñoVigente.FirstOrDefault().Año).ToList());
        }

        [HttpPost]
        public ActionResult Importar(HttpPostedFileBase upload)
        {
            if (upload == null && upload.ContentLength < 0)
                throw new SystemException("Debe seleccionar un archivo.");

            // ExcelDataReader works with the binary Excel file, so it needs a FileStream
            // to get started. This is how we avoid dependencies on ACE or Interop:
            System.IO.Stream stream = upload.InputStream;
            // We return the interface, so that
            IExcelDataReader reader = null;

            if (upload.FileName.EndsWith(".xls"))
            {
                reader = ExcelReaderFactory.CreateBinaryReader(stream);
            }
            else if (upload.FileName.EndsWith(".xlsx"))
            {
                reader = ExcelReaderFactory.CreateOpenXmlReader(stream);
            }
            else
            {
                //ModelState.AddModelError("File", "Formato de archivo no soportado. ");
                throw new HttpException((int)System.Net.HttpStatusCode.Forbidden, "Formato de archivo no soportado. ");
            }
            //reader.IsFirstRowAsColumnNames = true;

            //DataSet result = new DataSet();

            List<Poa_Partidas> list = new List<Poa_Partidas>();
            int contador = 0;
            while (reader.Read())
            {
                if (contador == 0)
                    reader.Read();
                Poa_Partidas newlist = new Poa_Partidas();

                //newlist.IdPartidas = System.Convert.ToInt16(reader.GetValue(0));
                newlist.Concepto = System.Convert.ToString(reader.GetValue(0));
                newlist.Capitulo = System.Convert.ToString(reader.GetValue(1));
                newlist.Partida = System.Convert.ToString(reader.GetValue(2));
                newlist.PartidaEspecifica = System.Convert.ToString(reader.GetValue(3));
                newlist.PartidaGenerica = System.Convert.ToString(reader.GetValue(4));
                newlist.Año = System.Convert.ToInt16(reader.GetValue(5));


                list.Add(newlist);

                contador++;
            }
            reader.Close();

            if (list.Count() <= 0)
                throw new HttpException((int)System.Net.HttpStatusCode.Forbidden, "Error al cargar los datos. Probablemente el archivo este vací ");

            try
            {
                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {

                    //eliminar el conjunto de datos
                    db.Poa_Partidas.RemoveRange(db.Poa_Partidas.Where(x => x.Año == db.Poa_SistemaAñoVigente.FirstOrDefault().Año));

                    //gurdar datos en base de datos
                    db.Poa_Partidas.AddRange(list);
                    db.SaveChanges();

                    scope.Complete();

                }
            }
            catch (Exception e)
            {
                throw new HttpException((int)System.Net.HttpStatusCode.Forbidden, "Error al cargar los datos: " + e.ToString());
            }

            return View(db.Poa_Partidas.Where(a => a.Año == db.Poa_SistemaAñoVigente.FirstOrDefault().Año).ToList());
        }


        // GET: Partidas/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Partidas poa_Partidas = db.Poa_Partidas.Find(id);
            if (poa_Partidas == null)
            {
                return HttpNotFound();
            }
            return View(poa_Partidas);
        }

        // GET: Partidas/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: Partidas/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdPartidas,Capitulo,Partida,PartidaEspecifica,PartidaGenerica,Año")] Poa_Partidas poa_Partidas)
        {
            if (ModelState.IsValid)
            {
                db.Poa_Partidas.Add(poa_Partidas);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(poa_Partidas);
        }

        // GET: Partidas/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Partidas poa_Partidas = db.Poa_Partidas.Find(id);
            if (poa_Partidas == null)
            {
                return HttpNotFound();
            }
            return View(poa_Partidas);
        }

        // POST: Partidas/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdPartidas,Capitulo,Partida,PartidaEspecifica,PartidaGenerica,Año")] Poa_Partidas poa_Partidas)
        {
            if (ModelState.IsValid)
            {
                db.Entry(poa_Partidas).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(poa_Partidas);
        }

        // GET: Partidas/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_Partidas poa_Partidas = db.Poa_Partidas.Find(id);
            if (poa_Partidas == null)
            {
                return HttpNotFound();
            }
            return View(poa_Partidas);
        }

        // POST: Partidas/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Poa_Partidas poa_Partidas = db.Poa_Partidas.Find(id);
            db.Poa_Partidas.Remove(poa_Partidas);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
