﻿using Dapper;
using Nova.Libraries;
using Nova.Models;
using Rotativa;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.Poa.Mir
{
    public class PoaDenominacionProyectoController : Controller
    {

        string query = @"select (c.Numero) Numero, max(c.Proyecto) Proyecto, max(a.ResumenNarrativo) ResumenNarrativo, max(d.TipoElementoObjetivos ) TipoElementoObjetivos
,max(b.IdProyectoArbol)IdProyectoArbol,max(b.IdPadreElementoObjetivos) IdPadreElementoObjetivos, max(a.AñoMir) Año
from poa_mir a 
inner join Poa_ProyectoArbol b on b.IdProyectoArbol = a.IdProyectoArbol
inner join Poa_Proyectos c on c.IdProyectos = b.IdProyectos
inner join Poa_TipoElementoObjetivos d on d.IdTipoElementoObjetivos = b.IdTipoElementoObjetivos
inner join Poa_ProyectosAño e on e.idProyectos = c.idProyectos and a.AñoMir = @anio
where a.IdMirEstatus=(select IdMirEstatus from [Poa_MirEstatus] where EstatusMir='Indicadores Autorizados')
group by c.Numero, a.IdMir
order by c.Numero asc, Max(d.OrdenMir)";

        bdNovaEntities db = new bdNovaEntities();
        // GET: PoaDenominacionProyecto
        public ActionResult Index()
        {
            var años = db.Poa_ProyectosAño.GroupBy(s => s.AñoProyectos).Select(t=>t.Key).ToList();
            ViewBag.Anios = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });
            return View();
        }

        public ActionResult DenominacionProyectoView(Int16 anio)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
                                                    
            var result = (List<DenominacionProyecto>)dp.connection.Query<DenominacionProyecto>(query, new { anio });
            dp.Close();

            return PartialView("_DenominacionProyecto", result);

        }
        public ActionResult DenominacionProyecto()
        {

            Int16 anio = System.Convert.ToInt16(Request["anios"]);
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            var result = (List<DenominacionProyecto>)dp.connection.Query<DenominacionProyecto>(query, new { anio });
            dp.Close();

            string modalidad = "Poa_DenominacionProyecto" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 10;
            m.Left = 20;
            m.Right = 5;
            m.Top = 0;


            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


        }

    }
}