﻿using System;
using System.Collections.Generic;
 
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Poa.MetasEstatales
{
    public class PoaMetasEstatalesMesesController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        //// GET: PoaMetasEstatalesMeses
        //public ActionResult Index()
        //{
        //    var poa_EstructuraProgramaticaEstatalActividadAñoMetas = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Include(p => p.Catalogos_ctMes).Include(p => p.Poa_EstructuraProgramaticaEstatalActividadAño);
        //    return View(poa_EstructuraProgramaticaEstatalActividadAñoMetas.ToList());
        //}

        //// GET: PoaMetasEstatalesMeses/Details/5
        //public ActionResult Details(int? id)
        //{
        //    if (id == null)
        //    {
        //        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        //    }
        //    Poa_EstructuraProgramaticaEstatalActividadAñoMetas poa_EstructuraProgramaticaEstatalActividadAñoMetas = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Find(id);
        //    if (poa_EstructuraProgramaticaEstatalActividadAñoMetas == null)
        //    {
        //        return HttpNotFound();
        //    }
        //    return View(poa_EstructuraProgramaticaEstatalActividadAñoMetas);
        //}

        // GET: PoaMetasEstatalesMeses/Create
        public ActionResult Create(int id,short mes)
        {

            var metas = db.Poa_EstructuraProgramaticaEstatalActividadAño.Find(id);

            //if metas.Poa_EstructuraProgramaticaEstatal.Poa_Mir.Poa_Indicadores.FirstOrDefault().Poa_FrecuenciaMedicionIndicador.FrecuenciaMedicion

            var registros = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(d => d.IdEstructuraProgramaticaEstatalActividadAño == id).ToList();

            

            bool hayerror = false;
            //string msjError = "Estimado usuario, una vez completado este registro, la meta estatal se dará por terminada, por lo que ya no podra hacer modificaciones";
            //switch (metas.Poa_EstructuraProgramaticaEstatal.Poa_Mir.Poa_Indicadores.FirstOrDefault().Poa_FrecuenciaMedicionIndicador.FrecuenciaMedicion)
            //{
            //    case "Anual":
            //        if (registros.Count == 0)
            //        {
            //            hayerror = true;

            //        }
            //        break;

            //    case "Semestral":
            //        if (registros.Count == 5)
            //        {
            //            hayerror = true;

            //        }
            //        break;

            //    case "Trimestral":
            //        if (registros.Count == 3)
            //        {
            //            hayerror = true;

            //        }
            //        break;

            //    case "Mensual":
            //        if (registros.Count == 11)
            //        {
            //            hayerror = true;

            //        }
            //        break;
            //}

           

            ViewBag.HayError = false;

            Poa_EstructuraProgramaticaEstatalActividadAñoMetas model = new Poa_EstructuraProgramaticaEstatalActividadAñoMetas();
            model.IdEstructuraProgramaticaEstatalActividadAño = id;
            model.IdMes = mes;
            return View(model);
        }

        // POST: PoaMetasEstatalesMeses/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdEstructuraProgramaticaEstatalActividadAñoMetas,IdEstructuraProgramaticaEstatalActividadAño,IdMes,Valor")] Poa_EstructuraProgramaticaEstatalActividadAñoMetas poa_EstructuraProgramaticaEstatalActividadAñoMetas)
        {
            poa_EstructuraProgramaticaEstatalActividadAñoMetas.IdCalendarioElemento = db.Poa_CalendarioElemento.Where(t => t.CalendarioElemento == "Programado").FirstOrDefault().IdCalendarioElemento;
            poa_EstructuraProgramaticaEstatalActividadAñoMetas.IdConvenioLaboralTrabajadorCategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            poa_EstructuraProgramaticaEstatalActividadAñoMetas.FechaUltimaModificacion = DateTime.Now;


            if (ModelState.IsValid)
            {
                var metas=db.Poa_EstructuraProgramaticaEstatalActividadAño.Find(poa_EstructuraProgramaticaEstatalActividadAñoMetas.IdEstructuraProgramaticaEstatalActividadAño);

                //if metas.Poa_EstructuraProgramaticaEstatal.Poa_Mir.Poa_Indicadores.FirstOrDefault().Poa_FrecuenciaMedicionIndicador.FrecuenciaMedicion

                var registros = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(d => d.IdEstructuraProgramaticaEstatalActividadAño == poa_EstructuraProgramaticaEstatalActividadAñoMetas.IdEstructuraProgramaticaEstatalActividadAño).ToList();
                bool hayerror = false;
                //bool ultimameta = false;
                string msjError = "Ya ha terminado de capturar con anterioridad todas su metas , verifique su información";
                //switch (metas.Poa_EstructuraProgramaticaEstatal.Poa_Mir.Poa_Indicadores.FirstOrDefault().Poa_FrecuenciaMedicionIndicador.FrecuenciaMedicion)
                //    {
                //        case "Anual":
                //        if (registros.Count > 0)
                //        {
                //            hayerror = true;

                //        }
                //        if (registros.Count == 0)
                //        { ultimameta = true; }
                //        break;

                //    case "Semestral":
                //        if (registros.Count > 5)
                //        {
                //            hayerror = true;

                //        }
                //        if (registros.Count == 5)
                //        { ultimameta = true; }
                //        break;

                //    case "Trimestral":
                //        if (registros.Count > 3)
                //        {
                //            hayerror = true;

                //        }
                //        if (registros.Count == 3)
                //        { ultimameta = true; }
                //        break;

                //    case "Mensual":
                //        if (registros.Count > 11)
                //        {
                //            hayerror = true;

                //        }
                //        if (registros.Count == 11)
                //        { ultimameta = true; }
                //        break;
                //}


                if ((registros.Sum(g => g.Valor) + poa_EstructuraProgramaticaEstatalActividadAñoMetas.Valor) > metas.Meta)
                {
                    hayerror = true;
                    msjError = "Los valores de las metas capturadas no igualan al valor de la meta establecida, hacen falta: " + (metas.Meta - (registros.Sum(g => g.Valor) + poa_EstructuraProgramaticaEstatalActividadAñoMetas.Valor)).ToString() + " , verifique su información";
                }


                if (hayerror)
                {
                    return Json(new { Valid = false, Message = msjError });
                }
                else
                {
                    db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Add(poa_EstructuraProgramaticaEstatalActividadAñoMetas);


                    try
                    {

                        db.SaveChanges();



                    }
                    catch (Exception e)
                    {


                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }
                }

                return JsonView(ModelState.IsValid, "Se ha grabado la meta estatal exitosamente", null, null, Url.Action("Index", "PoaCalendario"));
            }

            string messages = string.Join("; ", ModelState.Values
                           .SelectMany(x => x.Errors)
                           .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, "Create", poa_EstructuraProgramaticaEstatalActividadAñoMetas);
        }

        // GET: PoaMetasEstatalesMeses/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_EstructuraProgramaticaEstatalActividadAñoMetas poa_EstructuraProgramaticaEstatalActividadAñoMetas = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Find(id);
            if (poa_EstructuraProgramaticaEstatalActividadAñoMetas == null)
            {
                return HttpNotFound();
            }
               return View(poa_EstructuraProgramaticaEstatalActividadAñoMetas);
        }

        // POST: PoaMetasEstatalesMeses/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdEstructuraProgramaticaEstatalActividadAñoMetas,IdEstructuraProgramaticaEstatalActividadAño,IdCalendarioElemento,IdMes,Valor,")] Poa_EstructuraProgramaticaEstatalActividadAñoMetas poa_EstructuraProgramaticaEstatalActividadAñoMetas)
        {
            poa_EstructuraProgramaticaEstatalActividadAñoMetas.IdConvenioLaboralTrabajadorCategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            poa_EstructuraProgramaticaEstatalActividadAñoMetas.FechaUltimaModificacion = DateTime.Now;

            bool hayerror = false;
            string msjError = "";
            var metas = db.Poa_EstructuraProgramaticaEstatalActividadAño.Find(poa_EstructuraProgramaticaEstatalActividadAñoMetas.IdEstructuraProgramaticaEstatalActividadAño);
            var registros = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Where(d => d.IdEstructuraProgramaticaEstatalActividadAño == poa_EstructuraProgramaticaEstatalActividadAñoMetas.IdEstructuraProgramaticaEstatalActividadAño).ToList();

            if (ModelState.IsValid)
            {


                if ((registros.Sum(g => g.Valor) + poa_EstructuraProgramaticaEstatalActividadAñoMetas.Valor) > metas.Meta)
                {
                    hayerror = true;
                    msjError = "Los valores de las metas capturadas no igualan al valor de la meta establecida, hacen falta: " + (metas.Meta - (registros.Sum(g => g.Valor) + poa_EstructuraProgramaticaEstatalActividadAñoMetas.Valor)).ToString() + " , verifique su información";
                }


                if (hayerror)
                {
                    return Json(new { Valid = false, Message = msjError });
                }

                try
                {
                    db.Entry(poa_EstructuraProgramaticaEstatalActividadAñoMetas).State = EntityState.Modified;
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                
            }
            return JsonView(ModelState.IsValid, "Se ha grabado la meta estatal exitosamente", null, null, Url.Action("Index", "PoaCalendario"));
        }

        // GET: PoaMetasEstatalesMeses/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_EstructuraProgramaticaEstatalActividadAñoMetas poa_EstructuraProgramaticaEstatalActividadAñoMetas = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Find(id);
            if (poa_EstructuraProgramaticaEstatalActividadAñoMetas == null)
            {
                return HttpNotFound();
            }
            return View(poa_EstructuraProgramaticaEstatalActividadAñoMetas);
        }

        // POST: PoaMetasEstatalesMeses/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Poa_EstructuraProgramaticaEstatalActividadAñoMetas poa_EstructuraProgramaticaEstatalActividadAñoMetas = db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Find(id);
            db.Poa_EstructuraProgramaticaEstatalActividadAñoMetas.Remove(poa_EstructuraProgramaticaEstatalActividadAñoMetas);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
