﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.POA
{
    public class PoaComprasConsolidadasController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: PoaComprasConsolidadas
        public ActionResult Index()
        {
            var poa_año = db.Poa_SistemaAñoVigente.FirstOrDefault().Año;
            var poa_ComprasConsolidadas = db.Poa_ComprasConsolidadas.Where(a=>a.Año==poa_año).Include(p => p.Catalogos_ctMes);
            return View(poa_ComprasConsolidadas.ToList());
        }

        // GET: PoaComprasConsolidadas/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_ComprasConsolidadas poa_ComprasConsolidadas = db.Poa_ComprasConsolidadas.Find(id);
            if (poa_ComprasConsolidadas == null)
            {
                return HttpNotFound();
            }
            return View(poa_ComprasConsolidadas);
        }

        // GET: PoaComprasConsolidadas/Create
        public ActionResult Create()
        {
            ViewBag.IdMes = new SelectList(db.Catalogos_ctMes, "IdMes", "Mes");
            //ViewBag.IdPartidas = new SelectList(db.Poa_Partidas, "IdPartidas", "Partida");
            
            ViewBag.IdPartidas = new SelectList((from s in db.Poa_Partidas.Where(a=>a.Año == db.Poa_SistemaAñoVigente.FirstOrDefault().Año).ToList() select new { IdPartidas = s.IdPartidas, Partida = s.PartidaGenerica + "|" + s.PartidaEspecifica + "|" + s.Partida }), "IdPartidas", "Partida");

            return View();
        }

        // POST: PoaComprasConsolidadas/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdComprasConsolidadas,Año,IdMes,IdPartidas")] Poa_ComprasConsolidadas poa_ComprasConsolidadas)
        {
            poa_ComprasConsolidadas.Año = db.Poa_SistemaAñoVigente.Select(a => a.Año).FirstOrDefault();
            if (ModelState.IsValid)
            {        
                db.Poa_ComprasConsolidadas.Add(poa_ComprasConsolidadas);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdMes = new SelectList(db.Catalogos_ctMes, "IdMes", "Mes", poa_ComprasConsolidadas.IdMes);

            ViewBag.IdPartidas = new SelectList((from s in db.Poa_Partidas.ToList() select new { IdPartidas=s.IdPartidas, Partida=s.PartidaGenerica +"|"+s.PartidaEspecifica+"|"+s.Partida }), "IdPartidas", "Partida", poa_ComprasConsolidadas.IdPartidas);

            return View(poa_ComprasConsolidadas);
        }

        // GET: PoaComprasConsolidadas/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_ComprasConsolidadas poa_ComprasConsolidadas = db.Poa_ComprasConsolidadas.Find(id);
            if (poa_ComprasConsolidadas == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdMes = new SelectList(db.Catalogos_ctMes, "IdMes", "Mes", poa_ComprasConsolidadas.IdMes);
            ViewBag.IdPartidas = new SelectList((from s in db.Poa_Partidas.ToList() select new { IdPartidas = s.IdPartidas, Partida = s.PartidaGenerica + "|" + s.PartidaEspecifica + "|" + s.Partida }), "IdPartidas", "Partida", poa_ComprasConsolidadas.IdPartidas);

            //ViewBag.IdPartidas = new SelectList(db.Poa_Partidas, "IdPartidas", "Partida", poa_ComprasConsolidadas.IdPartidas);

            return View(poa_ComprasConsolidadas);
        }

        // POST: PoaComprasConsolidadas/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdComprasConsolidadas,Año,IdMes,IdPartidas")] Poa_ComprasConsolidadas poa_ComprasConsolidadas)
        {
            if (ModelState.IsValid)
            {
                db.Entry(poa_ComprasConsolidadas).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdMes = new SelectList(db.Catalogos_ctMes, "IdMes", "Mes", poa_ComprasConsolidadas.IdMes);
            ViewBag.IdPartidas = new SelectList((from s in db.Poa_Partidas.ToList() select new { IdPartidas = s.IdPartidas, Partida = s.PartidaGenerica + "|" + s.PartidaEspecifica + "|" + s.Partida }), "IdPartidas", "Partida", poa_ComprasConsolidadas.IdPartidas);

            //ViewBag.IdPartidas = new SelectList(db.Poa_Partidas, "IdPartidas", "Partida", poa_ComprasConsolidadas.IdPartidas);
            return View(poa_ComprasConsolidadas);
        }

        // GET: PoaComprasConsolidadas/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_ComprasConsolidadas poa_ComprasConsolidadas = db.Poa_ComprasConsolidadas.Find(id);
            if (poa_ComprasConsolidadas == null)
            {
                return HttpNotFound();
            }
            return View(poa_ComprasConsolidadas);
        }

        // POST: PoaComprasConsolidadas/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Poa_ComprasConsolidadas poa_ComprasConsolidadas = db.Poa_ComprasConsolidadas.Find(id);
            db.Poa_ComprasConsolidadas.Remove(poa_ComprasConsolidadas);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
