﻿using Dapper;
using Nova.Libraries;
using Nova.Models;
using Rotativa;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.Poa
{
    public class PoaCalendarioController : BaseController
    {
        bdNovaEntities bd = new bdNovaEntities();
        public ActionResult ReporteTrimestralHtml(int pagenum = 0, int RecordsPerPage = 0, string filter = null)
        {


            if (pagenum == 0)
                pagenum = 1;


            if (RecordsPerPage == 0)
                RecordsPerPage = 10000;


            PoaCalendario poa = new PoaCalendario();


            string modalidad = "Poa_Programacion" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 0;

            PoaMir mir = new PoaMir();
            string usuariorol = mir.setRol();


            // return new ViewAsPdf(poa.getCalendarioInidcadores(0, pagenum, RecordsPerPage, filter, usuariorol)) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


            return View("ReporteTrimestralPdf", poa.getCalendarioInidcadores(0,0, pagenum, RecordsPerPage, filter, usuariorol));

        }
        [HttpPost]
        public ActionResult ConsultarProyectosAnio()
        {
            int año = System.Convert.ToInt32(Request["Anio"]);
            if (año != 0 && año > 2000)
            {

            }
            else
            {
                año = bd.Poa_SistemaAñoVigente.Select(s => s.Año).FirstOrDefault();
            }

            int idusuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            PoaMir rol = new PoaMir();

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"select AñoProyectos as Año from Poa_ProyectosAño group by AñoProyectos order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            ViewBag.Anios = new SelectList(listAños, "Value", "Text", año);

  //          if (rol.EsAdministrador())
  //          {
  //              string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  //inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  //WHERE b.AñoProyectos = @año
  //group by a.Numero, a.Proyecto";

  //              var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año });
  //              ViewBag.Proyectos = proy.Select(x => new SelectListItem()
  //              {
  //                  Value = x.Proyecto,
  //                  Text = x.Numero + " " + x.Proyecto
  //              });


  //              string queryAreas = @" select d.EstructuraOrganica from Poa_Proyectos a 
  //inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  //inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  //inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  //WHERE b.AñoProyectos = @año
  //group by d.EstructuraOrganica";

  //              var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año });
  //              ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });
  //          }
  //          else if (rol.EsMandoMedio())//para saber si es PoaResponsable
  //          {
  //              string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  //inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  //inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  //inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  //inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  //inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  //WHERE f.AñoMir = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  //group by a.Numero, a.Proyecto";

  //              var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
  //              ViewBag.Proyectos = proy.Select(x => new SelectListItem()
  //              {
  //                  Value = x.Proyecto,
  //                  Text = x.Numero + " " + x.Proyecto
  //              });


  //              string queryAreas = @" select d.EstructuraOrganica from Poa_Proyectos a 
  //inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  //inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  //inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  //inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  //inner join Poa_Mir f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  //WHERE f.AñoMir = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  //group by d.EstructuraOrganica";

  //              var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
  //              ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });

  //          }
  //          else if (rol.TieneIndicadoresAsignados(año))
  //          {

  //              string queryProyectos = @"select a.Numero, a.Proyecto from Poa_Proyectos a 
  //inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  //inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  //inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  //inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  //inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  //WHERE b.AñoProyectos = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  //group by a.Numero, a.Proyecto";


  //              var proy = (List<Poa_Proyectos>)dp.connection.Query<Poa_Proyectos>(queryProyectos, new { año, idusuario });
  //              ViewBag.Proyectos = proy.Select(x => new SelectListItem()
  //              {
  //                  Value = x.Proyecto,
  //                  Text = x.Numero + " " + x.Proyecto
  //              });


  //              string queryAreas = @"select d.EstructuraOrganica from Poa_Proyectos a 
  //inner join Poa_ProyectosAño b on a.IdProyectos = b.IdProyectos
  //inner join Poa_ProyectosAñoAreas c on c.IdProyectosAño = b.IdProyectosAño
  //inner join Catalogos_ctEstructuraOrganica d on d.IdEstructuraOrganica = c.IdEstructuraOrganica
  //inner join Convenios_stConvenioLaboralTrabajadorCategoria e on e.IdEstructuraOrganica = d.IdEstructuraOrganica
  //inner join Poa_Indicadores f on f.IdConvenioLaboralTrabajadorCategoria = e.IdConvenioLaboralTrabajadorCategoria
  //WHERE b.AñoProyectos = @año and e.IdConvenioLaboralTrabajadorCategoria = @idusuario
  //group by d.EstructuraOrganica";

  //              var areas = (List<string>)dp.connection.Query<string>(queryAreas, new { año, idusuario });
  //              ViewBag.Areas = areas.Select(x => new SelectListItem() { Value = x, Text = x });
  //          }
  //          else
  //          {
  //              var result = "No se encuentra un elmento asociado";
  //              return Json(result, JsonRequestBehavior.AllowGet);
  //          }



            dp.Close();
            return PartialView("_FormListView");
        }

        [HttpGet]
        public ActionResult ReporteTrimestralPdf(int pagenum = 0, int RecordsPerPage = 0, string filter = null)
        {


            if (pagenum == 0)
                pagenum = 1;


            if (RecordsPerPage == 0)
                RecordsPerPage = 10000;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"select AñoProyectos as Año from Poa_ProyectosAño group by AñoProyectos order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            ViewBag.Anios = new SelectList(listAños, "Value", "Text");


            return View();

        }

        [HttpPost]
        public ActionResult ReporteTrimestralPdf(int anios)
        {
            PoaCalendario poa = new PoaCalendario();


            string modalidad = "Poa_Programacion" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 0;

            PoaMir mir = new PoaMir();
            string usuariorol = mir.setRol();


            return new ViewAsPdf("ReporteTrimestralPdf2", poa.getCalendarioInidcadores(0, anios, 1, 10000,null, usuariorol)) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


        }
        [HttpGet]
        public ActionResult ReporteTrimestralActividadPdf(int pagenum = 0, int RecordsPerPage = 0, string filter = null)
        {


            if (pagenum == 0)
                pagenum = 1;


            if (RecordsPerPage == 0)
                RecordsPerPage = 10000;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"select AñoProyectos as Año from Poa_ProyectosAño group by AñoProyectos order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            ViewBag.Anios = new SelectList(listAños, "Value", "Text");


            return View();



        }
        [HttpPost]
        public ActionResult ReporteTrimestralActividadPdf(int anios)
        {




            PoaCalendario poa = new PoaCalendario();


            string modalidad = "Poa_Programacion" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 0;

            PoaMir mir = new PoaMir();
            string usuariorol = mir.setRol();

            var datos = poa.getCalendarioInidcadores(0, anios, 1, 10000, null, usuariorol);
            
            return new ViewAsPdf("ReporteTrimestralActividadPdf2",datos) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            // return View("ReporteTrimestralActividadPdf2", poa.getCalendarioInidcadores(0, anios, 1, 10000, null, usuariorol));


        }

        //public ActionResult ReporteTrimestralPdf(int pagenum = 0, int RecordsPerPage = 0, string filter = null)
        //{


        //    if (pagenum == 0)
        //        pagenum = 1;

        //    if (RecordsPerPage == 0)
        //        RecordsPerPage = 100;

        //    PoaCalendario poa = new PoaCalendario();


        //    string modalidad = "Poa_Programacion" + DateTime.Now.ToShortDateString() + ".pdf";

        //    // return View(model);
        //    Rotativa.Options.Margins m = new Rotativa.Options.Margins();
        //    m.Bottom = 0;
        //    m.Left = 4;
        //    m.Right = 4;
        //    m.Top = 0;

        //    PoaMir mir = new PoaMir();
        //    string usuariorol = mir.setRol();


        //  //  return new ViewAsPdf(poa.getCalendarioInidcadores(0, pagenum, RecordsPerPage, filter, usuariorol)) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

        //    return View("ReporteTrimestralPdf", poa.getCalendarioInidcadores(0, pagenum, RecordsPerPage, filter, usuariorol));
        //    // return View("ReportePdf", poa.getCalendarioInidcadores(pagenum, RecordsPerPage, null, 1));

        //}
        [HttpGet]
        public ActionResult ReporteXls(int pagenum = 0, int RecordsPerPage = 0, string filter = null)
        {


            if (pagenum == 0)
                pagenum = 1;


            if (RecordsPerPage == 0)
                RecordsPerPage = 10000;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"select AñoProyectos as Año from Poa_ProyectosAño group by AñoProyectos order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            ViewBag.Anios = new SelectList(listAños, "Value", "Text");


            return View();

        }
        [HttpPost]
        public ActionResult ReporteXls(int anios)
        {



            PoaCalendario poa = new PoaCalendario();

            string modalidad = "Poa_Programacion" + DateTime.Now.ToShortDateString() + ".xls";

            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidad);


            PoaMir mir = new PoaMir();
            string usuariorol = mir.setRol();

            // return View("_tablacalendarioreporteXls", poa.getCalendarioInidcadores(0, pagenum, RecordsPerPage, null, usuariorol));
            return View("_tablacalendarioreporte", poa.getCalendarioInidcadores(0,anios, 1, 10000, null, usuariorol));

        }
        public ActionResult ReporteHtml(int pagenum = 0, int RecordsPerPage = 0, string filter = null)
        {


            if (pagenum == 0)
                pagenum = 1;


            if (RecordsPerPage == 0)
                RecordsPerPage = 10000;


            PoaCalendario poa = new PoaCalendario();


            string modalidad = "Poa_" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;
            // return new ViewAsPdf(poa.getCalendarioInidcadores(pagenum, RecordsPerPage, null, 1)) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            PoaMir mir = new PoaMir();
            string usuariorol = mir.setRol();

            return View("ReportePdf", poa.getCalendarioInidcadores(0,0, pagenum, RecordsPerPage, filter, usuariorol));

        }
        [HttpGet]
        public ActionResult ReportePdf(int pagenum = 0, int RecordsPerPage = 0, string filter = null)
        {


            if (pagenum == 0)
                pagenum = 1;

            if (RecordsPerPage == 0)
                RecordsPerPage = 100;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string queryAños = @"select AñoProyectos as Año from Poa_ProyectosAño group by AñoProyectos order by 1 desc";

            var años = (List<short>)dp.connection.Query<short>(queryAños);


            var listAños = años.Select(x =>
                                  new SelectListItem()
                                  {
                                      Value = x.ToString(),
                                      Text = x.ToString()
                                  });

            ViewBag.Anios = new SelectList(listAños, "Value", "Text");


            return View();


        }
        [HttpPost]
        public ActionResult ReportePdf(int anios)
        {

            //if (pagenum == 0)
            //    pagenum = 1;

            //if (RecordsPerPage == 0)
            //    RecordsPerPage = 100;

            PoaCalendario poa = new PoaCalendario();


            string modalidad = "Poa_Programacion" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 0;

            PoaMir mir = new PoaMir();
            string usuariorol = mir.setRol();


            //return new ViewAsPdf("ReportePdf2",poa.getCalendarioInidcadores(0, anios, 1, 100, null, usuariorol)) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            return new ViewAsPdf("ReportePdf2", poa.getCalendarioInidcadores(0, anios, 1, 100, null, usuariorol))
            {
                PageSize = Rotativa.Options.Size.Letter,
                PageOrientation = Rotativa.Options.Orientation.Portrait,
                PageMargins = m,
                FileName = modalidad,
                CustomSwitches = "--page-width 279.4 --page-height 215.9 --disable-smart-shrinking --zoom 1.0",
                MinimumFontSize = 8
            };
            // return View("ReportePdf", poa.getCalendarioInidcadores(pagenum, RecordsPerPage, null, 1));

        }

        [HttpPost]
        public ActionResult CerrarPresupuesto(int id)
        {
            var model = bd.Poa_Indicadores.Find(id);
            if (ModelState.IsValid)
            {

                model.PresupuestoCerrado = true;
                bd.Entry(model).State = System.Data.Entity.EntityState.Modified;


                try
                {

                    bd.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }



                return JsonView(ModelState.IsValid, "Se ha cerrado el presupuesto exitosamente", null, null, Url.Action("Index", "PoaCalendario"));
            }
            //return View(poa_ViaticosPasajes);
            string messages = string.Join("; ", ModelState.Values
                            .SelectMany(x => x.Errors)
                            .Select(x => x.ErrorMessage));

            // return JsonView(ModelState.IsValid, messages, "Edit", poa_ViaticosPasajes);
            return Json(new { Valid = false, messages });
        }


        public ActionResult CalendarioPdf(int pagenum = 0, int RecordsPerPage = 0, string filter = null)
        {


            if (pagenum == 0)
                pagenum = 1;

            if (RecordsPerPage == 0)
                RecordsPerPage = 100;

            PoaCalendario poa = new PoaCalendario();


            string modalidad = "Poa_Programacion" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 0;

            PoaMir mir = new PoaMir();
            string usuariorol = mir.setRol();



            if (pagenum == 0)
                pagenum = 1;

            if (RecordsPerPage == 0)
                RecordsPerPage = 10000;


            // return new ViewAsPdf("_tablaCalendario",poa.getCalendarioInidcadores(pagenum, RecordsPerPage, null, usuariorol)) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


            return View("ReportePdf", poa.getCalendarioInidcadores(0,0, pagenum, RecordsPerPage, null, usuariorol));

        }

        public ActionResult getDeleteProgramacion(int id)
        {
            // $(this).parent("li").html("<button class='btn btn-default btn-xs dropdown-toggle' type='button' data-toggle='dropdown'><span class='bold theme-font'>1,00</span> <i class='fa fa-angle-down'></i></button><ul class='dropdown-menu' role='menu'><li><a class='btneditprogramacion' data-id='375' data-mes='8' data-anio='2018' data-resumen='Reuniones de difusión del programa de educación intercultural en BG' data-proyecto='Pertinencia de Planes y Programas de Estudio' href='javascript:void(0);'>Editar</a></li><li><a class='btndeleteprogramacion' data-id='375' href='javascript:void(0);'>Eliminar</a></li></ul>").css("background", "yellow");


            Poa_Calendario calendario = bd.Poa_Calendario.Where(f => f.IdCalendario == id).FirstOrDefault();
            string ulId = calendario.IdIndicadores + "-" + calendario.IdMes;

            string html = @"  <a class='btnaddprogramacion additemcalendar' data-id='" + calendario.IdIndicadores + "' data-mes='" + calendario.IdMes + @"' data-anio='" + calendario.Poa_Indicadores.Poa_Mir.AñoMir + @"' data-resumen='" + calendario.Poa_Indicadores.Indicador + @"' data-proyecto='" + calendario.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_Proyectos.Proyecto + @"' href='javascript:void(0);'>
                                                <i style = 'font-size:9px;color:#c6c6c6;' class='fa fa-plus '></i>
                                            </a>";

            return Json(new { ulId = ulId, html = html }, JsonRequestBehavior.AllowGet);
        }

        public ActionResult getProgramacion(int id, short idmes)
        {
            // $(this).parent("li").html("<button class='btn btn-default btn-xs dropdown-toggle' type='button' data-toggle='dropdown'><span class='bold theme-font'>1,00</span> <i class='fa fa-angle-down'></i></button><ul class='dropdown-menu' role='menu'><li><a class='btneditprogramacion' data-id='375' data-mes='8' data-anio='2018' data-resumen='Reuniones de difusión del programa de educación intercultural en BG' data-proyecto='Pertinencia de Planes y Programas de Estudio' href='javascript:void(0);'>Editar</a></li><li><a class='btndeleteprogramacion' data-id='375' href='javascript:void(0);'>Eliminar</a></li></ul>").css("background", "yellow");

            Poa_Calendario calendario = bd.Poa_Calendario.Where(f => f.IdCalendario == id && f.IdMes == idmes).FirstOrDefault();
            string ulId = calendario.IdIndicadores + "-" + idmes;

            string html = @"  <button class='btn btn-default btn-xs dropdown-toggle' type='button' data-toggle='dropdown' aria-expanded='true'>
                                        <span class='bold theme-font'>" + calendario.Valor + @"</span> <i class='fa fa-angle-down'></i>
                                    </button>
                                    <ul class='dropdown-menu' role='menu'>
                                        <li>
                                            <a class='btneditprogramacion' data-id='" + calendario.IdCalendario + "' data-mes='" + idmes + @"' data-anio='" + calendario.Poa_Indicadores.Poa_Mir.AñoMir + @"' data-resumen='" + calendario.Poa_Indicadores.Indicador + @"' data-proyecto='" + calendario.Poa_Indicadores.Poa_Mir.Poa_ProyectoArbol.Poa_Proyectos.Proyecto + @"' href='javascript:void(0);'>
                                                Editar
                                            </a>
                                        </li>
                                        <li>
                                            <a class='btndeleteprogramacion' data-id='" + calendario.IdCalendario + @"' href='javascript:void(0);'>
                                                Eliminar
                                            </a>
                                        </li>
                                    </ul>";
            return Json(new { ulId = ulId, html = html }, JsonRequestBehavior.AllowGet);
        }

        public ActionResult getDeletePresupuesto(int id)
        {


            Poa_Calendario calendario = bd.Poa_Calendario.Where(f => f.IdCalendario == id).FirstOrDefault();
            string ulId = calendario.IdIndicadores + "-" + calendario.IdMes;

            string html = @"&nbsp;<a class='btnaddpresupuesto additemcalendar' data-id='" + calendario.IdIndicadores + @"' data-mes='" + calendario.IdMes + @"' data-anio='" + calendario.Poa_Indicadores.Poa_Mir.AñoMir + @"' href='javascript:void(0);'><i style='font-size:9px;color:#c6c6c6;' class='fa fa-plus '></i></a>
                                 ";

            return Json(new { ulId = ulId, html = html }, JsonRequestBehavior.AllowGet);
        }

        public ActionResult getPresupuesto(int id, short idmes)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query = @"SELECT a.IdPresupuesto  
       ,  CantidadProducto  
       , a.IdMes  
        , a.IdCalendario  
       , IdProductos  
       , PrecioProducto  
       , Total  
       , IdIndicadores  
 FROM  Poa_Presupuesto a inner join Poa_Calendario b on
            a.IdCalendario = b.IdCalendario  
inner join Poa_CalendarioElemento e on e.IdCalendarioElemento=b.IdCalendarioElemento
    where e.CalendarioElemento ='Presupuesto' and
 b.IdIndicadores in (" + id + ")";

            string ulId = "pres_" + id + "-" + idmes;
            List<Poa_PresupuestoMeses> Poa_PresupuestoelementosMeses = (List<Poa_PresupuestoMeses>)dp.connection.Query<Poa_PresupuestoMeses>(query);



            query = @" SELECT Año from  Poa_SistemaAñoVigente";

            int añoviogente = dp.connection.ExecuteScalar<int>(query);


            dp.Close();
            string html = "";
            if (Poa_PresupuestoelementosMeses.Count == 0)
            {
                html = @" &nbsp;<a class='btnaddpresupuesto additemcalendar' data-id='" + id + @"' data-mes='" + idmes + @"' data-anio='" + añoviogente + "' href='javascript:void(0);'><i style = 'font-size:9px;color:#c6c6c6;' class='fa fa-plus '></i></a>";
            }
            else
            {

                var valor = Poa_PresupuestoelementosMeses.Sum(t => t.Total);
                html = @" &nbsp;
                                        <button class='btn btn-default btn-xs dropdown-toggle' type='button' data-toggle='dropdown' aria-expanded='true'>
                                            <span class='bold theme-font'>" + valor + @"</span> <i class='fa fa-angle-down'></i>
                                        </button>
                                        <ul class='dropdown-menu' role='menu'>
                                            <li>
                                                <a class='btnaddpresupuesto' data-id='" + id + @"' data-mes='" + idmes + @"' href='javascript:void(0);'>
                                                    Editar
                                                </a>
                                            </li>

                                        </ul>";
            }
            return Json(new { ulId = ulId, html = html }, JsonRequestBehavior.AllowGet);
        }


        public ActionResult getViaticos(int id, short idmes)
        {
            // $(this).parent("li").html("<button class='btn btn-default btn-xs dropdown-toggle' type='button' data-toggle='dropdown'><span class='bold theme-font'>1,00</span> <i class='fa fa-angle-down'></i></button><ul class='dropdown-menu' role='menu'><li><a class='btneditprogramacion' data-id='375' data-mes='8' data-anio='2018' data-resumen='Reuniones de difusión del programa de educación intercultural en BG' data-proyecto='Pertinencia de Planes y Programas de Estudio' href='javascript:void(0);'>Editar</a></li><li><a class='btndeleteprogramacion' data-id='375' href='javascript:void(0);'>Eliminar</a></li></ul>").css("background", "yellow");

            List<Poa_ViaticosPasajes> calendario = bd.Poa_ViaticosPasajes.Where(f => f.Poa_Calendario.IdIndicadores == id && f.Poa_Calendario.IdMes == idmes).ToList();
            string ulId = "viat_" + id + "-" + idmes;
            string html = "";
            foreach (var item in calendario)
            {
                html = html + @"<div class='btn-group open'>
                                            <a class='btn btn-default btn-xs' href='#' data-toggle='dropdown' >
                                                <span class='bold theme-font'>V: " + item.TotalViaticos + @" P: " + item.TotalPasaje + @"</span> <i class='fa fa-angle-down'></i>
                                            </a>
                                            <ul class='dropdown-menu bottom-up'>
                                                <li>

                                                    <a class='btnviaticos' data-id='" + item.IdViaticosPasajes + @"' href='javascript:void(0);'>
                                                        <i class='fa fa-edit'></i>  Ver
                                                    </a>
                                                </li>
                                                        <li>
                                                            <a class='btn-vp-delete'  data-mes='" + idmes + @"' data-indicador='" + id + @"' data-id='" + item.IdViaticosPasajes + @"' href='javascript:void(0);'>
                                                                <i class='fa fa-trash-o'></i> Eliminar
                                                            </a>
                                                        </li>

                                                

                                            </ul>
                                        </div>";
            }

            html = html + "<a class='additemcalendar' href='javascript:addviaticos(" + id + ", " + idmes + ");'><i style='font-size:9px;color:#c6c6c6;' class='fa fa-plus '></i></a>&nbsp;";


            return Json(new { ulId = ulId, html = html }, JsonRequestBehavior.AllowGet);
        }

        public ActionResult TechoPresupuestal(int anio)
        {

            PoaMir mir = new PoaMir();
            string usuariorol = mir.setRol();

            PoaCalendario poa = new PoaCalendario();

            return View(poa.getCalendarioInidcadores(0,anio, 0, 10000, null, usuariorol));
        }

  public ActionResult Inicio(int anio=0)
        {
            bdNovaEntities bd = new bdNovaEntities();
            PoaMir mir = new PoaMir();
            string usuariorol = mir.setRol();
            PoaCalendario poa = new PoaCalendario();


            if (anio == 0)
            {
                if (!Request.IsAjaxRequest())
                    anio = System.Convert.ToInt32(Request["anio"]);

            }


            string ctrl = Request.QueryString["hfctrlcalendar"];

            var ListAños = bd.Poa_Mir.GroupBy(s => s.AñoMir).Select(t => new SelectListItem
            {
                Text = t.Key.ToString(),
                Value = t.Key.ToString()
            });

            if (anio == 0)
            {
                ViewBag.AñoDefault = bd.Poa_SistemaAñoVigente.FirstOrDefault().Año;
            }
            else
            {
                ViewBag.AñoDefault = anio;
            }

            ViewBag.SelectAño = new SelectList(ListAños, "Text", "Value");

            var model = poa.getCalendarioInidcadores(0,anio, 1, 10000, null, usuariorol);

          

          
            return View(model);

         
        }       

 public ActionResult calendarioDev(int anio)
        {
            PoaMir mir = new PoaMir();
            string usuariorol = mir.setRol();

            PoaCalendario poa = new PoaCalendario();

            var model = poa.getCalendarioInidcadores(0, anio, 1, 10000, null, usuariorol);
            return PartialView("_calendarioDev", model);
        }

        public ActionResult Index(int id = 0, int anio = 0, int pagenum = 0, int RecordsPerPage = 0, string filter = null)
        {
            if (anio == 0)
            {
                if (!Request.IsAjaxRequest())
                    anio = System.Convert.ToInt32(Request["anio"]);
            }

            string ctrl = Request.QueryString["hfctrlcalendar"];
            if (ctrl == "1")
                id = 0;

            if (pagenum == 0)
                pagenum = 1;

            if (RecordsPerPage == 0)
                RecordsPerPage = 10000;

            PoaMir mir = new PoaMir();
            string usuariorol = mir.setRol();

            // Traemos listado de años desde Poa_Mir
            var ListAños = bd.Poa_Mir
                .GroupBy(s => s.AñoMir)
                .Select(t => new SelectListItem
                {
                    Text = t.Key.ToString(),
                    Value = t.Key.ToString()
                })
                .ToList();

            // Obtenemos el año vigente desde la otra tabla
            int anioVigente = bd.Poa_SistemaAñoVigente.FirstOrDefault().Año;

            // Si no está en la lista, lo agregamos
            if (!ListAños.Any(x => x.Value == anioVigente.ToString()))
            {
                ListAños.Add(new SelectListItem
                {
                    Text = anioVigente.ToString(),
                    Value = anioVigente.ToString()
                });
            }

            // Si no se envió año, usamos el año vigente
            if (anio == 0)
            {
                ViewBag.AñoDefault = anioVigente;
            }
            else
            {
                ViewBag.AñoDefault = anio;
            }

            // Armamos el SelectList ordenado
            ViewBag.SelectAño = new SelectList(ListAños.OrderByDescending(x => x.Value), "Value", "Text", anio == 0 ? anioVigente : anio);

            PoaCalendario poa = new PoaCalendario();
            if (Request.IsAjaxRequest())
            {
                return View("calendarioDev", poa.getCalendarioInidcadores(id, anio, pagenum, RecordsPerPage, filter, usuariorol));
            }
            else
            {
                return View(poa.getCalendarioInidcadores(id, anio, pagenum, RecordsPerPage, filter, usuariorol));
            }
        }



        // GET: PoaCalendario
        //public ActionResult Index(int id = 0,int anio=0, int pagenum = 0, int RecordsPerPage = 0, string filter = null)
        //{
        //    if (anio==0)
        //    {
        //        if (!Request.IsAjaxRequest())
        //            anio = System.Convert.ToInt32(Request["anio"]);

        //    }


        //    string ctrl= Request.QueryString["hfctrlcalendar"];
        //    if (ctrl == "1")
        //        id = 0;

        //    if (pagenum == 0)
        //        pagenum = 1;

        //    if (RecordsPerPage == 0)
        //        RecordsPerPage = 10000;

        //    PoaMir mir = new PoaMir();
        //    string usuariorol = mir.setRol();

        //    var ListAños = bd.Poa_Mir.GroupBy(s => s.AñoMir).Select(t => new SelectListItem
        //    {
        //        Text = t.Key.ToString(),
        //        Value = t.Key.ToString()
        //    });

        //    if (anio == 0)
        //    {
        //        ViewBag.AñoDefault = bd.Poa_SistemaAñoVigente.FirstOrDefault().Año;
        //    }
        //    else
        //    {
        //        ViewBag.AñoDefault = anio;
        //    }

        //    ViewBag.SelectAño = new SelectList(ListAños.OrderByDescending(x=>x.Value), "Text", "Value",anio);

        //    PoaCalendario poa = new PoaCalendario();
        //    if (Request.IsAjaxRequest())
        //    {
        //        return View("calendarioDev", poa.getCalendarioInidcadores(id, anio, pagenum, RecordsPerPage, filter, usuariorol));
        //    }
        //    else
        //        return View(poa.getCalendarioInidcadores(id, anio, pagenum, RecordsPerPage, filter, usuariorol));
        //}

        //public ActionResult Admin(int pagenum = 0, int RecordsPerPage = 0, string filter = null)
        //{


        //    if (pagenum == 0)
        //        pagenum = 1;

        //    if (RecordsPerPage == 0)
        //        RecordsPerPage = 100;

        //    PoaMir mir = new PoaMir();
        //    string usuariorol = mir.setRol();

        //    PoaCalendario poa = new PoaCalendario();
        //    if (Request.IsAjaxRequest())
        //    {
        //        return View("_tablaCalendario", poa.getCalendarioInidcadores(pagenum, RecordsPerPage, filter, usuariorol));
        //    }
        //    else
        //        return View("Index", poa.getCalendarioInidcadores(pagenum, RecordsPerPage, null, usuariorol));
        //}
    }
}