﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.Poa.AsignarUsuario
{
    public class PoaAsignarUsuarioController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();
        // GET: AsignarUsuario
        public ActionResult Index()
        {
            return View();
        }

        public ActionResult AsignarTrabajador(int id)
        {
           return PartialView(db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(id));
        }
        public PartialViewResult BuscarTrabajador(String keyword)
        {
            List<vwDatosAspirantesTrabajadores> auxmodel = new List<vwDatosAspirantesTrabajadores>();
            var model = db.vwDatosAspirantesTrabajadores.Where(t => t.EstatusTrabajador == "ALTA" && t.IdModalidadEstudio == 0);
            var searchWords = keyword.Split(' ').Where(t => !String.IsNullOrWhiteSpace(t));
            keyword = keyword ?? String.Empty;

            if (keyword == "")
                return PartialView(model.OrderBy(x => x.CURP));
            else
            {
                foreach (var item in searchWords)
                {
                    var modelaux = model.Where(x => x.Nombre.Contains(item) || x.ApellidoPaterno.Contains(item) || x.ApellidoMaterno.Contains(item)).ToList();
                    if (modelaux.Count() != 0)
                        auxmodel.AddRange(modelaux.OrderBy(x => x.CURP));
                }
            }

            return PartialView(auxmodel.Distinct());
        }

        public JsonResult BuscarArbolTrabajador(int id)
        {
            var model = db.Poa_ProyectoArbol.Where(p => p.IdProyectoArbol == id).Select(x => new
            {
                Proyecto = x.Poa_Proyectos.Proyecto,
                Nombre = x.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " +
                         x.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                         x.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno,
                FechaCreacion = x.FechaCreacion

            }).ToArray();

            var JsonArbolTrabajador = Json(model, JsonRequestBehavior.AllowGet);

            return JsonArbolTrabajador;
        }
    }
}