﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Data.Entity;
using Nova.Models;
using Seguridad;
using System.Transactions;
using Rotativa;

namespace Nova.Controllers.POA
{
    public class PoaProyectoArbolObjetivosController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();
        // GET: PoaProyectoArbolObjetivos
        public ActionResult Index(int id, int? anio =  0)
        {
			PoaMir rolAdmin = new PoaMir();

            if (rolAdmin.EsAdministrador())
            {
                return RedirectToAction("ArbolAdmin", "PoaProyectoArbolObjetivos", new { id = id, anio = anio});
                    
            }
			
            //  var usuario = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            var usuario = Identidad.Usuario();

            if (usuario.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria != "MANDO MEDIO")
            {
                //throw new ApplicationException("No estas autorizado"); 
            }

            int idProyectoView = id;
            ViewBag.Proyecto = idProyectoView;


            Int16 añoSeleccionado = 0;
            if (anio == 0)
            {
                añoSeleccionado = db.Poa_SistemaAñoVigente.Where(t => t.Año != 0).Select(s => s.Año).FirstOrDefault();
            }else
            {
                añoSeleccionado = (Int16)anio.Value;
            }

            
            ViewBag.Año = añoSeleccionado;

            ViewBag.Usuario = usuario.IdConvenioLaboralTrabajadorCategoria;

            var poa_ProyectoArbol = db.Poa_ProyectoArbol.Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Poa_Proyectos).Include(p => p.Poa_TipoElementoObjetivos).Include(p => p.Poa_TipoElementoProblemas);
            return View(poa_ProyectoArbol.Where(t => t.IdProyectos == idProyectoView && t.AñoArbol == añoSeleccionado && t.EsActividadNueva == false).ToList());


        }

        public ActionResult ArbolAdmin(int id, int? anio = 0)
        {
			PoaMir rolAdmin = new PoaMir();

            if (!rolAdmin.EsAdministrador())
            {
                //throw new ApplicationException("No estas autorizado para realizar esta acción");
                return RedirectToAction("Index", "PoaProyectoArbolObjetivos", new { id = id, anio = anio});
            }
			
            int idProyectoView = id;
            ViewBag.Proyecto = idProyectoView;

            Int16 añoSeleccionado = 0;
            if (anio == 0)
            {
                añoSeleccionado = db.Poa_SistemaAñoVigente.Where(t => t.Año != 0).Select(s => s.Año).FirstOrDefault();
            }
            else
            {
                añoSeleccionado = (Int16)anio.Value;
            }
            
            ViewBag.Año = añoSeleccionado;

           

            var poa_ProyectoArbol = db.Poa_ProyectoArbol.Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Poa_Proyectos).Include(p => p.Poa_TipoElementoObjetivos).Include(p => p.Poa_TipoElementoProblemas);
            return View(poa_ProyectoArbol.Where(t => t.IdProyectos == idProyectoView && t.AñoArbol == añoSeleccionado && t.EsActividadNueva == false).ToList());
        }

        public ActionResult EditNodoObj(Poa_ProyectoArbol poa_ProyectoArbol)
        {
            var values = "";
            var msgs = "";
            Int32 id = System.Convert.ToInt32(Request["idElementArbol"]);
            string Descripcion = System.Convert.ToString(Request["description"]);

            poa_ProyectoArbol = db.Poa_ProyectoArbol.Find(id);

            poa_ProyectoArbol.DescripcionElementoObjetivos = Descripcion;


            if (ModelState.IsValid)
            {
                db.Entry(poa_ProyectoArbol).State = EntityState.Modified;
                db.SaveChanges();

                values = "success";
                msgs = "El elemento se ha editado con exito.";
            }
            else
            {
                values = "error";
                msgs = "Algo va mal!!. No se validaron los datos (Intentelo de nuevo). ";
            }


            var result = new { value = values, msg = msgs };
            return Json(result, JsonRequestBehavior.AllowGet);

        }

        public ActionResult ConvertObjToMir()
        {
            var values = "";
            var msgs = "";
            int proyecto = System.Convert.ToInt32(Request["proyecto"]);
            Int16 añoVigente = db.Poa_SistemaAñoVigente.Where(t => t.Año != 0).Select(s => s.Año).FirstOrDefault();
            List<Poa_ProyectoArbol> poa_ProyectoArbolObj = db.Poa_ProyectoArbol.Where(r => r.IdProyectos == proyecto && r.AñoArbol== añoVigente).ToList();

            List<Poa_Mir> listaMir = new List<Poa_Mir>();
            foreach (var item in poa_ProyectoArbolObj)
            {

                if (item.Poa_TipoElementoObjetivos.Orden != -1)
                {



                    Poa_Mir poa_Mir = new Poa_Mir();
                    poa_Mir.IdConvenioLaboralTrabajadorCategoria = db.Poa_ProyectoArbol.Where(t => t.IdProyectoArbol == item.IdProyectoArbol).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
                    poa_Mir.IdMirEstatus = 1;
                    poa_Mir.IdProyectoArbol = item.IdProyectoArbol;
                    poa_Mir.ResumenNarrativo = db.Poa_ProyectoArbol.Where(t => t.IdProyectoArbol == item.IdProyectoArbol).FirstOrDefault().DescripcionElementoObjetivos;
                    poa_Mir.AñoMir = añoVigente;
                    //if (ModelState.IsValid)
                    //{
                    listaMir.Add(poa_Mir);
                    //}
                    //else
                    //{
                    //    values = "error";
                    //    msgs = "Error al pasar elementos a la MIR";
                    //}
                }
            } 
            try
            {
                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {


                    db.Poa_Mir.AddRange(listaMir);
                    db.SaveChanges();
                    //db.SaveChanges();
                    values = "success"; msgs = "Ejecución terminada con exito.";

                    //cerrar el árbol de problemas
                    Poa_ProyectosAño poa_ProyectosAño = new Poa_ProyectosAño();
                    int idPoryectoAño = db.Poa_ProyectosAño.Where(t => t.IdProyectos == proyecto && t.AñoProyectos== añoVigente).Select(s => s.IdProyectosAño).FirstOrDefault();
                    poa_ProyectosAño = db.Poa_ProyectosAño.Find(idPoryectoAño);

                    poa_ProyectosAño.EsCerradoArbolObjetivos = true;
                    db.Entry(poa_ProyectosAño).State = EntityState.Modified;
                    db.SaveChanges();
                    scope.Complete();

                }
            }
            catch (Exception e)
            {
                values = "error"; msgs = "No se pudo guardar la Mir: "+ e.ToString();
            }



            var result = new { value = values, msg = msgs };
            return Json(result, JsonRequestBehavior.AllowGet);
        }
        public ActionResult ArbolPdf(int id)
        {
            Int16 añoVigente = db.Poa_SistemaAñoVigente.Where(t => t.Año != 0).Select(s => s.Año).FirstOrDefault();
            ViewBag.Año = añoVigente;

            var Proyecto = db.Poa_ProyectoArbol.Where(z => z.IdProyectos == id).FirstOrDefault();
            ViewBag.Proyecto = Proyecto.Poa_Proyectos.Numero + " " + Proyecto.Poa_Proyectos.Proyecto;

            string modalidad = "Poa_ProyectoArbol_Fecha_" + DateTime.Now.ToString("yyyy-MM-dd") + ".pdf";

            // Optimizar la consulta
            var data = db.Poa_ProyectoArbol
                .Where(t => t.IdProyectos == id && t.AñoArbol == añoVigente && t.EsActividadNueva == false)
                .Include(p => p.Poa_Proyectos)
                .Include(p => p.Poa_TipoElementoObjetivos)
                .OrderBy(p => p.Poa_TipoElementoObjetivos.Orden)
                .ToList();

            // Configuración básica para versiones antiguas
            return new ViewAsPdf(data)
            {
                PageSize = Rotativa.Options.Size.Tabloid,
                PageOrientation = Rotativa.Options.Orientation.Landscape,
                PageMargins = new Rotativa.Options.Margins(4, 4, 4, 0), // top, right, bottom, left
                FileName = modalidad
            };
        }

        //public ActionResult ArbolPdf(int id)
        //     {
        //         Int16 añoVigente = db.Poa_SistemaAñoVigente.Where(t => t.Año != 0).Select(s => s.Año).FirstOrDefault();
        //         ViewBag.Año = añoVigente;
        //         var Proyecto = db.Poa_ProyectoArbol.Where(z => z.IdProyectos == id).FirstOrDefault();
        //         ViewBag.Proyecto = Proyecto.Poa_Proyectos.Numero + " " + Proyecto.Poa_Proyectos.Proyecto;
        //         string modalidad = "Poa_ProyectoArbol" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

        //         // return View(model);
        //         Rotativa.Options.Margins m = new Rotativa.Options.Margins();
        //         m.Bottom = 0;
        //         m.Left = 4;
        //         m.Right = 4;
        //         m.Top = 4;

        //         var poa_ProyectoArbol = db.Poa_ProyectoArbol.Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Poa_Proyectos).Include(p => p.Poa_TipoElementoObjetivos).Include(p => p.Poa_TipoElementoProblemas);
        //         //return View(poa_ProyectoArbol.Where(t => t.IdProyectos == id && t.AñoArbol == añoVigente && t.EsActividadNueva == false).ToList());
        //         //return new ViewAsPdf(poa_ProyectoArbol.Where(t => t.IdProyectos == id && t.AñoArbol== añoVigente && t.EsActividadNueva == false).ToList()) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
        //         var data =db.Poa_ProyectoArbol
        //                     .Where(t => t.IdProyectos == id && t.AñoArbol == añoVigente && t.EsActividadNueva == false)
        //                     .Include(p => p.Poa_Proyectos)
        //                     .Include(p => p.Poa_TipoElementoObjetivos)
        //                     .OrderBy(p => p.Poa_TipoElementoObjetivos.Orden)
        //                     .ToList();
        //         return new ViewAsPdf(data)
        //         {
        //             PageSize = Rotativa.Options.Size.Tabloid,
        //             PageOrientation = Rotativa.Options.Orientation.Landscape,
        //             PageMargins = m,
        //             FileName = modalidad
        //         };
        //     }
        public ActionResult ArbolHtml(int id)
        {
            Int16 añoVigente = db.Poa_SistemaAñoVigente.Where(t => t.Año != 0).Select(s => s.Año).FirstOrDefault();
            ViewBag.Año = añoVigente;
            string modalidad = "Poa_ProyectoArbol" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 4;

            var poa_ProyectoArbol = db.Poa_ProyectoArbol.Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Poa_Proyectos).Include(p => p.Poa_TipoElementoObjetivos).Include(p => p.Poa_TipoElementoProblemas);
            return View("ArbolPdf",poa_ProyectoArbol.Where(t => t.IdProyectos == id && t.AñoArbol == añoVigente && t.EsActividadNueva == false).ToList());
            //return new ViewAsPdf(poa_ProyectoArbol.Where(t => t.IdProyectos == id && t.AñoArbol == añoVigente && t.EsActividadNueva == false).ToList()) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
        }
    }
}