﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Seguridad;
using Rotativa;

namespace Nova.Controllers
{
    public class PoaProyectoArbolController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: PoaProyectoArbol
        public ActionResult Index(int id,int? anio=0)
        {

            PoaMir rolAdmin = new PoaMir();

            bool existeMirVigente = false;

            if (rolAdmin.EsAdministrador())
            {
                return RedirectToAction("ArbolAdmin", "PoaProyectoArbol", new { id = id, anio = anio});
                    
            }


            //ViewBag.RolResponsalble = false;
            //if (rolAdmin.EsMandoMedio())
            //{
            //    ViewBag.RolResponsalble = true;
            //}
            //  var usuario = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;



            var usuario = Identidad.Usuario();

           
            //if (usuario.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria != "MANDO MEDIO")
            //{
            //    throw new ApplicationException("No estas autorizado"); 
            //}

            int idProyectoView = id;
            ViewBag.Proyecto = idProyectoView;

            Int16 añoSeleccionado = 0;
            if (anio == 0)
            {
                añoSeleccionado = db.Poa_SistemaAñoVigente.Where(t => t.Año != 0).Select(s => s.Año).FirstOrDefault();
            }
            else
            {
                añoSeleccionado = (Int16)anio.Value;
            }

            var datosMir=db.Poa_Mir.Where(x=>x.AñoMir==añoSeleccionado);

            if (datosMir.Count() > 0) 
            {
                existeMirVigente = true;
            }

            ViewBag.Año = añoSeleccionado;

            ViewBag.Usuario = usuario.IdConvenioLaboralTrabajadorCategoria;

            ViewBag.ExisteMirVigente = existeMirVigente;

           var poa_ProyectoArbol = db.Poa_ProyectoArbol.Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Poa_Proyectos).Include(p => p.Poa_TipoElementoObjetivos).Include(p => p.Poa_TipoElementoProblemas);
            return View(poa_ProyectoArbol.Where(t => t.IdProyectos == idProyectoView && t.AñoArbol== añoSeleccionado && t.EsActividadNueva == false).ToList());
        }

        public ActionResult ArbolAdmin(int id, int? anio=0)
        {
            PoaMir rolAdmin = new PoaMir();

            if (!rolAdmin.EsAdministrador())
            {
                //throw new ApplicationException("No estas autorizado para realizar esta acción");
                return RedirectToAction("Index", "PoaProyectoArbol", new { id = id, anio = anio });
            }

            int idProyectoView = id;
            
            var poa_ProyectoArbol = db.Poa_ProyectoArbol.Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Poa_Proyectos).Include(p => p.Poa_TipoElementoObjetivos).Include(p => p.Poa_TipoElementoProblemas);

            ViewBag.Proyecto = idProyectoView;

            Int16 añoSeleccionado = 0;
            if(anio == 0)
            {
                añoSeleccionado = db.Poa_SistemaAñoVigente.Where(t => t.Año != 0).Select(s => s.Año).FirstOrDefault();
            }else
            {
                añoSeleccionado = (Int16)anio.Value;            }

            
            ViewBag.Año = añoSeleccionado;

            return View(poa_ProyectoArbol.Where(t=>t.IdProyectos == idProyectoView && t.AñoArbol== añoSeleccionado && t.EsActividadNueva == false).ToList());
        }

        [HttpPost]
        public ActionResult CreateNodo(Poa_ProyectoArbol poa_ProyectoArbol)
        {
            var values = "";
            var msgs = "";

            string Descripcion = System.Convert.ToString(Request["description"]);
            Int16 IdPadre = System.Convert.ToInt16(Request["idpadre"]);
            Int16 Proyecto = System.Convert.ToInt16(Request["project"]);
            Int16 TipoElemento = System.Convert.ToInt16(Request["tipop"]);
            Int16 Año = System.Convert.ToInt16(Request["anio"]);
            var usuario = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;


            DateTime thisDay = DateTime.Today;
            DateTime dtC = DateTime.Parse("20/06/2019");

            poa_ProyectoArbol.DescripcionElementoProblemas = Descripcion;
            poa_ProyectoArbol.FechaActualizacion = thisDay.Date;
            poa_ProyectoArbol.FechaCreacion = dtC;
            poa_ProyectoArbol.IdConvenioLaboralTrabajadorCategoria = usuario;
            poa_ProyectoArbol.IdPadreElementoProblemas = IdPadre;
            poa_ProyectoArbol.IdProyectos = Proyecto;
            poa_ProyectoArbol.IdTipoElementoObjetivos = 1;
            poa_ProyectoArbol.IdTipoElementoProblemas = TipoElemento;
            poa_ProyectoArbol.AñoArbol= Año;

            if (Descripcion == "")
                ModelState.AddModelError("", "Campo requerido");
            if (ModelState.IsValid)
            {
                db.Poa_ProyectoArbol.Add(poa_ProyectoArbol);
                db.SaveChanges();
                values = "success";
                msgs = "El elemento se ha creado con exito.";
            }
            else
            {
                values = "error";
                msgs = "Algo va mal!!. No se validaron los datos (Intentelo de nuevo). ";
            }
            //RedirectToAction("Index", "PoaProyectoArbol");
            //return null;
            var result = new { value = values, msg = msgs };
            return Json(result, JsonRequestBehavior.AllowGet);

        }

        [HttpPost]
        public ActionResult EditNodo(Poa_ProyectoArbol poa_ProyectoArbol)
        {
            var values = "";
            var msgs = "";

            
            

            Int32 id = System.Convert.ToInt32(Request["idElementArbol"]);
            string Descripcion = System.Convert.ToString(Request["description"]);

            

            poa_ProyectoArbol = db.Poa_ProyectoArbol.Find(id);



            int IdPadre = db.Poa_ProyectoArbol.Where(a => a.IdProyectoArbol == id).Select(t=>t.IdPadreElementoProblemas).FirstOrDefault();
            Int16 Proyecto = db.Poa_ProyectoArbol.Where(a => a.IdProyectoArbol == id).Select(t => t.IdProyectos).FirstOrDefault();
            Int16 TipoElemento = db.Poa_ProyectoArbol.Where(a => a.IdProyectoArbol == id).Select(t => t.IdTipoElementoProblemas).FirstOrDefault();
            Int16 Año = db.Poa_ProyectoArbol.Where(a => a.IdProyectoArbol == id).Select(t => t.AñoArbol).FirstOrDefault();
            Int32 usuario = db.Poa_ProyectoArbol.Where(a => a.IdProyectoArbol == id).Select(t => t.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
            
           

            DateTime thisDay = DateTime.Today;
            DateTime dtC = db.Poa_ProyectoArbol.Where(a => a.IdProyectoArbol == id).Select(t => t.FechaCreacion).FirstOrDefault();

            poa_ProyectoArbol.DescripcionElementoProblemas = Descripcion;
            poa_ProyectoArbol.FechaActualizacion = thisDay.Date;
            poa_ProyectoArbol.FechaCreacion = dtC;
            poa_ProyectoArbol.IdConvenioLaboralTrabajadorCategoria = usuario;
            poa_ProyectoArbol.IdPadreElementoProblemas = IdPadre;
            poa_ProyectoArbol.IdProyectos = Proyecto;
            poa_ProyectoArbol.IdTipoElementoObjetivos = 1;
            poa_ProyectoArbol.IdTipoElementoProblemas = TipoElemento;
            poa_ProyectoArbol.AñoArbol= Año;



            if (ModelState.IsValid)
            {
                db.Entry(poa_ProyectoArbol).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();

                values = "success";
                msgs = "El elemento se ha editado con exito.";
            }
            else
            {
                values = "error";
                msgs = "Algo va mal!!. No se validaron los datos (Intentelo de nuevo). ";
            }


            var result = new { value = values, msg = msgs };
            return Json(result, JsonRequestBehavior.AllowGet);
        }

        // GET: PoaProyectoArbol/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Poa_ProyectoArbol poa_ProyectoArbol = db.Poa_ProyectoArbol.Find(id);
            if (poa_ProyectoArbol == null)
            {
                return HttpNotFound();
            }
            return View(poa_ProyectoArbol);
        }

        // POST: PoaProyectoArbol/Delete/5
        [HttpPost]
        public ActionResult DeleteConfirmed()
        {
            int id = System.Convert.ToInt32(Request["idProArbol"]);
            string values = "";
            string msgs = "";
            

            List<Int32> poa_ProyectoArbolChild = db.Poa_ProyectoArbol.Where(r => r.IdPadreElementoProblemas == id).Select(t => t.IdProyectoArbol).ToList();
            //poa_ProyectoArbolChild.Add(id);

            if (poa_ProyectoArbolChild.Count() == 0)
            {
                Poa_ProyectoArbol poa_ProyectoArbol = db.Poa_ProyectoArbol.Find(id);
                db.Poa_ProyectoArbol.Remove(poa_ProyectoArbol);
                try
                {
                    db.SaveChanges();
                    values = "success";
                }
                catch (Exception ex)
                {
                    values = "failed";
                    msgs = ex.ToString();
                }
            }
            else
            {
                values = "warning";
                msgs = "El elemento tiene hijos, es necesario borrar sus dependientes para proceder con la acción de borrado.";
            }
            
            
            var result = new { value = values, msg = msgs };
            return Json(result, JsonRequestBehavior.AllowGet);

            
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }

        public ActionResult ConvertProblemToObj(Poa_ProyectoArbol poa_ProyectoArbol)
        {

            string values = "";
            string msgs = "";

            int proyecto = System.Convert.ToInt32(Request["proyecto"]);
            Int16 añoVigente = db.Poa_SistemaAñoVigente.Where(t => t.Año != 0).Select(s => s.Año).FirstOrDefault();

            List<Int32> poa_ProyectoArbolProblem = db.Poa_ProyectoArbol.Where(r => r.IdProyectos == proyecto && r.AñoArbol == añoVigente).Select(t => t.IdProyectoArbol).ToList();

            foreach (var item in poa_ProyectoArbolProblem)
            {
                
                poa_ProyectoArbol = db.Poa_ProyectoArbol.Find(item);

                
                    int IdPadre = db.Poa_ProyectoArbol.Where(a => a.IdProyectoArbol == item).Select(t => t.IdPadreElementoProblemas).FirstOrDefault();
                    Int16 TipoElemento = db.Poa_ProyectoArbol.Where(a => a.IdProyectoArbol == item).Select(t => t.IdTipoElementoProblemas).FirstOrDefault();
                    Int16 Proyecto = db.Poa_ProyectoArbol.Where(a => a.IdProyectoArbol == item).Select(t => t.IdProyectos).FirstOrDefault();
                    Int16 Año = db.Poa_ProyectoArbol.Where(a => a.IdProyectoArbol == item).Select(t => t.AñoArbol).FirstOrDefault();
                    Int32 usuario = db.Poa_ProyectoArbol.Where(a => a.IdProyectoArbol == item).Select(t => t.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                    string Descripcion = db.Poa_ProyectoArbol.Where(t => t.IdProyectoArbol == item).Select(s => s.DescripcionElementoProblemas).FirstOrDefault();

                    Int16 ordenProblemas = db.Poa_TipoElementoProblemas.Where(t => t.IdTipoElementoProblemas == TipoElemento).Select(s => s.Orden).FirstOrDefault();


                    Int16 idTipoElementoObjetivos = db.Poa_TipoElementoObjetivos.Where(t => t.Orden == ordenProblemas).Select(s => s.IdTipoElementoObjetivos).FirstOrDefault();

                    DateTime dtC = db.Poa_ProyectoArbol.Where(a => a.IdProyectoArbol == item).Select(t => t.FechaCreacion).FirstOrDefault();
                    DateTime dtA = db.Poa_ProyectoArbol.Where(a => a.IdProyectoArbol == item).Select(t => t.FechaActualizacion).FirstOrDefault();

                    poa_ProyectoArbol.DescripcionElementoObjetivos = Descripcion;
                    poa_ProyectoArbol.FechaActualizacion = dtA;
                    poa_ProyectoArbol.FechaCreacion = dtC;
                    poa_ProyectoArbol.IdConvenioLaboralTrabajadorCategoria = usuario;
                    poa_ProyectoArbol.IdPadreElementoProblemas = IdPadre;
                    poa_ProyectoArbol.IdPadreElementoObjetivos = IdPadre;
                    poa_ProyectoArbol.IdProyectos = Proyecto;
                    poa_ProyectoArbol.IdTipoElementoObjetivos = idTipoElementoObjetivos;
                    poa_ProyectoArbol.IdTipoElementoProblemas = TipoElemento;
                    poa_ProyectoArbol.AñoArbol= Año;

                    if (ModelState.IsValid)
                    {
                        db.Entry(poa_ProyectoArbol).State = System.Data.Entity.EntityState.Modified;
                    }
                
                
            }

            try
            {
                db.SaveChanges();
                values = "success";
                msgs = "Se ha creado correctamente el arbol de objetivos.";

                //cerrar el árbol de problemas
                Poa_ProyectosAño poa_ProyectosAño = new Poa_ProyectosAño();
                int idPoryectoAño = db.Poa_ProyectosAño.Where(t => t.IdProyectos == proyecto && t.AñoProyectos == añoVigente).Select(s => s.IdProyectosAño).FirstOrDefault();
                poa_ProyectosAño = db.Poa_ProyectosAño.Find(idPoryectoAño);

                poa_ProyectosAño.EsCerradoArbolProblemas = true;
                db.Entry(poa_ProyectosAño).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();

            }
            catch (Exception e)
            {
                values = "error";
                msgs = "" + e.ToString();
            }

            
           
            



            var result = new { value = values , msg = msgs };
            return Json(result, JsonRequestBehavior.AllowGet);
        }

		
		public ActionResult ArbolPdf(int id)
        {
            Int16 añoVigente = db.Poa_SistemaAñoVigente.Where(t => t.Año != 0).Select(s => s.Año).FirstOrDefault();
            ViewBag.Año = añoVigente;
            var Proyecto = db.Poa_ProyectoArbol.Where(z => z.IdProyectos == id).FirstOrDefault();
            ViewBag.Proyecto = Proyecto.Poa_Proyectos.Numero + " " + Proyecto.Poa_Proyectos.Proyecto;
            string modalidad = "Poa_ProyectoArbol" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 4;

            var poa_ProyectoArbol = db.Poa_ProyectoArbol.Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Poa_Proyectos).Include(p => p.Poa_TipoElementoObjetivos).Include(p => p.Poa_TipoElementoProblemas);
            //return View(poa_ProyectoArbol.Where(t => t.IdProyectos == id && t.Año == añoVigente).ToList());
            return new ViewAsPdf(poa_ProyectoArbol.Where(t => t.IdProyectos == id && t.AñoArbol == añoVigente && t.EsActividadNueva == false).ToList()) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
        }

        public ActionResult ArbolHtml(int id)
        {
            Int16 añoVigente = db.Poa_SistemaAñoVigente.Where(t => t.Año != 0).Select(s => s.Año).FirstOrDefault();
            ViewBag.Año = añoVigente;
            string modalidad = "Poa_ProyectoArbol" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 4;

            var poa_ProyectoArbol = db.Poa_ProyectoArbol.Include(p => p.Convenios_stConvenioLaboralTrabajadorCategoria).Include(p => p.Poa_Proyectos).Include(p => p.Poa_TipoElementoObjetivos).Include(p => p.Poa_TipoElementoProblemas);
            return View("ArbolPdf",poa_ProyectoArbol.Where(t => t.IdProyectos == id && t.AñoArbol == añoVigente && t.EsActividadNueva == false).ToList());
            //return new ViewAsPdf(poa_ProyectoArbol.Where(t => t.IdProyectos == id && t.AñoArbol == añoVigente && t.EsActividadNueva == false).ToList()) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
        }
        [HttpPost]
        public ActionResult ValidarElementosNecesarios()
        {
            int id = System.Convert.ToInt32(Request["proyecto"]);
            string values = "";
            string msgs = "";

            Int16 añoVigente = db.Poa_SistemaAñoVigente.Where(t => t.Año != 0).Select(s => s.Año).FirstOrDefault();

            int level_2 = db.Poa_ProyectoArbol.Where(t => t.IdProyectos == id && t.AñoArbol== añoVigente && t.Poa_TipoElementoProblemas.Orden == -2).Count();
            int level_1 = db.Poa_ProyectoArbol.Where(t => t.IdProyectos == id && t.AñoArbol == añoVigente && t.Poa_TipoElementoProblemas.Orden == -1).Count();
            int level0 = db.Poa_ProyectoArbol.Where(t => t.IdProyectos == id && t.AñoArbol== añoVigente && t.Poa_TipoElementoProblemas.Orden == 0).Count();
            int level1 = db.Poa_ProyectoArbol.Where(t => t.IdProyectos == id && t.AñoArbol== añoVigente && t.Poa_TipoElementoProblemas.Orden == 1).Count();

            if (level_2 == 0)
            {
                values = "efailed";
                msgs = "No se ha definido el siguiente elemento:  " + db.Poa_TipoElementoProblemas.Where(t=>t.Orden ==-2).Select(s=>s.TipoElementoProblemas).SingleOrDefault();
            }
            if (level_1 == 0)
            {
                values = "efailed";
                msgs = "No se ha definido el siguiente elemento: " + db.Poa_TipoElementoProblemas.Where(t => t.Orden == -1).Select(s => s.TipoElementoProblemas).SingleOrDefault();
            }
            if (level0 == 0)
            {
                values = "efailed";
                msgs = "No se ha definido el siguiente elemento: " + db.Poa_TipoElementoProblemas.Where(t => t.Orden == 0).Select(s => s.TipoElementoProblemas).SingleOrDefault();
            }
            if (level1 == 0)
            {
                values = "efailed";
                msgs = "No se ha definido el siguiente elemento: " + db.Poa_TipoElementoProblemas.Where(t => t.Orden == 1).Select(s => s.TipoElementoProblemas).SingleOrDefault();
            }

            if (values != "efailed")
            {
                values = "nextsuccess";
            }

            //int level2= db.Poa_ProyectoArbol.Where(t => t.IdProyectos == id && t.Año == añoVigente && t.Poa_TipoElementoProblemas.Orden == -2).Count();

            var result = new { value = values, msg = msgs };
            return Json(result, JsonRequestBehavior.AllowGet);
        }
		
    }
}
