﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Transactions;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers 
{
 
    public class PoaAgregarActividadMIRController : BaseController
    {

        private bdNovaEntities db = new bdNovaEntities();

        public ActionResult Index()
        {

            return View();
        }
        public ActionResult Modal()
        {

            return View();
        }
        public ActionResult Create(int IdMir)
        {

            DateTime Hoy= DateTime.Now;
            
            Poa_Mir mir = db.Poa_Mir.Find(IdMir);

            ProyectoArbolMir model = new ProyectoArbolMir();
         
 

            short Año =(short) mir.AñoMir;
            model.ProyectoNumero = mir.Poa_ProyectoArbol.Poa_Proyectos.Numero.ToString()+"-"+ mir.Poa_ProyectoArbol.Poa_Proyectos.Proyecto;

            model.ProyectoArbol.AñoArbol= Año;
            
            model.ProyectoArbol.IdConvenioLaboralTrabajadorCategoria = mir.IdConvenioLaboralTrabajadorCategoria;
            model.ProyectoArbol.IdPadreElementoObjetivos = mir.IdProyectoArbol;
            model.ProyectoArbol.IdPadreElementoProblemas = mir.IdProyectoArbol;
            model.ProyectoArbol.IdProyectos = mir.Poa_ProyectoArbol.IdProyectos;
            model.ProyectoArbol.IdTipoElementoObjetivos = db.Poa_TipoElementoObjetivos.Where(t => t.TipoElementoObjetivos.Contains("Actividad")).FirstOrDefault().IdTipoElementoObjetivos;
            model.ProyectoArbol.IdTipoElementoProblemas = db.Poa_TipoElementoProblemas.Where(t => t.TipoElementoProblemas.Contains("Consecuencias")).FirstOrDefault().IdTipoElementoProblemas;
            model.ProyectoArbol.EsActividadNueva = true;
            model.ProyectoArbol.FechaActualizacion = Hoy;
            model.ProyectoArbol.FechaCreacion = Hoy;

            return View(model);
           
        }

        [HttpPost]
        public ActionResult Create(ProyectoArbolMir poaProyectoArbolMir)
        {
            //Poa_Mir buscamir = db.Poa_Mir.Where(x=>x.ResumenNarrativo == poaProyectoArbolMir.ResumenNarrativo && x.AñoMir != db.Poa_SistemaAñoVigente.FirstOrDefault().Año).FirstOrDefault();
            //Poa_Mir buscamir = db.Poa_Mir.Where(x => x.ResumenNarrativo == poaProyectoArbolMir.ResumenNarrativo && x.AñoMir != db.Poa_SistemaAñoVigente.FirstOrDefault().Año).FirstOrDefault();

            //if (buscamir != null)

            //    return Json(new { Valid = false, Message = "Error, Ya existe la actividad" });

            Poa_ProyectoArbol poaarbol = new Poa_ProyectoArbol();

            Poa_Mir poamir = new Poa_Mir();
            
            if (ModelState.IsValid)
            {
             using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                {
                    
                     TransactionOptions GrabaActividad = new TransactionOptions();
                GrabaActividad.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, GrabaActividad))
                    {
                        try
                        {

                            poaarbol = poaProyectoArbolMir.ProyectoArbol;
                            poaarbol.DescripcionElementoObjetivos = poaProyectoArbolMir.ResumenNarrativo;
                            poaarbol.DescripcionElementoProblemas = poaProyectoArbolMir.ResumenNarrativo;
                            poamir.ResumenNarrativo = poaProyectoArbolMir.ResumenNarrativo;
                            poamir.IdConvenioLaboralTrabajadorCategoria = poaProyectoArbolMir.ProyectoArbol.IdConvenioLaboralTrabajadorCategoria;
                            poamir.IdMirEstatus = db.Poa_MirEstatus.Where(s => s.EstatusMir.Contains("Actividad Nueva")).FirstOrDefault().IdMirEstatus;

                            //Guardar nueva activiad en el arbol
                            db.Poa_ProyectoArbol.Add(poaarbol);
                            db.SaveChanges();

                            //guardar nueva activida en el la Mir
                            poamir.IdProyectoArbol = poaarbol.IdProyectoArbol;
                            poamir.AñoMir = poaarbol.AñoArbol;
                            db.Poa_Mir.Add(poamir);
                            db.SaveChanges();

                            //Enviar mail a los administradores de nueva actividad
                            PoaMir mir = new PoaMir();
                            mir.NuevaActividadMail(poamir.IdMir);
                        }

                        catch (Exception e)
                        {
                            var mensaje = ExceptionExtensions.GetOriginalException(e).Message;

                            if (mensaje.IndexOf("FK_") > -1)
                                mensaje = "Error al insertar la actividad, valide que no esté duplicada.";
                            return Json(new { Valid = false, Message = mensaje });
                        }

                        scope.Complete();
                }

                } // transaction scope end
             // termina transacción
            return JsonView(true, "Se agregó la actividad exitosamente", null, null, Url.Action("Index", "PoaMir"));
        }
            else
            return Json(new { Valid = false, Message = "Campo Nombre de la actividad. Requerido." });
 

        }

        

        [HttpPost]
        public ActionResult DeleteConfirmed()
        {
            int id = System.Convert.ToInt32(Request["idAct"]);
            string values = "";
            string msgs = "";

          
            TransactionOptions GrabaActividad = new TransactionOptions();
                GrabaActividad.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, GrabaActividad))
                {

                Poa_Mir poamir = db.Poa_Mir.Find(id);

                Poa_ProyectoArbol poa_ProyectoArbol = db.Poa_ProyectoArbol.Find(poamir.IdProyectoArbol);

                int IdProyectoArbol = poamir.IdProyectoArbol;


               

                            try
                            {
                                db.Poa_Mir.Remove(db.Poa_Mir.Find(id));
                                db.Poa_ProyectoArbol.Remove(db.Poa_ProyectoArbol.Find(IdProyectoArbol));
                                db.SaveChanges();
                                values = "success";
                            }

                            catch (Exception e)
                            {
                                values = "failed";
                                    if (e.GetOriginalException().Message.Contains("Poa_Indicadores"))
                                        msgs = "Deberá eliminar antes el indicador correspondiente a la actividad.";
                                            else
                                                msgs = e.GetOriginalException().Message;
                            }

                            scope.Complete();
                }

            var result = new { value = values, msg = msgs };
            return Json(result, JsonRequestBehavior.AllowGet);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    
    }
}
