﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
 
using Nova.Libraries;
using Dapper;

namespace Nova.Controllers.AsignarPlaza
{
    public class PlazasPivotController : Controller
    {
        bdNovaEntities db = new bdNovaEntities();
        public static List<PlazasVacantes> GetPlazasVacantes()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query;

            query = @"select 1 as No, b.Categoria as Plaza, c.EstructuraOrganica as Adscripcion, 
case when a.EsVigente=1 then 'Si'  else 'No' end as EsVigente ,
case when a.EsVacante=1 then 'Si'  else 'No' end as EsVacante,
case when a.EsAutorizada=1 then 'Si'  else 'No' end as EsAutorizada
,x.ApellidoPaterno+'  '+x.ApellidoMaterno+'  '+ x.Nombre as Nombre
from Plazas_stDistribucionPlazaCategoria a
inner join Plazas_ctCategoria b on a.IdCategoria=b.IdCategoria
inner join Catalogos_ctEstructuraOrganica c on a.IdEstructuraOrganica=c.IdEstructuraOrganica
left join vwDatosAspirantesTrabajadores x on x.EstatusTrabajador='ALTA' and x.IdDistribucionPlazaCategoria=a.IdDistribucionPlazaCategoria
";

//            query = @"select b.Categoria as Plaza, c.EstructuraOrganica as Adscripcion, a.EsVigente, a.EsVacante, a.EsAutorizada from Plazas_stDistribucionPlazaCategoria a
//inner join Plazas_ctCategoria b on a.IdCategoria=b.IdCategoria
//inner join Catalogos_ctEstructuraOrganica c on a.IdEstructuraOrganica=c.IdEstructuraOrganica
//where a.EsVacante = 1";




            var t = (List<PlazasVacantes>)dp.connection.Query<PlazasVacantes>(query);

            dp.Close();
            return t;

        }

        // GET: PlazasPivot
        public ActionResult Index()
        {
            List<PlazasVacantes> result = GetPlazasVacantes();

            
            ViewBag.DemoOptions = ViewBag.DemoOptions ?? new PivotGridExportOptions();
            return View(result);
        }
        [HttpPost]
        public ActionResult Index(PivotGridExportOptions options)
        {
            List<PlazasVacantes> result = GetPlazasVacantes();
            if (Request.Params["ExportTo"] == null)
            { // Theme changing
                ViewBag.DemoOptions = options;

                return View(result);
            }

            return PlazasPivot.GetExportActionResult(options, result);
        }

        public ActionResult PlazasVacantesPartialPivot()
        {

            List<PlazasVacantes> result = GetPlazasVacantes();
            return PartialView("_PlazasVacantesPivot", result);
        }


        //public ActionResult ExportPartial()
        //{
        //    return PartialView("ExportPartial", DatosNominaClass.getDatos());
        //}

    }
}