﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class PlantillaNominaPercepcionesController : Controller
    {
        //
        // GET: / PlantillaNominaPercepciones/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvPlantillaNominaPercepciones()
        {
            var model = db.Percepciones_stPlantillaNominaPercepciones;
            return PartialView("_pvPlantillaNominaPercepciones", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvPlantillaNominaPercepcionesAddNew(Nova.Models.Percepciones_stPlantillaNominaPercepciones  item)
        {
            var model = db.Percepciones_stPlantillaNominaPercepciones;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvPlantillaNominaPercepciones", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPlantillaNominaPercepcionesUpdate(Nova.Models.Percepciones_stPlantillaNominaPercepciones item)
        {
            var model = db.Percepciones_stPlantillaNominaPercepciones;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPlantillaNominaPercepcion == item.IdPlantillaNominaPercepcion);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvPlantillaNominaPercepciones", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPlantillaNominaPercepcionesDelete(System.Int16 IdPlantillaNominaPercepcion)
        {
            var model = db.Percepciones_stPlantillaNominaPercepciones;
            if (IdPlantillaNominaPercepcion != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvPlantillaNominaPercepciones", model.ToList());
        }
    }
}
