﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Seguridad;
using System.Net.Mail;
using System.Net;
using Nova.App_Start;

namespace Nova.Controllers
{
    public class PersonalProcesosController : Controller
    {
        bdNovaEntities bd = new bdNovaEntities();
        //
        // GET: /Personal/
        public ActionResult Seguimiento()
        {
            var grupo = bd.Catalogos_ctEstructuraOrganica.GroupBy(q => q.IdEstructuraOrganicaPadre).Select(q => q.Key).ToArray();
            //  var deptos = bd.vwDatosAspirantesTrabajadores.Where(s=> grupo.Contains(s.IdEstructuraOrganicaPadre)).GroupBy(q => q.IdEstructuraOrganica).Select(q => q.Key).ToArray();

            List<vwDatosAspirantesTrabajadores> model = bd.vwDatosAspirantesTrabajadores.Where(q => grupo.Contains((short)q.IdEstructuraOrganicaFisica)).OrderBy(q => q.IdEstructuraOrganica).ToList();
            return View(model);
        }

        [AllowAnonymous]
        [HttpGet]
        public ActionResult ListadoPersonal()
        {
            List<vwDatosAspirantesTrabajadores> model = new List<vwDatosAspirantesTrabajadores>();
            var usuario = Identidad.Usuario();
            short id = Identidad.Usuario().IdEstructuraOrganica;
            short? idModalidad = new bdNovaEntities().vwDatosAspirantesTrabajadores.Where(x => x.IdKardex == usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex).FirstOrDefault().IdModalidadEstudio;
            // short id = 160;
            short nivel = 1000;
            int idConvenioLaboralTrabajadorCategoria = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria convenio = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Find(idConvenioLaboralTrabajadorCategoria);
            //Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria convenio = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Find(Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria);
            if (convenio.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.OrdenEstructuraOrganica >= 1000)
                id = -1;
            //si es menor a 1000 puede ser un jefe
            nivel = (short)convenio.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.OrdenEstructuraOrganica;
            if (idModalidad == 0 && nivel < 5 || idModalidad > 0 && nivel < 13)
                model = bd.vwDatosAspirantesTrabajadores.Where(q => q.IdEstructuraOrganicaFisica == id && q.EstatusTrabajador == "ALTA" && q.RestringirMenu == null && (q.OrdenEstructuraOrganica >= nivel || q.IdConvenioLaboralTrabajadorCategoria == idConvenioLaboralTrabajadorCategoria)).OrderBy(q => q.CURP).ToList();
            //List<vwDatosAspirantesTrabajadores> model = bd.vwDatosAspirantesTrabajadores.Where(q => q.IdEstructuraOrganicaFisica == id && q.EstatusTrabajador == "ALTA" && (q.OrdenEstructuraOrganica > nivel || q.IdConvenioLaboralTrabajadorCategoria == idConvenioLaboralTrabajadorCategoria)).OrderBy(q => q.IdEstructuraOrganica).ToList();
            if (model.Count > 0)
                return View("ListadoPersonal", model);
            else
                return View("vacio");
        }

        [HttpPost]
        [AllowAnonymous]
        [NoCache]
        public ActionResult CompletarProceso(int id)
        {
            Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria usuario = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Find(id);
            Nova.Models.Credenciales model = new Nova.Models.Credenciales();
            MailMessage msg = new MailMessage();

            msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
            model.getEmailAdministradores(ref msg);

            msg.Subject = usuario.Catalogos_ctEstructuraOrganica.EstructuraOrganica + " - Proceso de actualización de información completado";
            msg.IsBodyHtml = true;

            //CredencialesEmailReporte email = new CredencialesEmailReporte();
            PersonalProcesos email = new PersonalProcesos();

            //email = model.EmailReporteSinImpresion(Identidad.Usuario(), 1);

            msg.Body = email.EmailTerminoProceso(usuario);
            // ViewBag.Correo = email.Email;

            SmtpClient client = new SmtpClient();


            client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
            client.Host = "smtp.gmail.com";
            client.Port = 587;
            client.DeliveryMethod = SmtpDeliveryMethod.Network;
            client.EnableSsl = true;
            // client.UseDefaultCredentials = false;

            try
            {
                client.Send(msg);
                PersonalProcesos_Credenciales reporte = new PersonalProcesos_Credenciales();
                reporte.IdConvenioLaboralTrabajadorCategoria = id;
                reporte.FechaTermino = DateTime.Now;
                //reporte.IdConvenioLaboralTrabajadorCategoria = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                //reporte.IdConvenioLaboralTrabajadorCategoriaReporto = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                //reporte.FechaReporte = DateTime.Now;
                //reporte.IdTipoReporte = 1;
                //reporte.TotalReportadas = email.TotalReporte;

                //int idstructuraorganica = Identidad.Usuario().Catalogos_ctEstructuraOrganica.IdEstructuraOrganica;

                //reporte.IdModalidadEstudio = bd.Catalogos_ctEstructuraOrganica.Where(q => q.IdEstructuraOrganica == idstructuraorganica).FirstOrDefault().IdModalidadEstudio;


                bd.Entry(reporte).State = System.Data.Entity.EntityState.Added;
                bd.SaveChanges();

            }
            catch (Exception ex)
            {
                // regresa = false;
                throw new Exception(" Estimado usuario el correo ya ha sido enviado con anterioridad, no es necesario reenviarlo nuevamente");
            }

            return View();
        }


        public ActionResult EnviarRecordatorio(int id, string correo)
        {
            Nova.Models.Convenios_stConvenioLaboralTrabajadorCategoria usuario = bd.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => q.Convenios_stConvenioLaboralTrabajador.IdTrabajador == id).OrderByDescending(e => e.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
            Nova.Models.Credenciales model = new Nova.Models.Credenciales();
            MailMessage msg = new MailMessage();

            msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
            msg.To.Add(correo);
            model.getEmailAdministradores(ref msg);

            msg.Subject = "Recordatorio de actualización de información ";
            msg.IsBodyHtml = true;


            PersonalProcesos email = new PersonalProcesos();


            msg.Body = email.EmailReportarProceso(usuario);


            SmtpClient client = new SmtpClient();


            client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
            client.Host = "smtp.gmail.com";
            client.Port = 587;
            client.DeliveryMethod = SmtpDeliveryMethod.Network;
            client.EnableSsl = true;
            // client.UseDefaultCredentials = false;

            try
            {
                client.Send(msg);


            }
            catch (Exception)
            {
                // regresa = false;
                throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
            }

            return View();
        }

    }
}