﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models.PlantillaNominaPercepciones;


namespace Nova.Controllers.PercepcionesFijas
{
    public class PercepcionesFijasController : Controller
    {
        //
        // GET: /PercepcionesFijas/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        public ActionResult pvPercepcionesFijasDetalle(int? IdPlantillaNomina)
        {
            if (IdPlantillaNomina.HasValue)
            {
                Session["IdPlantillaNomina"] = IdPlantillaNomina;
                return PartialView("_pvPercepcionesFijasDetalle", NorthwindDataProvider.GetInvoices((int)IdPlantillaNomina));
            }
            else
                return RedirectToAction("Index", "PercepcionesFijas");
            
        }

        [ValidateInput(false)]
        public ActionResult pvPercepcionesFijas()
        {
            return PartialView("_pvPercepcionesFijas", NorthwindDataProvider.GetCustomers());
            //var model = db.Nomina_ctPlantillaNomina;
            //return PartialView("_MasterDetailMasterPartial", model.ToList());
            // return PartialView("_MasterDetailMasterPartial", NorthwindDataProvider.GetCustomers());
        }



        //[ValidateInput(false)]
        //public ActionResult pvPercepcionesFijas()
        //{
        //    var model = db.Nomina_ctPlantillaNomina;
        //    return PartialView("_pvPercepcionesFijas", model.ToList());
        //}

        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionesFijasAddNew(Nova.Models.Percepciones_stPlantillaNominaPercepciones item)
        {
            var model = db.Percepciones_stPlantillaNominaPercepciones;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvPercepcionesFijas", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionesFijasUpdate(Nova.Models.Percepciones_stPlantillaNominaPercepciones item)
        {
            var model = db.Percepciones_stPlantillaNominaPercepciones;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPlantillaNominaPercepcion == item.IdPlantillaNominaPercepcion);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvPercepcionesFijas", model.ToList());
        }
        
        
        
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionesFijasDelete(System.Int16 IdPlantillaNominaPercepcion)
        {
            var model = db.Percepciones_stPlantillaNominaPercepciones;
            //var model2= db.Nomina_ctPlantillaNomina;
            if (IdPlantillaNominaPercepcion != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvPercepcionesFijas", model.ToList());
            
        }


        //Botones Percepciones Detalle



        //[ValidateInput(false)]
        //public ActionResult pvDeduccionesFijasDetalle()
        //{
        //    var model = db.Deducciones_stPlantillaNominaDeducciones;
        //    return PartialView("_pvDeduccionesFijasDetalle", model.ToList());
        //}

        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionesFijasDetalleAddNew(Nova.Models.Percepciones_stPlantillaNominaPercepciones item)
        {
            var model = db.Percepciones_stPlantillaNominaPercepciones;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
                return RedirectToAction("Index", "PercepcionesFijas");
            }
            else

            {
                ViewData["EditError"] = "Please, correct all errors.";
                return PartialView("_pvPercepcionesFijasDetalle", model.ToList());
            }
                
            //var model2 = db.Nomina_ctPlantillaNomina;
            //return PartialView("_pvDeduccionesFijas", model2.ToList());
            ////var model2 = db.Nomina_ctPlantillaNomina;
            ////return View("_pvDeduccionesFijas", model2.ToList());
            ////return Html.Action("pvDeduccionesFijas", "DeduccionesFijas")
            

            
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionesFijasDetalleUpdate(Nova.Models.Percepciones_stPlantillaNominaPercepciones item)
        {
            var model = db.Percepciones_stPlantillaNominaPercepciones;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPlantillaNominaPercepcion == item.IdPlantillaNominaPercepcion);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
                return RedirectToAction("Index", "PercepcionesFijas");
            }
            else
            {
                ViewData["EditError"] = "Please, correct all errors.";
                return PartialView("_pvPercepcionesFijasDetalle", model.ToList());
                //return PartialView("_pvDeduccionesFijasDetalle", model.ToList());
            }
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionesFijasDetalleDelete(System.Int16 IdPlantillaNominaPercepcion)
        {
            var model = db.Percepciones_stPlantillaNominaPercepciones;
            if (IdPlantillaNominaPercepcion != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            //return PartialView("_pvDeduccionesFijasDetalle", model.ToList());
            return RedirectToAction("Index", "PercepcionesFijas");
        }

    }


    }







