﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models.PercepcionesCalendarizadas;
using Nova.Models.PlantillaNominaDeducciones;

namespace Nova.Controllers.PercepcionesCalendarizadas
{
    public class PercepcionesCalendarizadasController : Controller
    {
        //
        // GET: /PercepcionesCalendarizadas/

        public ActionResult Index()
        {

            
            return View();
        }


        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        public ActionResult pvPercepcionesCalendarizadasDetalle(int? IdPlantillaNomina)
        {
           
            if (IdPlantillaNomina.HasValue)
            {
           
                Session["IdPlantillaNomina"] = IdPlantillaNomina;
                //ViewData["IdPlantillaNomina"] = IdPlantillaNomina;
                return PartialView("_pvPercepcionesCalendarizadasDetalle", NominaPercepcionesCalendarizadas.GetPercepcionesCalendarizadas((int)IdPlantillaNomina));
            }      
            else
                return RedirectToAction("Index", "PercepcionesCalendarizadas");
            }


        [ValidateInput(false)]
        public ActionResult pvPercepcionesCalendarizadas()
        {
           
            return PartialView("_pvPercepcionesCalendarizadas", NominaPercepcionesCalendarizadas.GetPlantillas2());
            //var model = db.Nomina_ctPlantillaNomina;
            //return PartialView("_MasterDetailMasterPartial", model.ToList());
            // return PartialView("_MasterDetailMasterPartial", NorthwindDataProvider.GetCustomers());
        }

        //Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        //[ValidateInput(false)]
        //public ActionResult pvPercepcionesCalendarizadas()
        //{
        //    var model = db.Nomina_ctPlantillaNomina;
        //    return PartialView("_pvPercepcionesCalendarizadas", model.ToList());
        //}

        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionesCalendarizadasAddNew(Nova.Models.Nomina_ctPlantillaNomina item)
        {
            var model = db.Nomina_ctPlantillaNomina;
            
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvPercepcionesCalendarizadas", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionesCalendarizadasUpdate(Nova.Models.Nomina_ctPlantillaNomina item)
        {
            var model = db.Nomina_ctPlantillaNomina;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPlantillaNomina == item.IdPlantillaNomina);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvPercepcionesCalendarizadas", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionesCalendarizadasDelete(System.Int16 IdPlantillaNomina)
        {
            var model = db.Nomina_ctPlantillaNomina;
            if (IdPlantillaNomina != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPlantillaNomina == IdPlantillaNomina);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvPercepcionesCalendarizadas", model.ToList());
        }


        // Detalle



        //Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        //[ValidateInput(false)]
        //public ActionResult pvPercepcionesCalendarizadasDetalle()
        //{
        //    var model = db.Percepciones_stPercepcionesCalendarizadas;
        //    return PartialView("_pvPercepcionesCalendarizadasDetalle", model.ToList());
        //}

        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionesCalendarizadasDetalleAddNew(Nova.Models.Percepciones_stPercepcionesCalendarizadas item)
        {
            
            var model = db.Percepciones_stPercepcionesCalendarizadas;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
                return RedirectToAction("Index", "PercepcionesCalendarizadas");
            }
            else
            {
                ViewData["EditError"] = "Please, correct all errors.";
                return PartialView("_pvPercepcionesCalendarizadasDetalle", model.ToList());
            }
           
            
            
            //return PartialView("_pvPercepcionesCalendarizadasDetalle", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionesCalendarizadasDetalleUpdate(Nova.Models.Percepciones_stPercepcionesCalendarizadas item)
        {
            var model = db.Percepciones_stPercepcionesCalendarizadas;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPercepcionCalendarizada == item.IdPercepcionCalendarizada);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
                return RedirectToAction("Index", "PercepcionesCalendarizadas");
            }
            else
            {
                ViewData["EditError"] = "Please, correct all errors.";
                return PartialView("_pvPercepcionesCalendarizadasDetalle", model.ToList());
            }
            //return PartialView("_pvPercepcionesCalendarizadasDetalle", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvPercepcionesCalendarizadasDetalleDelete(System.Int16 IdPercepcionCalendarizada)
        {
            var model = db.Percepciones_stPercepcionesCalendarizadas;
            if (IdPercepcionCalendarizada != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPercepcionCalendarizada == IdPercepcionCalendarizada);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return RedirectToAction("Index", "PercepcionesCalendarizadas");
            //return PartialView("_pvPercepcionesCalendarizadasDetalle", model.ToList());
        }

    }
}
