﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

using Nova.Libraries;
//using DevExpress.Web;
using DevExpress.Web.Mvc;
using System.Web.UI;
using Rotativa;
using System.Drawing;
using System.IO;
using System.Drawing.Imaging;
using System.Runtime.InteropServices;
using System.Web.Helpers;


namespace Nova.Controllers.Peliculas
{
    public class PeliculasController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: Peliculas
        public ActionResult Index()
        {
            var cinedebates_ctPeliculas = db.Cinedebates_ctPeliculas.Include(c => c.Cinedebates_ctDirector).Include(c => c.Cinedebates_ctFormato).Include(c => c.Cinedebates_ctGenero).Include(c => c.Cinedebates_ctPais);
            return View(cinedebates_ctPeliculas.ToList());
        }
        public ActionResult Peliculas()
        {
            var cinedebates_ctPeliculas = db.Cinedebates_ctPeliculas.Include(c => c.Cinedebates_ctDirector).Include(c => c.Cinedebates_ctFormato).Include(c => c.Cinedebates_ctGenero).Include(c => c.Cinedebates_ctPais);
            return View(cinedebates_ctPeliculas.ToList());
        }
        public ActionResult Pelicula()
        {
            return View();
        }

        [AllowAnonymous]
        public ActionResult getFotografiapeliculas(int id)
        {
            byte[] image = Kardex_ctDatosPersonales.getFotografiapeliculas(id);
            if (image == null)
                //return File(StreamHelpers.FromFile("~/App_Themes/Nova/img/user.jpg"), "image/jpg");
                return File("~/App_Themes/Nova/img/user.jpg", "image/jpg");
            else
            {

                //using (MemoryStream ms = new MemoryStream(image))
                //{
                //    Bitmap img = (Bitmap)Image.FromStream(ms);
                //    return File(BitmapToByteArray(img), "image/jpg");
                //}
                Image miimagen = byteArrayToImage(image);

                //miimagen.Save(@"C:\imagenes\test.jpg", System.Drawing.Imaging.ImageFormat.Jpeg);


                return File(ToStream(miimagen, ImageFormat.Jpeg), "image/jpg");
            }
            //return File(image, "image/jpg");
        }

        // GET: Peliculas/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Cinedebates_ctPeliculas cinedebates_ctPeliculas = db.Cinedebates_ctPeliculas.Find(id);
            if (cinedebates_ctPeliculas == null)
            {
                return HttpNotFound();
            }
            return View(cinedebates_ctPeliculas);
        }

        // GET: Peliculas/Create
        public ActionResult Create()
        {
            ViewBag.IdDirector = new SelectList(db.Cinedebates_ctDirector, "IdDirector", "Director");
            ViewBag.IdFormato = new SelectList(db.Cinedebates_ctFormato, "IdFormato", "Formato");
            ViewBag.IdGenero = new SelectList(db.Cinedebates_ctGenero, "IdGenero", "Genero");
            ViewBag.IdPais = new SelectList(db.Cinedebates_ctPais, "IdPais", "Pais");
            return View();
        }

        // POST: Peliculas/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create( Cinedebates_ctPeliculas cinedebates_ctPeliculas)
        {
            ViewBag.IdPelicula = 0;
            ViewBag.urlimage = "";

            if (Request.Files[0].FileName != "")
            {
                //var image = new WebImage(Request.Files[0].InputStream); 
                //var Height = image.Height; 
                //var Width = image.Width; 

                //    int Top = ConvertToInt.ConvertToInt32(Request["hfimgcrop_top"]);
                //int Left = ConvertToInt.ConvertToInt32(Request["hfimgcrop_left"]);
                //int Bottom = ConvertToInt.ConvertToInt32(Request["hfimgcrop_bottom"]);
                //int Right = ConvertToInt.ConvertToInt32(Request["hfimgcrop_right"]);


                //    image.Crop((int)Top, (int)Left, (int)(Height - Bottom), (int)(Width - Right));


                var image = new WebImage(Request.Files[0].InputStream);

                var Height = image.Height;
                var Width = image.Width;

                decimal Top = System.Convert.ToDecimal(Request["hfimgcrop_top"]);
                decimal Left = System.Convert.ToDecimal(Request["hfimgcrop_left"]);
                decimal Bottom = System.Convert.ToDecimal(Request["hfimgcrop_bottom"]);
                decimal Right = System.Convert.ToDecimal(Request["hfimgcrop_right"]);



                //      width: Math.round(rx * boundx) + 'px',
                //height: Math.round(ry * boundy) + 'px',
                //marginLeft: '-' + Math.round(rx * c.x) + 'px',
                //marginTop: '-' + Math.round(ry * c.y) + 'px'


                image.Crop((int)Top, (int)Left, (int)(Height - Bottom), (int)(Width - Right));

                image.Resize(220, 228, true, true);


                cinedebates_ctPeliculas.Fotografia = image.GetBytes();




            }
            else
                if (Request["hfUrlImage"] != null)
                    if (Request["hfUrlImage"] != "" && Request["hfUrlImage"].IndexOf("getFotografia") == -1)
                    {
                        cinedebates_ctPeliculas.Fotografia = StreamHelpers.FromFile(Request["hfUrlImage"].Replace("..", "~"));
                        ViewBag.urlimage = Request["hfUrlImage"];
                    }

            if (ModelState.IsValid)
            {
                db.Cinedebates_ctPeliculas.Add(cinedebates_ctPeliculas);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdDirector = new SelectList(db.Cinedebates_ctDirector, "IdDirector", "Director", cinedebates_ctPeliculas.IdDirector);
            ViewBag.IdFormato = new SelectList(db.Cinedebates_ctFormato, "IdFormato", "Formato", cinedebates_ctPeliculas.IdFormato);
            ViewBag.IdGenero = new SelectList(db.Cinedebates_ctGenero, "IdGenero", "Genero", cinedebates_ctPeliculas.IdGenero);
            ViewBag.IdPais = new SelectList(db.Cinedebates_ctPais, "IdPais", "Pais", cinedebates_ctPeliculas.IdPais);
            return View(cinedebates_ctPeliculas);
        }

        // GET: Peliculas/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Cinedebates_ctPeliculas cinedebates_ctPeliculas = db.Cinedebates_ctPeliculas.Find(id);
            if (cinedebates_ctPeliculas == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdDirector = new SelectList(db.Cinedebates_ctDirector, "IdDirector", "Director", cinedebates_ctPeliculas.IdDirector);
            ViewBag.IdFormato = new SelectList(db.Cinedebates_ctFormato, "IdFormato", "Formato", cinedebates_ctPeliculas.IdFormato);
            ViewBag.IdGenero = new SelectList(db.Cinedebates_ctGenero, "IdGenero", "Genero", cinedebates_ctPeliculas.IdGenero);
            ViewBag.IdPais = new SelectList(db.Cinedebates_ctPais, "IdPais", "Pais", cinedebates_ctPeliculas.IdPais);
            return View(cinedebates_ctPeliculas);
        }

        // POST: Peliculas/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdPelicula,TituloPelicula,DescripcionPelicula,SinopsisPelicula,IdFormato,Año,IdDirector,IdPais,Duracion,IdGenero,Existencias")] Cinedebates_ctPeliculas cinedebates_ctPeliculas)
        {
            Int32 idp = cinedebates_ctPeliculas.IdPelicula;
            ViewBag.urlimage = "";
            byte[] foto = db.Cinedebates_ctPeliculas.Where(e => e.IdPelicula == idp).Select(f => f.Fotografia).SingleOrDefault();

            if (Request.Files[0].FileName != "")
            {

                var image = new WebImage(Request.Files[0].InputStream);


                var Height = image.Height;
                var Width = image.Width;

                decimal Top = 0;
                decimal Left = 0;
                decimal Bottom = 0;
                decimal Right = 0;

                if (Request["hfimgcrop_top"] != "")
                {
                    Top = System.Convert.ToDecimal(Request["hfimgcrop_top"]);
                    Left = System.Convert.ToDecimal(Request["hfimgcrop_left"]);
                    Bottom = System.Convert.ToDecimal(Request["hfimgcrop_bottom"]);
                    Right = System.Convert.ToDecimal(Request["hfimgcrop_right"]);

                    image.Crop((int)Top, (int)Left, (int)(Height - Bottom), (int)(Width - Right));
                }


                //      width: Math.round(rx * boundx) + 'px',
                //height: Math.round(ry * boundy) + 'px',
                //marginLeft: '-' + Math.round(rx * c.x) + 'px',
                //marginTop: '-' + Math.round(ry * c.y) + 'px'



                image.Resize(220, 228, true, true);


                cinedebates_ctPeliculas.Fotografia = image.GetBytes();
            }
            else

            //if (Request["hfUrlImage"] != null)
            //    if (Request["hfUrlImage"] != "")
            //    {
            //        kardex_ctdatospersonales.Fotografia = StreamHelpers.FromFile(Request["hfUrlImage"].Replace("..", "~"));
            //        ViewBag.urlimage = Request["hfUrlImage"];
            //    }
            {

                cinedebates_ctPeliculas.Fotografia = foto;
            }

            if (ModelState.IsValid)
            {
                db.Entry(cinedebates_ctPeliculas).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdDirector = new SelectList(db.Cinedebates_ctDirector, "IdDirector", "Director", cinedebates_ctPeliculas.IdDirector);
            ViewBag.IdFormato = new SelectList(db.Cinedebates_ctFormato, "IdFormato", "Formato", cinedebates_ctPeliculas.IdFormato);
            ViewBag.IdGenero = new SelectList(db.Cinedebates_ctGenero, "IdGenero", "Genero", cinedebates_ctPeliculas.IdGenero);
            ViewBag.IdPais = new SelectList(db.Cinedebates_ctPais, "IdPais", "Pais", cinedebates_ctPeliculas.IdPais);
            return View(cinedebates_ctPeliculas);
        }

        // GET: Peliculas/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Cinedebates_ctPeliculas cinedebates_ctPeliculas = db.Cinedebates_ctPeliculas.Find(id);
            if (cinedebates_ctPeliculas == null)
            {
                return HttpNotFound();
            }
            return View(cinedebates_ctPeliculas);
        }

        // POST: Peliculas/Delete/5
        //[HttpPost, ActionName("Delete")]
        [HttpPost, ActionName("DeleteConfirmed")]
        //[ValidateAntiForgeryToken]
        public JsonResult DeleteConfirmed(int id)
        {
            Cinedebates_ctPeliculas cinedebates_ctPeliculas = db.Cinedebates_ctPeliculas.Find(id);
            db.Cinedebates_ctPeliculas.Remove(cinedebates_ctPeliculas);
            db.SaveChanges();
            return new JsonResult() { Data = "Registro eliminado exitosamente" };
            //return RedirectToAction("Index");
        }

        public ActionResult UploadControlCallbackAction()
        {
            UploadControlExtension.GetUploadedFiles("Fotografia", UploadControlDemosHelper.UploadControlValidationSettings, UploadControlDemosHelper.uc_FileUploadComplete);
            return null;
        }

          [AllowAnonymous]

        public ActionResult getFotografia(int id)
        {
            byte[] image = Kardex_ctDatosPersonales.getFotografia2(id);
            if (image == null)
                //return File(StreamHelpers.FromFile("~/App_Themes/Nova/img/user.jpg"), "image/jpg");
                return File("~/App_Themes/Nova/img/user.jpg", "image/jpg");
            else
            {

                //using (MemoryStream ms = new MemoryStream(image))
                //{
                //    Bitmap img = (Bitmap)Image.FromStream(ms);
                //    return File(BitmapToByteArray(img), "image/jpg");
                //}
                Image miimagen = byteArrayToImage(image);

                //miimagen.Save(@"C:\imagenes\test.jpg", System.Drawing.Imaging.ImageFormat.Jpeg);


                return File(ToStream(miimagen, ImageFormat.Jpeg), "image/jpg");
            }
            //return File(image, "image/jpg");
        }

        public Image byteArrayToImage(byte[] byteArrayIn)
        {
            MemoryStream ms = new MemoryStream(byteArrayIn);
            Image returnImage = Image.FromStream(ms);
            return returnImage;
        }

        public Stream ToStream(Image image, ImageFormat formaw)
        {
            var stream = new System.IO.MemoryStream();
            image.Save(stream, formaw);
            stream.Position = 0;
            return stream;
        }
        //Then you can use the following

        //var stream = myImage.ToStream(ImageFormat.Gif);

        public byte[] BitmapToByteArray(Bitmap bitmap)
        {

            BitmapData bmpdata = bitmap.LockBits(new Rectangle(0, 0, bitmap.Width, bitmap.Height), ImageLockMode.ReadOnly, bitmap.PixelFormat);
            int numbytes = bmpdata.Stride * bitmap.Height;
            byte[] bytedata = new byte[numbytes];
            IntPtr ptr = bmpdata.Scan0;

            Marshal.Copy(ptr, bytedata, 0, numbytes);

            bitmap.UnlockBits(bmpdata);

            return bytedata;
        }

        public class UploadControlDemosHelper
        {

            public const string UploadDirectory = "/Content/UploadControl/UploadFolder/";

            public static readonly DevExpress.Web.UploadControlValidationSettings UploadControlValidationSettings = new DevExpress.Web.UploadControlValidationSettings
            {
                AllowedFileExtensions = new string[] { ".jpg", ".jpeg", ".jpe", ".gif", ".bmp", },
                MaxFileSize = 20971520,
            };



            public static void uc_FileUploadComplete(object sender, DevExpress.Web.FileUploadCompleteEventArgs e)
            {
                if (e.UploadedFile.IsValid)
                {
                    string resultFilePath = System.Web.HttpContext.Current.Request.MapPath(UploadDirectory + e.UploadedFile.FileName);
                    e.UploadedFile.SaveAs(resultFilePath, true);//Code Central Mode - Uncomment This Line
                    IUrlResolutionService urlResolver = sender as IUrlResolutionService;
                    if (urlResolver != null)
                    {
                        //e.CallbackData = urlResolver.ResolveClientUrl(UploadDirectory + e.UploadedFile.FileName);
                        e.CallbackData = String.Format(System.Web.HttpContext.Current.Request.IsSecureConnection ? "https://{0}{1}{2}" : "http://{0}{1}{2}", System.Web.HttpContext.Current.Request.Url.Host, (System.Web.HttpContext.Current.Request.Url.IsDefaultPort ? "" : ":" + System.Web.HttpContext.Current.Request.Url.Port), UploadDirectory + e.UploadedFile.FileName);
                    }
                }
            }


        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
