﻿using Dapper;
using DevExpress.DataAccess.ObjectBinding;
using DevExpress.Utils.Extensions;
using DevExpress.XtraPrinting;
using DocumentFormat.OpenXml.Office2010.Excel;
using Nova.Libraries;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Models.Nomina;
using Nova.Models.Timbrado.DinvBox;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using System.Web.Mvc;


namespace Nova.Controllers
{



    public class NominaController : BaseController
    {


        private FileResult ExportDocument(byte[] document, string format, string fileName, bool isInline)
        {
            string contentType;
            string disposition = (isInline) ? "inline" : "attachment";

            switch (format.ToLower())
            {
                case "docx":
                    contentType = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
                    break;
                case "xls":
                    contentType = "application/vnd.ms-excel";
                    break;
                case "xlsx":
                    contentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
                    break;
                case "mht":
                    contentType = "message/rfc822";
                    break;
                case "html":
                    contentType = "text/html";
                    break;
                case "txt":
                case "csv":
                    contentType = "text/plain";
                    break;
                case "png":
                    contentType = "image/png";
                    break;
                default:
                    contentType = String.Format("application/{0}", format);
                    break;
            }

            Response.AddHeader("Content-Disposition", String.Format("{0}; filename={1}", disposition, fileName));
            return File(document, contentType);
        }


        [HttpGet]
        public ActionResult prListaRaya()
        {
            repListaRaya report = new repListaRaya();



            (report.DataSource as ObjectDataSource).DataSource = ListaRayaTrabajadores.getListaRayaTrabajadores(103);

            using (MemoryStream ms = new MemoryStream())
            {
                report.ExportToPdf(ms, new PdfExportOptions() { ShowPrintDialogOnOpen = false });
                return ExportDocument(ms.ToArray(), "pdf", "Report.pdf", true);
            }
        }



        public ActionResult vwListaRaya()
        {
            repListaRaya report = new repListaRaya();



            (report.DataSource as ObjectDataSource).DataSource = ListaRayaTrabajadores.getListaRayaTrabajadores(103);

            return View(report);
        }

        public ActionResult NominaTrabajadorDetalle(int id, int idt)
        {

            return PartialView(ListaRayaTrabajadores.getListaRayaTrabajador(id, idt));
        }
        public ActionResult Recibo(int id, int idt)
        {
            ViewBag.Layout = "Nada";
            return PartialView("pdfListaRaya", ListaRayaTrabajadores.getListaRayaTrabajador(id, idt));
        }


        public ActionResult ReciboHistoria(int id, int idt,int idnt)
        {
            ViewBag.Layout = "Nada";
            return PartialView("pdfListaRaya", ListaRayaTrabajadores.getListaRayaTrabajadorHistoria(id, idt,idnt));
        }

        public async Task<ActionResult> ListadoGeneral(int id)
        {
            var model = await ListaRayaTrabajadores.getListaRayaTrabajadores(id);
            return View(model);
        }

        public static DataTable ToDataTable<T>(IList<T> data)
        {
            PropertyDescriptorCollection properties =
                TypeDescriptor.GetProperties(typeof(T));
            DataTable table = new DataTable();
            foreach (PropertyDescriptor prop in properties)
                table.Columns.Add(prop.Name, Nullable.GetUnderlyingType(prop.PropertyType) ?? prop.PropertyType);
            foreach (T item in data)
            {
                DataRow row = table.NewRow();
                foreach (PropertyDescriptor prop in properties)
                    row[prop.Name] = prop.GetValue(item) ?? DBNull.Value;
                table.Rows.Add(row);
            }
            return table;
        }

        //public ActionResult Report(string fi, string ff)
        //{
        //    var model = ListaRayaTrabajadores.getConcentradoNomina(fi, ff);
        //    string webRootPath = Server.MapPath("~/content/");
        //    string fileName = @"Testingdummy.xlsx";
        //    string URL = webRootPath+ fileName;
        //    FileInfo file = new FileInfo(Path.Combine(webRootPath, fileName));
        //    var memoryStream = new MemoryStream();
        //    // --- Below code would create excel file with dummy data----  
        //    using (var fs = new FileStream(Path.Combine(webRootPath, fileName), FileMode.Create, FileAccess.Write))
        //    {
        //        IWorkbook workbook = new XSSFWorkbook();
        //        ISheet excelSheet = workbook.CreateSheet("Testingdummy");

        //        IRow row = excelSheet.CreateRow(0);
        //        row.CreateCell(0).SetCellValue("IdTrabajador");
        //        row.CreateCell(1).SetCellValue("NombreTrabajador");
        //        row.CreateCell(2).SetCellValue("SueldoDiario");



        //int counter = 1;
        //        foreach (var customer in model)
        //        {
        //            //string FirstName = string.Empty;
        //            //if (customer.FirstName.Length > 100)
        //            //    FirstName = customer.FirstName.Substring(0, 100);
        //            //else
        //            //    FirstName = customer.FirstName;
        //            row = excelSheet.CreateRow(counter);
        //            row.CreateCell(0).SetCellValue(customer.IdTrabajador);
        //            row.CreateCell(1).SetCellValue(customer.NombreTrabajador);
        //            row.CreateCell(2).SetCellValue((double)customer.SueldoDiario);

        //            counter++;
        //        }
        //        workbook.Write(fs);
        //    }
        //    using (var fileStream = new FileStream(Path.Combine(webRootPath, fileName), FileMode.Open))
        //    {
        //         fileStream.CopyToAsync(memoryStream);
        //    }
        //    memoryStream.Position = 0;
        //    return File(memoryStream, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", fileName);
        //}
        //public FileResult ConcentradoNomina(string fi,string ff)
        //{
        //    DateTime inicio = DateTime.Now;
        //    var list=ListaRayaTrabajadores.getConcentradoNomina(fi, ff);
        //    DateTime termino= DateTime.Now;
        //    var total = termino - inicio;


        //    DataTable dtData = new DataTable();
        //    //var l = list.Skip(2).Take(500).ToList();
        //    dtData = ToDataTable(list);
        //    string fileName = Guid.NewGuid().ToString();

        //    try
        //    {


        //        //More details- http://closedxml.codeplex.com/
        //        var MyWorkBook = new XLWorkbook();
        //        var MyWorkSheet = MyWorkBook.Worksheets.Add("Sheet 1");
        //        int TotalColumns = dtData.Columns.Count;

        //        //-->headline
        //        //first row is intentionaly left blank.
        //        var headLine = MyWorkSheet.Range(MyWorkSheet.Cell(2, 1).Address, MyWorkSheet.Cell(2, TotalColumns).Address);
        //        //headLine.Style.Font.Bold = true;
        //        //headLine.Style.Font.FontSize = 15;
        //        //headLine.Style.Font.FontColor = XLColor.White;
        //        //headLine.Style.Alignment.Horizontal = XLAlignmentHorizontalValues.Center;
        //        //headLine.Style.Alignment.Vertical = XLAlignmentVerticalValues.Center;
        //        //headLine.Style.Fill.BackgroundColor = XLColor.FromTheme(XLThemeColor.Accent1, 0.25);
        //        //headLine.Style.Border.TopBorder = XLBorderStyleValues.Medium;
        //        //headLine.Style.Border.BottomBorder = XLBorderStyleValues.Medium;
        //        //headLine.Style.Border.LeftBorder = XLBorderStyleValues.Medium;
        //        //headLine.Style.Border.RightBorder = XLBorderStyleValues.Medium;

        //        //headLine.Merge();
        //        //headLine.Value = reportHeader;
        //        //<-- headline

        //        //--> column settings
        //        for (int i = 1; i < dtData.Columns.Count + 1; i++)
        //        {
        //            String combinedHeaderText = dtData.Columns[i - 1].ColumnName.ToString();
        //            string separatedColumnHeader = "";
        //            foreach (char letter in combinedHeaderText)
        //            {
        //                if (Char.IsUpper(letter) && separatedColumnHeader.Length > 0)
        //                    separatedColumnHeader += " " + letter;
        //                else
        //                    separatedColumnHeader += letter;
        //            }
        //            MyWorkSheet.Cell(4, i).Value = separatedColumnHeader;
        //            MyWorkSheet.Cell(4, i).Style.Alignment.WrapText = true;
        //        }

        //        var columnRange = MyWorkSheet.Range(MyWorkSheet.Cell(4, 1).Address, MyWorkSheet.Cell(4, TotalColumns).Address);
        //        //columnRange.Style.Font.Bold = true;
        //        //columnRange.Style.Font.FontSize = 10;
        //        //columnRange.Style.Alignment.Horizontal = XLAlignmentHorizontalValues.Center;
        //        //columnRange.Style.Alignment.Vertical = XLAlignmentVerticalValues.Center;
        //        //columnRange.Style.Fill.BackgroundColor = XLColor.FromArgb(171, 195, 223);
        //        //columnRange.Style.Border.TopBorder = XLBorderStyleValues.Thin;
        //        //columnRange.Style.Border.BottomBorder = XLBorderStyleValues.Thin;
        //        //columnRange.Style.Border.LeftBorder = XLBorderStyleValues.Thin;
        //        //columnRange.Style.Border.RightBorder = XLBorderStyleValues.Thin;
        //        //<-- column settings

        //        //--> row data & settings
        //        for (int i = 0; i < dtData.Rows.Count; i++)
        //        {
        //            DataRow row = dtData.Rows[i];
        //            for (int j = 0; j < dtData.Columns.Count; j++)
        //            {
        //                MyWorkSheet.Cell(i + 5, j + 1).Value = row[j].ToString();
        //            }
        //        }

        //        var dataRowRange = MyWorkSheet.Range(MyWorkSheet.Cell(5, 1).Address, MyWorkSheet.Cell(dtData.Rows.Count + 4, TotalColumns).Address);
        //        //dataRowRange.Style.Font.Bold = false;
        //        //dataRowRange.Style.Font.FontSize = 10;
        //        //dataRowRange.Style.Alignment.Horizontal = XLAlignmentHorizontalValues.Center;
        //        //dataRowRange.Style.Alignment.Vertical = XLAlignmentVerticalValues.Center;
        //        //dataRowRange.Style.Fill.BackgroundColor = XLColor.FromArgb(219, 229, 241);
        //        //dataRowRange.Style.Border.TopBorder = XLBorderStyleValues.Thin;
        //        //dataRowRange.Style.Border.BottomBorder = XLBorderStyleValues.Thin;
        //        //dataRowRange.Style.Border.LeftBorder = XLBorderStyleValues.Thin;
        //        //dataRowRange.Style.Border.RightBorder = XLBorderStyleValues.Thin;
        //        ////<-- row data & settings

        //        // Prepare the response
        //        Response.Clear();
        //        Response.ContentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        //        Response.AddHeader("content-disposition", "attachment;filename=cool.xlsx");

        //        // Flush the workbook to the Response.OutputStream
        //        using (MemoryStream memoryStream = new MemoryStream())
        //        {
        //            MyWorkBook.SaveAs(memoryStream);
        //            memoryStream.WriteTo(Response.OutputStream);
        //            memoryStream.Close();
        //        }

        //        Response.End();
        //        return File(Response.OutputStream, Response.ContentType);
        //    }
        //    catch (Exception ex)
        //    {
        //        throw ex;
        //    }


        //}


        public async Task<ActionResult> pdfListaRaya(int id)
        {
            //repListaRaya report = new repListaRaya();



            //(report.DataSource as ObjectDataSource).DataSource = ListaRayaTrabajadores.getListaRayaTrabajadores(103);
            var listaRayaTrabajadores = await ListaRayaTrabajadores.getListaRayaTrabajadores(id); // Asegúrate de esperar el resultado

            return View(listaRayaTrabajadores);
        }
        //
        // GET: /Nomina/
        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        //public ActionResult Index()
        //{

        //    //SingletonAntiguedad horarios1 = SingletonAntiguedad.Instance;

        //    //AntiguedadLaboralQuinquenioTrabajador old = horarios1.getAntiguedad(5);
        //    //AntiguedadLaboralQuinquenioTrabajador oldw= horarios1.getAntiguedad(1764);

        //    ViewData["idnomina"] = 0;
        //    ViewData["Universo"] = "0";
        //    ViewData["Procesados"] = "0";

        //    return View();
        //}
        public ActionResult vMovimientosTrabajadores()
        {
            return View();
        }

        public ActionResult MovimientosTrabajadores()
        {
            List<NominaMovimientos> model = new List<NominaMovimientos>();
            var result = from x in db.vwNominaMovimientosTrabajadores
                         join vwas in db.vwDatosAspirantesTrabajadores on x.IdTrabajador equals vwas.IdTrabajador
                         orderby x.FechaCreacion descending
                         select new
                         {

                             IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
                             IdTrabajador = x.IdTrabajador,
                             Fotografia = vwas.Fotografia,
                             Movimiento = x.Movimiento,
                             Nombre = x.Nombre,
                             ApellidoPaterno = x.ApellidoPaterno,
                             ApellidoMaterno = x.ApellidoMaterno,
                             Categoria = x.Categoria,
                             Adscripcion = x.EstructuraOrganica,
                             UbicacionFisica = x.UbicacionFisica,
                             ConvenioLaboral = x.ConvenioLaboral,
                             RelacionLaboral = x.RelacionLaboral,
                             FechaInicio = x.FechaInicio,
                             FechaTermino = x.FechaTermino,
                             FechaCreacion = x.FechaCreacion,
                             Observacion = x.Observacion,
                             Usuario = x.Usuario
                         };
            foreach (var item in result)
            {
                NominaMovimientos nm = new NominaMovimientos();
                nm.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                nm.IdTrabajador = item.IdTrabajador;
                nm.Fotografia = item.Fotografia;
                nm.Movimiento = item.Movimiento;
                nm.Nombre = item.Nombre;
                nm.ApellidoPaterno = item.ApellidoPaterno;
                nm.ApellidoMaterno = item.ApellidoMaterno;
                nm.Categoria = item.Categoria;
                nm.Adscripcion = item.Adscripcion;
                nm.UbicacionFisica = item.UbicacionFisica;
                nm.ConvenioLaboral = item.ConvenioLaboral;
                nm.RelacionLaboral = item.RelacionLaboral;
                nm.FechaInicio = item.FechaInicio;
                nm.FechaTermino = item.FechaTermino;
                nm.FechaCreacion = item.FechaCreacion;
                nm.Observacion = item.Observacion;
                nm.Usuario = item.Usuario;
                model.Add(nm);
            };

            if (model.Count() > 0)

                return PartialView("_pvMovimientosTrabajadores", model.ToList());
            else
                throw new InvalidOperationException("No existen movimientos de trabajadores en los 30 días anteriores o posteriores a la fecha actual");

        }

        public ActionResult MostrarGridTrabajadores(int IdNomina)
        {

            ViewData["IdNomina"] = IdNomina;
            return View();
        }

        [ValidateInput(false)]
        public ActionResult pvNominaTrabajadores(int IdNomina)
        {
            List<Nomina_stNominaTrabajador> model = new List<Nomina_stNominaTrabajador>();


            model = db.Nomina_stNominaTrabajador.AsNoTracking().Where(s => s.IdNomina == IdNomina).ToList();



            ViewData["IdNomina"] = IdNomina;
            return PartialView("_pvNominaTrabajadores", model);
        }


        [ValidateInput(false)]
        public ActionResult pvTrabajadoresdelaNomina(int IdNomina)
        {
            List<Nomina_stNominaTrabajador> model = new List<Nomina_stNominaTrabajador>();


            model = db.Nomina_stNominaTrabajador.AsNoTracking().Where(s => s.IdNomina == IdNomina).ToList();



            ViewData["IdNomina"] = IdNomina;
            return PartialView( model);
        }

        //PARA TRAER INFORMACIÓN Y MOSTRARLO COMO DETALLES DE NÓMINA POR TRABAJADOR
        [HttpPost]
        public ActionResult getInfoNominaTrabajador(Int64 IdNominaTrabajador)
        {
            Nomina_stNominaTrabajador nominaTrabajador = db.Nomina_stNominaTrabajador.Find(IdNominaTrabajador);
            return PartialView("_DetailsOneNominaTrabajador", nominaTrabajador);
        }

        [ValidateInput(false)]
        public async Task<ActionResult> IndexDocente(string fechainicial = null, string fechafinal = null, string t = null)
        {
            ViewBag.NominaPorSolicitud = false;
            ViewBag.Validar = "ValidarDocente";
            ViewBag.Proyecciones = await db.Nomina_stProyeccion.ToListAsync(); // Método asíncrono

            if (t == "t")
            {
                var model = await db.Nomina_stNomina.AsNoTracking()
                    .Where(s =>
                        s.Nomina_ctPlantillaNomina.CalculoPorSolicitud == false &&
                        s.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("DOCENTE")
                    )
                    .OrderByDescending(f => f.FechaInicio)
                    .ToListAsync(); // Método asíncrono para obtener la lista

                return View("Index", model);
            }
            else if (fechainicial == null && fechafinal == null)
            {
                var mes = DateTime.Now.Month;
                var año = DateTime.Now.Year;
                var fecha = new DateTime(año, mes, 1);

                ViewBag.fechainicio = fecha.ToShortDateString();

                int diastotales = DateTime.DaysInMonth(año, mes); // Manejo de días totales en el mes
                var fechaf = new DateTime(año, mes, diastotales);

                ViewBag.fechafinal = fechaf.ToShortDateString();

                var model = await db.Nomina_stNomina.AsNoTracking()
                    .Where(f => f.FechaInicio >= fecha &&
                                f.Nomina_ctPlantillaNomina.CalculoPorSolicitud == false &&
                                f.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("DOCENTE")
                    )
                    .OrderByDescending(f => f.FechaInicio)
                    .ToListAsync(); // Método asíncrono para obtener la lista

                return View("Index", model);
            }
            else
            {
                var fechai = Convert.ToDateTime(fechainicial);
                var fechaf = Convert.ToDateTime(fechafinal);

                ViewBag.fechainicio = fechai.ToShortDateString();
                ViewBag.fechafinal = fechaf.ToShortDateString();

                var model = await db.Nomina_stNomina.AsNoTracking()
                    .Where(n => n.FechaInicio >= fechai &&
                                n.Nomina_ctPlantillaNomina.CalculoPorSolicitud == false &&
                                n.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("DOCENTE")
                    )
                    .OrderBy(f => f.FechaInicio)
                    .ToListAsync(); // Método asíncrono para obtener la lista

                return View("Index", model);
            }
        }


        [ValidateInput(false)]
        public ActionResult NominaPorSolicitud(string fechainicial = null, string fechafinal = null, string t = null)
        {
            ViewBag.NominaPorSolicitud = true;
            ViewBag.Proyecciones = db.Nomina_stProyeccion.AsNoTracking().ToList();

            if (t == "t")
            {
                var model = db.Nomina_stNomina.AsNoTracking().Where(s => s.Nomina_ctPlantillaNomina.CalculoPorSolicitud==true
                                        ).OrderByDescending(f => f.FechaInicio);

                return View("Index", model.ToList());
            }
            else
            if (fechainicial == null && fechafinal == null)
            {
                var mes = DateTime.Now.Month;
                var año = DateTime.Now.Year;
                var fecha = new DateTime(año, mes, 01);

                ViewBag.fechainicio = fecha.ToShortDateString();

                var mesf = DateTime.Now.Month;
                var añof = DateTime.Now.Year;
                int diastotales = 30;
                if (mes == 2)
                    diastotales = DateTime.DaysInMonth(año, 2);




                var fechaf = new DateTime(año, mes, diastotales);

                ViewBag.fechafinal = fechaf.ToShortDateString();
                var model = db.Nomina_stNomina.AsNoTracking().Where(f => f.FechaInicio >= fecha
                //&& f.FechaTermino <= fechaf
                && f.Nomina_ctPlantillaNomina.CalculoPorSolicitud == true
                ).OrderByDescending(f => f.FechaInicio);
                return View("Index", model.ToList());
            }
            else
            {
                var fechai = Convert.ToDateTime(fechainicial);
                var fechaf = Convert.ToDateTime(fechafinal);
                ViewBag.fechainicio = fechai.ToShortDateString();
                ViewBag.fechafinal = fechaf.ToShortDateString();

                var model = db.Nomina_stNomina.AsNoTracking().Where(f => f.FechaInicio >= fechai
                  //&& f.FechaTermino <= fechaf
                  && f.Nomina_ctPlantillaNomina.CalculoPorSolicitud == true
               ).OrderBy(f => f.FechaInicio);

                return View("Index", model.ToList());
            }


        }

        [ValidateInput(false)]
        public ActionResult IndexAdicionales(string fechainicial = null, string fechafinal = null, string t = null)
        {
            ViewBag.NominaPorSolicitud = false;
            ViewBag.Proyecciones = db.Nomina_stProyeccion.AsNoTracking().ToList();

            if (t == "t")
            {
                var model = db.Nomina_stNomina.AsNoTracking().Where(s => s.Nomina_ctPlantillaNomina.Plantilla.Contains("PRESTACIONES ADICIONALES")).OrderByDescending(f => f.FechaInicio);

                return View("Index", model.ToList());
            }
            else
            if (fechainicial == null && fechafinal == null)
            {
                var mes = DateTime.Now.Month;
                var año = DateTime.Now.Year;
                var fecha = new DateTime(año, mes, 01);

                ViewBag.fechainicio = fecha.ToShortDateString();

                var mesf = DateTime.Now.Month;
                var añof = DateTime.Now.Year;
                int diastotales = 30;
                if (mes == 2)
                    diastotales = DateTime.DaysInMonth(año, 2);




                var fechaf = new DateTime(año, mes, diastotales);

                ViewBag.fechafinal = fechaf.ToShortDateString();
                var model = db.Nomina_stNomina.AsNoTracking().Where(f => f.FechaInicio >= fecha
                //&& f.FechaTermino <= fechaf
                && f.Nomina_ctPlantillaNomina.Plantilla.Contains("PRESTACIONES ADICIONALES")                                      
                ).OrderByDescending(f => f.FechaInicio);
                return View("Index", model.ToList());
            }
            else
            {
                var fechai = Convert.ToDateTime(fechainicial);
                var fechaf = Convert.ToDateTime(fechafinal);
                ViewBag.fechainicio = fechai.ToShortDateString();
                ViewBag.fechafinal = fechaf.ToShortDateString();

                var model = db.Nomina_stNomina.AsNoTracking().Where(f => f.FechaInicio >= fechai
               //&& f.FechaTermino <= fechaf
               && f.Nomina_ctPlantillaNomina.Plantilla.Contains("PRESTACIONES ADICIONALES")
                    ).OrderBy(f => f.FechaInicio);

                return View("Index", model.ToList());
            }


        }

        public ActionResult lazy()
        {
            return View();
        }
        //[JQDataTable]
        //public ActionResult GetCustomersData()
        //{
             

        //    IQueryable<Nomina_stNomina> data = db.Nomina_stNomina
        //      .Where(s => s.Nomina_ctPlantillaNomina.CalculoPorSolicitud == false &&
        //                  (s.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("ADMINISTRATIVO") ||
        //                   s.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("MANDO MEDIO")))
        //      .OrderByDescending(f => f.FechaInicio);

        //    return this.View(data);
        //}

        public ActionResult CargarDatos()
        {
            // Obtén los parámetros de DataTables para la carga diferida
            int start = Convert.ToInt32(Request.Form["start"]);
            int length = Convert.ToInt32(Request.Form["length"]);
            string searchValue = Request.Form["search[value]"];
            string sortColumn = Request.Form["columns[" + Request.Form["order[0][column]"] + "][name]"];
            string sortDirection = Request.Form["order[0][dir]"];

            // Realiza la consulta a la base de datos utilizando Entity Framework
            var query = db.Nomina_stNomina.AsNoTracking()
                .Where(s => s.Nomina_ctPlantillaNomina.CalculoPorSolicitud == false &&
                            (s.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("ADMINISTRATIVO") ||
                             s.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("MANDO MEDIO")))
                .OrderByDescending(f => f.FechaInicio);

            // Aplica la paginación y el ordenamiento
            var filteredData = query
                .Where(s => string.IsNullOrEmpty(searchValue) || s.AliasNomina.Contains(searchValue))
                .Skip(start)
                .Take(length)
                .ToList();

            var totalData = query.Count();
            var totalFilteredData = query.Count(s => string.IsNullOrEmpty(searchValue) || s.AliasNomina.Contains(searchValue));

            // Devuelve los datos en el formato adecuado para DataTables
            var jsonData = new
            {
                recordsTotal = totalData,
                recordsFiltered = totalFilteredData,
                data = filteredData
            };

            return Json(jsonData);
        }




        [ValidateInput(false)]
        public async Task<ActionResult> IndexAdministrativa(string fechainicial = null, string fechafinal = null, string t = null)
        {
            ViewBag.NominaPorSolicitud = false;
            ViewBag.Validar = "ValidarAdministrativa";
            ViewBag.Proyecciones = await db.Nomina_stProyeccion.AsNoTracking().ToListAsync(); // Método asíncrono

            if (t == "t")
            {
                var model = await db.Nomina_stNomina.AsNoTracking()
                    .Where(s =>
                        s.Nomina_ctPlantillaNomina.CalculoPorSolicitud == false &&
                        (s.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("ADMINISTRATIVO")
                        || s.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("MANDO MEDIO"))
                    )
                    .OrderByDescending(f => f.FechaInicio)
                    .ToListAsync(); // Método asíncrono para obtener la lista

                return View("Index", model);
            }
            else if (fechainicial == null && fechafinal == null)
            {
                var mes = DateTime.Now.Month;
                var año = DateTime.Now.Year;
                var fecha = new DateTime(año, mes, 1);

                ViewBag.fechainicio = fecha.ToShortDateString();

                var diastotales = DateTime.DaysInMonth(año, mes); // Manejo de días totales en el mes
                var fechaf = new DateTime(año, mes, diastotales);

                ViewBag.fechafinal = fechaf.ToShortDateString();

                var model = await db.Nomina_stNomina.AsNoTracking()
                    .Where(f => f.FechaInicio >= fecha &&
                                f.Nomina_ctPlantillaNomina.CalculoPorSolicitud == false &&
                                (f.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("ADMINISTRATIVO")
                                 || f.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("MANDO MEDIO"))
                    )
                    .OrderByDescending(f => f.FechaInicio)
                    .ToListAsync(); // Método asíncrono para obtener la lista

                return View("Index", model);
            }
            else
            {
                var fechai = Convert.ToDateTime(fechainicial);
                var fechaf = Convert.ToDateTime(fechafinal);

                ViewBag.fechainicio = fechai.ToShortDateString();
                ViewBag.fechafinal = fechaf.ToShortDateString();

                var model = await db.Nomina_stNomina.AsNoTracking()
                    .Where(f => f.FechaInicio >= fechai &&
                                f.Nomina_ctPlantillaNomina.CalculoPorSolicitud == false &&
                                (f.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("ADMINISTRATIVO")
                                 || f.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("MANDO MEDIO"))
                    )
                    .OrderBy(f => f.FechaInicio)
                    .Include(a => a.Nomina_ctPlantillaNomina)
                    .ToListAsync(); // Método asíncrono para obtener la lista

                return View("Index", model);
            }
        }


        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult Delete(int id)
        {

            try
            {

                string query = @" 
delete from Percepciones_stNominaTrabajadorPercepciones where IdNominaTrabajador in ( select IdNominaTrabajador from Nomina_stNominaTrabajador where IdNomina in (select IdNomina from [Nomina_stNomina] where IdNomina in (" + id + @")))
;

delete from Deducciones_stNominaTrabajadorSubDeducciones where IdNominaTrabajadorDeduccion in ( select IdNominaTrabajadorDeduccion from Deducciones_stNominaTrabajadorDeduccion where IdNominaTrabajador in ( select IdNominaTrabajador from Nomina_stNominaTrabajador where IdNomina in (select IdNomina from [Nomina_stNomina] where IdNomina in (" + id + @"))))

;

delete from Deducciones_stNominaTrabajadorDeduccion where IdNominaTrabajador in ( select IdNominaTrabajador from Nomina_stNominaTrabajador where IdNomina in (select IdNomina from [Nomina_stNomina] where IdNomina in (" + id + @")))

;

delete from Deducciones_stNominaTrabajadorDeduccion where IdNominaTrabajador in ( select IdNominaTrabajador from Nomina_stNominaTrabajador where IdNomina in (select IdNomina from [Nomina_stNomina] where IdNomina in (" + id + @")))

;

delete from Creditos_stNominaCreditoTrabajador where IdNominaTrabajador in ( select IdNominaTrabajador from Nomina_stNominaTrabajador where IdNomina in (select IdNomina from [Nomina_stNomina] where IdNomina in (" + id + @")))

;

delete from Pensiones_stNominaPensionTrabajador where IdNominaTrabajador in ( select IdNominaTrabajador from Nomina_stNominaTrabajador where IdNomina in (select IdNomina from [Nomina_stNomina] where IdNomina in (" + id + @")))

;

delete from Percepciones_stNominaTrabajadorPercepcionesViaticos where IdNominaTrabajador in ( select IdNominaTrabajador from Nomina_stNominaTrabajador where IdNomina in (select IdNomina from [Nomina_stNomina] where IdNomina in (" + id + @")))

;



delete from Nomina_stNominaTrabajadorHistorial  where IdNomina in (select IdNomina from [Nomina_stNomina] where IdNomina in (" + id + @"))

;

delete from Nomina_stNominaTrabajador where IdNomina in (select IdNomina from [Nomina_stNomina] where IdNomina in (" + id + @"))

;

delete from Percepciones_Proyeccion where IdProyeccion in (select IdProyeccion from [Nomina_stProyeccion] where IdNomina in (" + id + @"))

;

delete from  Deducciones_Proyeccion where IdProyeccion in (select IdProyeccion from [Nomina_stProyeccion] where IdNomina in (" + id + @"))

;

delete from Nomina_stProyeccion where IdNomina in (select IdNomina from [Nomina_stNomina] where IdNomina in (" + id + @"))

;

delete from Creditos_stNominaCreditoTrabajadorNoAplicados where IdNominaTrabajador in ( select IdNominaTrabajador from Nomina_stNominaTrabajador where IdNomina in (select IdNomina from [Nomina_stNomina] where IdNomina in (" + id + @")));



delete from Nomina_stNomina where IdNomina in (select IdNomina from [Nomina_stNomina] where IdNomina in (" + id + @"))

";


                Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");


                var control = dp.connection.Query(query);



                //Nomina_stNomina poa_Calendario = db.Nomina_stNomina.Find(id);
                //db.Nomina_stNomina.Remove(poa_Calendario);
                //db.SaveChanges();


            }
            catch (Exception e)
            {
                string msj = ExceptionExtensions.GetOriginalException(e).Message;
                if (msj.IndexOf("REFERENCE") > -1)
                {
                    msj = "Existe información con esta nómina, para poder eliminarla primero debe de eliminar toda la información relacionada";
                }

                return Json(new { Valid = false, Message = msj });
            }




            return JsonView(ModelState.IsValid, "Se ha eliminado la Nómina exitosamente", null, null, null);

        }

        [ValidateInput(false)]
        public ActionResult pvNomina()
        {
            //var model = db.Nomina_stNomina;
            var model = db.Nomina_stNomina.AsNoTracking().OrderByDescending(f => f.FechaInicio);
            //Session["IdQuincenaMes"] = Nova.Models.Nomina_stNomina.getIdQuincenaMes();

            return PartialView("_pvNomina", model.ToList());
        }
        [ValidateInput(false)]
        public ActionResult pvPanelNomina()
        {
            //var model = db.Nomina_stNomina;
            var model = db.Nomina_stNomina.AsNoTracking().OrderByDescending(f => f.FechaInicio);
            //Session["IdQuincenaMes"] = Nova.Models.Nomina_stNomina.getIdQuincenaMes();

            return PartialView("_pvPanelNomina", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvNominaAddNew(Nova.Models.Nomina_stNomina item)
        {
            var model = db.Nomina_stNomina;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                    ViewData["redirect"] = "ok";

                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            return PartialView("_pvNomina", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvNominaUpdate(Nova.Models.Nomina_stNomina item)
        {
            var model = db.Nomina_stNomina;
            //var model = db.Nomina_stNomina;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdNomina == item.IdNomina);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                        ViewData["redirect"] = "ok";
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvNomina", model.ToList());





        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvNominaDelete(System.Int32 IdNomina)
        {
            var model = db.Nomina_stNomina;
            if (IdNomina != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdNomina == IdNomina);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                    ViewData["redirect"] = "ok";
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }

            return PartialView("_pvNomina", model.ToList());
        }


        [ValidateInput(false)]
        public ActionResult pvInfoNomina(string _IdNomina)
        {
            short idsg = 0;
            int idn = Convert.ToInt32(_IdNomina);
            var idisrgrupo = from a in db.Nomina_stNomina where a.IdNomina == idn select new { a.IdIsrGrupo };
            foreach (var item in idisrgrupo)
            {
                idsg = item.IdIsrGrupo;
            }
            var model = db.Configuracion_ctISR.Where(s => s.IdIsrGrupo == idsg);

            var procesados = from a in db.Nomina_stNomina
                             where a.IdNomina == idn
                             select new { universo = a.UniversoTrabajadores, procesados = a.TrabajadoresProcesados, fi = a.FechaInicio, ft = a.FechaTermino };
            foreach (var item in procesados)
            {
                ViewData["Universo"] = item.universo.ToString();
                ViewData["Procesados"] = item.procesados.ToString();
            }
            //ViewData["SalarioMinimo"] = "";
            //ViewData["Zona"] = "";
            //try
            //{
            //         var sm = from a in db.Catalogos_ctSalarioMinimo
            //         join b in db.Catalogos_ctZonaSalarioMinimo on a.IdZonaSalarioMinimo equals b.IdZonaSalarioMinimo
            //         where (a.FechaInicio <= fechai && a.FechaTermino >= fechat)
            //         select new { zona = b.ZonaSalarioMinimo, salariominimo = a.Monto };
            //         ViewData["SalarioMinimo"] = sm.FirstOrDefault().salariominimo.ToString();
            //        ViewData["Zona"] = sm.FirstOrDefault().zona.ToString();

            //}
            //catch (Exception)
            //{
            //    ViewData["SalarioMinimo"] = "No existe salario mínimo vigente!!";

            //}

            return PartialView("_pvInfoNomina", model.ToList());
        }
        public ActionResult CerrarNomina()
        {
            //var mesas=Nomina_stNominaTrabajador.MesasPorConcluir();
            //if (mesas.Count > 0)
            ////{
            //    var output = string.Join(" ", mesas.Select(t => "<p>" + t.Nombre + " " + t.EstructuraOrganica + " </p> "));
            //    ViewData["EditError"] = "Estos usuarios no han cerrado todas sus mesas de incidencias: " + output;
            //    return JsonView(false, "Estos usuarios no han cerrado todas sus mesas de incidencias: " + output );
            //}

            try
            {

                DateTime HoraInicioProceso = DateTime.Now;

                String msjnomina = "";
                var TipoCalculos = HttpContext.Request.Params.Get("Tipo");
                int totalTrabajadores = 0;
                if (TipoCalculos != null)
                {
                    if (TipoCalculos != "")
                    {
                        List<int> nominasAbiertas = new List<int>();
                        if (TipoCalculos == "IndexAdministrativa")

                            nominasAbiertas = db.Nomina_stNomina.AsNoTracking().Where(
                                s => s.Nomina_ctPlantillaNomina.CalculoPorSolicitud==false && s.EsCerrada == false && s.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral != "DOCENTE"
                                ).OrderBy(q => new { q.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral, q.Nomina_ctPlantillaNomina.Orden }).Select(f => f.IdNomina).ToList();
                        else
                            nominasAbiertas = db.Nomina_stNomina.AsNoTracking().Where(
                                s => s.Nomina_ctPlantillaNomina.CalculoPorSolicitud == false &&  s.EsCerrada == false && s.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral == "DOCENTE"
                                ).OrderBy(q => new { q.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral, q.Nomina_ctPlantillaNomina.Orden }).Select(f => f.IdNomina).ToList();

                        DateTime HoraFinProceso = DateTime.Now;

                        foreach (var item in nominasAbiertas)
                        {

                            Nomina_stNominaTrabajador nt = new Nomina_stNominaTrabajador(item, 0, false, true);

                            CalculosNomina calculosnomina = new CalculosNomina(nt);

                            msjnomina = msjnomina + "<p> la nómina de <strong>" + nt.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla + "</strong> del " + nt.Nomina_stNomina.FechaInicio.ToShortDateString() + " al " + nt.Nomina_stNomina.FechaTermino.ToShortDateString() + " </p>";
                            
                            nt.getuniversoTrabajadores();
                            ActualizaProcesados(item, nt.UniversoTrabajadores, nt.TrabajadoresVigentes.Count(), nt.TrabajadoresError);
                            totalTrabajadores = totalTrabajadores + nt.TrabajadoresVigentes.Count();
                        }

                        TimeSpan difference = HoraFinProceso - HoraInicioProceso;
                        double seconds = Math.Round(difference.TotalSeconds, 2);



                        TimeSpan t = TimeSpan.FromSeconds(seconds);
                        SendPushNotification(" Cierre realizado de :" + msjnomina, TypePushNotification.success, "Nómina");
                        return JsonView(true, " <p>Proceso de cierre realizado correctamente Para: </p>" + msjnomina + "<p> en <strong> " + t.ToString() + "</strong> segs.<p> Total de trabajadores: " + totalTrabajadores.ToString() + "</p>");
                    }
                }
                else
                {







                    AuthorizationContext ht = new AuthorizationContext();
                    Session["IdNomina"] = Convert.ToInt32(HttpContext.Request.Params.Get("IdNomina"));

                    int idn = Convert.ToInt32(Session["IdNomina"]);

                    bdNovaEntities bd = new bdNovaEntities();

                    Nomina_stNominaTrabajador nomina = bd.Nomina_stNominaTrabajador.AsNoTracking().Where(a=> a.IdNomina==idn)
                        .Include(z=> z.Nomina_stNomina.Nomina_ctPlantillaNomina)
                        .FirstOrDefault();
                    if(nomina!=null)
                    if (nomina.Nomina_stNomina.IdTipoNomina == 1)
                    {
                        List<Nomina_ctPlantillaNomina> ordenplantilla = bd.Nomina_ctPlantillaNomina.Where(a =>
                        a.IdRelacionConvenioLaboral == nomina.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral
                          && a.EsVigente
                        )
                             .OrderBy(a => a.Orden).ToList();

                        string ordenplantillamsj = string.Join(" ", ordenplantilla.Select(a => a.Plantilla + " - " + a.Orden));

                        short ordenminimo = ordenplantilla.FirstOrDefault().Orden;
                        if (nomina.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
                            ordenminimo = (short)ordenplantilla.FirstOrDefault().OrdenCalculoRetroactivo;

                        if (nomina.Nomina_stNomina.Nomina_ctPlantillaNomina.Orden > ordenminimo)
                        {
                            if (nomina.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
                            {
                                Nomina_stNominaTrabajador nominasanterior = bd.Nomina_stNominaTrabajador.AsNoTracking().Where(a =>
                            a.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral == nomina.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral
                            && a.Nomina_stNomina.IdQuincenaMes == nomina.Nomina_stNomina.IdQuincenaMes
                            && a.Nomina_stNomina.Año == nomina.Nomina_stNomina.Año
                            && a.Nomina_stNomina.IdTipoNomina == nomina.Nomina_stNomina.IdTipoNomina
                            && a.Nomina_stNomina.EsCerrada && a.Nomina_stNomina.Nomina_ctPlantillaNomina.EsVigente
                            && a.Nomina_stNomina.Nomina_ctPlantillaNomina.OrdenCalculoRetroactivo < nomina.Nomina_stNomina.Nomina_ctPlantillaNomina.OrdenCalculoRetroactivo


                            )
                              .Include(z => z.Nomina_stNomina.Nomina_ctPlantillaNomina)
                              .FirstOrDefault();

                                if (nominasanterior == null)
                                {
                                    var plantilla = ordenplantilla.Where(a => (short)a.OrdenCalculoRetroactivo == (short)nomina.Nomina_stNomina.Nomina_ctPlantillaNomina.OrdenCalculoRetroactivo - 1).FirstOrDefault();
                                    string msj = $"Debe de cerrar primero la nomina que {plantilla.Plantilla}, (o la que le precede en orden menor ),para poder continuar" + ordenplantillamsj + "";
                                    return JsonView(false, msj);
                                }
                            }
                            else
                            {

                                Nomina_stNominaTrabajador nominasanterior = bd.Nomina_stNominaTrabajador.AsNoTracking().Where(a =>
                           a.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral == nomina.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral
                           && a.Nomina_stNomina.IdQuincenaMes == nomina.Nomina_stNomina.IdQuincenaMes
                           && a.Nomina_stNomina.Año == nomina.Nomina_stNomina.Año
                           && a.Nomina_stNomina.IdTipoNomina == nomina.Nomina_stNomina.IdTipoNomina
                           && a.Nomina_stNomina.EsCerrada && a.Nomina_stNomina.Nomina_ctPlantillaNomina.EsVigente
                           && a.Nomina_stNomina.Nomina_ctPlantillaNomina.Orden < nomina.Nomina_stNomina.Nomina_ctPlantillaNomina.Orden


                           )
                             .Include(z => z.Nomina_stNomina.Nomina_ctPlantillaNomina)
                             .FirstOrDefault();

                                if (nominasanterior == null)
                                {
                                    var plantilla = ordenplantilla.Where(a => a.Orden < nomina.Nomina_stNomina.Nomina_ctPlantillaNomina.Orden).FirstOrDefault();
                                    string msj = $"Debe de cerrar primero la nomina que {plantilla.Plantilla}, (o la que le precede en orden menor ),para poder continuar" + ordenplantillamsj + "";
                                    return JsonView(false, msj);
                                }

                            }

                        }
                    }


                    Nomina_stNominaTrabajador nt = new Nomina_stNominaTrabajador(idn, 0, false, true);

                    CalculosNomina calculosnomina = new CalculosNomina(nt);


                    DateTime HoraFinProceso = DateTime.Now;


                    TimeSpan difference = HoraFinProceso - HoraInicioProceso;
                    double seconds = Math.Round(difference.TotalSeconds, 2);



                    TimeSpan t = TimeSpan.FromSeconds(seconds);

                    msjnomina = "<p> la nómina de <strong>" + nt.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla + "</strong> del " + nt.Nomina_stNomina.FechaInicio.ToShortDateString() + " al " + nt.Nomina_stNomina.FechaTermino.ToShortDateString() + " </p>";
                    
                    nt.getuniversoTrabajadores();
                    ActualizaProcesados(idn, nt.UniversoTrabajadores, nt.TrabajadoresVigentes.Count(), nt.TrabajadoresError);

                    SendPushNotification(" Cerró y cálculo  de :" + msjnomina, TypePushNotification.success, "Nómina");

                    //return Json(new { Valid=true, Tiempo = " <p>Proceso realizado correctamente Para: </p>"+ msjnomina + "<p> en <strong> " + t.ToString() + "</strong> segs.<p> Total de trabajadores: " + nt.TrabajadoresVigentes.Count.ToString()+"</p>" });
                    //return Json(new { Valid = false, msj = " <p>Proceso realizado correctamente Para: </p>" + msjnomina + "<p> en <strong> " + t.ToString() + "</strong> segs.<p> Total de trabajadores: " + nt.TrabajadoresVigentes.Count.ToString() + "</p>" });
                    return JsonView(true, " <p>Se ha Calculado y cerrado el proceso correctamente Para: </p>" + msjnomina + "<p> en <strong> " + t.ToString() + "</strong> segs.<p> Total de trabajadores: " + nt.TrabajadoresVigentes.Count.ToString() + "</p>");
                }
            }

            catch (NominaExcepcion ex)
            {

                return JsonView(false, ExceptionExtensions.GetOriginalException(ex).Message, null, null, null, null, ex.ErrorCode.ToString());
            }
            catch (Exception ex)
            {

                return JsonView(false, ExceptionExtensions.GetOriginalException(ex).Message + " | " + ex.StackTrace + " | " + ex.Source);
            }

            return Json(new { Valid = false, msj = " No se pueden cerrar las nóminas" });

            //          int idnom = Convert.ToInt32(HttpContext.Request.Params.Get("IdNomina"));

            //          Nova.Models.Nomina_stNomina st_nomina = db.Nomina_stNomina.Find(idnom);

            //          string query = @"  select * from (
            //select 
            //z.EstructuraOrganica,
            // f.ApellidoPaterno+' '+f.ApellidoMaterno+' '+f.Nombre as Nombre,
            //case when q.total is null then 0 else q.total end Cerradas 
            //from Nomina_RelojChecadorControlUsuarios a
            //inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas=b.IdRelojChecadorAreas
            //inner join Convenios_stConvenioLaboralTrabajadorCategoria c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
            //inner join Convenios_stConvenioLaboralTrabajador d on d.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
            //inner join Kardex_ctTrabajador e on e.IdTrabajador=d.IdTrabajador
            //inner join Kardex_ctDatosPersonales f on f.IdKardex=e.IdKardex
            //inner join Catalogos_ctEstructuraOrganica z on z.IdEstructuraOrganica=b.IdEstructuraOrganica
            //  left join (
            //SELECT b.IdEstructuraOrganica,COUNT(a.IdIncidenciaTrabajador) as total
            //FROM IncidenciaPermiso_stIncidenciaTrabajador a inner join 
            //Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
            //inner join Catalogos_ctTipoIncidencia c on a.IdTipoIncidencia=c.IdTipoIncidencia
            //inner join Catalogos_ctEstructuraOrganica f on f.IdEstructuraOrganica=b.IdEstructuraOrganica
            //inner join Catalogos_ctTipoIncidenciaPermiso d on d.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
            //where  d.TipoIncidenciaPermiso='INCIDENCIA'

            //and EsCerrada=1 
            //and cast(a.FechaInicio as DATE)>='" + st_nomina.FechaInicio.ToString("yyyy-MM-dd") + @"' and cast(a.FechaTermino as DATE)<='" + st_nomina.FechaTermino.ToString("yyyy-MM-dd") + @"'
            //group by b.IdEstructuraOrganica
            //) as q on q.IdEstructuraOrganica=b.IdEstructuraOrganica
            //) as r where r.Cerradas=0";

            //          Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");


            //          var control = (List<IncidenciasControlNominas>)dp.connection.Query<IncidenciasControlNominas>(query);

            //          //if (control.Count > 0)
            //          //{
            //          //    var output = string.Join(" ", control.Select(t => ""+t.Nombre + " " + t.EstructuraOrganica+" | "));
            //          //    ViewData["EditError"] = "Estos usuarios no ha cerrado sus incindecias: " + output;
            //          //    return Json(new { Valid=false, Tiempo = "Estos usuarios no ha cerrado sus incindecias: " + output });
            //          //}
            //          dp.Close();
            //          //int idnomina = Convert.ToInt32(Request["hdIdNomina"]);
            //          //idnomina = ViewBag.idnomina;
            //          //int idnom = Convert.ToInt32(Session["IdNomina"]);

            //          st_nomina.EsCerrada = true;
            //          //var model = db.Nomina_stNomina;
            //          if (ModelState.IsValid)
            //          {
            //              try
            //              {
            //                  //var modelItem = model.FirstOrDefault(it => it.IdNomina == idnomina);
            //                  if (st_nomina != null)
            //                  {
            //                      db.Entry(st_nomina).State = System.Data.Entity.EntityState.Modified;
            //                      db.SaveChanges();
            //                      //this.UpdateModel(st_nomina);
            //                      //db.SaveChanges();
            //                  }
            //              }
            //              catch (Exception e)
            //              {
            //                  ViewData["EditError"] = e.Message;
            //              }
            //          }
            //          else
            //              ViewData["EditError"] = "Please, correct all errors.";
            //          return Json(new { Valid = true, Tiempo = " Proceso realizado correctamente " });

            //          //return View("Index");
        }

        public ActionResult ReCalcularNomina(int idclt, int idn, short diasp,int idmot)
        {

           
            
            if (diasp <= 0)

                return JsonView(false, "Debe de especificar valores mayores a 0 ");

            if (diasp > 15)

                return JsonView(false, "Debe de especificar valores entre 1 y 15 días ");

            if (idmot ==0)

                return JsonView(false, "Debe de especificar un motivo ");


            DateTime HoraInicioProceso = DateTime.Now;

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string sql = @"select a.* from Nomina_stNominaTrabajador a
inner join Nomina_stNominaTrabajadorEstatus b on a.IdNominaTrabajadorEstatus=b.IdNominaTrabajadorEstatus
where idnomina=" + idn+" and IdConvenioLaboralTrabajadorCategoria="+idclt+" and b.EstatusNomina='CANCELADO'";

         //   long idcancelado = 0;

            var tienecancelados = (List<Nomina_stNominaTrabajador>)dp.connection.Query<Nomina_stNominaTrabajador>(sql);
           


            if (tienecancelados.Count > 0)
                    return JsonView(false, " Ya existe un medio recibo, si requiere volver a crear un recibo debe de eliminar previamente el ya existente ");


              sql = @"select a.* from Nomina_stNominaTrabajador a
inner join Nomina_stNominaTrabajadorEstatus b on a.IdNominaTrabajadorEstatus=b.IdNominaTrabajadorEstatus
where idnomina=" + idn + " and IdConvenioLaboralTrabajadorCategoria=" + idclt + " ";

            //   long idcancelado = 0;

            var nominatrabajador = (Nomina_stNominaTrabajador)dp.connection.QueryFirstOrDefault<Nomina_stNominaTrabajador>(sql);
            
            dp.Close();

            if (nominatrabajador != null)
            {
                ReCalculosNomina calculos = new ReCalculosNomina();
                var res = calculos.ValidaNomina(nominatrabajador.IdNominaTrabajador);

                //if (!res.IsValid)
                //{
                //    return JsonView(false, res.Messsage);
                //}
            }
            else
                return JsonView(false, " No hay nomina para este trabajador");
            //try
            //{
            //    idcancelado = (long)dp.connection.ExecuteScalar(sql, null, null, 0, System.Data.CommandType.Text);
            //    dp.Close();
            //    if (idcancelado>0)
            //        return JsonView(false, " Ya existe un medio recibo, si requiere volver a crear un recibo debe de eliminar previamente el ya existente ");

            //    dp.Close();
            //}
            //catch (Exception ex)
            //{
            //    dp.Close();

            //}








            //   AuthorizationContext ht = new AuthorizationContext();



            DateTime HoraFinProceso = DateTime.Now;
                //nt.DiasPagados = diasp;
                try
                {
                Nomina_stNominaTrabajador nt = new Nomina_stNominaTrabajador(idn, idclt, false, false, true, false, diasp, idmot);
                CalculosNomina calculosnomina = new CalculosNomina(nt);

                //var modelo = db.Nomina_stNominaTrabajador.AsNoTracking().Where(a => a.IdNomina == idn && a.IdConvenioLaboralTrabajadorCategoria == idclt).ToList();

                //foreach (var item in modelo)
                //{
                //    item.IdMotivoDevolucion = (short)idmot;

                //    db.Entry(item).State = EntityState.Modified;
                //    db.SaveChanges();
                //}
                    

                TimeSpan difference = HoraFinProceso - HoraInicioProceso;
                double seconds = Math.Round(difference.TotalSeconds, 2);
                
                nt.getuniversoTrabajadores();
                return JsonView(true, " Proceso realizado correctamente en <strong> " + seconds.ToString() + "</strong> segs.<p> Total de trabajadores: " + nt.TrabajadoresVigentes.Count.ToString());

            }
            catch (NominaExcepcion ex)
            {
               // Nomina_stNominaTrabajador.rollbackReCalculoTrabajador(idn, idclt);

                return JsonView(false, ExceptionExtensions.GetOriginalException(ex).Message, null, null, null, null, ex.ErrorCode.ToString());
            }
            catch (Exception ex)
            {
                //Nomina_stNominaTrabajador.rollbackReCalculoTrabajador(idn, idclt);
                return JsonView(false, ExceptionExtensions.GetOriginalException(ex).Message + " | " + ex.StackTrace + " | " + ex.Source);
            }
             

               
             

              
              //}
        }

        [HttpPost]
        public ActionResult CambiarFechaPago()
        {
            var idnomina = Libraries.ConvertToInt.ConvertToInt32(HttpContext.Request.Params.Get("hfidNominacambios"));
            var ids = HttpContext.Request.Params.Get("hfidcltccambios");
            var fechainiciopago = HttpContext.Request.Params.Get("fechainiciopago");

            if (fechainiciopago.Trim() == "" || ids == "")
            {
                return JsonView(false, "Debe de seleccionar trabajadores y fecha de pago para poder realizar el proceso");
            }


            var fecha = DateTime.Parse(fechainiciopago);
            bdNovaEntities bd = new bdNovaEntities();
            var datos = bd.Nomina_stNomina.Find(idnomina);
            if (datos.FechaTermino >= fecha)
            {
                return JsonView(false, "La fecha de pago debe de ser mayor a la fecha de término de la quincena a procesar");
            }

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query;


            // actualiza la bandera de las altas 

            ids = ids.Substring(0, ids.Length - 1);

            query = @"update Convenios_stConvenioLaboralTrabajadorCategoria set FechaInicioPago='" + fechainiciopago + @"' where IdConvenioLaboralTrabajadorCategoria 
                                in (" + ids + ")";
            try
            {
                var ww = dp.connection.Execute(query);
            }
            catch (Exception ex)
            {

                return JsonView(false, ExceptionExtensions.GetOriginalException(ex).Message);
            }


            dp.Close();
            return JsonView(true, "Se han cambiado exitosamente las fechas de pago de los trabajadores seleccionados");
        }
        public ActionResult PosponerAltas(int id)
        {
            bdNovaEntities bd = new bdNovaEntities();
            var nomina = bd.Nomina_stNomina.Find(id);
            var trabajadores = bd.Convenios_stConvenioLaboralTrabajadorCategoria.AsNoTracking().Where(s => s.EsPrimerCalculo == true && s.FechaInicioPago == null).Select(d => d.IdConvenioLaboralTrabajadorCategoria).ToArray();
            var model = bd.vwDatosAspirantesTrabajadores.AsNoTracking().Where(d =>
              d.RelacionConvenioLaboral == nomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral
              && trabajadores.Contains((int)d.IdConvenioLaboralTrabajadorCategoria)).ToList();
            ViewBag.nomina = nomina;
            return PartialView("_PosponerPagoAltas", model);
        }


        public ActionResult CalcularNominaTrabajador(int idnomina,int idcltc)
        {


            try
            {



                DateTime HoraInicioProceso = DateTime.Now;

                String msjnomina = "";
                var TipoCalculos = HttpContext.Request.Params.Get("Tipo");
                int totalTrabajadores = 0;
                var item = db.Nomina_stNomina.Find(idnomina);

                if (item.EsCerrada)
                {
                    return JsonView(false, $" La nómina { item.Nomina_ctPlantillaNomina.Plantilla} de fechas {item.FechaInicio.ToString("yyyy-MM-dd")} al {item.FechaTermino.ToString("yyyy-MM-dd")} ya esta cerrada");
                }


                msjnomina = msjnomina + "<p> la nómina de <strong>" + item.Nomina_ctPlantillaNomina.Plantilla + "</strong> del " + item.FechaInicio.ToShortDateString() + " al " + item.FechaTermino.ToShortDateString() + " </p>";

                            Nomina_stNominaTrabajador nt = new Nomina_stNominaTrabajador(item.IdNomina, idcltc, false, false, false,false);

                            CalculosNomina calculosnomina = new CalculosNomina(nt);
                
                nt.getuniversoTrabajadores();
                            ActualizaProcesados(item.IdNomina, nt.UniversoTrabajadores, nt.TrabajadoresVigentes.Count(), nt.TrabajadoresError);
                            totalTrabajadores = totalTrabajadores + nt.TrabajadoresVigentes.Count();

                 

                        DateTime HoraFinProceso = DateTime.Now;
                        TimeSpan difference = HoraFinProceso - HoraInicioProceso;
                        double seconds = Math.Round(difference.TotalSeconds, 2);


                var model = db.Convenios_stConvenioLaboralTrabajadorCategoria.AsNoTracking().Where(a => a.IdConvenioLaboralTrabajadorCategoria == idcltc).Include(a => a.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales).FirstOrDefault();

                string persona = $" el trabajador : {model.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre} {model.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno} {model.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno}";
                        TimeSpan t = TimeSpan.FromSeconds(seconds);
                        SendPushNotification(" Cálculo realizado para :" +persona +" de "+ msjnomina, TypePushNotification.success, "Nómina");
                        return JsonView(true, " <p>Proceso realizado correctamente para: "  +persona +" de "+" </p>" + msjnomina + "<p> en <strong> " + t.ToString() + "</strong> segs.<p> Total de trabajadores: " + totalTrabajadores.ToString() + "</p>");
             

            }


            catch (NominaExcepcion ex)
            {

                return JsonView(false, ExceptionExtensions.GetOriginalException(ex).Message, null, null, null, null, ex.ErrorCode.ToString());
            }
            catch (Exception ex)
            {

                return JsonView(false, ExceptionExtensions.GetOriginalException(ex).Message + " | " + ex.StackTrace + " | " + ex.Source);
            }

            return Json(new { Valid = false, msj = " No se puede procesar la nómina" });
        }
        public ActionResult CalcularNomina()
        {


            try
            {



                DateTime HoraInicioProceso = DateTime.Now;

                String msjnomina = "";
                var TipoCalculos = HttpContext.Request.Params.Get("Tipo");
                int totalTrabajadores = 0;
                if (TipoCalculos != null)
                {
                    if (TipoCalculos != "")
                    {
                        List<Nomina_stNomina> nominasAbiertas = new List<Nomina_stNomina>();
                        if (TipoCalculos == "IndexAdministrativa")

                            nominasAbiertas = db.Nomina_stNomina.AsNoTracking().Where(
                                s => s.Nomina_ctPlantillaNomina.CalculoPorSolicitud==false && s.EsCerrada == false && s.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral != "DOCENTE"
                                ).OrderBy(q => new { q.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral, q.Nomina_ctPlantillaNomina.Orden }).ToList();
                        else
                            nominasAbiertas = db.Nomina_stNomina.AsNoTracking().Where(
                                s => s.Nomina_ctPlantillaNomina.CalculoPorSolicitud == false && s.EsCerrada == false && s.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral == "DOCENTE"
                                ).OrderBy(q => new { q.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral, q.Nomina_ctPlantillaNomina.Orden }).ToList();


                        int contador = 0;
                        bool resetSingleton = false;
                        foreach (var item in nominasAbiertas)
                        {

                            contador++;
                            if (contador == 1)
                                resetSingleton = true;
                            else
                                resetSingleton = false;


                            msjnomina = msjnomina + "<p> la nómina de <strong>" + item.Nomina_ctPlantillaNomina.Plantilla + "</strong> del " + item.FechaInicio.ToShortDateString() + " al " + item.FechaTermino.ToShortDateString() + " </p>";

                            Nomina_stNominaTrabajador nt = new Nomina_stNominaTrabajador(item.IdNomina, 0, false, false, false, resetSingleton);
                            
                            CalculosNomina calculosnomina = new CalculosNomina(nt);

                            nt.getuniversoTrabajadores();

                            ActualizaProcesados(item.IdNomina, nt.UniversoTrabajadores, nt.TrabajadoresVigentes.Count(), nt.TrabajadoresError);
                            totalTrabajadores = totalTrabajadores + nt.TrabajadoresVigentes.Count();


                        }

                        DateTime HoraFinProceso = DateTime.Now;
                        TimeSpan difference = HoraFinProceso - HoraInicioProceso;
                        double seconds = Math.Round(difference.TotalSeconds, 2);



                        TimeSpan t = TimeSpan.FromSeconds(seconds);
                        SendPushNotification(" Cálculo realizado de :" + msjnomina, TypePushNotification.success, "Nómina");
                        return JsonView(true, " <p>Proceso realizado correctamente Para: </p>" + msjnomina + "<p> en <strong> " + t.ToString() + "</strong> segs.<p> Total de trabajadores: " + totalTrabajadores.ToString() + "</p>");
                    }
                }
                else
                {
                    //AuthorizationContext ht = new AuthorizationContext();
                    Session["IdNomina"] = Convert.ToInt32(HttpContext.Request.Params.Get("IdNomina"));
                    Session["IdConvenioLaboralTrabajadorCategoria"] = Convert.ToInt32(HttpContext.Request.Params.Get("IdConvenioLaboralTrabajadorCategoria"));
                    int idn = Convert.ToInt32(Session["IdNomina"]);
                    int idclt = Convert.ToInt32(Session["IdConvenioLaboralTrabajadorCategoria"]);
                    Nomina_stNominaTrabajador nt = new Nomina_stNominaTrabajador(idn, idclt);

                    CalculosNomina calculosnomina = new CalculosNomina(nt);


                    DateTime HoraFinProceso = DateTime.Now;


                    TimeSpan difference = HoraFinProceso - HoraInicioProceso;
                    double seconds = Math.Round(difference.TotalSeconds, 2);



                    TimeSpan t = TimeSpan.FromSeconds(seconds);

                    msjnomina = "<p> la nómina de <strong>" + nt.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla + "</strong> del " + nt.Nomina_stNomina.FechaInicio.ToShortDateString() + " al " + nt.Nomina_stNomina.FechaTermino.ToShortDateString() + " </p>";
                    
                    nt.getuniversoTrabajadores();
                    ActualizaProcesados(idn, nt.UniversoTrabajadores, nt.TrabajadoresVigentes.Count(), nt.TrabajadoresError);

                    SendPushNotification(" Cálculo realizado de :" + msjnomina, TypePushNotification.success, "Nómina");
                    return JsonView(true, " <p>Proceso realizado correctamente Para: </p>" + msjnomina + "<p> en <strong> " + t.ToString() + "</strong> segs.<p> Total de trabajadores: " + nt.TrabajadoresVigentes.Count.ToString() + "</p>");
                }
                //return Json(new { Valid=true, Tiempo = " <p>Proceso realizado correctamente Para: </p>"+ msjnomina + "<p> en <strong> " + t.ToString() + "</strong> segs.<p> Total de trabajadores: " + nt.TrabajadoresVigentes.Count.ToString()+"</p>" });
                //return Json(new { Valid = false, msj = " <p>Proceso realizado correctamente Para: </p>" + msjnomina + "<p> en <strong> " + t.ToString() + "</strong> segs.<p> Total de trabajadores: " + nt.TrabajadoresVigentes.Count.ToString() + "</p>" });

            }


            catch (NominaExcepcion ex)
            {

                return JsonView(false, ExceptionExtensions.GetOriginalException(ex).Message, null, null, null, null, ex.ErrorCode.ToString());
            }
            catch (Exception ex)
            {

                return JsonView(false, ExceptionExtensions.GetOriginalException(ex).Message + " | " + ex.StackTrace + " | " + ex.Source);
            }

            return Json(new { Valid = false, msj = " No se puede procesar la nómina" });
        }
        public void ActualizaProcesados(int idnomina, int Universo, int procesados, int trabajadoreserror)
        {
            int idnom = Convert.ToInt32(HttpContext.Request.Params.Get("IdNomina"));
            Nova.Models.Nomina_stNomina st_nomina = db.Nomina_stNomina.Find(idnomina);
            st_nomina.TrabajadoresProcesados = procesados;
            st_nomina.UniversoTrabajadores = Universo;
            if (trabajadoreserror > 0)
            {
                st_nomina.EsError = true;
            }
            //var model = db.Nomina_stNomina;
            if (ModelState.IsValid)
            {
                try
                {
                    //var modelItem = model.FirstOrDefault(it => it.IdNomina == idnomina);
                    if (st_nomina != null)
                    {
                        db.Entry(st_nomina).State = System.Data.Entity.EntityState.Modified;
                        db.SaveChanges();
                        //this.UpdateModel(st_nomina);
                        //db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    throw new System.ApplicationException("No fue posible actualizar para la nómina " + idnomina.ToString() + "el número de trabajadores procesados !!");
                }
            }
            else
                throw new System.ApplicationException("No fue posible actualizar para la nómina " + idnomina.ToString() + "el número de trabajadores procesados !!");
            return;

            //return View("Index");
        }
        [OutputCache(Location = System.Web.UI.OutputCacheLocation.None, NoStore = true)]
        public ActionResult ActualizaViewbag(int idnomina)
        {
            Session["IdNomina"] = idnomina;

            return null;
        }

        //[HttpPost]
        public ActionResult Reporte(int id)
        {
            ViewBag.id = id;

            return View();
        }

     

        public ActionResult NominasPorTrabajador(int id)
        {
            bdNovaEntities bd = new bdNovaEntities();

            var t = bd.Nomina_stNominaTrabajador.AsNoTracking().Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdTrabajador == id).ToList();
            return View(t);
        }

        public ActionResult ReporteGeneralIncidencias()
        {


            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string u = @"select * from (
                    
                    SELECT a.IdIncidenciaTrabajador,t.IdTrabajador, t.RelacionLaboral,t.ConvenioLaboral,t.RelacionConvenioLaboral, a.Horas,
                    t.Nombre +' ' +t.ApellidoPaterno +' ' +t.ApellidoMaterno as Nombre ,t.Categoria,t.UbicacionFisica,t.IdEstructuraOrganicaFisica
                    ,a.FechaInicio,a.EsFaltaDirecta,b.Incidencia,c.TipoIncidenciaPermiso
                    FROM IncidenciaPermiso_stIncidenciaTrabajador  a
 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
  inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
 inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
 WHERE c.TipoIncidenciaPermiso in('INCIDENCIA') 
 and EsCerrada=1 AND EsAplicada=0 and Autorizo=0) as uno
                    inner join (
                    SELECT  q.IdEstructuraOrganica ,a.Nombre +' ' +a.ApellidoPaterno +' ' +a.ApellidoMaterno as Registro,q.EstructuraOrganica 
                     FROM Nomina_RelojChecadorControlUsuarios w
                    inner join Nomina_RelojChecadorAreas r on w.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join  Nomina_RelojChecadorAreasEstructuraOrganica s on s.IdRelojChecadorAreas=r.IdRelojChecadorAreas
                    inner join Catalogos_ctEstructuraOrganica q on q.IdEstructuraOrganica=s.IdEstructuraOrganica
                    inner join vwDatosAspirantesTrabajadores  a on a.IdConvenioLaboralTrabajadorCategoria=w.IdConvenioLaboralTrabajadorCategoria
                    
                    ) as dos on uno.IdEstructuraOrganicaFisica=dos.IdEstructuraOrganica";


            List<IndicenciasConcentrado> model = (List<IndicenciasConcentrado>)dp.connection.Query<IndicenciasConcentrado>(u);



            ViewBag.TituloView = "Incidencias para aplicar al " + DateTime.Now.ToShortDateString();

            return View(model);
        }

        public ActionResult ReporteSaldosIncidencias(string id)
        {

           

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query = @"SELECT a.IdIncidenciaTrabajador,b.IdTrabajador,b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.RelacionConvenioLaboral,d.Incidencia,c.FechaInicio,c.FechaTermino
,b.Categoria,b.UbicacionFisica,a.Saldo,a.Total,a.DiasSaldo,a.DiasTotales
  FROM  [Nomina_IncidenciasSaldos] a
  inner join  IncidenciaPermiso_stIncidenciaTrabajador c on a.IdIncidenciaTrabajador=c.IdIncidenciaTrabajador
  inner join  Catalogos_ctTipoIncidencia d on d.IdTipoIncidencia=c.IdTipoIncidencia
  inner join  vwDatosAspirantesTrabajadoresHistorial b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
where [RelacionConvenioLaboral]='" + id+"' " +
@" union SELECT a.IdIncidenciaTrabajador,b.IdTrabajador,b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.RelacionConvenioLaboral,d.Incidencia,c.FechaInicio,c.FechaTermino
 ,b.Categoria,b.UbicacionFisica,a.Saldo,a.Total,a.DiasSaldo,a.DiasTotales
  FROM[Nomina_IncidenciasSaldosAuxiliar] a
inner join IncidenciaPermiso_stIncidenciaTrabajador c on a.IdIncidenciaTrabajador = c.IdIncidenciaTrabajador
  inner join  Catalogos_ctTipoIncidencia d on d.IdTipoIncidencia = c.IdTipoIncidencia
  inner join  vwDatosAspirantesTrabajadoresHistorial b on a.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
where[RelacionConvenioLaboral] = '" + id+"'";

            List<SaldosIncidenciasIncapacidades> items = (List<SaldosIncidenciasIncapacidades>)dp.connection.Query<SaldosIncidenciasIncapacidades>(query);
 
            dp.Close();



            ViewBag.TituloView = "Saldos de Incidencias por Incapacidades";

            return View("ReporteSaldosIncidencias", items);
        }
        public ActionResult ReportePrimaDominical(int id)
        {

            var nomina = db.Nomina_stNomina.Find(id);

            if (nomina.EsCerrada == true)
                throw new ApplicationException("La nómina ya esta cerrada, no es posible mostrar esta información");

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query = @"SELECT IdIncidenciaTrabajador FROM IncidenciaPermiso_stIncidenciaTrabajador a
inner join Catalogos_ctTipoIncidencia c on a.IdTipoIncidencia=c.IdTipoIncidencia
  inner join  Catalogos_ctTipoIncidenciaPermiso d on c.IdTipoIncidenciaPermiso=d.IdTipoIncidenciaPermiso

                    WHERE    d.TipoIncidenciaPermiso in('PERCEPCION') 
        
                     and EsCerrada=1 AND EsAplicada=0 and ((Autorizo=1 and a.IdIncidenciaJustificacion=0) or Autorizo=0 OR EsCancelada=1 ) 
                    AND A.QuincenaParaNomina="+nomina.Catalogos_ctQuincenaMes.QuincenaMes+ @" and AñoParaNomina=" + nomina.Año + @"
                    and IdConvenioLaboralTrabajadorCategoria in (
						select IdConvenioLaboralTrabajadorCategoria from vwDatosAspirantesTrabajadoresHistorial a1
						inner join Nomina_ctPlantillaNomina b1 on a1.IdRelacionConvenioLaboral=b1.IdRelacionConvenioLaboral
						inner join Nomina_stNomina e1 on e1.IdPlantillaNomina=b1.IdPlantillaNomina
						where IdNomina=" + id + ")";

            List<long> items = (List<long>)dp.connection.Query<long>(query);

            var model = db.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(s => items.Contains(s.IdIncidenciaTrabajador)
              

            ).ToList();
            dp.Close();



            ViewBag.TituloView = "Primas Dominicales para aplicar en la Nómina " + nomina.Nomina_ctPlantillaNomina.Plantilla + " del " + nomina.FechaInicio.ToShortDateString() + " al " + nomina.FechaTermino.ToShortDateString();

            return View("ReporteIncidencias",model);
        }
        public ActionResult ReporteIncidencias(int id)
        {

            var nomina = db.Nomina_stNomina.Find(id);

            if (nomina.EsCerrada == true)
                throw new ApplicationException("La nómina ya esta cerrada, no es posible mostrar esta información");

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query = @"SELECT IdIncidenciaTrabajador FROM IncidenciaPermiso_stIncidenciaTrabajador a
inner join Catalogos_ctTipoIncidencia c on a.IdTipoIncidencia=c.IdTipoIncidencia
  inner join  Catalogos_ctTipoIncidenciaPermiso d on c.IdTipoIncidenciaPermiso=d.IdTipoIncidenciaPermiso

                    WHERE    d.TipoIncidenciaPermiso in('INCIDENCIA','RETARDOS') 
           AND A.QuincenaParaNomina=" + nomina.Catalogos_ctQuincenaMes.QuincenaMes + @" and AñoParaNomina=" + nomina.Año + @"
                     and EsCerrada=1 AND EsAplicada=0 and ((Autorizo=1 and a.IdIncidenciaJustificacion=0) or Autorizo=0 OR EsCancelada=1 ) 
                    
                    and IdConvenioLaboralTrabajadorCategoria in (
						select IdConvenioLaboralTrabajadorCategoria from vwDatosAspirantesTrabajadoresHistorial a1
						inner join Nomina_ctPlantillaNomina b1 on a1.IdRelacionConvenioLaboral=b1.IdRelacionConvenioLaboral
						inner join Nomina_stNomina e1 on e1.IdPlantillaNomina=b1.IdPlantillaNomina
						where IdNomina=" + id + ")";

            List<long> items = (List<long>)dp.connection.Query<long>(query);

            var model = db.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(s => items.Contains(s.IdIncidenciaTrabajador)
              && !s.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso.TipoIncidenciaPermiso.Contains("PERCEPCION")
              && !s.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso.TipoIncidenciaPermiso.Contains("BAJAS")
              && !s.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso.TipoIncidenciaPermiso.Contains("RETARDOS")
            ).ToList();
            dp.Close();



            ViewBag.TituloView = "Incidencias para aplicar en la Nómina " + nomina.Nomina_ctPlantillaNomina.Plantilla + " del " + nomina.FechaInicio.ToShortDateString() + " al " + nomina.FechaTermino.ToShortDateString();

            return View(model);
        }


        public ActionResult ReporteIncidenciasAplicadas(int id)
        {
            var nomina = db.Nomina_stNomina.Find(id);
            if (nomina.EsCerrada == false)
                throw new ApplicationException("La nómina No esta cerrada, no es posible mostrar esta información");

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query = @"SELECT a.IdIncidenciaTrabajador FROM IncidenciaPermiso_stIncidenciaTrabajador a
                    inner join  Nomina_stNominaIncidenciasTrabajadorAplicadas t on t.IdIncidenciaTrabajador=a.IdIncidenciaTrabajador
inner join Catalogos_ctTipoIncidencia c on a.IdTipoIncidencia=c.IdTipoIncidencia
  inner join  Catalogos_ctTipoIncidenciaPermiso d on c.IdTipoIncidenciaPermiso=d.IdTipoIncidenciaPermiso
                    WHERE c.EsAfectacionCalculoNomina=1 and  d.TipoIncidenciaPermiso in('INCIDENCIA','RETARDOS') and IDNOMINA=" + id + @"
AND EsCerrada=1 AND EsAplicada=1";


            List<long> items = (List<long>)dp.connection.Query<long>(query);

            var model = db.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking().Where(s => items.Contains(s.IdIncidenciaTrabajador)
            ).ToList();
            dp.Close();


            ViewBag.TituloView = "Incidencias aplicadas para la Nómina " + nomina.Nomina_ctPlantillaNomina.Plantilla + " del " + nomina.FechaInicio.ToShortDateString() + " al " + nomina.FechaTermino.ToShortDateString();
            return View("ReporteIncidencias", model);
        }



        public ActionResult ValidarDocente()
        {
            NominaValidator nomina = new NominaValidator();

            List<ErrorNomina> errores = new List<ErrorNomina>();

            var nominasAbiertas = db.Nomina_stNomina.AsNoTracking().Where(
                 s => s.Nomina_ctPlantillaNomina.CalculoPorSolicitud == false && s.EsCerrada == false && s.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral == "DOCENTE"
                 ).OrderBy(q => new { q.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral, q.Nomina_ctPlantillaNomina.Orden }).ToList();


            foreach (var item in nominasAbiertas)
            {
                var model = db.Nomina_stNominaTrabajador.AsNoTracking().Where(z => z.IdNomina == item.IdNomina)
              .Include(z => z.Convenios_stConvenioLaboralTrabajadorCategoria)
                  .Include(z => z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
              .ToList();

                var error = nomina.ValidateNomina(model);
                errores.AddRange(error);
            }



            return PartialView("validar", errores);
        }

        public ActionResult ValidarAdministrativa()
        {
            NominaValidator nomina = new NominaValidator();

            List<ErrorNomina> errores = new List<ErrorNomina>();

               var nominasAbiertas = db.Nomina_stNomina.AsNoTracking().Where(
                    s => s.Nomina_ctPlantillaNomina.CalculoPorSolicitud == false && s.EsCerrada == false && s.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral != "DOCENTE"
                    ).OrderBy(q => new { q.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral, q.Nomina_ctPlantillaNomina.Orden }).ToList();


            foreach (var item in nominasAbiertas)
            {
                var model = db.Nomina_stNominaTrabajador.AsNoTracking().Where(z => z.IdNomina == item.IdNomina)
              .Include(z => z.Convenios_stConvenioLaboralTrabajadorCategoria)
                  .Include(z => z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
              .ToList();

                var error = nomina.ValidateNomina(model);
                errores.AddRange(error);
            }
          
           

            return PartialView("validar",errores);
        }


        [HttpPost]
        public ActionResult ViaticosPorNomina(int id)
        {

            var nomina = db.Nomina_stNomina.AsNoTracking().Where(a=> a.IdNomina==id).FirstOrDefault();
                
                

            try
            {

                DapperQuery dp = new DapperQuery("bdNovaEntities");



                string sql = $@"SELECT a.Importe, f.IdTrabajador, FechaInicioPercepcion, a.FechaTermino, f.Nombre,f.ApellidoPaterno,f.ApellidoMaterno
,UbicacionFisica,Categoria,RelacionConvenioLaboral
FROM  [Percepciones_stPercepcionesPersonalizadas] a
INNER JOIN Percepciones_ctPercepcion c ON a.IdPercepcion = c.IdPercepcion
INNER JOIN vwDatosAspirantesTrabajadoresHistorial f ON f.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
WHERE Percepcion = 'VIÁTICOS'
AND a.FechaInicioPercepcion >= '{nomina.FechaInicio.ToString("yyyyMMdd")}'
AND a.FechaTermino <= '{nomina.FechaTermino.ToString("yyyyMMdd")}'
ORDER BY FechaInicioPercepcion, A.IdConvenioLaboralTrabajadorCategoria";


                List<ViaticosModel> items = (List<ViaticosModel>)dp.connection.Query<ViaticosModel>(sql);


                var excelBytes = ViaticosModel.ExportarViaticosPorNomina(items).Result;
                string fileName = $"Reporte_Viaticos_{DateTime.Now:yyyyMMdd_HHmmss}.xlsx";

                Response.ContentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
                Response.AddHeader("Content-Disposition", $"attachment; filename={fileName}");
                return File(excelBytes, Response.ContentType);
            }
            catch (Exception ex)
            {
                return Json(new { error = ex.Message }, JsonRequestBehavior.AllowGet);
            }
        }

        [HttpPost]
        public ActionResult DiasEconomicosPorNomina(int id)
        {
            try
            {

                DapperQuery dp = new DapperQuery("bdNovaEntities");

                
                
                string sql = $@"SELECT  'DiasEconomicos' as tipo, a.*,b.NombreCompleto,b.UbicacionFisica, categoria, b.RelacionConvenioLaboral
, case when IdModalidadEstudio=0 then 'OFICINAS CENTRALES' ELSE 'CENTROS EDUCATIVOS' end as Lugar
            ,b.EstructuraOrganica,QuincenaMes
 ,w.FechaInicio,w.FechaTermino,w.Año as AñoNomina,TipoPagoRegistro
  FROM [bdNova].[dbo].[Nomina_PagosDiasEconomicosyPuntualidadAuxiliar] A 
  inner join vwDatosAspirantesTrabajadores b on a.IdTrabajador=b.IdTrabajador
  inner join Catalogos_ctQuincenaMes d on d.IdQuincenaMes=a.IdQuincenaMes
  inner join Nomina_stNomina w on w.IdNomina=a.IdNomina
  inner join Catalogos_ctTipoPagoRegistro r on r.IdTipoPagoRegistro=a.IdTipoPagoRegistro
where 
  w.IdNomina={id}
  and esplazabase=1
  
  order by TipoPagoRegistro,idtrabajador";

                List<ReporteDiasEconomicosyPuntualidad> items = (List<ReporteDiasEconomicosyPuntualidad>)dp.connection.Query<ReporteDiasEconomicosyPuntualidad>(sql);

               
                var excelBytes =  ReporteDiasEconomicosyPuntualidad.ExportarDiasEconomicosPuntualidadAExcel(items).Result;
                string fileName = $"Reporte_DiasEconYPuntualidad_{DateTime.Now:yyyyMMdd_HHmmss}.xlsx";

                Response.ContentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
                Response.AddHeader("Content-Disposition", $"attachment; filename={fileName}");
                return File(excelBytes, Response.ContentType);
            }
            catch (Exception ex)
            {
                return Json(new { error = ex.Message }, JsonRequestBehavior.AllowGet);
            }
        }

        public ActionResult CreditosNoAplicados(int id)
        {
            bdNovaEntities nd = new bdNovaEntities();
            var model = db.Creditos_stNominaCreditoTrabajadorNoAplicados.AsNoTracking().Where(s => s.Nomina_stNominaTrabajador.IdNomina == id).ToList();


            return View(model);
        }
        public ActionResult ReporteNomina(int id)
        {
            List<Percepciones_stNominaTrabajadorPercepciones> model = db.Percepciones_stNominaTrabajadorPercepciones.AsNoTracking().Where(w => w.Nomina_stNominaTrabajador.IdNomina == id).OrderBy(q => new { q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.EstructuraOrganica, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre, q.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Clave }).ToList();
            if (model.Count == 0)
                throw new System.ApplicationException("No hay registros para esta Nómina");
            else
            {
                short idplantilla = model.ElementAt(0).Nomina_stNominaTrabajador.Nomina_stNomina.IdPlantillaNomina;
                ViewBag.Percepciones = db.Percepciones_stPlantillaNominaPercepciones.AsNoTracking().Where(q => q.IdPlantillaNomina == idplantilla).OrderBy(w => w.Percepciones_ctPercepcion.Percepcion).ToList(); ;
                ViewBag.Deducciones = db.Deducciones_stPlantillaNominaDeducciones.AsNoTracking().Where(q => q.IdPlantillaNomina == idplantilla).OrderBy(w => w.Deducciones_ctDeduccion.Deduccion).ToList(); ;
                ViewBag.NominaDeducciones = db.Deducciones_stNominaTrabajadorDeduccion.AsNoTracking().Where(w => w.Nomina_stNominaTrabajador.IdNomina == id).OrderBy(q => new { q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.EstructuraOrganica, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre, q.Deducciones_stPlantillaNominaDeducciones.Deducciones_ctDeduccion.Clave }).ToList();
                ViewBag.Creditos = db.Creditos_stNominaCreditoTrabajador.AsNoTracking().Where(w => w.Nomina_stNominaTrabajador.IdNomina == id).OrderBy(q => new { q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.EstructuraOrganica, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre, q.Creditos_stCreditoTrabajador.Catalogos_ctTipoCredito.TipoCredito }).ToList();
                ViewBag.CatalogoCreditos = db.Catalogos_ctTipoCredito.AsNoTracking().OrderBy(s => s.TipoCredito).ToList();

                ViewBag.Pensiones = db.Pensiones_stNominaPensionTrabajador.Where(w => w.Nomina_stNominaTrabajador.IdNomina == id).OrderBy(q => new { q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.EstructuraOrganica, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre, q.Pensiones_stPensionesTrabajador.FechaInicio }).ToList();
            }

            return PartialView("_reportenomina", model);
        }

        public ActionResult ExportToExcel(int id)
        {
            Response.AddHeader("content-disposition", "attachment;filename=Nomina_" + id.ToString() + ".xls");
            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            List<Percepciones_stNominaTrabajadorPercepciones> model = db.Percepciones_stNominaTrabajadorPercepciones.AsNoTracking().Where(w => w.Nomina_stNominaTrabajador.IdNomina == id).OrderBy(q => new { q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.EstructuraOrganica, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre, q.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Clave }).ToList();
            if (model.Count == 0)
                throw new System.ApplicationException("No hay registros para esta Nómina");
            else
            {
                short idplantilla = model.ElementAt(0).Nomina_stNominaTrabajador.Nomina_stNomina.IdPlantillaNomina;
                ViewBag.Percepciones = db.Percepciones_stPlantillaNominaPercepciones.AsNoTracking().Where(q => q.IdPlantillaNomina == idplantilla).OrderBy(w => w.Percepciones_ctPercepcion.Percepcion).ToList(); ;
                ViewBag.Deducciones = db.Deducciones_stPlantillaNominaDeducciones.AsNoTracking().Where(q => q.IdPlantillaNomina == idplantilla).OrderBy(w => w.Deducciones_ctDeduccion.Deduccion).ToList(); ;
                ViewBag.NominaDeducciones = db.Deducciones_stNominaTrabajadorDeduccion.AsNoTracking().Where(w => w.Nomina_stNominaTrabajador.IdNomina == id).OrderBy(q => new { q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.EstructuraOrganica, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre, q.Deducciones_stPlantillaNominaDeducciones.Deducciones_ctDeduccion.Clave }).ToList();
                ViewBag.Creditos = db.Creditos_stNominaCreditoTrabajador.AsNoTracking().Where(w => w.Nomina_stNominaTrabajador.IdNomina == id).OrderBy(q => new { q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.EstructuraOrganica, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre, q.Creditos_stCreditoTrabajador.Catalogos_ctTipoCredito.TipoCredito }).ToList();
                ViewBag.CatalogoCreditos = db.Catalogos_ctTipoCredito.AsNoTracking().OrderBy(s => s.TipoCredito).ToList();

                ViewBag.Pensiones = db.Pensiones_stNominaPensionTrabajador.AsNoTracking().Where(w => w.Nomina_stNominaTrabajador.IdNomina == id).OrderBy(q => new { q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Catalogos_ctEstructuraOrganica.EstructuraOrganica, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno, q.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre, q.Pensiones_stPensionesTrabajador.FechaInicio }).ToList();
            }

            return PartialView("_reportenomina", model);
        }

        public ActionResult getSueldo(int idcltc)
        {
            CalculadoraSueldo calculadora = new CalculadoraSueldo();
            var percepciones = calculadora.getSueldo(idcltc);

            return View();
        }
    }
}
