﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;
using System.Data.Entity;
using Seguridad;

namespace Nova.Controllers
{
    public class NominaApoyoEstudiosController : Controller
    {
        //
        // GET: /NominaApoyoEstudios/
        bdNovaEntities bd = new bdNovaEntities();

        public ActionResult Index(int idtrabajador)
        {
            string convenio = db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == idtrabajador).FirstOrDefault().ConvenioLaboral;
            if (convenio != "BASE")
            {
                throw new Exception("El convenio laboral del trabajador no es válido");
            }

            Session["idtrabajador"] = idtrabajador;
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvNominaApoyoEstudios()
        {
            int idtrabajador = Convert.ToInt32(Session["idtrabajador"]);
            var model = db.Nomina_ApoyoEstudios.Where(s =>  s.IdTrabajador ==idtrabajador);
            return PartialView("_pvNominaApoyoEstudios", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvNominaApoyoEstudiosAddNew(Nova.Models.Nomina_ApoyoEstudios item)
        {
            
            int idtrabajador = Convert.ToInt32(Session["idtrabajador"]);
            Nomina_ApoyoEstudios valida = new Nomina_ApoyoEstudios();
            if (!valida.ValidaModelo(item.FechaTermino,idtrabajador).IsValid)
            {
                ModelState.AddModelError("FechaTermino", valida.parenresult.Mensaje);

            }
            else { 
            item.IdTrabajador = idtrabajador;
            item.IdConvenioLaboralTrabajadorCategoria = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            item.FechaUltimaModificacion = DateTime.Today;
            }
            var model = db.Nomina_ApoyoEstudios;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            //var modelt = db.Nomina_ApoyoEstudios.Where(z=>z.IdTrabajador==idtrabajador);

            return PartialView("_pvNominaApoyoEstudios", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvNominaApoyoEstudiosUpdate(Nova.Models.Nomina_ApoyoEstudios item)
        {


            int idtrabajador = Convert.ToInt32(Session["idtrabajador"]);
            var model = db.Nomina_ApoyoEstudios;

            //Nomina_ApoyoEstudios valida = new Nomina_ApoyoEstudios();
            //if (!valida.ValidaModelo(item.FechaTermino, idtrabajador).IsValid)
            //{
            //    ModelState.AddModelError("FechaTermino", valida.parenresult.Mensaje);

            //}
            //else
            //{
            item.IdTrabajador = idtrabajador;
            item.IdConvenioLaboralTrabajadorCategoria = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            item.FechaUltimaModificacion = DateTime.Today;
            //}
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdTrabajador == item.IdTrabajador);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Por Favor corriga los errores !!";

            return PartialView("_pvNominaApoyoEstudios", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvNominaApoyoEstudiosDelete(System.Int32 IdNominaApoyoEstudios)
        {

            Nomina_ApoyoEstudios ele = db.Nomina_ApoyoEstudios.Where(x => x.IdNominaApoyoEstudios == IdNominaApoyoEstudios).FirstOrDefault();

            if (IdNominaApoyoEstudios != 0)
                if (ModelState.IsValid)
                {
                    try
                    {
                        db.Nomina_ApoyoEstudios.Attach(ele);
                        db.Nomina_ApoyoEstudios.Remove(ele);

                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }
                }
                else
                    ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                                 .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            var model = db.Nomina_ApoyoEstudios.Where(x => x.IdNominaApoyoEstudios == ele.IdNominaApoyoEstudios).ToList();
            return PartialView("_pvNominaApoyoEstudios", model.ToList());
        }


    }
}
