﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web.Mvc;
using Nova.Models;
using Rotativa;
using System.Threading.Tasks;
using System.IO;
using System.Transactions;

namespace Nova.Controllers.Mst
{
    public class MstTicketsController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: MstTickets
        public ActionResult Index()
        {
            Tuple<List<Mst_Ticket>, bool> model = null;

            int idUsuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            int idUsuarioArea = Seguridad.Identidad.Usuario().IdEstructuraOrganica;

            MstSeguridadRoles rolUser = new MstSeguridadRoles();
            if (rolUser.EsAdministrador())
            {
                var mst_Ticket = db.Mst_Ticket.Include(m => m.Mst_EquipoComputo).Include(m => m.Mst_EstatusTicket).Include(m => m.Mst_FormaContactoTicket).Include(m => m.Mst_PrioridadTicket).Include(m => m.Mst_ProcesoAtencionTicket).Include(m => m.Mst_TipoTicket);
                var modelOrder = mst_Ticket.OrderByDescending(y => y.IdTicket).ToList();
                model = Tuple.Create<List<Mst_Ticket>, bool>(modelOrder, true);
            }
            else
            {
                var mst_Ticket = db.Mst_Ticket.Include(m => m.Mst_EquipoComputo).Include(m => m.Mst_EstatusTicket).Include(m => m.Mst_FormaContactoTicket).Include(m => m.Mst_PrioridadTicket).Include(m => m.Mst_ProcesoAtencionTicket).Include(m => m.Mst_TipoTicket);
                var modelOrder = mst_Ticket.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUsuario).OrderByDescending(y => y.IdTicket).ToList();
                model = Tuple.Create<List<Mst_Ticket>, bool>(modelOrder, false);
            }

            return View(model);

        }

        // GET: MstTickets/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_Ticket mst_Ticket = db.Mst_Ticket.Find(id);
            if (mst_Ticket == null)
            {
                return HttpNotFound();
            }
            return View(mst_Ticket);
        }

        // GET: MstTickets/Create
        public ActionResult Create()
        {
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            var list = new List<SelectListItem>
            {
               new SelectListItem { Value = "0", Text = "Ninguno Seleccionado..." },
               //...
            };

            var modelE = list.Select(x => new {
                IdEquipoComputo = x.Value,
                EquipoComputo = x.Text
            }).ToList();



            var userName = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).Select(x => new
            {
                IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
                NombreCompleto =
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " +
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno
            }).ToList();

            var convenio = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).FirstOrDefault();
            List<Catalogos_ctEstructuraOrganica> catalogos_ctEstructuraOrganica = db.Catalogos_ctEstructuraOrganica.ToList();

            short idFirstEstructuraOrganica = catalogos_ctEstructuraOrganica.OrderBy(t => t.EstructuraOrganica).FirstOrDefault().IdEstructuraOrganica;
            //consultar los usuarios por defecto de la primera EstructuraOrganica
            var usersFirstEstructuraOrganica = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdEstructuraOrganica == idFirstEstructuraOrganica && t.FechaTermino == null ).Select(x => new
            {
                IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
                NombreCompleto =
                    
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + " " +
                        x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre
            }).ToList();

            MstSeguridadRoles rolUser = new MstSeguridadRoles();
            if (rolUser.EsAdministrador())
            {
                ViewBag.IdFormaContacto = new SelectList(db.Mst_FormaContactoTicket, "IdFormaContacto", "FormaContacto");
                ViewBag.IdEstructuraOrganica = new SelectList(catalogos_ctEstructuraOrganica.Where(t=>t.EsVigente == true).OrderBy(t=>t.EstructuraOrganica), "IdEstructuraOrganica", "EstructuraOrganica");
                ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(usersFirstEstructuraOrganica.OrderBy(o=>o.NombreCompleto), "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto");
            }
            else
            {
                ViewBag.IdEstructuraOrganica = new SelectList(catalogos_ctEstructuraOrganica.Where(t => t.IdEstructuraOrganica == convenio.IdEstructuraOrganica), "IdEstructuraOrganica", "EstructuraOrganica");
                ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(userName, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto");
            }


            ViewBag.IdEquipoComputo = new SelectList(modelE, "IdEquipoComputo", "EquipoComputo");
            //ViewBag.IdEstatusTicket = new SelectList(db.Mst_EstatusTicket, "IdEstatusTicket", "EstatusTicket");
            //ViewBag.IdFormaContacto = new SelectList(db.Mst_FormaContactoTicket, "IdFormaContacto", "FormaContacto");
            //ViewBag.IdPrioridadTicket = new SelectList(db.Mst_PrioridadTicket, "IdPrioridadTicket", "PrioridadTicket");
            //ViewBag.IdProcesoAtencionTicket = new SelectList(db.Mst_ProcesoAtencionTicket, "IdProcesoAtencionTicket", "ProcesoAtencionTicket");
            ViewBag.IdTipoTicket = new SelectList(db.Mst_TipoTicket.OrderByDescending(o=>o.TipoTicket), "IdTipoTicket", "TipoTicket");
            return View();
        }

        // POST: MstTickets/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdTicket,FechaRegistro,IdTipoTicket,IdEquipoComputo,Incidente,Comentario,IdProcesoAtencionTicket,IdPrioridadTicket,IdUsuarioAsignado,IdFormaContacto,IdEstatusTicket,IdEstructuraOrganica,IdConvenioLaboralTrabajadorCategoria,IdUserEnter")] Mst_Ticket mst_Ticket)
        {
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;


            mst_Ticket.FechaRegistro = DateTime.Now;
            mst_Ticket.IdEstatusTicket = db.Mst_EstatusTicket.Where(t => t.EstatusTicket == "Pendiente").Select(s => s.IdEstatusTicket).FirstOrDefault();


            //forma contacto dependiendo del rol
            MstSeguridadRoles rolUser = new MstSeguridadRoles();
            if (!rolUser.EsAdministrador())
            {
                mst_Ticket.IdFormaContacto = db.Mst_FormaContactoTicket.Where(t => t.FormaContacto == "Sistema").Select(s => s.IdFormaContacto).FirstOrDefault();
            }
            

            if ((mst_Ticket.IdTipoTicket == db.Mst_TipoTicket.Where(t => t.TipoTicket == "Mantenimiento").Select(s => s.IdTipoTicket).FirstOrDefault()) && (mst_Ticket.IdEquipoComputo == 0 || mst_Ticket.IdEquipoComputo == null))
            {
                ModelState.AddModelError("IdEquipoComputo", "Es necesario relacionar un Equipo de Computo.");
            }
            else if (mst_Ticket.IdTipoTicket != db.Mst_TipoTicket.Where(t => t.TipoTicket == "Mantenimiento").Select(s => s.IdTipoTicket).FirstOrDefault())
            {
                mst_Ticket.IdEquipoComputo = null;
            }


            //mst_Ticket.IdEstructuraOrganica = 160;
            mst_Ticket.NumeroTicket = "S18010001";
            //mst_Ticket.IdConvenioLaboralTrabajadorCategoria = 3990;
            mst_Ticket.IdUserEnter = idUser;


            if (ModelState.IsValid)
            {
                db.Mst_Ticket.Add(mst_Ticket);
                db.SaveChanges();
                return RedirectToAction("Index");
            }



            if (mst_Ticket.IdEquipoComputo == 0 || mst_Ticket.IdEquipoComputo == null)
            {
                var list = new List<SelectListItem>
                {
                   new SelectListItem { Value = "0", Text = "Ninguno Seleccionado..." },
                   //...
                };
                var modelE = list.Select(x => new {
                    IdEquipoComputo = x.Value,
                    EquipoComputo = x.Text
                }).ToList();
                ViewBag.IdEquipoComputo = new SelectList(modelE, "IdEquipoComputo", "EquipoComputo");
            }
            else
            {
                var mst_EquipoComputo = db.Mst_EquipoComputo.Include(m => m.Mst_MarcaEquipoComputo).Include(m => m.Mst_ModeloEquipoComputo).Include(m => m.Mst_TipoEquipoComputo).Select(x => new {
                    IdEquipoComputo = x.IdEquipoComputo,
                    EquipoComputo = x.Mst_TipoEquipoComputo.TipoEquipoComputo + " " + x.Mst_MarcaEquipoComputo.MarcaEquipoComputo + " " + x.Mst_ModeloEquipoComputo.ModeloEquipoComputo
                }).Where(t => t.IdEquipoComputo == mst_Ticket.IdEquipoComputo);
                ViewBag.IdEquipoComputo = new SelectList(mst_EquipoComputo, "IdEquipoComputo", "EquipoComputo", mst_Ticket.IdEquipoComputo);
            }





            var userName = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).Select(x => new
            {
                IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
                NombreCompleto =
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " +
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno
            }).ToList();


            //var convenio = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).FirstOrDefault();
            //var catalogos_ctEstructuraOrganica = db.Catalogos_ctEstructuraOrganica.Where(t => t.IdEstructuraOrganica == convenio.IdEstructuraOrganica);


            var convenio = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).FirstOrDefault();
            List<Catalogos_ctEstructuraOrganica> catalogos_ctEstructuraOrganica = db.Catalogos_ctEstructuraOrganica.ToList();

            short idSelectEstructuraOrganica = catalogos_ctEstructuraOrganica.Where(t => t.IdEstructuraOrganica == mst_Ticket.IdEstructuraOrganica).OrderBy(t => t.IdEstructuraOrganica).FirstOrDefault().IdEstructuraOrganica;
            //consultar los usuarios por defecto de la primera EstructuraOrganica
            var usersFirstEstructuraOrganica = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdEstructuraOrganica == idSelectEstructuraOrganica && t.FechaTermino == null).Select(x => new
            {
                IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
                NombreCompleto =
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " +
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno
            }).ToList();

            //MstSeguridadRoles rolUser = new MstSeguridadRoles();
            if (rolUser.EsAdministrador())
            {
                ViewBag.IdFormaContacto = new SelectList(db.Mst_FormaContactoTicket, "IdFormaContacto", "FormaContacto", mst_Ticket.IdFormaContacto);
                ViewBag.IdEstructuraOrganica = new SelectList(catalogos_ctEstructuraOrganica.Where(t => t.EsVigente == true).OrderBy(t => t.EstructuraOrganica), "IdEstructuraOrganica", "EstructuraOrganica", mst_Ticket.IdEstructuraOrganica);
                ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(usersFirstEstructuraOrganica, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto", mst_Ticket.IdConvenioLaboralTrabajadorCategoria);
            }
            else
            {
                ViewBag.IdEstructuraOrganica = new SelectList(catalogos_ctEstructuraOrganica.Where(t => t.IdEstructuraOrganica == convenio.IdEstructuraOrganica), "IdEstructuraOrganica", "EstructuraOrganica");
                ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(userName, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto");
            }



            //ViewBag.IdEstructuraOrganica = new SelectList(catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", mst_Ticket.IdEstructuraOrganica);
            //ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(userName, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto", mst_Ticket.IdConvenioLaboralTrabajadorCategoria);



            //ViewBag.IdEstatusTicket = new SelectList(db.Mst_EstatusTicket, "IdEstatusTicket", "EstatusTicket", mst_Ticket.IdEstatusTicket);
            //ViewBag.IdFormaContacto = new SelectList(db.Mst_FormaContactoTicket, "IdFormaContacto", "FormaContacto", mst_Ticket.IdFormaContacto);
            //ViewBag.IdPrioridadTicket = new SelectList(db.Mst_PrioridadTicket, "IdPrioridadTicket", "PrioridadTicket", mst_Ticket.IdPrioridadTicket);
            //ViewBag.IdProcesoAtencionTicket = new SelectList(db.Mst_ProcesoAtencionTicket, "IdProcesoAtencionTicket", "ProcesoAtencionTicket", mst_Ticket.IdProcesoAtencionTicket);
            ViewBag.IdTipoTicket = new SelectList(db.Mst_TipoTicket, "IdTipoTicket", "TipoTicket", mst_Ticket.IdTipoTicket);
            return View(mst_Ticket);
        }

        // GET: MstTickets/Edit/5
        public ActionResult Edit(int? id)
        {
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_Ticket mst_Ticket = db.Mst_Ticket.Find(id);
            if (mst_Ticket == null)
            {
                return HttpNotFound();
            }

            if (mst_Ticket.IdEquipoComputo == 0 || mst_Ticket.IdEquipoComputo == null)
            {
                var list = new List<SelectListItem>
                {
                   new SelectListItem { Value = "0", Text = "Ninguno Seleccionado..." },
                   //...
                };
                var modelE = list.Select(x => new {
                    IdEquipoComputo = x.Value,
                    EquipoComputo = x.Text
                }).ToList();
                ViewBag.IdEquipoComputo = new SelectList(modelE, "IdEquipoComputo", "EquipoComputo");
            }
            else
            {
                var mst_EquipoComputo = db.Mst_EquipoComputo.Include(m => m.Mst_MarcaEquipoComputo).Include(m => m.Mst_ModeloEquipoComputo).Include(m => m.Mst_TipoEquipoComputo).Select(x => new {
                    IdEquipoComputo = x.IdEquipoComputo,
                    EquipoComputo = x.Mst_TipoEquipoComputo.TipoEquipoComputo + " " + x.Mst_MarcaEquipoComputo.MarcaEquipoComputo + " " + x.Mst_ModeloEquipoComputo.ModeloEquipoComputo
                }).Where(t => t.IdEquipoComputo == mst_Ticket.IdEquipoComputo);
                ViewBag.IdEquipoComputo = new SelectList(mst_EquipoComputo, "IdEquipoComputo", "EquipoComputo", mst_Ticket.IdEquipoComputo);
            }

            //var mst_EquipoComputo = db.Mst_EquipoComputo.Include(m => m.Mst_MarcaEquipoComputo).Include(m => m.Mst_ModeloEquipoComputo).Include(m => m.Mst_TipoEquipoComputo).Select(x => new {
            //    IdEquipoComputo = x.IdEquipoComputo,
            //    EquipoComputo = x.Mst_TipoEquipoComputo.TipoEquipoComputo + " " + x.Mst_MarcaEquipoComputo.MarcaEquipoComputo + " " + x.Mst_ModeloEquipoComputo.ModeloEquipoComputo
            //}).Where(t => t.IdEquipoComputo == mst_Ticket.IdEquipoComputo);
            //ViewBag.IdEquipoComputo = new SelectList(mst_EquipoComputo, "IdEquipoComputo", "EquipoComputo", mst_Ticket.IdEquipoComputo);

            var userName = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).Select(x => new
            {
                IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
                NombreCompleto =
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " +
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno
            }).ToList();




            //var convenio = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).FirstOrDefault();
            //var catalogos_ctEstructuraOrganica = db.Catalogos_ctEstructuraOrganica.Where(t => t.IdEstructuraOrganica == convenio.IdEstructuraOrganica);

            var convenio = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).FirstOrDefault();
            List<Catalogos_ctEstructuraOrganica> catalogos_ctEstructuraOrganica = db.Catalogos_ctEstructuraOrganica.ToList();

            short idSelectEstructuraOrganica = catalogos_ctEstructuraOrganica.Where(t=>t.IdEstructuraOrganica == mst_Ticket.IdEstructuraOrganica).OrderBy(t => t.IdEstructuraOrganica).FirstOrDefault().IdEstructuraOrganica;
            //consultar los usuarios por defecto de la primera EstructuraOrganica
            var usersFirstEstructuraOrganica = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdEstructuraOrganica == idSelectEstructuraOrganica && t.FechaTermino == null).Select(x => new
            {
                IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
                NombreCompleto =
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " +
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno
            }).ToList();

            MstSeguridadRoles rolUser = new MstSeguridadRoles();
            if (rolUser.EsAdministrador())
            {
                ViewBag.IdFormaContacto = new SelectList(db.Mst_FormaContactoTicket, "IdFormaContacto", "FormaContacto",mst_Ticket.IdFormaContacto);
                ViewBag.IdEstructuraOrganica = new SelectList(catalogos_ctEstructuraOrganica.Where(t => t.EsVigente == true).OrderBy(t => t.EstructuraOrganica), "IdEstructuraOrganica", "EstructuraOrganica",mst_Ticket.IdEstructuraOrganica);
                ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(usersFirstEstructuraOrganica, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto",mst_Ticket.IdConvenioLaboralTrabajadorCategoria);
            }
            else
            {
                ViewBag.IdEstructuraOrganica = new SelectList(catalogos_ctEstructuraOrganica.Where(t => t.IdEstructuraOrganica == convenio.IdEstructuraOrganica), "IdEstructuraOrganica", "EstructuraOrganica");
                ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(userName, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto");
            }


            //ViewBag.IdEstructuraOrganica = new SelectList(catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", mst_Ticket.IdEstructuraOrganica);
            //ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(userName, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto", mst_Ticket.IdConvenioLaboralTrabajadorCategoria);


            //ViewBag.IdEstatusTicket = new SelectList(db.Mst_EstatusTicket, "IdEstatusTicket", "EstatusTicket", mst_Ticket.IdEstatusTicket);
            //ViewBag.IdFormaContacto = new SelectList(db.Mst_FormaContactoTicket, "IdFormaContacto", "FormaContacto", mst_Ticket.IdFormaContacto);
            //ViewBag.IdPrioridadTicket = new SelectList(db.Mst_PrioridadTicket, "IdPrioridadTicket", "PrioridadTicket", mst_Ticket.IdPrioridadTicket);
            //ViewBag.IdProcesoAtencionTicket = new SelectList(db.Mst_ProcesoAtencionTicket, "IdProcesoAtencionTicket", "ProcesoAtencionTicket", mst_Ticket.IdProcesoAtencionTicket);
            ViewBag.IdTipoTicket = new SelectList(db.Mst_TipoTicket, "IdTipoTicket", "TipoTicket", mst_Ticket.IdTipoTicket);
            return View(mst_Ticket);
        }

        // POST: MstTickets/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdTicket,FechaRegistro,NumeroTicket,IdTipoTicket,IdEquipoComputo,Incidente,Comentario,IdProcesoAtencionTicket,IdPrioridadTicket,IdUsuarioAsignado,IdFormaContacto,IdEstatusTicket,IdEstructuraOrganica,IdConvenioLaboralTrabajadorCategoria,IdUserEnter")] Mst_Ticket mst_Ticket)
        {
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            if (db.Mst_EstatusTicket.Where(t => t.IdEstatusTicket == mst_Ticket.IdEstatusTicket).Select(S => S.EstatusTicket).FirstOrDefault() != "Pendiente")
            {
                ModelState.AddModelError("IdTicket", "Control de seguridad. No se permite editar el Ticket!!!");
            }
            if ((mst_Ticket.IdTipoTicket == db.Mst_TipoTicket.Where(t => t.TipoTicket == "Mantenimiento").Select(s => s.IdTipoTicket).FirstOrDefault()) && (mst_Ticket.IdEquipoComputo == 0 || mst_Ticket.IdEquipoComputo == null))
            {
                ModelState.AddModelError("IdEquipoComputo", "Es necesario relacionar un Equipo de Computo.");

            }
            else if (mst_Ticket.IdTipoTicket == db.Mst_TipoTicket.Where(t => t.TipoTicket != "Mantenimiento").Select(s => s.IdTipoTicket).FirstOrDefault())
            {
                mst_Ticket.IdEquipoComputo = null;
            }



            if (ModelState.IsValid)
            {
                db.Entry(mst_Ticket).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            if (mst_Ticket.IdEquipoComputo == 0 || mst_Ticket.IdEquipoComputo == null)
            {
                var list = new List<SelectListItem>
                {
                   new SelectListItem { Value = "0", Text = "Ninguno Seleccionado..." },
                   //...
                };
                var modelE = list.Select(x => new {
                    IdEquipoComputo = x.Value,
                    EquipoComputo = x.Text
                }).ToList();
                ViewBag.IdEquipoComputo = new SelectList(modelE, "IdEquipoComputo", "EquipoComputo");
            }
            else
            {
                var mst_EquipoComputo = db.Mst_EquipoComputo.Include(m => m.Mst_MarcaEquipoComputo).Include(m => m.Mst_ModeloEquipoComputo).Include(m => m.Mst_TipoEquipoComputo).Select(x => new {
                    IdEquipoComputo = x.IdEquipoComputo,
                    EquipoComputo = x.Mst_TipoEquipoComputo.TipoEquipoComputo + " " + x.Mst_MarcaEquipoComputo.MarcaEquipoComputo + " " + x.Mst_ModeloEquipoComputo.ModeloEquipoComputo
                }).Where(t => t.IdEquipoComputo == mst_Ticket.IdEquipoComputo);
                ViewBag.IdEquipoComputo = new SelectList(mst_EquipoComputo, "IdEquipoComputo", "EquipoComputo", mst_Ticket.IdEquipoComputo);
            }

            var userName = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).Select(x => new
            {
                IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
                NombreCompleto =
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " +
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno
            }).ToList();

            //var convenio = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).FirstOrDefault();
            //var catalogos_ctEstructuraOrganica = db.Catalogos_ctEstructuraOrganica.Where(t => t.IdEstructuraOrganica == convenio.IdEstructuraOrganica);


            var convenio = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).FirstOrDefault();
            List<Catalogos_ctEstructuraOrganica> catalogos_ctEstructuraOrganica = db.Catalogos_ctEstructuraOrganica.ToList();

            short idSelectEstructuraOrganica = catalogos_ctEstructuraOrganica.Where(t => t.IdEstructuraOrganica == mst_Ticket.IdEstructuraOrganica).OrderBy(t => t.IdEstructuraOrganica).FirstOrDefault().IdEstructuraOrganica;
            //consultar los usuarios por defecto de la primera EstructuraOrganica
            var usersFirstEstructuraOrganica = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdEstructuraOrganica == idSelectEstructuraOrganica && t.FechaTermino == null).Select(x => new
            {
                IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
                NombreCompleto =
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " +
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno
            }).ToList();

            MstSeguridadRoles rolUser = new MstSeguridadRoles();
            if (rolUser.EsAdministrador())
            {
                ViewBag.IdFormaContacto = new SelectList(db.Mst_FormaContactoTicket, "IdFormaContacto", "FormaContacto", mst_Ticket.IdFormaContacto);
                ViewBag.IdEstructuraOrganica = new SelectList(catalogos_ctEstructuraOrganica.Where(t => t.EsVigente == true).OrderBy(t => t.EstructuraOrganica), "IdEstructuraOrganica", "EstructuraOrganica", mst_Ticket.IdEstructuraOrganica);
                ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(usersFirstEstructuraOrganica, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto", mst_Ticket.IdConvenioLaboralTrabajadorCategoria);
            }
            else
            {
                ViewBag.IdEstructuraOrganica = new SelectList(catalogos_ctEstructuraOrganica.Where(t => t.IdEstructuraOrganica == convenio.IdEstructuraOrganica), "IdEstructuraOrganica", "EstructuraOrganica");
                ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(userName, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto");
            }


            
            //ViewBag.IdEstructuraOrganica = new SelectList(catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", mst_Ticket.IdEstructuraOrganica);
            //ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(userName, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto", mst_Ticket.IdConvenioLaboralTrabajadorCategoria);


            //ViewBag.IdEquipoComputo = new SelectList(db.Mst_EquipoComputo, "IdEquipoComputo", "NumeroSerie", mst_Ticket.IdEquipoComputo);
            ViewBag.IdEstatusTicket = new SelectList(db.Mst_EstatusTicket, "IdEstatusTicket", "EstatusTicket", mst_Ticket.IdEstatusTicket);
            ViewBag.IdFormaContacto = new SelectList(db.Mst_FormaContactoTicket, "IdFormaContacto", "FormaContacto", mst_Ticket.IdFormaContacto);
            ViewBag.IdPrioridadTicket = new SelectList(db.Mst_PrioridadTicket, "IdPrioridadTicket", "PrioridadTicket", mst_Ticket.IdPrioridadTicket);
            ViewBag.IdProcesoAtencionTicket = new SelectList(db.Mst_ProcesoAtencionTicket, "IdProcesoAtencionTicket", "ProcesoAtencionTicket", mst_Ticket.IdProcesoAtencionTicket);
            ViewBag.IdTipoTicket = new SelectList(db.Mst_TipoTicket, "IdTipoTicket", "TipoTicket", mst_Ticket.IdTipoTicket);
            return View(mst_Ticket);
        }

        // GET: MstTickets/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_Ticket mst_Ticket = db.Mst_Ticket.Find(id);
            if (mst_Ticket == null)
            {
                return HttpNotFound();
            }
            return View(mst_Ticket);
        }

        // POST: MstTickets/Delete/5
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        [HttpPost]
        public ActionResult DeleteConfirmed()
        {
            var result = new { value = "", msg = "" };
            //var result = new { };
            int idTicket = System.Convert.ToInt32(Request["TicketId"]);
            if (idTicket <= 0)
            {
                result = new { value = "efailed", msg = "Error al identificar el Ticket" };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

            Mst_Ticket mst_Ticket = db.Mst_Ticket.Find(idTicket);

            if (mst_Ticket.Mst_EstatusTicket.EstatusTicket != "Pendiente")
            {
                result = new { value = "efailed", msg = "No se puede eliminar el Ticket identificado porque el Estatus ha cambiado." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }
            try
            {
                db.Mst_Ticket.Remove(mst_Ticket);
                db.SaveChanges();
            }
            catch (Exception e)
            {
                result = new { value = "efailed", msg = e.ToString() };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

            //return RedirectToAction("Index");
            result = new { value = "esuccess", msg = "Se ha eliminado el elemento correctamente." };
            return Json(result, JsonRequestBehavior.AllowGet);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }

        public ActionResult Follow(int? id)
        {
            var idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_Ticket mst_Ticket = db.Mst_Ticket.Find(id);
            if (mst_Ticket == null)
            {
                return HttpNotFound();
            }

            MstComentariosTicket ticketComentarios = new MstComentariosTicket();
            ticketComentarios.Ticket = mst_Ticket;
            ticketComentarios.Comentarios = db.Mst_ComentariosTicket.Where(t => t.IdTicket == mst_Ticket.IdTicket && t.Publico == true).ToList();


            ViewBag.IdUsuarioLogin = idUser;
            return View(ticketComentarios);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Follow([Bind(Include = "IdComentarioMv,Comentario,FechaComentarioMv,Publico,IdUsuarioComentarioMv,IdTicket,IdProcesoAtencionTicket,IdPrioridadTicket,IdEstatusTicket,IdUsuarioAsignado")] Mst_ComentariosTicket mst_ComentariosTicket)
        {
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            mst_ComentariosTicket.FechaComentarioMv = DateTime.Now;
            mst_ComentariosTicket.IdUsuarioComentarioMv = idUser;
            mst_ComentariosTicket.Publico = true;

            Mst_Ticket mst_Ticket = db.Mst_Ticket.Find(mst_ComentariosTicket.IdTicket);

            if (mst_Ticket == null)
            {
                ModelState.AddModelError(string.Empty,"No se localiza el Ticket");
            }

            mst_ComentariosTicket.IdEstatusTicket = mst_Ticket.IdEstatusTicket;

            if (mst_Ticket.IdPrioridadTicket.HasValue)
            {
                mst_ComentariosTicket.IdProcesoAtencionTicket = mst_Ticket.IdProcesoAtencionTicket.Value;
                mst_ComentariosTicket.IdPrioridadTicket = mst_Ticket.IdPrioridadTicket.Value;
                mst_ComentariosTicket.IdUsuarioAsignado = mst_Ticket.IdUsuarioAsignado.Value;
            }
            else
            {
                mst_ComentariosTicket.IdProcesoAtencionTicket = db.Mst_ProcesoAtencionTicket.Where(t => t.ProcesoAtencionTicket == "En línea").Select(s => s.IdProcesoAtencionTicket).FirstOrDefault();
                mst_ComentariosTicket.IdPrioridadTicket = db.Mst_PrioridadTicket.Where(t => t.PrioridadTicket == "Baja").Select(s => s.IdPrioridadTicket).FirstOrDefault();
                mst_ComentariosTicket.IdUsuarioAsignado = idUser;
            }

            

            //ModelState["IdComentarioMv"].Errors.Clear();
            //ModelState["Comentario"].Errors.Clear();
            //ModelState["FechaComentarioMv"].Errors.Clear();
            //ModelState["Publico"].Errors.Clear();
            //ModelState["IdUsuarioComentarioMv"].Errors.Clear();
            //ModelState["IdTicket"].Errors.Clear();
            ModelState["IdProcesoAtencionTicket"].Errors.Clear();
            ModelState["IdPrioridadTicket"].Errors.Clear();
            ModelState["IdEstatusTicket"].Errors.Clear();
            ModelState["IdUsuarioAsignado"].Errors.Clear();



            if (ModelState.IsValid)
            {
                
                db.Mst_ComentariosTicket.Add(mst_ComentariosTicket);
                db.SaveChanges();

                
                return RedirectToAction("Follow", "MstTickets", new { id = mst_ComentariosTicket.IdTicket });
            }


            MstComentariosTicket ticketComentarios = new MstComentariosTicket();
            ticketComentarios.Ticket = mst_Ticket;
            ticketComentarios.Comentarios = db.Mst_ComentariosTicket.Where(t => t.IdTicket == mst_Ticket.IdTicket && t.Publico == true).ToList();
            ticketComentarios.Comentario = mst_ComentariosTicket;


            ViewBag.IdUsuarioLogin = idUser;
            return View(ticketComentarios);
        }



        public ActionResult FollowAdmin(int? id)
        {
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_Ticket mst_Ticket = db.Mst_Ticket.Find(id);
            if (mst_Ticket == null)
            {
                return HttpNotFound();
            }
            MstComentariosTicket ticketComentarios = new MstComentariosTicket();
            ticketComentarios.Ticket = mst_Ticket;
            ticketComentarios.Comentarios = db.Mst_ComentariosTicket.Where(t => t.IdTicket == mst_Ticket.IdTicket && t.Publico == false).ToList();

            //List<string> listaUser = new List<string>();
            //listaUser.Add("Caleb Cruz Garcia");
            //listaUser.Add("Paulo Zafra J");
            var Hoy = DateTime.Now;
            var ListaUsuarios = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.FechaTermino==null  && t.Catalogos_ctEstructuraOrganica.EsVigente  == true && t.Catalogos_ctEstructuraOrganica.EstructuraOrganica.Contains("SISTEMAS")).Include(i => i.Convenios_stConvenioLaboralTrabajador).Select(x=>new
            {
                IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
                NombreCompleto = 
                            
                            x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                            x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + " " +
                            x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre 
            }).OrderBy(o=>o.NombreCompleto);


            //var modelUser = listaUser.Select(x => new
            //{
            //    IdConvenioLaboralTrabajadorCategoria = x,
            //    NombreCompleto = x
            //}).ToList();

            ViewBag.IdEstatusTicket = new SelectList(db.Mst_EstatusTicket.OrderBy(t=>t.IdEstatusTicket), "IdEstatusTicket", "EstatusTicket", mst_Ticket.IdEstatusTicket);
            ViewBag.IdPrioridadTicket = new SelectList(db.Mst_PrioridadTicket.OrderByDescending(t=>t.IdPrioridadTicket), "IdPrioridadTicket", "PrioridadTicket", mst_Ticket.IdPrioridadTicket);
            ViewBag.IdProcesoAtencionTicket = new SelectList(db.Mst_ProcesoAtencionTicket, "IdProcesoAtencionTicket", "ProcesoAtencionTicket", mst_Ticket.IdProcesoAtencionTicket);
            ViewBag.IdUsuarioAsignado = new SelectList(ListaUsuarios, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto", mst_Ticket.IdUsuarioAsignado);
            ViewBag.IdUsuarioLogin = idUser;
            return View(ticketComentarios);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult FollowAdmin([Bind(Include = "IdComentarioMv,Comentario,FechaComentarioMv,Publico,IdUsuarioComentarioMv,IdTicket,IdProcesoAtencionTicket,IdPrioridadTicket,IdEstatusTicket,IdUsuarioAsignado")] Mst_ComentariosTicket mst_ComentariosTicket)
        {
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            if (mst_ComentariosTicket.IdTicket == 0)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }

            mst_ComentariosTicket.FechaComentarioMv = DateTime.Now;
            //mst_ComentariosTicket.IdUsuarioAsignado = 3990;

            //este valor corresponde al usuarios logeado
            mst_ComentariosTicket.IdUsuarioComentarioMv = idUser;

            if (mst_ComentariosTicket.IdEstatusTicket == db.Mst_EstatusTicket.Where(t=>t.EstatusTicket == "Terminado").Select(s=>s.IdEstatusTicket).FirstOrDefault())
            {
                Mst_Reporte mst_Reporte = db.Mst_Reporte.Where(t => t.IdTicketAsociado == mst_ComentariosTicket.IdTicket).FirstOrDefault();
                if (mst_Reporte != null)
                {
                    if(mst_Reporte.Mst_EstatusReporte.EstatusReporte != "Entregado")
                    {
                        ModelState.AddModelError("IdEstatusTicket", "No se puede cerrar el Ticket porque esta asociado a un reporte y este sigue en Proceso.");
                    }
                }
            }
            if (mst_ComentariosTicket.IdEstatusTicket == db.Mst_EstatusTicket.Where(t => t.EstatusTicket == "Pendiente").Select(s => s.IdEstatusTicket).FirstOrDefault())
            {
                ModelState.AddModelError("IdEstatusTicket", "El Estatus debe cambiar a: En Proceso.");
            }

            


            if (ModelState.IsValid)
            {
                Mst_Ticket mstTicket = db.Mst_Ticket.Find(mst_ComentariosTicket.IdTicket);
                

                //saber que usuario esta asignado. 
                int idUserAsignadoAnterior =0;
                if (mstTicket.IdUsuarioAsignado.HasValue)
                {
                    idUserAsignadoAnterior = mstTicket.IdUsuarioAsignado.Value;
                }


                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {

                    mstTicket.IdEstatusTicket = mst_ComentariosTicket.IdEstatusTicket;
                    mstTicket.IdPrioridadTicket = mst_ComentariosTicket.IdPrioridadTicket;
                    mstTicket.IdProcesoAtencionTicket = mst_ComentariosTicket.IdProcesoAtencionTicket;
                    mstTicket.IdUsuarioAsignado = mst_ComentariosTicket.IdUsuarioAsignado;

                    db.Entry(mstTicket).State = EntityState.Modified;

                    db.Mst_ComentariosTicket.Add(mst_ComentariosTicket);
                    db.SaveChanges();


                    scope.Complete();
                }


                //enviar correo a quien se ha asignado el Ticket

                if ((idUserAsignadoAnterior == 0 && mst_ComentariosTicket.IdUsuarioAsignado != 0) || (idUserAsignadoAnterior != 0 && (idUserAsignadoAnterior != mst_ComentariosTicket.IdUsuarioAsignado)))
                {
                    string correoUsuarioAsignado = "";
                    //var existeCorreoOficial = mstTicket.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.CorreoOficial;
                    

                    if (mstTicket.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.CorreoOficial != "")
                    {
                        correoUsuarioAsignado = mstTicket.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.CorreoOficial;
                    }
                    else
                    {
                        correoUsuarioAsignado = mstTicket.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.CorreoElectronico;
                    }
                    
                    MstSoporteClass classMst = new MstSoporteClass();

                    string templateHtmlView = @"";
                    //Task.Run(async delegate

                    //{
                    //    templateHtmlView = await RenderRazorViewToStringForEmailUserAsignado(mstTicket);

                    //    var task = classMst.EnviarMailUsuarioAsignado(mstTicket.NumeroTicket, correoUsuarioAsignado, templateHtmlView);
                    //});
                    templateHtmlView = RenderRazorViewToStringForEmailUserAsignado(mstTicket);
                    var task = classMst.EnviarMailUsuarioAsignado(mstTicket.NumeroTicket, correoUsuarioAsignado, templateHtmlView);
                }





                //comprobar que el estatus sea en cerrar
                //var contextController = this.ControllerContext;
                
                if(mstTicket.IdEstatusTicket == db.Mst_EstatusTicket.Where(t=>t.EstatusTicket == "Terminado").Select(s=>s.IdEstatusTicket).FirstOrDefault())
                {
                    Mst_Ticket mst_TicketCache = db.Mst_Ticket.Find(mst_ComentariosTicket.IdTicket);
                    //es Convenios_stConvenioLaboralTrabajadorCategoria1
                    string correoUsuarioAtendido = "";
                    if (mst_TicketCache.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.CorreoOficial != null)
                    {
                        correoUsuarioAtendido = mst_TicketCache.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.CorreoOficial;
                    }
                    else
                    {
                        correoUsuarioAtendido = mst_TicketCache.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.CorreoElectronico;
                    }



                    //write code here 
                    byte[] binaryPdf = null;

                    binaryPdf = TestSavePdf(mst_TicketCache);
                    //lamar tarea asincrona para enviar mail
                    MstSoporteClass classMst = new MstSoporteClass();

                    string templateHtmlView = @"";
                    //Task.Run(async delegate
                    //{
                    //    templateHtmlView = await RenderRazorViewToStringForEmail2(this.ControllerContext, mstTicket);

                    //    var task = classMst.EnviarMail(binaryPdf, mstTicket.NumeroTicket, correoUsuarioAtendido, templateHtmlView);
                    //});

                    templateHtmlView = RenderRazorViewToStringForEmail(mst_TicketCache);
                    var task = classMst.EnviarMail(binaryPdf, mst_TicketCache.NumeroTicket,correoUsuarioAtendido, templateHtmlView);

                    //task.Start();
                }




                return RedirectToAction("FollowAdmin", "MstTickets", new { id = mst_ComentariosTicket.IdTicket });
            }


            Mst_Ticket mst_Ticket = db.Mst_Ticket.Find(mst_ComentariosTicket.IdTicket);
            if (mst_Ticket == null)
            {
                return HttpNotFound();
            }
            MstComentariosTicket ticketComentarios = new MstComentariosTicket();
            ticketComentarios.Ticket = mst_Ticket;
            ticketComentarios.Comentarios = db.Mst_ComentariosTicket.Where(t => t.IdTicket == mst_Ticket.IdTicket && t.Publico == false).ToList();
            ticketComentarios.Comentario = mst_ComentariosTicket;

            //List<string> listaUser = new List<string>();
            //listaUser.Add("Caleb Cruz Garcia");
            //listaUser.Add("Paulo Zafra J");
            
            var ListaUsuarios = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.FechaTermino == null && t.Catalogos_ctEstructuraOrganica.EsVigente == true  && t.Catalogos_ctEstructuraOrganica.EsVigente== true && t.Catalogos_ctEstructuraOrganica.EstructuraOrganica.Contains("SISTEMAS")).Include(i => i.Convenios_stConvenioLaboralTrabajador).Select(x => new
            {
                IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
                NombreCompleto =
                           
                            x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                            x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + " " +
                             x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre
            }).OrderBy(o => o.NombreCompleto);


            //var modelUser = listaUser.Select(x => new
            //{
            //    IdConvenioLaboralTrabajadorCategoria = x,
            //    NombreCompleto = x
            //}).ToList();

            ViewBag.IdEstatusTicket = new SelectList(db.Mst_EstatusTicket.OrderBy(t => t.IdEstatusTicket), "IdEstatusTicket", "EstatusTicket", mst_ComentariosTicket.IdEstatusTicket);
            ViewBag.IdPrioridadTicket = new SelectList(db.Mst_PrioridadTicket.OrderByDescending(t => t.IdPrioridadTicket), "IdPrioridadTicket", "PrioridadTicket", mst_ComentariosTicket.IdPrioridadTicket);
            ViewBag.IdProcesoAtencionTicket = new SelectList(db.Mst_ProcesoAtencionTicket, "IdProcesoAtencionTicket", "ProcesoAtencionTicket", mst_ComentariosTicket.IdProcesoAtencionTicket);
            ViewBag.IdUsuarioAsignado = new SelectList(ListaUsuarios, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto", mst_ComentariosTicket.IdUsuarioAsignado);
            ViewBag.IdUsuarioLogin = idUser;
            return View(ticketComentarios);
        }


        //obtener una lista para importarlo en los reportes
        [HttpPost]
        public ActionResult GetListTicketImport(string NumeroTicket)
        {
            if (NumeroTicket == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_Ticket mst_Ticket = db.Mst_Ticket.Where(t => t.NumeroTicket == NumeroTicket).FirstOrDefault();
            if (mst_Ticket == null)
            {
                //return HttpNotFound();
                var result = new { value_e = "efailed", msg = "La No se localiza un Ticket en el Numero:"+NumeroTicket };
                return Json(result, JsonRequestBehavior.AllowGet);
            }
            if (!mst_Ticket.IdEquipoComputo.HasValue)
            {
                var result = new { value_e = "efailed", msg = "El ticket Numero:" + NumeroTicket+" no tiene asociado un Equipo." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }
            if (mst_Ticket.Mst_EstatusTicket.EstatusTicket == "Terminado")
            {
                var result = new { value_e = "efailed", msg = "El ticket Numero:" + NumeroTicket + " esta Cerrado." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

            return PartialView("_ListaTicket", mst_Ticket);
        }


        //devuelbe el pdf en byte para que se envía por correo
        public byte[] TestSavePdf(Mst_Ticket mst_Ticket)
        {

            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 1;
            m.Right = 0;
            m.Top = 0;

            var pdfView = new ViewAsPdf("ViewPdf", mst_Ticket)
            {
                PageMargins = m,
                PageSize = Rotativa.Options.Size.Letter,
            };
            var binary = pdfView.BuildPdf(this.ControllerContext);
            return binary;
        }

        //descargar el pdf cuando el ticket se termina
        [HttpGet]
        public ActionResult ViewPdfDownload(int id)
        {
            if (id == 0)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_Ticket mst_Ticket = db.Mst_Ticket.Find(id);
            if (mst_Ticket == null)
            {
                return HttpNotFound();
            }
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 1;
            m.Right = 0;
            m.Top = 0;

            return new ViewAsPdf("ViewPdf", mst_Ticket)
            {
                PageMargins = m,
                PageSize = Rotativa.Options.Size.Letter,
                FileName = "Reporte_Ticket_" + mst_Ticket.NumeroTicket + ".pdf",

            };

        }

        //public Task<byte[]> TestSavePdf(Mst_Ticket mst_Ticket)
        //{
        //    return Task.Factory.StartNew(() =>
        //    {
        //        Rotativa.Options.Margins m = new Rotativa.Options.Margins();
        //        m.Bottom = 4;
        //        m.Left = 4;
        //        m.Right = 4;
        //        m.Top = 7;

        //        var pdfView = new PartialViewAsPdf("_ViewPdfSend", mst_Ticket)
        //        {
        //            FileName = "ejemplo2.pdf",
        //            PageSize = Rotativa.Options.Size.Letter,
        //        };
        
        //        var binary = pdfView.BuildPdf(this.ControllerContext);
        //        return binary;
        //    });

        //}

        //public ActionResult pdfprueba(int id)
        //{
        //    if (id == 0)
        //    {
        //        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        //    }
        //    Mst_Ticket mst_Ticket = db.Mst_Ticket.Find(id);
        //    if (mst_Ticket == null)
        //    {
        //        return HttpNotFound();
        //    }

        //    //return new PartialViewAsPdf("_ViewPdfSend", mst_Ticket)
        //    //{
        //    //    PageSize = Rotativa.Options.Size.Letter,
        //    //    FileName = "Reporte_Ticket_" + mst_Ticket.NumeroTicket + ".pdf",

        //    //};
        //    return View("ViewPdf", mst_Ticket);

        //}


        [System.Web.Services.WebMethod]
        public JsonResult GetUsersArea(int id)
        {
            var usersFirstEstructuraOrganica = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdEstructuraOrganica == id && t.FechaTermino == null).Select(x => new
            {
                IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
                NombreCompleto =
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno + " " +
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre
            }).ToList();
            return Json(usersFirstEstructuraOrganica.OrderBy(o=>o.NombreCompleto), JsonRequestBehavior.AllowGet);
        }

        public string RenderRazorViewToStringForEmail(Mst_Ticket mst_Ticket)
        {
            ViewData.Model = mst_Ticket;
            using (var sw = new StringWriter())
            {
                var viewResult = ViewEngines.Engines.FindPartialView(ControllerContext, "_ViewToStringSend");
                var viewContext = new ViewContext(ControllerContext, viewResult.View, ViewData, TempData, sw);
                viewResult.View.Render(viewContext, sw);
                viewResult.ViewEngine.ReleaseView(ControllerContext, viewResult.View);
                return sw.GetStringBuilder().ToString();
            }
        }

        public string RenderRazorViewToStringForEmailUserAsignado(Mst_Ticket mst_Ticket)
        {
            ViewData.Model = mst_Ticket;
            using (var sw = new StringWriter())
            {
                var viewResult = ViewEngines.Engines.FindPartialView(ControllerContext, "_ViewToStringSendUsuarioAsignado");
                var viewContext = new ViewContext(ControllerContext, viewResult.View, ViewData, TempData, sw);
                viewResult.View.Render(viewContext, sw);
                viewResult.ViewEngine.ReleaseView(ControllerContext, viewResult.View);
                return sw.GetStringBuilder().ToString();
            }
        }

        //public Task<string> RenderRazorViewToStringForEmail2(ControllerContext context,Mst_Ticket mst_Ticket)
        //{
        //    return Task.Factory.StartNew(() =>
        //    {
        //        ViewData.Model = mst_Ticket;
        //        using (var sw = new StringWriter())
        //        {
        //            var viewResult = ViewEngines.Engines.FindPartialView(context, "_ViewToStringSend");
        //            var viewContext = new ViewContext(context, viewResult.View, ViewData, TempData, sw);
        //            viewResult.View.Render(viewContext, sw);
        //            viewResult.ViewEngine.ReleaseView(context, viewResult.View);
        //            return sw.GetStringBuilder().ToString();
        //        }
        //    });

        //}

        //public Task<string> RenderRazorViewToStringForEmailUsuarioAsignado2(ControllerContext context, Mst_Ticket mst_Ticket)
        //{
        //    return Task.Factory.StartNew(() =>
        //    {
        //        ViewData.Model = mst_Ticket;
        //        using (var sw = new StringWriter())
        //        {
        //            var viewResult = ViewEngines.Engines.FindPartialView(context, "_ViewToStringSendUsuarioAsignado");
        //            var viewContext = new ViewContext(context, viewResult.View, ViewData, TempData, sw);
        //            viewResult.View.Render(viewContext, sw);
        //            viewResult.ViewEngine.ReleaseView(context, viewResult.View);
        //            return sw.GetStringBuilder().ToString();
        //        }
        //    });

        //}

    }
}
