﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Mst.Ticket
{
    public class MstEstructuraOrganicaProveedorInternetController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: MstEstructuraOrganicaProveedorInternet
        public ActionResult Index()
        {
            var mst_EstructuraOrganicaProveedorInternet = db.Mst_EstructuraOrganicaProveedorInternet.Include(m => m.Catalogos_ctEstructuraOrganica).Include(m => m.Mst_ProveedorTipoServicio).Include(m => m.Mst_TipoInternet);
            return View(mst_EstructuraOrganicaProveedorInternet.ToList());
        }

        // GET: MstEstructuraOrganicaProveedorInternet/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_EstructuraOrganicaProveedorInternet mst_EstructuraOrganicaProveedorInternet = db.Mst_EstructuraOrganicaProveedorInternet.Find(id);
            if (mst_EstructuraOrganicaProveedorInternet == null)
            {
                return HttpNotFound();
            }
            return View(mst_EstructuraOrganicaProveedorInternet);
        }

        // GET: MstEstructuraOrganicaProveedorInternet/Create
        public ActionResult Create()
        {
            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica");

            var list = db.Mst_ProveedorTipoServicio.Select(t => new {
                IdProveedorTipoServicio = t.IdProveedorTipoServicio,
                ProveedorTipoServicio = t.Mst_Proveedor.RazonSocial + " | " + t.Mst_TipoServicio.TipoServicio
            });

            ViewBag.IdProveedorTipoServicio = new SelectList(list, "IdProveedorTipoServicio", "ProveedorTipoServicio");
            ViewBag.IdTipoInternet = new SelectList(db.Mst_TipoInternet, "IdTipoInternet", "TipoInternet");
            return View();
        }

        // POST: MstEstructuraOrganicaProveedorInternet/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdEstructuraOrganicaProveedorInternet,IdProveedorTipoServicio,IdTipoInternet,Velocidad,CostoMensual,FechaInicio,FechaTermino,IdEstructuraOrganica")] Mst_EstructuraOrganicaProveedorInternet mst_EstructuraOrganicaProveedorInternet)
        {
            if (ModelState.IsValid)
            {
                db.Mst_EstructuraOrganicaProveedorInternet.Add(mst_EstructuraOrganicaProveedorInternet);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", mst_EstructuraOrganicaProveedorInternet.IdEstructuraOrganica);

            var list = db.Mst_ProveedorTipoServicio.Select(t => new {
                IdProveedorTipoServicio = t.IdProveedorTipoServicio,
                ProveedorTipoServicio = t.Mst_Proveedor.RazonSocial + " | " + t.Mst_TipoServicio.TipoServicio
            });

            ViewBag.IdProveedorTipoServicio = new SelectList(list, "IdProveedorTipoServicio", "ProveedorTipoServicio", mst_EstructuraOrganicaProveedorInternet.IdProveedorTipoServicio);

            ViewBag.IdTipoInternet = new SelectList(db.Mst_TipoInternet, "IdTipoInternet", "TipoInternet", mst_EstructuraOrganicaProveedorInternet.IdTipoInternet);
            return View(mst_EstructuraOrganicaProveedorInternet);
        }

        // GET: MstEstructuraOrganicaProveedorInternet/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_EstructuraOrganicaProveedorInternet mst_EstructuraOrganicaProveedorInternet = db.Mst_EstructuraOrganicaProveedorInternet.Find(id);
            if (mst_EstructuraOrganicaProveedorInternet == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", mst_EstructuraOrganicaProveedorInternet.IdEstructuraOrganica);

            var list = db.Mst_ProveedorTipoServicio.Select(t => new {
                IdProveedorTipoServicio = t.IdProveedorTipoServicio,
                ProveedorTipoServicio = t.Mst_Proveedor.RazonSocial + " | " + t.Mst_TipoServicio.TipoServicio
            });

            ViewBag.IdProveedorTipoServicio = new SelectList(list, "IdProveedorTipoServicio", "ProveedorTipoServicio", mst_EstructuraOrganicaProveedorInternet.IdProveedorTipoServicio);

            ViewBag.IdTipoInternet = new SelectList(db.Mst_TipoInternet, "IdTipoInternet", "TipoInternet", mst_EstructuraOrganicaProveedorInternet.IdTipoInternet);
            return View(mst_EstructuraOrganicaProveedorInternet);
        }

        // POST: MstEstructuraOrganicaProveedorInternet/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdEstructuraOrganicaProveedorInternet,IdProveedorTipoServicio,IdTipoInternet,Velocidad,CostoMensual,FechaInicio,FechaTermino,IdEstructuraOrganica")] Mst_EstructuraOrganicaProveedorInternet mst_EstructuraOrganicaProveedorInternet)
        {
            if (ModelState.IsValid)
            {
                db.Entry(mst_EstructuraOrganicaProveedorInternet).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", mst_EstructuraOrganicaProveedorInternet.IdEstructuraOrganica);

            var list = db.Mst_ProveedorTipoServicio.Select(t => new {
                IdProveedorTipoServicio = t.IdProveedorTipoServicio,
                ProveedorTipoServicio = t.Mst_Proveedor.RazonSocial + " | " + t.Mst_TipoServicio.TipoServicio
            });

            ViewBag.IdProveedorTipoServicio = new SelectList(list, "IdProveedorTipoServicio", "ProveedorTipoServicio", mst_EstructuraOrganicaProveedorInternet.IdProveedorTipoServicio);

            ViewBag.IdTipoInternet = new SelectList(db.Mst_TipoInternet, "IdTipoInternet", "TipoInternet", mst_EstructuraOrganicaProveedorInternet.IdTipoInternet);
            return View(mst_EstructuraOrganicaProveedorInternet);
        }

        // GET: MstEstructuraOrganicaProveedorInternet/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_EstructuraOrganicaProveedorInternet mst_EstructuraOrganicaProveedorInternet = db.Mst_EstructuraOrganicaProveedorInternet.Find(id);
            if (mst_EstructuraOrganicaProveedorInternet == null)
            {
                return HttpNotFound();
            }
            return View(mst_EstructuraOrganicaProveedorInternet);
        }

        // POST: MstEstructuraOrganicaProveedorInternet/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Mst_EstructuraOrganicaProveedorInternet mst_EstructuraOrganicaProveedorInternet = db.Mst_EstructuraOrganicaProveedorInternet.Find(id);
            db.Mst_EstructuraOrganicaProveedorInternet.Remove(mst_EstructuraOrganicaProveedorInternet);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }


        //consultar que el Área tenga un registro de Internet
        //id => idEstructuraOrganica
        [HttpPost]
        public ActionResult getInformacionInternet(int id)
        {
            Mst_EstructuraOrganicaProveedorInternet model;
            var result = new { value_e = false, msgHtml ="" };

            model = db.Mst_EstructuraOrganicaProveedorInternet.OrderByDescending(o=>o.IdEstructuraOrganicaProveedorInternet).FirstOrDefault(t => t.IdEstructuraOrganica == id);

            if (model!=null)
            {
                result = new { value_e = true, msgHtml = "Datos del Servicio de Internet. Proveedor: "+model.Mst_ProveedorTipoServicio.Mst_Proveedor.RazonSocial +  ", Tel Oficina: "+model.Mst_ProveedorTipoServicio.Mst_Proveedor.TelefonoOficina + ", Móvil: "+model.Mst_ProveedorTipoServicio.Mst_Proveedor.TelefonoMovil + ", Email: "+ model.Mst_ProveedorTipoServicio.Mst_Proveedor.CorreoElectronico};
            }

            return Json(result, JsonRequestBehavior.AllowGet);
        }

    }
}
