﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Rotativa;
using System.IO;
using System.Transactions;

namespace Nova.Controllers.Mst
{
    public class MstReporteController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: MstReporte
        public ActionResult Index()
        {
            var mst_Reporte = db.Mst_Reporte.Include(m => m.Convenios_stConvenioLaboralTrabajadorCategoria).Include(m => m.Mst_GrupoReporte);
            return View(mst_Reporte.ToList());
        }

        public ActionResult GReportes(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }

            List<Mst_Reporte> mst_Reportes = db.Mst_Reporte.Where(t => t.IdGrupoReporte == id).ToList();

            return PartialView("_ListaReporte",mst_Reportes);
        }

        // GET: MstReporte/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_Reporte mst_Reporte = db.Mst_Reporte.Find(id);
            if (mst_Reporte == null)
            {
                return HttpNotFound();
            }
            return View(mst_Reporte);
        }

        // GET: MstReporte/Create
        public ActionResult Create(int? id)
        {

            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            //int idUser = 3990;

            

            //var userName = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t=>t.IdConvenioLaboralTrabajadorCategoria == idUser).Select(x=> new
            //{
            //    IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
            //    NombreCompleto = 
            //        x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre +" "+
            //        x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno +" "+
            //        x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno 
            //}).ToList();


            //var convenio = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).FirstOrDefault();
            //var catalogos_ctEstructuraOrganica = db.Catalogos_ctEstructuraOrganica.Where(t=>t.IdEstructuraOrganica == convenio.IdEstructuraOrganica);

            var list = new List<SelectListItem>
            {
               new SelectListItem { Value = "0", Text = "Ninguno Seleccionado..." },
               //...
            };

            var modelE = list.Select(x => new {
                IdEquipoComputo = x.Value,
                EquipoComputo = x.Text
            }).ToList();

            ViewBag.IdEquipoComputo = new SelectList(modelE, "IdEquipoComputo", "EquipoComputo"); 

            //ViewBag.IdEstructuraOrganica = new SelectList(catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica");
            //ViewBag.IdConvenioLaboralTrabajadorCategoria_Responsable = new SelectList(userName, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto");
            //ViewBag.IdUsuarioRegistroEnter = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            //ViewBag.IdGrupoReporte = new SelectList(db.Mst_GrupoReporte.Where(t=>t.IdGrupoReporte == id), "IdGrupoReporte", "IdGrupoReporte");
            
            ViewBag.IdGrupoReporte = id;
            return View();
        }

        // POST: MstReporte/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdReporte,NumeroReporte,NumeroOficio,FechaRegistro,IdEquipoComputo,ProblemaObservado,IdUsuarioRegistroEnter,IdEstatusReporte,IdGrupoReporte,IdTicketAsociado")] Mst_Reporte mst_Reporte)
        {
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            

            Int16 idEstatusReporte = db.Mst_EstatusReporte.Where(t => t.EstatusReporte == "Pendiente").Select(s => s.IdEstatusReporte).FirstOrDefault();
            if (idEstatusReporte == 0)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            
            mst_Reporte.IdUsuarioRegistroEnter = idUser;
            mst_Reporte.IdEstatusReporte = idEstatusReporte;
            mst_Reporte.FechaRegistro = DateTime.Now;
            mst_Reporte.NumeroReporte = "M18010001";

            if (mst_Reporte.IdEquipoComputo == 0)
            {
                ModelState.AddModelError("IdEquipoComputo", "Es necesario relacionar un Equipo de Computo.");
            }

            if (mst_Reporte.IdTicketAsociado != null && mst_Reporte.IdTicketAsociado > 0)
            {
               
                Mst_Ticket mst_Ticket = db.Mst_Ticket.Find(mst_Reporte.IdTicketAsociado);
                if (mst_Ticket == null)
                {
                    return HttpNotFound();
                }
                if (mst_Ticket.IdEquipoComputo > 0 || mst_Ticket.IdEquipoComputo != null)
                {
                    if(mst_Ticket.Mst_EstatusTicket.EstatusTicket != "Terminado")
                    {
                        mst_Reporte.ProblemaObservado = mst_Ticket.Incidente;
                        //int idEquipo = mst_Ticket.IdEquipoComputo.Value;
                        mst_Reporte.IdEquipoComputo = mst_Ticket.IdEquipoComputo.Value;
                    }
                    else
                    {
                        ModelState.AddModelError("IdReporte", "El ticket asociado esta Cerrado. Intente de nuevo.");
                        mst_Reporte.IdEquipoComputo = 0;
                        mst_Reporte.ProblemaObservado = null;
                        mst_Reporte.NumeroOficio = null;
                    }
                    
                }
                else
                {
                    ModelState.AddModelError("IdReporte", "El ticket asociado no se relaciona con un Equipo. Intente de nuevo.");
                    mst_Reporte.IdEquipoComputo = 0;
                    mst_Reporte.ProblemaObservado = null;
                    mst_Reporte.NumeroOficio = null;
                }

                
            }

            if (ModelState.IsValid)
            {
                db.Mst_Reporte.Add(mst_Reporte);
                db.SaveChanges();
                return RedirectToAction("Edit","MstGrupoReporte", new { id=mst_Reporte.IdGrupoReporte });
            }

            if (mst_Reporte.IdEquipoComputo == 0)
            {
                var list = new List<SelectListItem>
                {
                   new SelectListItem { Value = "0", Text = "Ninguno Seleccionado..." },
                   //...
                };
                var modelE = list.Select(x => new {
                    IdEquipoComputo = x.Value,
                    EquipoComputo = x.Text
                }).ToList();
                ViewBag.IdEquipoComputo = new SelectList(modelE, "IdEquipoComputo", "EquipoComputo");
            }
            else
            {
                var mst_EquipoComputo = db.Mst_EquipoComputo.Include(m => m.Mst_MarcaEquipoComputo).Include(m => m.Mst_ModeloEquipoComputo).Include(m => m.Mst_TipoEquipoComputo).Select(x => new {
                    IdEquipoComputo = x.IdEquipoComputo,
                    EquipoComputo = x.Mst_TipoEquipoComputo.TipoEquipoComputo + " " + x.Mst_MarcaEquipoComputo.MarcaEquipoComputo + " " + x.Mst_ModeloEquipoComputo.ModeloEquipoComputo
                }).Where(t => t.IdEquipoComputo == mst_Reporte.IdEquipoComputo);
                ViewBag.IdEquipoComputo = new SelectList(mst_EquipoComputo, "IdEquipoComputo", "EquipoComputo", mst_Reporte.IdEquipoComputo);
            }

            //var userName = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).Select(x => new
            //{
            //    IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
            //    NombreCompleto =
            //          x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " +
            //          x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
            //          x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno
            //}).ToList();


            //var convenio = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).FirstOrDefault();
            //var catalogos_ctEstructuraOrganica = db.Catalogos_ctEstructuraOrganica.Where(t => t.IdEstructuraOrganica == convenio.IdEstructuraOrganica);



            //ViewBag.IdEstructuraOrganica = new SelectList(catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", mst_Reporte.IdEstructuraOrganica);
            //ViewBag.IdConvenioLaboralTrabajadorCategoria_Responsable = new SelectList(userName, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto",mst_Reporte.IdConvenioLaboralTrabajadorCategoria_Responsable);
            //ViewBag.IdUsuarioRegistroEnter = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", mst_Reporte.IdUsuarioRegistroEnter);
            ViewBag.IdGrupoReporte = mst_Reporte.IdGrupoReporte;
            return View(mst_Reporte);
        }

        // GET: MstReporte/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_Reporte mst_Reporte = db.Mst_Reporte.Find(id);
            if (mst_Reporte == null)
            {
                return HttpNotFound();
            }
            if (mst_Reporte.IdEquipoComputo == 0)
            {
                var list = new List<SelectListItem>
                {
                   new SelectListItem { Value = "0", Text = "Ninguno Seleccionado..." },
                   //...
                };
                var modelE = list.Select(x => new {
                    IdEquipoComputo = x.Value,
                    EquipoComputo = x.Text
                }).ToList();
                ViewBag.IdEquipoComputo = new SelectList(modelE, "IdEquipoComputo", "EquipoComputo");
            }
            else
            {
                var mst_EquipoComputo = db.Mst_EquipoComputo.Include(m => m.Mst_MarcaEquipoComputo).Include(m => m.Mst_ModeloEquipoComputo).Include(m => m.Mst_TipoEquipoComputo).Select(x => new {
                    IdEquipoComputo = x.IdEquipoComputo,
                    EquipoComputo = x.Mst_TipoEquipoComputo.TipoEquipoComputo + " " + x.Mst_MarcaEquipoComputo.MarcaEquipoComputo + " " + x.Mst_ModeloEquipoComputo.ModeloEquipoComputo
                }).Where(t => t.IdEquipoComputo == mst_Reporte.IdEquipoComputo);
                ViewBag.IdEquipoComputo = new SelectList(mst_EquipoComputo, "IdEquipoComputo", "EquipoComputo", mst_Reporte.IdEquipoComputo);
            }
            //ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", mst_Reporte.IdEstructuraOrganica);
            //ViewBag.IdConvenioLaboralTrabajadorCategoria_Responsable = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", mst_Reporte.IdConvenioLaboralTrabajadorCategoria_Responsable);
            ViewBag.IdUsuarioRegistroEnter = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", mst_Reporte.IdUsuarioRegistroEnter);
            ViewBag.IdGrupoReporte = new SelectList(db.Mst_GrupoReporte, "IdGrupoReporte", "IdGrupoReporte", mst_Reporte.IdGrupoReporte);
            return View(mst_Reporte);
        }

        // POST: MstReporte/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdReporte,NumeroReporte,NumeroOficio,FechaRegistro,IdEquipoComputo,ProblemaObservado,IdUsuarioRegistroEnter,IdEstatusReporte,IdGrupoReporte")] Mst_Reporte mst_Reporte)
        {
            //Mst_Reporte rp = db.Mst_Reporte.Find(mst_Reporte.IdReporte);
            //if (rp == null)
            //{
            //    return HttpNotFound();
            //}
            //mst_Reporte.FechaRegistro = rp.FechaRegistro;
            //mst_Reporte.IdEstatusReporte = rp.IdEstatusReporte;
            //mst_Reporte.IdUsuarioRegistroEnter = rp.IdUsuarioRegistroEnter;
            //mst_Reporte.NumeroOficio = rp.NumeroOficio;
            //mst_Reporte.NumeroReporte = rp.NumeroReporte;
            //db.

            if (mst_Reporte.IdEquipoComputo == 0)
            {
                ModelState.AddModelError("IdEquipoComputo", "Es necesario relacionar un Equipo de Computo.");
            }

            if (ModelState.IsValid)
            {
                db.Entry(mst_Reporte).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Edit", "MstGrupoReporte", new { id = mst_Reporte.IdGrupoReporte });
            }

            if (mst_Reporte.IdEquipoComputo == 0)
            {
                var list = new List<SelectListItem>
                {
                   new SelectListItem { Value = "0", Text = "Ninguno Seleccionado..." },
                   //...
                };
                var modelE = list.Select(x => new {
                    IdEquipoComputo = x.Value,
                    EquipoComputo = x.Text
                }).ToList();
                ViewBag.IdEquipoComputo = new SelectList(modelE, "IdEquipoComputo", "EquipoComputo");
            }
            else
            {
                var mst_EquipoComputo = db.Mst_EquipoComputo.Include(m => m.Mst_MarcaEquipoComputo).Include(m => m.Mst_ModeloEquipoComputo).Include(m => m.Mst_TipoEquipoComputo).Select(x => new {
                    IdEquipoComputo = x.IdEquipoComputo,
                    EquipoComputo = x.Mst_TipoEquipoComputo.TipoEquipoComputo + " " + x.Mst_MarcaEquipoComputo.MarcaEquipoComputo + " " + x.Mst_ModeloEquipoComputo.ModeloEquipoComputo
                }).Where(t => t.IdEquipoComputo == mst_Reporte.IdEquipoComputo);
                ViewBag.IdEquipoComputo = new SelectList(mst_EquipoComputo, "IdEquipoComputo", "EquipoComputo", mst_Reporte.IdEquipoComputo);
            }
            //ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", mst_Reporte.IdEstructuraOrganica);
            //ViewBag.IdConvenioLaboralTrabajadorCategoria_Responsable = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", mst_Reporte.IdConvenioLaboralTrabajadorCategoria_Responsable);
            ViewBag.IdUsuarioRegistroEnter = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", mst_Reporte.IdUsuarioRegistroEnter);
            ViewBag.IdGrupoReporte = new SelectList(db.Mst_GrupoReporte, "IdGrupoReporte", "IdGrupoReporte", mst_Reporte.IdGrupoReporte);
            return View(mst_Reporte);
        }

        // GET: MstReporte/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_Reporte mst_Reporte = db.Mst_Reporte.Find(id);
            if (mst_Reporte == null)
            {
                return HttpNotFound();
            }
            return View(mst_Reporte);
        }

        // POST: MstReporte/Delete/5
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        [HttpPost]
        public ActionResult DeleteConfirmed()
        {
            var result = new { value = "", msg = "" };
            //var result = new { };
            int idReporte = System.Convert.ToInt32(Request["ReporteId"]);
            if (idReporte <= 0)
            {
                result = new { value = "efailed", msg = "Error al identificar el Reporte" };
                return Json(result, JsonRequestBehavior.AllowGet);
            }
            Mst_Reporte mst_Reporte = db.Mst_Reporte.Find(idReporte);

            if (mst_Reporte.Mst_EstatusReporte.EstatusReporte != "Pendiente")
            {
                result = new { value = "efailed", msg = "No se puede eliminar el Reporte identificado porque el Estatus ha cambiado." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }
            try
            {
                db.Mst_Reporte.Remove(mst_Reporte);
                db.SaveChanges();
            }
            catch (Exception e)
            {
                result = new { value = "efailed", msg = e.ToString() };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

            //return RedirectToAction("Index");
            result = new { value = "esuccess", msg = "Se ha eliminado el elemento correctamente." };
            return Json(result, JsonRequestBehavior.AllowGet);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }


        public ActionResult Follow(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }

            MstSeguridadRoles roles = new MstSeguridadRoles();
            if (roles.EsAdministrador())
            {
                return RedirectToAction("FollowAdmin", new { id = id });
            }

            Mst_Reporte mst_Reporte = db.Mst_Reporte.Find(id);
            if (mst_Reporte == null)
            {
                return HttpNotFound();
            }

            MstComentariosReporte reporteComentarios = new MstComentariosReporte();
            reporteComentarios.Reporte = mst_Reporte;
            reporteComentarios.Comentarios = db.Mst_ComentariosReporte.Where(T => T.IdReporte == mst_Reporte.IdReporte && T.Publico == true).ToList();
            

            return View(reporteComentarios);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Follow([Bind(Include = "IdComentarioReporte,ComentarioReporte,FechaComentarioReporte,IdConvenioLaboralTrabajadorCategoria,IdEstatusReporte,Publico,IdReporte")] Mst_ComentariosReporte mst_ComentariosReporte)
        {
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            if (mst_ComentariosReporte.IdReporte == 0)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }

            Mst_Reporte mst_Reporte = db.Mst_Reporte.Find(mst_ComentariosReporte.IdReporte);
            if (mst_Reporte == null)
            {
                return HttpNotFound();
            }

            mst_ComentariosReporte.FechaComentarioReporte = DateTime.Now;
            mst_ComentariosReporte.IdConvenioLaboralTrabajadorCategoria = idUser;
            mst_ComentariosReporte.IdEstatusReporte = mst_Reporte.IdEstatusReporte;
            mst_ComentariosReporte.Publico = true;

            if (mst_ComentariosReporte.ComentarioReporte == null || mst_ComentariosReporte.ComentarioReporte == "")
            {
                ModelState.AddModelError("ComentarioReporte", "El campo Comentario es requerido.");
            }

            if (mst_ComentariosReporte.IdEstatusReporte > 0)
                ModelState["IdEstatusReporte"].Errors.Clear();
            else
                ModelState.AddModelError("ComentarioReporte", "Imposible insertar el comentario.");
            

            if (ModelState.IsValid)
            {
                db.Mst_ComentariosReporte.Add(mst_ComentariosReporte);
                db.SaveChanges();
                return RedirectToAction("Follow", "MstReporte", new { id = mst_ComentariosReporte.IdReporte });
            }
            

            MstComentariosReporte reporteComentarios = new MstComentariosReporte();
            reporteComentarios.Reporte = mst_Reporte;
            reporteComentarios.Comentarios = db.Mst_ComentariosReporte.Where(T => T.IdReporte == mst_Reporte.IdReporte && T.Publico == true).ToList();

            return View(reporteComentarios);
        }

        public ActionResult FollowAdmin(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            MstSeguridadRoles roles = new MstSeguridadRoles();
            if (!roles.EsAdministrador())
            {
                return RedirectToAction("Follow",new { id = id});
            }

            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            

            Mst_Reporte mst_Reporte = db.Mst_Reporte.Find(id);
            if (mst_Reporte == null)
            {
                return HttpNotFound();
            }

            MstComentariosReporte reporteComentarios = new MstComentariosReporte();
            reporteComentarios.Reporte = mst_Reporte;
            reporteComentarios.Comentarios = db.Mst_ComentariosReporte.Where(T => T.IdReporte == mst_Reporte.IdReporte && T.Publico == false).ToList();

            
            ViewBag.IdEstatusReporte = new SelectList(db.Mst_EstatusReporte, "IdEstatusReporte", "EstatusReporte", mst_Reporte.IdEstatusReporte);
            ViewBag.IdUsuarioLogin = idUser;
            ViewBag.IdTicketAsociado = db.Mst_Ticket.Where(t => t.IdTicket == mst_Reporte.IdTicketAsociado).FirstOrDefault();
            return View(reporteComentarios);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult FollowAdmin([Bind(Include = "IdComentarioReporte,ComentarioReporte,FechaComentarioReporte,IdConvenioLaboralTrabajadorCategoria,IdEstatusReporte,Publico,IdReporte")] Mst_ComentariosReporte mst_ComentariosReporte)
        {
            

            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            if (mst_ComentariosReporte.IdReporte == 0)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            
            mst_ComentariosReporte.FechaComentarioReporte = DateTime.Now;
            mst_ComentariosReporte.IdConvenioLaboralTrabajadorCategoria = idUser;

            if (mst_ComentariosReporte.ComentarioReporte == null || mst_ComentariosReporte.ComentarioReporte == "")
            {
                ModelState.AddModelError("ComentarioReporte", "El campo Comentario es requerido.");
            }

            if (mst_ComentariosReporte.IdEstatusReporte == db.Mst_EstatusReporte.Where(t=>t.EstatusReporte == "Pendiente").Select(s=>s.IdEstatusReporte).FirstOrDefault())
            {
                ModelState.AddModelError("IdEstatusReporte", "El Estatus debe cambiar a: En Proceso.");
            }

            if (mst_ComentariosReporte.IdEstatusReporte == db.Mst_EstatusReporte.Where(t => t.EstatusReporte == "Entregado").Select(s => s.IdEstatusReporte).FirstOrDefault())
            {
                Mst_EntregaReporte mst_EntregaReporte = db.Mst_EntregaReporte.Where(t => t.IdReporte == mst_ComentariosReporte.IdReporte).FirstOrDefault();
                if (mst_EntregaReporte == null)
                {
                    ModelState.AddModelError("IdEstatusReporte", "No puede Entregar un Reporte cuando no ha registrado Una Entrega.");
                }
            }

            Mst_Reporte mst_Reporte = null;

            if (ModelState.IsValid)
            {
                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {

                    mst_Reporte = db.Mst_Reporte.Find(mst_ComentariosReporte.IdReporte);
                    mst_Reporte.IdEstatusReporte = mst_ComentariosReporte.IdEstatusReporte;
                    db.Entry(mst_Reporte).State = EntityState.Modified;

                    db.Mst_ComentariosReporte.Add(mst_ComentariosReporte);
                    db.SaveChanges();

                    scope.Complete();
                }

                //cuando el Reporte incia y el estatus es "Proceso Inciado" se envia el correo electrónico al usuario como reporte de entrada. 
                
                if (mst_ComentariosReporte.IdEstatusReporte == db.Mst_EstatusReporte.Where(t => t.EstatusReporte == "En Proceso").Select(s => s.IdEstatusReporte).FirstOrDefault())
                {
                    if (db.Mst_ComentariosReporte.Where(t => t.IdReporte == mst_ComentariosReporte.IdReporte && t.Mst_EstatusReporte.EstatusReporte == "En Proceso").Count() == 1)
                    {
                        //======================== EJEMPLO ENTRADA REPORTE ==========================================
                        string correoUsuarioAtendido ="";
                        if (mst_Reporte.Mst_GrupoReporte.Convenios_stConvenioLaboralTrabajadorCategoria1.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.CorreoOficial != null)
                        {
                            correoUsuarioAtendido = mst_Reporte.Mst_GrupoReporte.Convenios_stConvenioLaboralTrabajadorCategoria1.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.CorreoOficial;
                        }
                        else
                        {
                            correoUsuarioAtendido = mst_Reporte.Mst_GrupoReporte.Convenios_stConvenioLaboralTrabajadorCategoria1.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.CorreoElectronico;
                        }
                        
                        //write code here 
                        byte[] binaryPdf = null;

                        binaryPdf = TestSavePdfIn(mst_Reporte);
                        //lamar tarea asincrona para enviar mail
                        MstSoporteClass classMst = new MstSoporteClass();
                        string templateHtmlView = @"";

                        templateHtmlView = RenderRazorTemplateReporteEnter(mst_Reporte);
                        var task = classMst.EnviarMailMantenimientoIn(binaryPdf, mst_Reporte.NumeroReporte, correoUsuarioAtendido, templateHtmlView);
                        //==================================================================
                    }

                }


                //cuando se repara el equipo, enviar correo electronico
                if (mst_ComentariosReporte.IdEstatusReporte == db.Mst_EstatusReporte.Where(t => t.EstatusReporte == "Reparado").Select(s => s.IdEstatusReporte).FirstOrDefault())
                {
                    //======================== EJEMPLO SALIDA REPORTE ==========================================
                    string correoUsuarioAtendido2 = "";
                    if (mst_Reporte.Mst_GrupoReporte.Convenios_stConvenioLaboralTrabajadorCategoria1.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.CorreoOficial != null)
                    {
                        correoUsuarioAtendido2 = mst_Reporte.Mst_GrupoReporte.Convenios_stConvenioLaboralTrabajadorCategoria1.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.CorreoOficial;
                    }
                    else
                    {
                        correoUsuarioAtendido2 = mst_Reporte.Mst_GrupoReporte.Convenios_stConvenioLaboralTrabajadorCategoria1.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.CorreoElectronico;
                    }

                    //lamar tarea asincrona para enviar mail
                    MstSoporteClass classMst2 = new MstSoporteClass();
                    string templateHtmlView2 = @"";

                    templateHtmlView2 = RenderRazorTemplateReporte(mst_Reporte, "_ViewToStringReportReparado");
                    var task2 = classMst2.EnviarMailMantenimientoReparado(mst_Reporte.NumeroReporte, correoUsuarioAtendido2, templateHtmlView2);
                    //==================================================================

                }

                //Cuando se termina el reporte enviar por correo electronico el PDF
                //      //      //
                //falta comprobar los estatus para que se envie el reporte
                if (mst_ComentariosReporte.IdEstatusReporte == db.Mst_EstatusReporte.Where(t=>t.EstatusReporte == "Entregado").Select(s=>s.IdEstatusReporte).FirstOrDefault())
                {
                    //======================== EJEMPLO SALIDA REPORTE ==========================================
                    string correoUsuarioAtendido2 ="";
                    if (mst_Reporte.Mst_GrupoReporte.Convenios_stConvenioLaboralTrabajadorCategoria1.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.CorreoOficial != null)
                    {
                        correoUsuarioAtendido2 = mst_Reporte.Mst_GrupoReporte.Convenios_stConvenioLaboralTrabajadorCategoria1.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.CorreoOficial;
                    }
                    else
                    {
                        correoUsuarioAtendido2 = mst_Reporte.Mst_GrupoReporte.Convenios_stConvenioLaboralTrabajadorCategoria1.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.CorreoElectronico;
                    }
                    
                    //write code here 
                    byte[] binaryPdf2 = null;

                    binaryPdf2 = TestSavePdfOut(mst_Reporte);
                    //lamar tarea asincrona para enviar mail
                    MstSoporteClass classMst2 = new MstSoporteClass();
                    string templateHtmlView2 = @"";

                    templateHtmlView2 = RenderRazorTemplateReporte(mst_Reporte, "_ViewToStringReportOut");
                    var task2 = classMst2.EnviarMailMantenimientoOut(binaryPdf2, mst_Reporte.NumeroReporte, correoUsuarioAtendido2, templateHtmlView2);
                    //==================================================================

                }




                return RedirectToAction("FollowAdmin", "MstReporte", new { id = mst_ComentariosReporte.IdReporte });
            }

            //Mst_Reporte mst_Reporte = db.Mst_Reporte.Find(mst_ComentariosReporte.IdReporte);
            //if (mst_Reporte == null)
            //{
            //    return HttpNotFound();
            //}
            mst_Reporte = db.Mst_Reporte.Find(mst_ComentariosReporte.IdReporte);
            MstComentariosReporte reporteComentarios = new MstComentariosReporte();
            reporteComentarios.Reporte = mst_Reporte;
            reporteComentarios.Comentarios = db.Mst_ComentariosReporte.Where(T => T.IdReporte == mst_Reporte.IdReporte && T.Publico == false).ToList();
            reporteComentarios.Comentario = mst_ComentariosReporte;


            ViewBag.IdEstatusReporte = new SelectList(db.Mst_EstatusReporte, "IdEstatusReporte", "EstatusReporte", mst_ComentariosReporte.IdEstatusReporte);
            ViewBag.IdUsuarioLogin = idUser;
            ViewBag.IdTicketAsociado = db.Mst_Ticket.Where(t => t.IdTicket == mst_Reporte.IdTicketAsociado).FirstOrDefault();
            return View(reporteComentarios);
        }


        //==============================================================================================
        //==================================  ENTRADA DE REPORTE =======================================
        //==============================================================================================

        //devuelbe el pdf en byte para envíar por correo para reporte de entrada
        public byte[] TestSavePdfIn(Mst_Reporte mst_Reporte)
        {

            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 1;
            m.Right = 0;
            m.Top = 0;

            var pdfView = new ViewAsPdf("ViewPdfDownloadIn", mst_Reporte)
            {
                PageMargins = m,
                PageSize = Rotativa.Options.Size.Letter,
            };
            var binary = pdfView.BuildPdf(this.ControllerContext);
            return binary;
        }

        //pdf download when enter report
        [HttpGet]
        public ActionResult ViewPdfDownloadIn(int id)
        {
            if (id == 0)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_Reporte mst_Reporte = db.Mst_Reporte.Find(id);
            if (mst_Reporte == null)
            {
                return HttpNotFound();
            }

            
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 0;
            m.Right = 0;
            m.Top = 0;

            return new ViewAsPdf("ViewPdfDownloadIn", mst_Reporte)
            {
                PageMargins = m,
                PageSize = Rotativa.Options.Size.Letter,
                FileName = "Reporte_Mantenimiento_Entrada_" + mst_Reporte.NumeroReporte + ".pdf",

            };

        }

        //[HttpGet]
        //public ActionResult ejemploIn(int id)
        //{
        //    if (id == 0)
        //    {
        //        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        //    }
        //    Mst_Reporte mst_Reporte = db.Mst_Reporte.Find(id);
        //    if (mst_Reporte == null)
        //    {
        //        return HttpNotFound();
        //    }

            
        //    return View("ViewPdfDownloadIn", mst_Reporte);
        //}

        //Template para Mail de Entrada de Reporte 
        public string RenderRazorTemplateReporteEnter(Mst_Reporte mst_Reporte)
        {
            ViewData.Model = mst_Reporte;
            using (var sw = new StringWriter())
            {
                var viewResult = ViewEngines.Engines.FindPartialView(ControllerContext, "_ViewToStringReportIn");
                var viewContext = new ViewContext(ControllerContext, viewResult.View, ViewData, TempData, sw);
                viewResult.View.Render(viewContext, sw);
                viewResult.ViewEngine.ReleaseView(ControllerContext, viewResult.View);
                return sw.GetStringBuilder().ToString();
            }
        }

        //==============================================================================================
        //==================================  SALIDA DE REPORTE ========================================
        //==============================================================================================

        //devuelbe el pdf en byte para que se envía por correo cuando el reporte sale
        public byte[] TestSavePdfOut(Mst_Reporte mst_Reporte)
        {

            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 1;
            m.Right = 0;
            m.Top = 0;

            var pdfView = new ViewAsPdf("ViewPdfDownloadOut", mst_Reporte)
            {
                PageMargins = m,
                PageSize = Rotativa.Options.Size.Letter,
            };
            var binary = pdfView.BuildPdf(this.ControllerContext);
            return binary;
        }

        //pdf download when out report
        [HttpGet]
        public ActionResult ViewPdfDownloadOut(int id)
        {
            if (id == 0)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_Reporte mst_Reporte = db.Mst_Reporte.Find(id);
            if (mst_Reporte == null)
            {
                return HttpNotFound();
            }


            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 0;
            m.Right = 0;
            m.Top = 0;

            return new ViewAsPdf("ViewPdfDownloadOut", mst_Reporte)
            {
                PageMargins = m,
                PageSize = Rotativa.Options.Size.Letter,
                FileName = "Reporte_Mantenimiento_Salida_" + mst_Reporte.NumeroReporte + ".pdf",

            };

        }
        
        //[HttpGet]
        //public ActionResult ejemploOut(int id)
        //{
        //    if (id == 0)
        //    {
        //        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        //    }
        //    Mst_Reporte mst_Reporte = db.Mst_Reporte.Find(id);
        //    if (mst_Reporte == null)
        //    {
        //        return HttpNotFound();
        //    }

        //    return View("ViewPdfDownloadOut", mst_Reporte);
        //}

        //Template para Mail de Salida de Reporte 
        public string RenderRazorTemplateReporte(Mst_Reporte mst_Reporte, string NamePartialView)
        {
            ViewData.Model = mst_Reporte;
            using (var sw = new StringWriter())
            {
                var viewResult = ViewEngines.Engines.FindPartialView(ControllerContext, NamePartialView);
                var viewContext = new ViewContext(ControllerContext, viewResult.View, ViewData, TempData, sw);
                viewResult.View.Render(viewContext, sw);
                viewResult.ViewEngine.ReleaseView(ControllerContext, viewResult.View);
                return sw.GetStringBuilder().ToString();
            }
        }




    }
}
