﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Mst
{
    public class MstGrupoReporteController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: MstGrupoReporte
        public ActionResult Index()
        {
            int idUsuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            MstSeguridadRoles rolUser = new MstSeguridadRoles();
            List<Mst_GrupoReporte> listGrupo = null;
            List<MstGrupoReporteClassModel> model = new List<MstGrupoReporteClassModel>();
            if (rolUser.EsAdministrador())
            {
                //listReporte = db.Mst_Reporte.ToList();

                listGrupo = db.Mst_GrupoReporte.OrderByDescending(t=>t.IdGrupoReporte).ToList();

                foreach (var item in listGrupo)
                {
                    MstGrupoReporteClassModel grupo = new MstGrupoReporteClassModel();

                    grupo.IdGrupoReporte = item.IdGrupoReporte;
                    grupo.EstructuraOrganica = item.Catalogos_ctEstructuraOrganica.EstructuraOrganica;
                    grupo.UsuarioAtencion = item.Convenios_stConvenioLaboralTrabajadorCategoria1.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + item.Convenios_stConvenioLaboralTrabajadorCategoria1.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + item.Convenios_stConvenioLaboralTrabajadorCategoria1.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
                    grupo.NumeroReportes = item.Mst_Reporte.Count();
                    grupo.ReportesPendientes = item.Mst_Reporte.Where(t => t.Mst_EstatusReporte.EstatusReporte == "Pendiente").Count();

                    Func<int, int, bool> testEquality = (x, y) => x != y; 
                    grupo.PuedeSeguir = testEquality(grupo.NumeroReportes,0);
                    grupo.PuedeEditar = true;

                    if (grupo.NumeroReportes > 0)
                    {
                        grupo.PuedeEliminar = false;
                    }
                    else
                    {
                        grupo.PuedeEliminar = true;
                    }

                    model.Add(grupo);

                }
            }
            else
            {
                listGrupo = db.Mst_GrupoReporte.Where(t => t.IdConvenioLaboralTrabajadorCategoria_Responsable == idUsuario).OrderByDescending(t=>t.IdGrupoReporte).ToList();
                foreach (var item in listGrupo)
                {
                    MstGrupoReporteClassModel grupo = new MstGrupoReporteClassModel();
                    grupo.IdGrupoReporte = item.IdGrupoReporte;
                    grupo.EstructuraOrganica = item.Catalogos_ctEstructuraOrganica.EstructuraOrganica;
                    grupo.UsuarioAtencion = item.Convenios_stConvenioLaboralTrabajadorCategoria1.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + item.Convenios_stConvenioLaboralTrabajadorCategoria1.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + item.Convenios_stConvenioLaboralTrabajadorCategoria1.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
                    grupo.NumeroReportes = item.Mst_Reporte.Count();
                    grupo.ReportesPendientes = item.Mst_Reporte.Where(t => t.Mst_EstatusReporte.EstatusReporte == "Pendiente").Count();
                    grupo.PuedeEditar = true;

                    if (grupo.NumeroReportes > 0)
                    {
                        grupo.PuedeEliminar = false;
                    }
                    else
                    {
                        grupo.PuedeEliminar = true;
                    }
                    model.Add(grupo);

                }
            }

            return View(model);
        }



        // GET: MstGrupoReporte/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }

            var mst_Reportes = db.Mst_Reporte.Include(y => y.Mst_GrupoReporte).Where(t => t.IdGrupoReporte == id).ToList();

            if (mst_Reportes == null)
            {
                return HttpNotFound();
            }
            return View(mst_Reportes);
        }

        // GET: MstGrupoReporte/Create
        public ActionResult Create()
        {
            int idUsuario = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria; ;
            var idgt = db.Mst_GrupoReporte.Where(w => w.IdConvenioLaboralTrabajadorCategoria == idUsuario).OrderByDescending(t => t.IdGrupoReporte).FirstOrDefault();

            var reportes = db.Mst_Reporte.Where(t => t.IdGrupoReporte == idgt.IdGrupoReporte).Count();
            if (reportes > 0)
            {
                return RedirectToAction("Index", "MstGrupoReporte");
            }

            return RedirectToAction("Edit", "MstGrupoReporte", new { id = idgt.IdGrupoReporte });

        }

        // POST: MstGrupoReporte/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdGrupoReporte")] Mst_GrupoReporte mst_GrupoReporte)
        {
            if (ModelState.IsValid)
            {
                db.Mst_GrupoReporte.Add(mst_GrupoReporte);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(mst_GrupoReporte);
        }

        // GET: MstGrupoReporte/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_GrupoReporte mst_GrupoReporte = db.Mst_GrupoReporte.Find(id);
            if (mst_GrupoReporte == null)
            {
                return HttpNotFound();
            }
            var userConvenio = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == mst_GrupoReporte.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();


            string estructuraOrganica = db.Catalogos_ctEstructuraOrganica.Where(t => t.IdEstructuraOrganica == userConvenio.IdEstructuraOrganica).Select(s => s.EstructuraOrganica).FirstOrDefault();
            ViewBag.IdEstructuraOrganica = estructuraOrganica;
            return View(mst_GrupoReporte);
        }

        // POST: MstGrupoReporte/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdGrupoReporte")] Mst_GrupoReporte mst_GrupoReporte)
        {
            if (ModelState.IsValid)
            {
                db.Entry(mst_GrupoReporte).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(mst_GrupoReporte);
        }

        // GET: MstGrupoReporte/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_GrupoReporte mst_GrupoReporte = db.Mst_GrupoReporte.Find(id);
            if (mst_GrupoReporte == null)
            {
                return HttpNotFound();
            }
            return View(mst_GrupoReporte);
        }

        // POST: MstGrupoReporte/Delete/5
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        [HttpPost]
        public ActionResult DeleteConfirmed(int id)
        {
            var result = new { value = false, msg = "" };
            if (id == 0)
            {
                result = new { value = false, msg = "Parametro invalido!. No se puedo enviar parametros para localizar el reporte" };
                return Json(result, JsonRequestBehavior.AllowGet);
            }
            Mst_GrupoReporte mst_GrupoReporte = db.Mst_GrupoReporte.Find(id);
            if (mst_GrupoReporte == null)
            {
                result = new { value = false, msg = "No se localiza el Grupo de Reporte." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

            if (mst_GrupoReporte.Mst_Reporte.Count() > 0)
            {
                result = new { value = false, msg = "No es posible eliminar el Grupo porque este contiene Reportes." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

            db.Mst_GrupoReporte.Remove(mst_GrupoReporte);
            db.SaveChanges();

            result = new { value = true, msg = "Se eliminó el Grupo de Reporte." };
            return Json(result, JsonRequestBehavior.AllowGet);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }

        //Method GET
        public ActionResult GetFormNewGroup()
        {
            
            Mst_GrupoReporte mstGrupoReporte = new Mst_GrupoReporte();
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            

            var userName = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).Select(x => new
            {
                IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
                NombreCompleto =
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " +
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno
            }).ToList();

            var convenio = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).FirstOrDefault();
            List<Catalogos_ctEstructuraOrganica> catalogos_ctEstructuraOrganica = db.Catalogos_ctEstructuraOrganica.ToList();

            short idFirstEstructuraOrganica = catalogos_ctEstructuraOrganica.OrderBy(t => t.IdEstructuraOrganica).FirstOrDefault().IdEstructuraOrganica;

            //consultar los usuarios por defecto de la primera EstructuraOrganica
            var usersFirstEstructuraOrganica = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdEstructuraOrganica == idFirstEstructuraOrganica && t.FechaTermino == null).Select(x => new
            {
                IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
                NombreCompleto =
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " +
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno
            }).ToList();

            MstSeguridadRoles rolUser = new MstSeguridadRoles();
            if (rolUser.EsAdministrador())
            {
                ViewBag.IdEstructuraOrganica = new SelectList(catalogos_ctEstructuraOrganica.Where(t => t.EsVigente == true).OrderBy(t => t.IdEstructuraOrganica), "IdEstructuraOrganica", "EstructuraOrganica");
                ViewBag.IdConvenioLaboralTrabajadorCategoria_Responsable = new SelectList(usersFirstEstructuraOrganica, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto");
            }
            else
            {
                ViewBag.IdEstructuraOrganica = new SelectList(catalogos_ctEstructuraOrganica.Where(t => t.IdEstructuraOrganica == convenio.IdEstructuraOrganica), "IdEstructuraOrganica", "EstructuraOrganica");
                ViewBag.IdConvenioLaboralTrabajadorCategoria_Responsable = new SelectList(userName, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto");
            }





            return PartialView("_GetFormNewGroup");
        }

        //Method POST
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult GetFormNewGroup([Bind(Include = "IdGrupoReporte,IdConvenioLaboralTrabajadorCategoria,IdEstructuraOrganica,IdConvenioLaboralTrabajadorCategoria_Responsable")] Mst_GrupoReporte mst_GrupoReporte)
        {
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            mst_GrupoReporte.IdConvenioLaboralTrabajadorCategoria = idUser;

            var result = new { value_e = false, msg = "" };
            if (ModelState.IsValid)
            {
                db.Entry(mst_GrupoReporte).State = EntityState.Added;
                db.SaveChanges();

                result = new { value_e = true, msg = "Se ha registrado el Grupo de Reporte." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

            //Mst_GrupoReporte mstGrupoReporte = new Mst_GrupoReporte();
            


            var userName = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).Select(x => new
            {
                IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
                NombreCompleto =
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " +
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                      x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno
            }).ToList();

            var convenio = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == idUser).FirstOrDefault();
            List<Catalogos_ctEstructuraOrganica> catalogos_ctEstructuraOrganica = db.Catalogos_ctEstructuraOrganica.ToList();

            short idFirstEstructuraOrganica = catalogos_ctEstructuraOrganica.OrderBy(t => t.IdEstructuraOrganica).FirstOrDefault().IdEstructuraOrganica;

            //consultar los usuarios por defecto de la primera EstructuraOrganica
            var usersFirstEstructuraOrganica = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdEstructuraOrganica == idFirstEstructuraOrganica && t.FechaTermino == null).Select(x => new
            {
                IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
                NombreCompleto =
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " +
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno
            }).ToList();

            MstSeguridadRoles rolUser = new MstSeguridadRoles();
            if (rolUser.EsAdministrador())
            {
                ViewBag.IdEstructuraOrganica = new SelectList(catalogos_ctEstructuraOrganica.Where(t => t.EsVigente == true).OrderBy(t => t.IdEstructuraOrganica), "IdEstructuraOrganica", "EstructuraOrganica",mst_GrupoReporte.IdEstructuraOrganica);
                ViewBag.IdConvenioLaboralTrabajadorCategoria_Responsable = new SelectList(usersFirstEstructuraOrganica, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto",mst_GrupoReporte.IdConvenioLaboralTrabajadorCategoria_Responsable);
            }
            else
            {
                ViewBag.IdEstructuraOrganica = new SelectList(catalogos_ctEstructuraOrganica.Where(t => t.IdEstructuraOrganica == convenio.IdEstructuraOrganica), "IdEstructuraOrganica", "EstructuraOrganica", mst_GrupoReporte.IdEstructuraOrganica);
                ViewBag.IdConvenioLaboralTrabajadorCategoria_Responsable = new SelectList(userName, "IdConvenioLaboralTrabajadorCategoria", "NombreCompleto",mst_GrupoReporte.IdConvenioLaboralTrabajadorCategoria_Responsable);
            }





            return PartialView("_GetFormNewGroup", mst_GrupoReporte);
        }


        [System.Web.Services.WebMethod]
        public JsonResult GetUsersArea(int id)
        {
            var usersFirstEstructuraOrganica = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdEstructuraOrganica == id && t.FechaTermino == null).Select(x => new
            {
                IdConvenioLaboralTrabajadorCategoria = x.IdConvenioLaboralTrabajadorCategoria,
                NombreCompleto =
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " +
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " +
                     x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno
            }).ToList();

            return Json(usersFirstEstructuraOrganica, JsonRequestBehavior.AllowGet);
        }




    }
}
