﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Mst
{
    public class MstComentariosReporteController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: MstComentariosReporte
        //public ActionResult Index()
        //{
        //    var mst_ComentariosReporte = db.Mst_ComentariosReporte.Include(m => m.Convenios_stConvenioLaboralTrabajadorCategoria).Include(m => m.Mst_EstatusReporte).Include(m => m.Mst_Reporte);
        //    return View(mst_ComentariosReporte.ToList());
        //}

        // GET: MstComentariosReporte/Details/5
        //public ActionResult Details(int? id)
        //{
        //    if (id == null)
        //    {
        //        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        //    }
        //    Mst_ComentariosReporte mst_ComentariosReporte = db.Mst_ComentariosReporte.Find(id);
        //    if (mst_ComentariosReporte == null)
        //    {
        //        return HttpNotFound();
        //    }
        //    return View(mst_ComentariosReporte);
        //}

        // GET: MstComentariosReporte/Create
        //public ActionResult Create()
        //{
        //    ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
        //    ViewBag.IdEstatusReporte = new SelectList(db.Mst_EstatusReporte, "IdEstatusReporte", "EstatusReporte");
        //    ViewBag.IdReporte = new SelectList(db.Mst_Reporte, "IdReporte", "NumeroReporte");
        //    return View();
        //}

        // POST: MstComentariosReporte/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdComentarioReporte,ComentarioReporte,FechaComentarioReporte,IdConvenioLaboralTrabajadorCategoria,IdEstatusReporte,Publico,IdReporte")] Mst_ComentariosReporte mst_ComentariosReporte)
        {
            Mst_Reporte mst_Reporte = new Mst_Reporte();
            if (mst_ComentariosReporte.ComentarioReporte == null || mst_ComentariosReporte.ComentarioReporte == "")
            {
                ModelState.AddModelError("ComentarioReporte", "El campo Comentario es requerido.");
            }
            else
            {
                int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                mst_Reporte = db.Mst_Reporte.Find(mst_ComentariosReporte.IdReporte);
                if (mst_Reporte == null)
                {
                    ModelState.AddModelError(string.Empty, "No se puede localizar el Reporte asociado.");
                }

                mst_ComentariosReporte.FechaComentarioReporte = DateTime.Now;
                mst_ComentariosReporte.IdConvenioLaboralTrabajadorCategoria = idUser;
                mst_ComentariosReporte.IdEstatusReporte = mst_Reporte.IdEstatusReporte;
                mst_ComentariosReporte.Publico = true;
                

            }


            ModelState["IdEstatusReporte"].Errors.Clear();
            if (ModelState.IsValid)
            {
                db.Mst_ComentariosReporte.Add(mst_ComentariosReporte);
                db.SaveChanges();

                var result = new { value_e = "esuccess", msg = "Se ha añadido un comentario.", IdReporte = mst_Reporte.IdReporte };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

            foreach (var item in ModelState.Values.SelectMany(v => v.Errors).Select(v => v.ErrorMessage + " " + v.Exception).ToList())
            {
                ModelState.AddModelError(string.Empty, item.ToString());
            }


            return PartialView("_ChatsUserForm", mst_ComentariosReporte);
        }

        // GET: MstComentariosReporte/Edit/5
        //public ActionResult Edit(int? id)
        //{
        //    if (id == null)
        //    {
        //        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        //    }
        //    Mst_ComentariosReporte mst_ComentariosReporte = db.Mst_ComentariosReporte.Find(id);
        //    if (mst_ComentariosReporte == null)
        //    {
        //        return HttpNotFound();
        //    }
        //    ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", mst_ComentariosReporte.IdConvenioLaboralTrabajadorCategoria);
        //    ViewBag.IdEstatusReporte = new SelectList(db.Mst_EstatusReporte, "IdEstatusReporte", "EstatusReporte", mst_ComentariosReporte.IdEstatusReporte);
        //    ViewBag.IdReporte = new SelectList(db.Mst_Reporte, "IdReporte", "NumeroReporte", mst_ComentariosReporte.IdReporte);
        //    return View(mst_ComentariosReporte);
        //}

        // POST: MstComentariosReporte/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        //[HttpPost]
        //[ValidateAntiForgeryToken]
        //public ActionResult Edit([Bind(Include = "IdComentarioReporte,ComentarioReporte,FechaComentarioReporte,IdConvenioLaboralTrabajadorCategoria,IdEstatusReporte,Publico,IdReporte")] Mst_ComentariosReporte mst_ComentariosReporte)
        //{
        //    if (ModelState.IsValid)
        //    {
        //        db.Entry(mst_ComentariosReporte).State = EntityState.Modified;
        //        db.SaveChanges();
        //        return RedirectToAction("Index");
        //    }
        //    ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", mst_ComentariosReporte.IdConvenioLaboralTrabajadorCategoria);
        //    ViewBag.IdEstatusReporte = new SelectList(db.Mst_EstatusReporte, "IdEstatusReporte", "EstatusReporte", mst_ComentariosReporte.IdEstatusReporte);
        //    ViewBag.IdReporte = new SelectList(db.Mst_Reporte, "IdReporte", "NumeroReporte", mst_ComentariosReporte.IdReporte);
        //    return View(mst_ComentariosReporte);
        //}

        // GET: MstComentariosReporte/Delete/5
        //public ActionResult Delete(int? id)
        //{
        //    if (id == null)
        //    {
        //        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        //    }
        //    Mst_ComentariosReporte mst_ComentariosReporte = db.Mst_ComentariosReporte.Find(id);
        //    if (mst_ComentariosReporte == null)
        //    {
        //        return HttpNotFound();
        //    }
        //    return View(mst_ComentariosReporte);
        //}

        // POST: MstComentariosReporte/Delete/5
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        //public ActionResult DeleteConfirmed(int id)
        //{
        //    Mst_ComentariosReporte mst_ComentariosReporte = db.Mst_ComentariosReporte.Find(id);
        //    db.Mst_ComentariosReporte.Remove(mst_ComentariosReporte);
        //    db.SaveChanges();
        //    return RedirectToAction("Index");
        //}

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }

        public ActionResult GetComentariosAll(int id)
        {
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            MstComentariosUserReporte model = new MstComentariosUserReporte();
            model.Comentarios = db.Mst_ComentariosReporte.Where(t => t.IdReporte == id && t.Publico == true).ToList();
            model.EstatusReporte = db.Mst_Reporte.Find(id).Mst_EstatusReporte.EstatusReporte;
            model.IdReporte = db.Mst_Reporte.Find(id).IdReporte;

            ViewBag.IdUsuarioLogin = idUser;
            return PartialView("_ListComentariosUser", model);
        }

        public ActionResult GetComentariosUserUpdate(int id)
        {
            int idUser = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            var comentarios = db.Mst_ComentariosReporte.Where(t => t.IdReporte == id && t.Publico == true).ToList();

            ViewBag.IdUsuarioLogin = idUser;
            return PartialView("_ComentariosUserUpdate", comentarios);
        }

    }
}
