﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Mst.Proveedor
{
    public class MstTipoServicioController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: MstTipoServicio
        public ActionResult Index()
        {
            return View(db.Mst_TipoServicio.ToList());
        }

        // GET: MstTipoServicio/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_TipoServicio mst_TipoServicio = db.Mst_TipoServicio.Find(id);
            if (mst_TipoServicio == null)
            {
                return HttpNotFound();
            }
            return View(mst_TipoServicio);
        }

        // GET: MstTipoServicio/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: MstTipoServicio/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdTipoServicio,TipoServicio,Descripcion")] Mst_TipoServicio mst_TipoServicio)
        {
            if (ModelState.IsValid)
            {
                db.Mst_TipoServicio.Add(mst_TipoServicio);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(mst_TipoServicio);
        }

        // GET: MstTipoServicio/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_TipoServicio mst_TipoServicio = db.Mst_TipoServicio.Find(id);
            if (mst_TipoServicio == null)
            {
                return HttpNotFound();
            }
            return View(mst_TipoServicio);
        }

        // POST: MstTipoServicio/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdTipoServicio,TipoServicio,Descripcion")] Mst_TipoServicio mst_TipoServicio)
        {
            if (ModelState.IsValid)
            {
                db.Entry(mst_TipoServicio).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(mst_TipoServicio);
        }

        // GET: MstTipoServicio/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_TipoServicio mst_TipoServicio = db.Mst_TipoServicio.Find(id);
            if (mst_TipoServicio == null)
            {
                return HttpNotFound();
            }
            return View(mst_TipoServicio);
        }

        // POST: MstTipoServicio/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Mst_TipoServicio mst_TipoServicio = db.Mst_TipoServicio.Find(id);
            db.Mst_TipoServicio.Remove(mst_TipoServicio);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
