﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Mst.Proveedor
{
    public class MstProveedorTipoServicioController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: MstProveedorTipoServicio
        public ActionResult Index()
        {
            var mst_ProveedorTipoServicio = db.Mst_ProveedorTipoServicio.Include(m => m.Mst_Proveedor).Include(m => m.Mst_TipoServicio);
            return View(mst_ProveedorTipoServicio.ToList());
        }

        // GET: MstProveedorTipoServicio/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_ProveedorTipoServicio mst_ProveedorTipoServicio = db.Mst_ProveedorTipoServicio.Find(id);
            if (mst_ProveedorTipoServicio == null)
            {
                return HttpNotFound();
            }
            return View(mst_ProveedorTipoServicio);
        }

        // GET: MstProveedorTipoServicio/Create
        public ActionResult Create()
        {
            ViewBag.IdProveedor = new SelectList(db.Mst_Proveedor, "IdProveedor", "RazonSocial");
            ViewBag.IdTipoServicio = new SelectList(db.Mst_TipoServicio, "IdTipoServicio", "TipoServicio");
            return View();
        }

        // POST: MstProveedorTipoServicio/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdProveedorTipoServicio,IdTipoServicio,IdProveedor")] Mst_ProveedorTipoServicio mst_ProveedorTipoServicio)
        {
            if (ModelState.IsValid)
            {
                db.Mst_ProveedorTipoServicio.Add(mst_ProveedorTipoServicio);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdProveedor = new SelectList(db.Mst_Proveedor, "IdProveedor", "RazonSocial", mst_ProveedorTipoServicio.IdProveedor);
            ViewBag.IdTipoServicio = new SelectList(db.Mst_TipoServicio, "IdTipoServicio", "TipoServicio", mst_ProveedorTipoServicio.IdTipoServicio);
            return View(mst_ProveedorTipoServicio);
        }

        // GET: MstProveedorTipoServicio/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_ProveedorTipoServicio mst_ProveedorTipoServicio = db.Mst_ProveedorTipoServicio.Find(id);
            if (mst_ProveedorTipoServicio == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdProveedor = new SelectList(db.Mst_Proveedor, "IdProveedor", "RazonSocial", mst_ProveedorTipoServicio.IdProveedor);
            ViewBag.IdTipoServicio = new SelectList(db.Mst_TipoServicio, "IdTipoServicio", "TipoServicio", mst_ProveedorTipoServicio.IdTipoServicio);
            return View(mst_ProveedorTipoServicio);
        }

        // POST: MstProveedorTipoServicio/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdProveedorTipoServicio,IdTipoServicio,IdProveedor")] Mst_ProveedorTipoServicio mst_ProveedorTipoServicio)
        {
            if (ModelState.IsValid)
            {
                db.Entry(mst_ProveedorTipoServicio).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdProveedor = new SelectList(db.Mst_Proveedor, "IdProveedor", "RazonSocial", mst_ProveedorTipoServicio.IdProveedor);
            ViewBag.IdTipoServicio = new SelectList(db.Mst_TipoServicio, "IdTipoServicio", "TipoServicio", mst_ProveedorTipoServicio.IdTipoServicio);
            return View(mst_ProveedorTipoServicio);
        }

        // GET: MstProveedorTipoServicio/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_ProveedorTipoServicio mst_ProveedorTipoServicio = db.Mst_ProveedorTipoServicio.Find(id);
            if (mst_ProveedorTipoServicio == null)
            {
                return HttpNotFound();
            }
            return View(mst_ProveedorTipoServicio);
        }

        // POST: MstProveedorTipoServicio/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Mst_ProveedorTipoServicio mst_ProveedorTipoServicio = db.Mst_ProveedorTipoServicio.Find(id);
            db.Mst_ProveedorTipoServicio.Remove(mst_ProveedorTipoServicio);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
