﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class MstTipoEquipoComputoController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: Mst_TipoEquipoComputo
        public ActionResult Index()
        {
            return View(db.Mst_TipoEquipoComputo.ToList());
        }

        // GET: Mst_TipoEquipoComputo/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_TipoEquipoComputo mst_TipoEquipoComputo = db.Mst_TipoEquipoComputo.Find(id);
            if (mst_TipoEquipoComputo == null)
            {
                return HttpNotFound();
            }
            return View(mst_TipoEquipoComputo);
        }

        // GET: Mst_TipoEquipoComputo/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: Mst_TipoEquipoComputo/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdTipoEquipoComputo,TipoEquipoComputo")] Mst_TipoEquipoComputo mst_TipoEquipoComputo)
        {
            if (ModelState.IsValid)
            {
                db.Mst_TipoEquipoComputo.Add(mst_TipoEquipoComputo);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(mst_TipoEquipoComputo);
        }

        // GET: Mst_TipoEquipoComputo/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_TipoEquipoComputo mst_TipoEquipoComputo = db.Mst_TipoEquipoComputo.Find(id);
            if (mst_TipoEquipoComputo == null)
            {
                return HttpNotFound();
            }
            return View(mst_TipoEquipoComputo);
        }

        // POST: Mst_TipoEquipoComputo/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdTipoEquipoComputo,TipoEquipoComputo")] Mst_TipoEquipoComputo mst_TipoEquipoComputo)
        {
            if (ModelState.IsValid)
            {
                db.Entry(mst_TipoEquipoComputo).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(mst_TipoEquipoComputo);
        }

        // GET: Mst_TipoEquipoComputo/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_TipoEquipoComputo mst_TipoEquipoComputo = db.Mst_TipoEquipoComputo.Find(id);
            if (mst_TipoEquipoComputo == null)
            {
                return HttpNotFound();
            }
            return View(mst_TipoEquipoComputo);
        }

        // POST: Mst_TipoEquipoComputo/Delete/5
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Mst_TipoEquipoComputo mst_TipoEquipoComputo = db.Mst_TipoEquipoComputo.Find(id);
            db.Mst_TipoEquipoComputo.Remove(mst_TipoEquipoComputo);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }

        

        [HttpPost]
        public ActionResult GetMarcasTipo()
        {
            int idTipo = System.Convert.ToInt32(Request["Tipo"]);
            List<Mst_MarcaEquipoComputo> marcas = db.Mst_MarcaEquipoComputo.Where(t => t.IdTipoEquipoComputo == idTipo).ToList();
            ViewBag.TipoId = idTipo;
            return PartialView("_MarcasTipo", marcas);
        }

        [HttpPost]
        public ActionResult GetModelosMarca()
        {
            int idTipo = System.Convert.ToInt32(Request["Tipo"]);
            int idMarca = System.Convert.ToInt32(Request["Marca"]);
            List<Mst_ModeloEquipoComputo> modelos = db.Mst_ModeloEquipoComputo.Include(m => m.Mst_MarcaEquipoComputo).Where(t => t.IdMarcaEquipoComputo == idMarca && t.Mst_MarcaEquipoComputo.IdTipoEquipoComputo == idTipo).ToList();
            ViewBag.MarcaId = idMarca;
            return PartialView("_ModelosMarca", modelos);
        }

        //Return Json para rellenar los select TIMO-MARCA-MODELO de la búsqueda al dar alta un ticket
        [HttpPost]
        public ActionResult GetTipos()
        {
            var listTipo = db.Mst_TipoEquipoComputo.Select(s => new { s.IdTipoEquipoComputo, s.TipoEquipoComputo }).ToList();
            return Json(listTipo, JsonRequestBehavior.AllowGet);
        }

        [HttpPost]
        public ActionResult GetMarcasTipoJson()
        {
            int idTipo = System.Convert.ToInt32(Request["Tipo"]);
            List<Mst_MarcaEquipoComputo> marcas = db.Mst_MarcaEquipoComputo.Where(t => t.IdTipoEquipoComputo == idTipo).ToList();
            return Json(marcas.Select(t=>new { t.IdMarcaEquipoComputo, t.MarcaEquipoComputo}), JsonRequestBehavior.AllowGet);
        }

        [HttpPost]
        public ActionResult GetModelosMarcaTipo()
        {
            int idTipo = System.Convert.ToInt32(Request["Tipo"]);
            int idMarca = System.Convert.ToInt32(Request["Marca"]);
            List<Mst_ModeloEquipoComputo> modelos = db.Mst_ModeloEquipoComputo.Include(m => m.Mst_MarcaEquipoComputo).Where(t => t.IdMarcaEquipoComputo == idMarca && t.Mst_MarcaEquipoComputo.IdTipoEquipoComputo == idTipo).ToList();
            return Json(modelos.Select(t=>new { t.IdModeloEquipoComputo, t.ModeloEquipoComputo}), JsonRequestBehavior.AllowGet);
        }


        

    }
}
