﻿using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class MstModeloEquipoComputoController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: MstModeloEquipoComputo
        public ActionResult Index()
        {
            var mst_ModeloEquipoComputo = db.Mst_ModeloEquipoComputo.Include(m => m.Mst_MarcaEquipoComputo);
            return View(mst_ModeloEquipoComputo.ToList());
        }

        // GET: MstModeloEquipoComputo/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_ModeloEquipoComputo mst_ModeloEquipoComputo = db.Mst_ModeloEquipoComputo.Find(id);
            if (mst_ModeloEquipoComputo == null)
            {
                return HttpNotFound();
            }
            return View(mst_ModeloEquipoComputo);
        }

        // GET: MstModeloEquipoComputo/Create
        public ActionResult Create(int id)
        {
            var Marca = db.Mst_MarcaEquipoComputo.Where(t => t.IdMarcaEquipoComputo == id);
            ViewBag.IdMarcaEquipoComputo = new SelectList(Marca, "IdMarcaEquipoComputo", "MarcaEquipoComputo");
            ViewBag.IdTipoEquipoComputo = new SelectList(db.Mst_TipoEquipoComputo.Where(t => t.IdTipoEquipoComputo == Marca.Select(x=>x.IdTipoEquipoComputo).FirstOrDefault()), "IdTipoEquipoComputo", "TipoEquipoComputo");
            return View();
        }

        // POST: MstModeloEquipoComputo/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdModeloEquipoComputo,ModeloEquipoComputo,IdMarcaEquipoComputo")] Mst_ModeloEquipoComputo mst_ModeloEquipoComputo)
        {
            if (ModelState.IsValid)
            {
                db.Mst_ModeloEquipoComputo.Add(mst_ModeloEquipoComputo);
                db.SaveChanges();
                return RedirectToAction("Index", "MstTipoEquipoComputo");
            }

            ViewBag.IdMarcaEquipoComputo = new SelectList(db.Mst_MarcaEquipoComputo, "IdMarcaEquipoComputo", "MarcaEquipoComputo", mst_ModeloEquipoComputo.IdMarcaEquipoComputo);
            return View(mst_ModeloEquipoComputo);
        }

        // GET: MstModeloEquipoComputo/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_ModeloEquipoComputo mst_ModeloEquipoComputo = db.Mst_ModeloEquipoComputo.Find(id);
            if (mst_ModeloEquipoComputo == null)
            {
                return HttpNotFound();
            }

            var marca = db.Mst_MarcaEquipoComputo.Where(t => t.IdMarcaEquipoComputo == mst_ModeloEquipoComputo.IdMarcaEquipoComputo);

            ViewBag.IdTipoEquipoComputo = new SelectList(db.Mst_TipoEquipoComputo.Where(t=>t.IdTipoEquipoComputo == marca.FirstOrDefault().IdTipoEquipoComputo), "IdTipoEquipoComputo", "TipoEquipoComputo");
            ViewBag.IdMarcaEquipoComputo = new SelectList(marca, "IdMarcaEquipoComputo", "MarcaEquipoComputo");
            return View(mst_ModeloEquipoComputo);
        }

        // POST: MstModeloEquipoComputo/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdModeloEquipoComputo,ModeloEquipoComputo,IdMarcaEquipoComputo")] Mst_ModeloEquipoComputo mst_ModeloEquipoComputo)
        {
            if (ModelState.IsValid)
            {
                db.Entry(mst_ModeloEquipoComputo).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index", "MstTipoEquipoComputo");
            }
            ViewBag.IdMarcaEquipoComputo = new SelectList(db.Mst_MarcaEquipoComputo, "IdMarcaEquipoComputo", "MarcaEquipoComputo", mst_ModeloEquipoComputo.IdMarcaEquipoComputo);
            return View(mst_ModeloEquipoComputo);
        }

        // GET: MstModeloEquipoComputo/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_ModeloEquipoComputo mst_ModeloEquipoComputo = db.Mst_ModeloEquipoComputo.Find(id);
            if (mst_ModeloEquipoComputo == null)
            {
                return HttpNotFound();
            }
            return View(mst_ModeloEquipoComputo);
        }

        // POST: MstModeloEquipoComputo/Delete/5
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int? id)
        {
            if (id == null || id <= 0)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Mst_ModeloEquipoComputo mst_ModeloEquipoComputo = db.Mst_ModeloEquipoComputo.Find(id);
            db.Mst_ModeloEquipoComputo.Remove(mst_ModeloEquipoComputo);
            db.SaveChanges();
            return RedirectToAction("Index", "MstTipoEquipoComputo");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
