﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class MaterialDidactico_TituloController : Controller
    {
        //
        // GET: /MaterialDidactico_Titulo/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvMaterialDidactico_Titulo()
        {
            var model = db.MaterialDidactico_Titulo;
            return PartialView("_pvMaterialDidactico_Titulo", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_TituloAddNew(Nova.Models.MaterialDidactico_Titulo item)
        {
            var model = db.MaterialDidactico_Titulo;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvMaterialDidactico_Titulo", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_TituloUpdate(Nova.Models.MaterialDidactico_Titulo item)
        {
            var model = db.MaterialDidactico_Titulo;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdTitulo == item.IdTitulo);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvMaterialDidactico_Titulo", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_TituloDelete(System.Int16 IdTitulo)
        {
            var model = db.MaterialDidactico_Titulo;
            if (IdTitulo != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdTitulo == IdTitulo);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvMaterialDidactico_Titulo", model.ToList());
        }
    }
}
