﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;
using Seguridad;

namespace Nova.Controllers
{
    public class MaterialDidactico_SolicitudController : Controller
    {
        //
        // GET: /MaterialDidactico_Titulo/

        public ActionResult VerSolicitudes()
        {
            MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.OrderByDescending(y => y.FechaInicio).FirstOrDefault();
          

            int id = 0;
            if (Request["IdConvocatoria"] != null)
                id = System.Convert.ToInt32(Request["IdConvocatoria"]);
            else
                id = convocatoria.IdConvocatoria;


            ViewBag.Id = id;
            return View();
        }

        public ActionResult VerSolicitudesDocente()
        {
            MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.OrderByDescending(y => y.FechaInicio).FirstOrDefault();
            int id = 0;
            if (Request["IdConvocatoria"] != null)
                id = System.Convert.ToInt32(Request["IdConvocatoria"]);
            else
                id = convocatoria.IdConvocatoria;


            ViewBag.Id = id;

            return View();
        }

        public ActionResult VerSolicitudesArea()
        {
            MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.OrderByDescending(y => y.FechaInicio).FirstOrDefault();
            int id = 0;
            if (Request["IdConvocatoria"] != null)
                id = System.Convert.ToInt32(Request["IdConvocatoria"]);
            else
                id = convocatoria.IdConvocatoria;


            ViewBag.Id = id;

            return View();
        }

        public ActionResult VerSolicitudesPorAsignatura()
        {
            MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.OrderByDescending(y => y.FechaInicio).FirstOrDefault();


            int id = 0;
            if (Request["IdConvocatoria"] != null)
                id = System.Convert.ToInt32(Request["IdConvocatoria"]);
            else
                id = convocatoria.IdConvocatoria;


            ViewBag.Id = id;
            return View();
        }

        public ActionResult VerSolicitudesEmsad()
        {
            MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.OrderByDescending(y => y.FechaInicio).FirstOrDefault();
            int id = 0;
            if (Request["IdConvocatoria"] != null)
                id = System.Convert.ToInt32(Request["IdConvocatoria"]);
            else
                id = convocatoria.IdConvocatoria;


            ViewBag.Id = id;

            return View();
        }

        public ActionResult SolicitudesPlantel(int id=0)
        {
            ViewBag.Id = id;
            var model = MaterialDidactico_Solicitud.ObtenSolicitudesArea("Plantel",id);



            return PartialView("_pvMaterialDidactico_SolicitudVerSolicitudesPlantel", model);
        }

        public ActionResult VerSolicitudesPlantel()
        {
            MaterialDidactico_ctConvocatoria convocatoria = db.MaterialDidactico_ctConvocatoria.OrderByDescending(y => y.FechaInicio).FirstOrDefault();
            int id = 0;
            if (Request["IdConvocatoria"] != null)
                id = System.Convert.ToInt32(Request["IdConvocatoria"]);
            else
                id = convocatoria.IdConvocatoria;


            ViewBag.Id = id;


            return View();
        }

        [ValidateInput(false)]
        public ActionResult SolicitudesPorAsignatura(int id)
        {
            ViewBag.Id = id;
            var model = MaterialDidactico_Solicitud.ObtenSolicitudesUsuario(Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdTrabajador,id);



            return PartialView("_pvMaterialDidactico_SolicitudVerSolicitudesAsignatura", model);
        }

        [ValidateInput(false)]
        public ActionResult SolicitudesArea(int id=0)
        {
            ViewBag.Id = id;
            var model = MaterialDidactico_Solicitud.ObtenSolicitudesArea(Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica,id);

            

            return PartialView("_pvMaterialDidactico_SolicitudVerSolicitudesArea", model);
        }

        [ValidateInput(false)]
        public ActionResult SolicitudesEmsad(int id =0)
        {
            ViewBag.Id = id;
            var model = MaterialDidactico_Solicitud.ObtenSolicitudesArea("Emsad",id);



            return PartialView("_pvMaterialDidactico_SolicitudVerSolicitudesArea", model);
        }

        //[ValidateInput(false)]
        //public ActionResult SolicitudesPlantel()
        //{

        //    var model = MaterialDidactico_Solicitud.ObtenSolicitudesArea("Plantel");



        //    return PartialView("_pvMaterialDidactico_SolicitudVerSolicitudesArea", model);
        //}

        [ValidateInput(false)]
        public ActionResult pvMaterialDidactico_SolicitudVerSolicitudesDocente()
        {
            var model = MaterialDidactico_Solicitud.ObtenSolicitudesDocente(System.Convert.ToInt32(Session["IdTrabajador"]));
            return PartialView("_pvMaterialDidactico_SolicitudVerSolicitudesDocente", model);
        }


        bdNovaEntities db = new bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvMaterialDidactico_SolicitudVerSolicitudes(int id)
        {
            ViewBag.Id = id;
            var model = MaterialDidactico_Solicitud.ObtenSolicitudes(id);
            return PartialView("_pvMaterialDidactico_SolicitudVerSolicitudes", model);
        }
        [ValidateInput(false)]
        public ActionResult pvMaterialDidactico_SolicitudDetalle(int IdSolicitud)
        {
            ViewData["IdSolicitud"] = IdSolicitud;
            var model = MaterialDidactico_Solicitud.ObtenSolicitudPorID(IdSolicitud);
            return PartialView("_pvMaterialDidactico_SolicitudDetalle", model);
        }
        [ValidateInput(false)]
        public ActionResult ImprimeSolicitud(int IdSolicitud)
        {
            ViewBag.Solicitud = MaterialDidactico_Solicitud.ObtenSolicitud(IdSolicitud);
            ViewBag.DetalleSolicitud = MaterialDidactico_Solicitud.ObtenSolicitudPorID(IdSolicitud);
            return View("ImpresionSolicitud");
        }

    }
}
