﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class MaterialDidactico_InventarioTituloController : Controller
    {
        //
        // GET: /MaterialDidactico_InventarioTitulo/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvMaterialDidactico_InventarioTitulo()
        {
            var model = db.MaterialDidactico_InventarioTitulo;
            return PartialView("_pvMaterialDidactico_InventarioTitulo", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_InventarioTituloAddNew(Nova.Models.MaterialDidactico_InventarioTitulo item)
        {
            var model = db.MaterialDidactico_InventarioTitulo;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvMaterialDidactico_InventarioTitulo", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_InventarioTituloUpdate(Nova.Models.MaterialDidactico_InventarioTitulo item)
        {
            var model = db.MaterialDidactico_InventarioTitulo;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdInventarioTitulo == item.IdInventarioTitulo);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvMaterialDidactico_InventarioTitulo", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_InventarioTituloDelete(System.Int16 IdInventarioTitulo)
        {
            var model = db.MaterialDidactico_InventarioTitulo;
            if (IdInventarioTitulo != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdInventarioTitulo == IdInventarioTitulo);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvMaterialDidactico_InventarioTitulo", model.ToList());
        }
    }
}
